WebAudio.GraphVisualizer={};WebAudio.GraphVisualizer.Size;WebAudio.GraphVisualizer.Point;WebAudio.GraphVisualizer.NodeLayout;WebAudio.GraphVisualizer.PortTypes={In:Symbol('In'),Out:Symbol('Out'),Param:Symbol('Param'),};WebAudio.GraphVisualizer.Port;WebAudio.GraphVisualizer.NodeCreationData;WebAudio.GraphVisualizer.ParamCreationData;WebAudio.GraphVisualizer.NodesConnectionData;WebAudio.GraphVisualizer.NodesDisconnectionData;WebAudio.GraphVisualizer.NodesDisconnectionDataWithDestination;WebAudio.GraphVisualizer.NodeParamConnectionData;WebAudio.GraphVisualizer.NodeParamDisconnectionData;;WebAudio.GraphVisualizer.GraphStyles={PortPadding:4,InputPortRadius:10,AudioParamRadius:5,LeftMarginOfText:12,RightMarginOfText:30,LeftSideTopPadding:5,BottomPaddingWithoutParam:6,BottomPaddingWithParam:8,ArrowHeadSize:12,GraphPadding:20,GraphMargin:20,};WebAudio.GraphVisualizer.GraphStyles.TotalInputPortHeight=WebAudio.GraphVisualizer.GraphStyles.InputPortRadius*2+WebAudio.GraphVisualizer.GraphStyles.PortPadding;WebAudio.GraphVisualizer.GraphStyles.TotalOutputPortHeight=WebAudio.GraphVisualizer.GraphStyles.TotalInputPortHeight;WebAudio.GraphVisualizer.GraphStyles.TotalParamPortHeight=WebAudio.GraphVisualizer.GraphStyles.AudioParamRadius*2+WebAudio.GraphVisualizer.GraphStyles.PortPadding;WebAudio.GraphVisualizer.GraphStyles.NodeLabelFontStyle='14px Segoe UI, Arial';WebAudio.GraphVisualizer.GraphStyles.ParamLabelFontStyle='12px Segoe UI, Arial';;WebAudio.GraphVisualizer.GraphManager=class extends Common.Object{constructor(){super();this._graphMapByContextId=new Map();}
createContext(contextId){const graph=new WebAudio.GraphVisualizer.GraphView(contextId);graph.addEventListener(WebAudio.GraphVisualizer.GraphView.Events.ShouldRedraw,this._notifyShouldRedraw,this);this._graphMapByContextId.set(contextId,graph);}
destroyContext(contextId){if(!this._graphMapByContextId.has(contextId)){return;}
const graph=this._graphMapByContextId.get(contextId);graph.removeEventListener(WebAudio.GraphVisualizer.GraphView.Events.ShouldRedraw,this._notifyShouldRedraw,this);this._graphMapByContextId.delete(contextId);}
hasContext(contextId){return this._graphMapByContextId.has(contextId);}
clearGraphs(){this._graphMapByContextId.clear();}
getGraph(contextId){return this._graphMapByContextId.get(contextId);}
_notifyShouldRedraw(event){const graph=(event.data);this.dispatchEventToListeners(WebAudio.GraphVisualizer.GraphView.Events.ShouldRedraw,graph);}};;WebAudio.GraphVisualizer.NodeRendererUtility={};WebAudio.GraphVisualizer.NodeRendererUtility.calculateInputPortXY=portIndex=>{const y=WebAudio.GraphVisualizer.GraphStyles.InputPortRadius+
WebAudio.GraphVisualizer.GraphStyles.LeftSideTopPadding+
portIndex*WebAudio.GraphVisualizer.GraphStyles.TotalInputPortHeight;return{x:0,y:y};};WebAudio.GraphVisualizer.NodeRendererUtility.calculateOutputPortXY=(portIndex,nodeSize,numberOfOutputs)=>{const{width,height}=nodeSize;const outputPortY=(height/2)+
(2*portIndex-numberOfOutputs+1)*WebAudio.GraphVisualizer.GraphStyles.TotalOutputPortHeight/2;return{x:width,y:outputPortY};};WebAudio.GraphVisualizer.NodeRendererUtility.calculateParamPortXY=(portIndex,offsetY)=>{const paramPortY=offsetY+WebAudio.GraphVisualizer.GraphStyles.TotalParamPortHeight*(portIndex+1)-
WebAudio.GraphVisualizer.GraphStyles.AudioParamRadius;return{x:0,y:paramPortY};};;WebAudio.GraphVisualizer.NodeView=class{constructor(data,label){this.id=data.nodeId;this.type=data.nodeType;this.numberOfInputs=data.numberOfInputs;this.numberOfOutputs=data.numberOfOutputs;this.label=label;this.size={width:0,height:0};this.position=null;this._layout={inputPortSectionHeight:0,outputPortSectionHeight:0,maxTextLength:0,totalHeight:0,};this.ports=new Map();this._initialize(data);}
_initialize(data){this._updateNodeLayoutAfterAddingNode(data);this._setupInputPorts();this._setupOutputPorts();}
addParamPort(paramId,paramType){const paramPorts=this.getPortsByType(WebAudio.GraphVisualizer.PortTypes.Param);const numberOfParams=paramPorts.length;const{x,y}=WebAudio.GraphVisualizer.NodeRendererUtility.calculateParamPortXY(numberOfParams,this._layout.inputPortSectionHeight);this._addPort({id:WebAudio.GraphVisualizer.generateParamPortId(this.id,paramId),type:WebAudio.GraphVisualizer.PortTypes.Param,label:paramType,x,y,});this._updateNodeLayoutAfterAddingParam(numberOfParams+1,paramType);this._setupOutputPorts();}
getPortsByType(type){const result=[];this.ports.forEach(port=>{if(port.type===type){result.push(port);}});return result;}
_updateNodeLayoutAfterAddingNode(data){const{TotalInputPortHeight,LeftSideTopPadding,BottomPaddingWithoutParam,TotalOutputPortHeight,NodeLabelFontStyle,}=WebAudio.GraphVisualizer.GraphStyles;const inputPortSectionHeight=TotalInputPortHeight*Math.max(1,data.numberOfInputs)+LeftSideTopPadding;this._layout.inputPortSectionHeight=inputPortSectionHeight;this._layout.outputPortSectionHeight=TotalOutputPortHeight*data.numberOfOutputs;this._layout.totalHeight=Math.max(inputPortSectionHeight+BottomPaddingWithoutParam,this._layout.outputPortSectionHeight);const nodeLabelLength=WebAudio.GraphVisualizer.measureTextWidth(this.label,NodeLabelFontStyle);this._layout.maxTextLength=Math.max(this._layout.maxTextLength,nodeLabelLength);this._updateNodeSize();}
_updateNodeLayoutAfterAddingParam(numberOfParams,paramType){const leftSideMaxHeight=this._layout.inputPortSectionHeight+
numberOfParams*WebAudio.GraphVisualizer.GraphStyles.TotalParamPortHeight+
WebAudio.GraphVisualizer.GraphStyles.BottomPaddingWithParam;this._layout.totalHeight=Math.max(leftSideMaxHeight,this._layout.outputPortSectionHeight);const paramLabelLength=WebAudio.GraphVisualizer.measureTextWidth(paramType,WebAudio.GraphVisualizer.GraphStyles.ParamLabelFontStyle);this._layout.maxTextLength=Math.max(this._layout.maxTextLength,paramLabelLength);this._updateNodeSize();}
_updateNodeSize(){this.size={width:Math.ceil(WebAudio.GraphVisualizer.GraphStyles.LeftMarginOfText+this._layout.maxTextLength+
WebAudio.GraphVisualizer.GraphStyles.RightMarginOfText),height:this._layout.totalHeight,};}
_setupInputPorts(){for(let i=0;i<this.numberOfInputs;i++){const{x,y}=WebAudio.GraphVisualizer.NodeRendererUtility.calculateInputPortXY(i);this._addPort({id:WebAudio.GraphVisualizer.generateInputPortId(this.id,i),type:WebAudio.GraphVisualizer.PortTypes.In,x,y,});}}
_setupOutputPorts(){for(let i=0;i<this.numberOfOutputs;i++){const portId=WebAudio.GraphVisualizer.generateOutputPortId(this.id,i);const{x,y}=WebAudio.GraphVisualizer.NodeRendererUtility.calculateOutputPortXY(i,this.size,this.numberOfOutputs);if(this.ports.has(portId)){const port=this.ports.get(portId);port.x=x;port.y=y;}else{this._addPort({id:portId,type:WebAudio.GraphVisualizer.PortTypes.Out,x,y,});}}}
_addPort(port){this.ports.set(port.id,port);}};WebAudio.GraphVisualizer.generateInputPortId=(nodeId,inputIndex)=>{return`${nodeId}-input-${inputIndex || 0}`;};WebAudio.GraphVisualizer.generateOutputPortId=(nodeId,outputIndex)=>{return`${nodeId}-output-${outputIndex || 0}`;};WebAudio.GraphVisualizer.generateParamPortId=(nodeId,paramId)=>{return`${nodeId}-param-${paramId}`;};WebAudio.GraphVisualizer.NodeLabelGenerator=class{constructor(){this._totalNumberOfNodes=0;}
generateLabel(nodeType){if(nodeType.endsWith('Node')){nodeType=nodeType.slice(0,nodeType.length-4);}
this._totalNumberOfNodes+=1;const label=`${nodeType} ${this._totalNumberOfNodes}`;return label;}};WebAudio.GraphVisualizer.measureTextWidth=(text,fontStyle)=>{if(!WebAudio.GraphVisualizer._contextForFontTextMeasuring){WebAudio.GraphVisualizer._contextForFontTextMeasuring=createElement('canvas').getContext('2d');}
const context=WebAudio.GraphVisualizer._contextForFontTextMeasuring;context.save();context.font=fontStyle;const width=UI.measureTextWidth(context,text);context.restore();return width;};;WebAudio.GraphVisualizer.EdgeView=class{constructor(data,type){const{edgeId,sourcePortId,destinationPortId}=WebAudio.GraphVisualizer.generateEdgePortIdsByData(data,type);this.id=edgeId;this.type=type;this.sourceId=data.sourceId;this.destinationId=data.destinationId;this.sourcePortId=sourcePortId;this.destinationPortId=destinationPortId;}};WebAudio.GraphVisualizer.generateEdgePortIdsByData=(data,type)=>{if(!data.sourceId||!data.destinationId){console.error(`Undefined node message: ${JSON.stringify(data)}`);return null;}
const sourcePortId=WebAudio.GraphVisualizer.generateOutputPortId(data.sourceId,data.sourceOutputIndex);const destinationPortId=getDestinationPortId(data,type);return{edgeId:`${sourcePortId}->${destinationPortId}`,sourcePortId:sourcePortId,destinationPortId:destinationPortId,};function getDestinationPortId(data,type){if(type===WebAudio.GraphVisualizer.EdgeTypes.NodeToNode){return WebAudio.GraphVisualizer.generateInputPortId(data.destinationId,data.destinationInputIndex);}else if(type===WebAudio.GraphVisualizer.EdgeTypes.NodeToParam){return WebAudio.GraphVisualizer.generateParamPortId(data.destinationId,data.destinationParamId);}else{console.error(`Unknown edge type: ${type}`);return'';}}};WebAudio.GraphVisualizer.EdgeTypes={NodeToNode:Symbol('NodeToNode'),NodeToParam:Symbol('NodeToParam'),};;WebAudio.GraphVisualizer.GraphView=class extends Common.Object{constructor(contextId){super();this.contextId=contextId;this._nodes=new Map();this._edges=new Map();this._outboundEdgeMap=new Platform.Multimap();this._inboundEdgeMap=new Platform.Multimap();this._nodeLabelGenerator=new WebAudio.GraphVisualizer.NodeLabelGenerator();this._paramIdToNodeIdMap=new Map();}
addNode(data){const label=this._nodeLabelGenerator.generateLabel(data.nodeType);const node=new WebAudio.GraphVisualizer.NodeView(data,label);this._nodes.set(data.nodeId,node);this._notifyShouldRedraw();}
removeNode(nodeId){this._outboundEdgeMap.get(nodeId).forEach(edgeId=>this._removeEdge(edgeId));this._inboundEdgeMap.get(nodeId).forEach(edgeId=>this._removeEdge(edgeId));this._nodes.delete(nodeId);this._notifyShouldRedraw();}
addParam(data){const node=this.getNodeById(data.nodeId);if(!node){console.error(`AudioNode should be added before AudioParam`);return;}
node.addParamPort(data.paramId,data.paramType);this._paramIdToNodeIdMap.set(data.paramId,data.nodeId);this._notifyShouldRedraw();}
removeParam(paramId){this._paramIdToNodeIdMap.delete(paramId);}
addNodeToNodeConnection(edgeData){const edge=new WebAudio.GraphVisualizer.EdgeView(edgeData,WebAudio.GraphVisualizer.EdgeTypes.NodeToNode);this._addEdge(edge);}
removeNodeToNodeConnection(edgeData){if(edgeData.destinationId){const{edgeId}=WebAudio.GraphVisualizer.generateEdgePortIdsByData((edgeData),WebAudio.GraphVisualizer.EdgeTypes.NodeToNode);this._removeEdge(edgeId);}else{this._outboundEdgeMap.get(edgeData.sourceId).forEach(edgeId=>this._removeEdge(edgeId));}}
addNodeToParamConnection(edgeData){const edge=new WebAudio.GraphVisualizer.EdgeView(edgeData,WebAudio.GraphVisualizer.EdgeTypes.NodeToParam);this._addEdge(edge);}
removeNodeToParamConnection(edgeData){const{edgeId}=WebAudio.GraphVisualizer.generateEdgePortIdsByData(edgeData,WebAudio.GraphVisualizer.EdgeTypes.NodeToParam);this._removeEdge(edgeId);}
getNodeById(nodeId){return this._nodes.get(nodeId);}
getNodes(){return this._nodes;}
getEdges(){return this._edges;}
getNodeIdByParamId(paramId){return this._paramIdToNodeIdMap.get(paramId);}
_addEdge(edge){const sourceId=edge.sourceId;if(this._outboundEdgeMap.hasValue(sourceId,edge.id)){return;}
this._edges.set(edge.id,edge);this._outboundEdgeMap.set(sourceId,edge.id);this._inboundEdgeMap.set(edge.destinationId,edge.id);this._notifyShouldRedraw();}
_removeEdge(edgeId){const edge=this._edges.get(edgeId);if(!edge){return;}
this._outboundEdgeMap.delete(edge.sourceId,edgeId);this._inboundEdgeMap.delete(edge.destinationId,edgeId);this._edges.delete(edgeId);this._notifyShouldRedraw();}
_notifyShouldRedraw(){this.dispatchEventToListeners(WebAudio.GraphVisualizer.GraphView.Events.ShouldRedraw,this);}};WebAudio.GraphVisualizer.GraphView.Events={ShouldRedraw:Symbol('ShouldRedraw')};;WebAudio.WebAudioModel=class extends SDK.SDKModel{constructor(target){super(target);this._enabled=false;this._agent=target.webAudioAgent();target.registerWebAudioDispatcher(this);SDK.targetManager.addModelListener(SDK.ResourceTreeModel,SDK.ResourceTreeModel.Events.FrameNavigated,this._flushContexts,this);}
_flushContexts(){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.ModelReset);}
suspendModel(){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.ModelSuspend);return this._agent.disable();}
resumeModel(){if(!this._enabled){return Promise.resolve();}
return this._agent.enable();}
ensureEnabled(){if(this._enabled){return;}
this._agent.enable();this._enabled=true;}
contextCreated(context){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.ContextCreated,context);}
contextWillBeDestroyed(contextId){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.ContextDestroyed,contextId);}
contextChanged(context){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.ContextChanged,context);}
audioListenerCreated(listener){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.AudioListenerCreated,listener);}
audioListenerWillBeDestroyed(contextId,listenerId){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.AudioListenerWillBeDestroyed,{contextId,listenerId});}
audioNodeCreated(node){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.AudioNodeCreated,node);}
audioNodeWillBeDestroyed(contextId,nodeId){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.AudioNodeWillBeDestroyed,{contextId,nodeId});}
audioParamCreated(param){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.AudioParamCreated,param);}
audioParamWillBeDestroyed(contextId,nodeId,paramId){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.AudioParamWillBeDestroyed,{contextId,paramId});}
nodesConnected(contextId,sourceId,destinationId,sourceOutputIndex,destinationInputIndex){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.NodesConnected,{contextId,sourceId,destinationId,sourceOutputIndex,destinationInputIndex});}
nodesDisconnected(contextId,sourceId,destinationId,sourceOutputIndex,destinationInputIndex){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.NodesDisconnected,{contextId,sourceId,destinationId,sourceOutputIndex,destinationInputIndex});}
nodeParamConnected(contextId,sourceId,destinationId,sourceOutputIndex){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.NodeParamConnected,{contextId,sourceId,destinationId,sourceOutputIndex,});}
nodeParamDisconnected(contextId,sourceId,destinationId,sourceOutputIndex){this.dispatchEventToListeners(WebAudio.WebAudioModel.Events.NodeParamDisconnected,{contextId,sourceId,destinationId,sourceOutputIndex,});}
async requestRealtimeData(contextId){return await this._agent.getRealtimeData(contextId);}};SDK.SDKModel.register(WebAudio.WebAudioModel,SDK.Target.Capability.DOM,false);WebAudio.WebAudioModel.Events={ContextCreated:Symbol('ContextCreated'),ContextDestroyed:Symbol('ContextDestroyed'),ContextChanged:Symbol('ContextChanged'),ModelReset:Symbol('ModelReset'),ModelSuspend:Symbol('ModelSuspend'),AudioListenerCreated:Symbol('AudioListenerCreated'),AudioListenerWillBeDestroyed:Symbol('AudioListenerWillBeDestroyed'),AudioNodeCreated:Symbol('AudioNodeCreated'),AudioNodeWillBeDestroyed:Symbol('AudioNodeWillBeDestroyed'),AudioParamCreated:Symbol('AudioParamCreated'),AudioParamWillBeDestroyed:Symbol('AudioParamWillBeDestroyed'),NodesConnected:Symbol('NodesConnected'),NodesDisconnected:Symbol('NodesDisconnected'),NodeParamConnected:Symbol('NodeParamConnected'),NodeParamDisconnected:Symbol('NodeParamDisconnected'),};;WebAudio.AudioContextSelector=class extends Common.Object{constructor(){super();this._placeholderText=ls`(no recordings)`;this._items=new UI.ListModel();this._dropDown=new UI.SoftDropDown(this._items,this);this._dropDown.setPlaceholderText(this._placeholderText);this._toolbarItem=new UI.ToolbarItem(this._dropDown.element);this._toolbarItem.setEnabled(false);this._toolbarItem.setTitle(ls`Audio context: ${this._placeholderText}`);this._items.addEventListener(UI.ListModel.Events.ItemsReplaced,this._onListItemReplaced,this);this._toolbarItem.element.classList.add('toolbar-has-dropdown');this._selectedContext=null;}
_onListItemReplaced(){const hasItems=!!this._items.length;this._toolbarItem.setEnabled(hasItems);if(!hasItems){this._toolbarItem.setTitle(ls`Audio context: ${this._placeholderText}`);}}
contextCreated(event){const context=(event.data);this._items.insert(this._items.length,context);if(this._items.length===1){this._dropDown.selectItem(context);}}
contextDestroyed(event){const contextId=(event.data);const contextIndex=this._items.findIndex(context=>context.contextId===contextId);if(contextIndex>-1){this._items.remove(contextIndex);}}
contextChanged(event){const changedContext=(event.data);const contextIndex=this._items.findIndex(context=>context.contextId===changedContext.contextId);if(contextIndex>-1){this._items.replace(contextIndex,changedContext);if(this._selectedContext&&this._selectedContext.contextId===changedContext.contextId){this._dropDown.selectItem(changedContext);}}}
createElementForItem(item){const element=createElementWithClass('div');const shadowRoot=UI.createShadowRootWithCoreStyles(element,'web_audio/audioContextSelector.css');const title=shadowRoot.createChild('div','title');title.createTextChild(this.titleFor(item).trimEndWithMaxLength(100));return element;}
selectedContext(){if(!this._selectedContext){return null;}
return this._selectedContext;}
highlightedItemChanged(from,to,fromElement,toElement){if(fromElement){fromElement.classList.remove('highlighted');}
if(toElement){toElement.classList.add('highlighted');}}
isItemSelectable(item){return true;}
itemSelected(item){if(!item){return;}
if(!this._selectedContext||this._selectedContext.contextId!==item.contextId){this._selectedContext=item;this._toolbarItem.setTitle(ls`Audio context: ${this.titleFor(item)}`);}
this.dispatchEventToListeners(WebAudio.AudioContextSelector.Events.ContextSelected,item);}
reset(){this._items.replaceAll([]);}
titleFor(context){return`${context.contextType} (${context.contextId.substr(-6)})`;}
toolbarItem(){return this._toolbarItem;}};WebAudio.AudioContextSelector.Events={ContextSelected:Symbol('ContextSelected')};;WebAudio.ContextDetailBuilder=class{constructor(context){this._fragment=createDocumentFragment();this._container=createElementWithClass('div','context-detail-container');this._fragment.appendChild(this._container);this._build(context);}
_build(context){const title=context.contextType==='realtime'?ls`AudioContext`:ls`OfflineAudioContext`;this._addTitle(title,context.contextId);this._addEntry(ls`State`,context.contextState);this._addEntry(ls`Sample Rate`,context.sampleRate,'Hz');if(context.contextType==='realtime'){this._addEntry(ls`Callback Buffer Size`,context.callbackBufferSize,'frames');}
this._addEntry(ls`Max Output Channels`,context.maxOutputChannelCount,'ch');}
_addTitle(title,subtitle){this._container.appendChild(UI.html`
      <div class="context-detail-header">
        <div class="context-detail-title">${title}</div>
        <div class="context-detail-subtitle">${subtitle}</div>
      </div>
    `);}
_addEntry(entry,value,unit){const valueWithUnit=value+(unit?` ${unit}`:'');this._container.appendChild(UI.html`
      <div class="context-detail-row">
        <div class="context-detail-row-entry">${entry}</div>
        <div class="context-detail-row-value">${valueWithUnit}</div>
      </div>
    `);}
getFragment(){return this._fragment;}};WebAudio.AudioContextSummaryBuilder=class{constructor(contextId,contextRealtimeData){const time=contextRealtimeData.currentTime.toFixed(3);const mean=(contextRealtimeData.callbackIntervalMean*1000).toFixed(3);const stddev=(Math.sqrt(contextRealtimeData.callbackIntervalVariance)*1000).toFixed(3);const capacity=(contextRealtimeData.renderCapacity*100).toFixed(3);this._fragment=createDocumentFragment();this._fragment.appendChild(UI.html`
      <div class="context-summary-container">
        <span>${ls`Current Time`}: ${time} s</span>
        <span>\u2758</span>
        <span>${ls`Callback Interval`}: μ = ${mean} ms, σ = ${stddev} ms</span>
        <span>\u2758</span>
        <span>${ls`Render Capacity`}: ${capacity} %</span>
      </div>
    `);}
getFragment(){return this._fragment;}};;WebAudio.WebAudioView=class extends UI.ThrottledWidget{constructor(){super(true,1000);this.element.classList.add('web-audio-drawer');this.registerRequiredCSS('web_audio/webAudio.css');const toolbarContainer=this.contentElement.createChild('div','web-audio-toolbar-container vbox');this._contextSelector=new WebAudio.AudioContextSelector();const toolbar=new UI.Toolbar('web-audio-toolbar',toolbarContainer);toolbar.appendToolbarItem(UI.Toolbar.createActionButtonForId('components.collect-garbage'));toolbar.appendSeparator();toolbar.appendToolbarItem(this._contextSelector.toolbarItem());this._detailViewContainer=this.contentElement.createChild('div','vbox flex-auto');this._graphManager=new WebAudio.GraphVisualizer.GraphManager();this._landingPage=new UI.VBox();this._landingPage.contentElement.classList.add('web-audio-landing-page','fill');this._landingPage.contentElement.appendChild(UI.html`
      <div>
        <p>${ls`Open a page that uses Web Audio API to start monitoring.`}</p>
      </div>
    `);this._landingPage.show(this._detailViewContainer);this._summaryBarContainer=this.contentElement.createChild('div','web-audio-summary-container');this._contextSelector.addEventListener(WebAudio.AudioContextSelector.Events.ContextSelected,event=>{const context=(event.data);this._updateDetailView(context);this.doUpdate();});SDK.targetManager.observeModels(WebAudio.WebAudioModel,this);}
wasShown(){super.wasShown();for(const model of SDK.targetManager.models(WebAudio.WebAudioModel)){this._addEventListeners(model);}}
willHide(){for(const model of SDK.targetManager.models(WebAudio.WebAudioModel)){this._removeEventListeners(model);}}
modelAdded(webAudioModel){if(this.isShowing()){this._addEventListeners(webAudioModel);}}
modelRemoved(webAudioModel){this._removeEventListeners(webAudioModel);}
async doUpdate(){await this._pollRealtimeData();this.update();}
_addEventListeners(webAudioModel){webAudioModel.ensureEnabled();webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.ContextCreated,this._contextCreated,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.ContextDestroyed,this._contextDestroyed,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.ContextChanged,this._contextChanged,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.ModelReset,this._reset,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.ModelSuspend,this._suspendModel,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.AudioListenerCreated,this._audioListenerCreated,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.AudioListenerWillBeDestroyed,this._audioListenerWillBeDestroyed,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.AudioNodeCreated,this._audioNodeCreated,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.AudioNodeWillBeDestroyed,this._audioNodeWillBeDestroyed,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.AudioParamCreated,this._audioParamCreated,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.AudioParamWillBeDestroyed,this._audioParamWillBeDestroyed,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.NodesConnected,this._nodesConnected,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.NodesDisconnected,this._nodesDisconnected,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.NodeParamConnected,this._nodeParamConnected,this);webAudioModel.addEventListener(WebAudio.WebAudioModel.Events.NodeParamDisconnected,this._nodeParamDisconnected,this);}
_removeEventListeners(webAudioModel){webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.ContextCreated,this._contextCreated,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.ContextDestroyed,this._contextDestroyed,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.ContextChanged,this._contextChanged,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.ModelReset,this._reset,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.ModelSuspend,this._suspendModel,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.AudioListenerCreated,this._audioListenerCreated,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.AudioListenerWillBeDestroyed,this._audioListenerWillBeDestroyed,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.AudioNodeCreated,this._audioNodeCreated,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.AudioNodeWillBeDestroyed,this._audioNodeWillBeDestroyed,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.AudioParamCreated,this._audioParamCreated,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.AudioParamWillBeDestroyed,this._audioParamWillBeDestroyed,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.NodesConnected,this._nodesConnected,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.NodesDisconnected,this._nodesDisconnected,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.NodeParamConnected,this._nodeParamConnected,this);webAudioModel.removeEventListener(WebAudio.WebAudioModel.Events.NodeParamDisconnected,this._nodeParamDisconnected,this);}
_contextCreated(event){const context=(event.data);this._graphManager.createContext(context.contextId);this._contextSelector.contextCreated(event);}
_contextDestroyed(event){const contextId=(event.data);this._graphManager.destroyContext(contextId);this._contextSelector.contextDestroyed(event);}
_contextChanged(event){const context=(event.data);if(!this._graphManager.hasContext(context.contextId)){return;}
this._contextSelector.contextChanged(event);}
_reset(){if(this._landingPage.isShowing()){this._landingPage.detach();}
this._contextSelector.reset();this._detailViewContainer.removeChildren();this._landingPage.show(this._detailViewContainer);this._graphManager.clearGraphs();}
_suspendModel(){this._graphManager.clearGraphs();}
_audioListenerCreated(event){const listener=(event.data);const graph=this._graphManager.getGraph(listener.contextId);if(!graph){return;}
graph.addNode({nodeId:listener.listenerId,nodeType:'Listener',numberOfInputs:0,numberOfOutputs:0,});}
_audioListenerWillBeDestroyed(event){const{contextId,listenerId}=event.data;const graph=this._graphManager.getGraph(contextId);if(!graph){return;}
graph.removeNode(listenerId);}
_audioNodeCreated(event){const node=(event.data);const graph=this._graphManager.getGraph(node.contextId);if(!graph){return;}
graph.addNode({nodeId:node.nodeId,nodeType:node.nodeType,numberOfInputs:node.numberOfInputs,numberOfOutputs:node.numberOfOutputs,});}
_audioNodeWillBeDestroyed(event){const{contextId,nodeId}=event.data;const graph=this._graphManager.getGraph(contextId);if(!graph){return;}
graph.removeNode(nodeId);}
_audioParamCreated(event){const param=(event.data);const graph=this._graphManager.getGraph(param.contextId);if(!graph){return;}
graph.addParam({paramId:param.paramId,paramType:param.paramType,nodeId:param.nodeId,});}
_audioParamWillBeDestroyed(event){const{contextId,paramId}=event.data;const graph=this._graphManager.getGraph(contextId);if(!graph){return;}
graph.removeParam(paramId);}
_nodesConnected(event){const{contextId,sourceId,destinationId,sourceOutputIndex,destinationInputIndex}=event.data;const graph=this._graphManager.getGraph(contextId);if(!graph){return;}
graph.addNodeToNodeConnection({sourceId,destinationId,sourceOutputIndex,destinationInputIndex,});}
_nodesDisconnected(event){const{contextId,sourceId,destinationId,sourceOutputIndex,destinationInputIndex}=event.data;const graph=this._graphManager.getGraph(contextId);if(!graph){return;}
graph.removeNodeToNodeConnection({sourceId,destinationId,sourceOutputIndex,destinationInputIndex,});}
_nodeParamConnected(event){const{contextId,sourceId,destinationId,sourceOutputIndex}=event.data;const graph=this._graphManager.getGraph(contextId);if(!graph){return;}
const nodeId=graph.getNodeIdByParamId(destinationId);if(!nodeId){return;}
graph.addNodeToParamConnection({sourceId,destinationId:nodeId,sourceOutputIndex,destinationParamId:destinationId,});}
_nodeParamDisconnected(event){const{contextId,sourceId,destinationId,sourceOutputIndex}=event.data;const graph=this._graphManager.getGraph(contextId);if(!graph){return;}
const nodeId=graph.getNodeIdByParamId(destinationId);if(!nodeId){return;}
graph.removeNodeToParamConnection({sourceId,destinationId:nodeId,sourceOutputIndex,destinationParamId:destinationId,});}
_updateDetailView(context){if(this._landingPage.isShowing()){this._landingPage.detach();}
const detailBuilder=new WebAudio.ContextDetailBuilder(context);this._detailViewContainer.removeChildren();this._detailViewContainer.appendChild(detailBuilder.getFragment());}
_updateSummaryBar(contextId,contextRealtimeData){const summaryBuilder=new WebAudio.AudioContextSummaryBuilder(contextId,contextRealtimeData);this._summaryBarContainer.removeChildren();this._summaryBarContainer.appendChild(summaryBuilder.getFragment());}
_clearSummaryBar(){this._summaryBarContainer.removeChildren();}
async _pollRealtimeData(){const context=this._contextSelector.selectedContext();if(!context){this._clearSummaryBar();return;}
for(const model of SDK.targetManager.models(WebAudio.WebAudioModel)){if(context.contextType==='realtime'){if(!this._graphManager.hasContext(context.contextId)){continue;}
const realtimeData=await model.requestRealtimeData(context.contextId);if(realtimeData){this._updateSummaryBar(context.contextId,realtimeData);}}else{this._clearSummaryBar();}}}};;Root.Runtime.cachedResources["web_audio/webAudio.css"]="/*\n * Copyright 2019 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n  overflow: hidden;\n}\n\n.web-audio-toolbar-container {\n  background-color: var(--toolbar-bg-color);\n  border-bottom: var(--divider-border);\n}\n\n.web-audio-toolbar {\n  display: inline-block;\n}\n\n.web-audio-landing-page {\n  position: absolute;\n  background-color: white;\n  justify-content: center;\n  align-items: center;\n  overflow: auto;\n  font-size: 13px;\n  color: #777;\n}\n\n.web-audio-landing-page > div {\n  max-width: 500px;\n  margin: 10px;\n}\n\n.web-audio-landing-page > div > p {\n  flex: none;\n  white-space: pre-line;\n}\n\n.context-detail-container {\n  flex: none;\n  display: flex;\n  background-color: white;\n  flex-direction: column;\n}\n\n.context-detail-header {\n  border-bottom: 1px solid rgb(230, 230, 230);\n  padding: 12px 24px;\n  margin-bottom: 10px;\n}\n\n.context-detail-title {\n  font-size: 15px;\n  font-weight: 400;\n}\n\n.context-detail-subtitle {\n  font-size: 12px;\n  margin-top: 10px;\n  user-select: text;\n}\n\n.context-detail-row {\n  flex-direction: row;\n  display: flex;\n  line-height: 18px;\n  padding-left: 24px;\n}\n\n.context-detail-row-entry:not(:empty) {\n  color: hsla(0, 0%, 46%, 1);\n  overflow: hidden;\n  width: 130px;\n}\n\n.context-detail-row-value {\n  user-select: text;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n  overflow: hidden;\n}\n\n.context-summary-container {\n  flex: 0 0 27px;\n  line-height: 27px;\n  padding-left: 5px;\n  background-color: #eee;\n  border-top: 1px solid #ccc;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n  overflow: hidden;\n}\n\n.context-summary-container span {\n  margin-right: 6px;\n}\n\n/*# sourceURL=web_audio/webAudio.css */";Root.Runtime.cachedResources["web_audio/audioContextSelector.css"]="/*\n * Copyright 2019 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n  padding: 2px 1px 2px 2px;\n  white-space: nowrap;\n  display: flex;\n  flex-direction: column;\n  height: 36px;\n  justify-content: center;\n}\n\n.title {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  flex-grow: 0;\n}\n/*# sourceURL=web_audio/audioContextSelector.css */";