#!/usr/local/bin/python2.7
# send 2 ping6 fragments with hop-by-hop extension header

import os
import threading
from addr import *
from scapy.all import *

class Sniff1(threading.Thread):
	filter = None
	captured = None
	packet = None
	def run(self):
		self.captured = sniff(iface=SRC_IF, filter=self.filter,
		    count=1, timeout=3)
		if self.captured:
			self.packet = self.captured[0]

dstaddr=sys.argv[1]
pid=os.getpid()
eid=pid & 0xffff
payload="ABCDEFGHIJKLOMNO"
packet=IPv6(src=SRC_OUT6, dst=dstaddr)/ICMPv6EchoRequest(id=eid, data=payload)
fid=pid & 0xffffffff
frag0=IPv6ExtHdrFragment(nh=58, id=fid, m=1)/str(packet)[40:56]
frag1=IPv6ExtHdrFragment(nh=58, id=fid, offset=2)/str(packet)[56:64]
pkt0=IPv6(src=SRC_OUT6, dst=dstaddr)/IPv6ExtHdrHopByHop()/frag0
pkt1=IPv6(src=SRC_OUT6, dst=dstaddr)/IPv6ExtHdrHopByHop()/frag1
eth=[]
eth.append(Ether(src=SRC_MAC, dst=PF_MAC)/pkt0)
eth.append(Ether(src=SRC_MAC, dst=PF_MAC)/pkt1)

sniffer = Sniff1();
sniffer.filter = "ip6 and src %s and dst %s and icmp6" % (dstaddr, SRC_OUT6)
sniffer.start()
time.sleep(1)
sendp(eth, iface=SRC_IF)
sniffer.join(timeout=5)
a = sniffer.packet

if a and a.type == ETH_P_IPV6 and \
    ipv6nh[a.payload.nh] == 'ICMPv6' and \
    icmp6types[a.payload.payload.type] == 'Echo Reply':
	id=a.payload.payload.id
	print "id=%#x" % (id)
	if id != eid:
		print "WRONG ECHO REPLY ID"
		exit(2)
	data=a.payload.payload.data
	print "payload=%s" % (data)
	if data == payload:
		exit(0)
	print "PAYLOAD!=%s" % (payload)
	exit(1)
print "NO ECHO REPLY"
exit(2)
