package VCP::Help;

%topics = (
########################################################################
'vcp' => <<'TOPIC',
NAME
    vcp - Copy versions of files between repositories and/or RevML

SYNOPSIS
       # interactive mode:

       vcp [vcp_opts]

       # scriptable command line mode:

       vcp [vcp_opts] <source> <dest>

       # getting options from a file:

       vcp vcp:config.vcp

       # help output:

       vcp help
       vcp help [topic]

DESCRIPTION
    "vcp" ('version copy') copies versions of files from one repository
    to another, translating as much metadata as possible along the way.
    This allows you to copy and translate files and their histories
    between revision storage systems.

    Supported source and destination types are "cvs:", "p4:", and
    "revml:".

  Copying Versions
    The general syntax of the vcp command line is:

       vcp [<vcp options>] <source> <dest>

    The three portions of the command line are:

    "<vcp options>"
        Command line options that control the operation of the "vcp"
        command, like "-d" for debugging or "-h" for help. There are
        very few global options, these are covered below. Note that they
        must come before the "<source>" specification.

    "<source>"
        Were to extract versions from, including any command line
        options needed to control what is extracted and how. See the
        next section.

    "<dest>"
        Where to insert versions, including any command line options
        needed to control how files are stored. See the next section.

  Specifying Repositories
    The "<source>" and "<dest>" specifications specify a repository and
    provide any options needed for accessing that repository.

    These spefications may be a simple filename for reading or writing
    RevML files (if the requisite XML handling modules are installed).
    or a full repository specification like "cvs:/home/cvs/root:module"
    or "p4:user:password@server:port://depot/dir".

    When using the long form to access a repository, "<source>" and
    "<dest>" specification have several fields delimited by ":" and "@",
    and may have trailing command line options. The full (rarely used)
    syntax is:

       scheme:user(view):password@repository:filespec [<options>]

    where

    "scheme:"
        The repository type ("p4:", "cvs:", "revml:").

    "user", "view", and "password"
        Optional values for authenticating with the repository and
        identifying which view to use. "cvs" does not use "view". For
        "p4", "view" is the client setting (equibalent to setting
        "P4CLIENT" or using "p4"'s "-c" option).

    "repository"
        The repository spec, CVSROOT for CVS or P4PORT for p4.

    "filespec"
        Which versions of what files to move. As much as possible, this
        spec is similar to the native filespecs used by the repository
        indicated by the scheme.

    "<options>"
        Command line options that usually mimic the options provided by
        the underlying repositories' command line tools ("cvs", "p4",
        etc).

    Most of these fields are omitted in practice, only the "scheme"
    field is required, though (in most cases) the "repository" field is
    also needed unless you set the appropriate environment variables
    ("CVSROOT", "P4PORT", etc).

    The a bit confusing, here are some examples specs:

       cvs:server:/foo
       p4:user@server://depot/foo/...
       p4:user:password@public.perforce.com:1666://depot/foo/...

    Options and formats for of individual schemes can be found in the
    relevant help topics, for instance:

       vcp help source::cvs

    Run "vcp help" for a list of topics.

    When reading and writing RevML files, a simple filename will do
    (although the long form may also be used). The special value "-"
    means to read/write stdin and stdout when used as a source or
    destination name, respectively. "-" is assumed if a specification is
    not provided, so these invocations all accomplish the same thing,
    reading and writing RevML:

       vcp
       vcp -
       vcp revml:-
       vcp revml:
       vcp - -
       vcp - revml:-
       vcp - revml:
       vcp revml:- revml:-
       vcp revml: revml:

  "vcp" Options
    All general options to vcp must precede the "<source>".
    Scheme-specific options must be placed immediately after the
    "<source>" or "<dest>" spec and before the next one.

    --debug, -d
        Enables logging of debugging information.

    --help, -h, -?
        These are all equivalent to "vcp help".

    --output-config-file=$filename
        Write the settings (parsed from the UI, the command line, or a
        config file to a file. Useful for capturing settings or user
        interface output. Does not affect running. Use "-" to emit to
        STDOUT.

        NOTE 1: This does *not* emit an "Options:" section containing
        global options (those listed here). Almost all of these options
        are not useful to emit; we can add an option to force their
        emission if need be.

        NOTE 2: When using the interactive user interface, this option
        takes effect after the last interactive portion and, if vcp goes
        on to run a conversion, before any conversion is run. This
        occurs in addition to any configuration files the user may ask
        the interactive interface to write. This may change in the
        future (for instance, if the interactive dialog includes an
        option to extract and analyze metadata).

    --dont-convert
        Do not run a conversion. Useful when you just want to emit a
        .vcp file.

    --versions
        Emits the version numbers of bundled files.

    --terse, -t
        Suppress verbose explanations when running the interactive UI.
        Has no effect on operation if all settings are read from the
        command line or a .vcp file.

    --quiet, -q
        Suppresses the banner and progress bars.

  Getting help
    (See also Generating HTML Documentation, below).

    There is a slightly different command line format for requesting
    help:

       vcp help [<topic>]

    where "<topic>" is the optional name of a topic. "vcp help" without
    a "<"topic">" prints out a list of topics, and "vcp help vcp" emits
    this page.

    All help documents are also available as Unix "man" pages and using
    the "perldoc" command, although the names are slightly different:

       with vcp               via perldoc        
       ================       ===========
       vcp help vcp           perldoc vcp
       vcp help source::cvs   perldoc VCP::Source::cvs
       vcp help source::cvs   perldoc VCP::Dest::p4

    "vcp help" is case insensitive, "perldoc" and "man" may or may not
    be depending on your filesystem. The "man" commands look just like
    the example "perldoc" commands except for the command name. Both
    have the advantage that they use your system's configured pager if
    possible.

  Environment Variables
    The environment is often used to set context for the source and
    destination by way of variables like P4USER, P4CLIENT, CVSROOT, etc.

    VCPDEBUG
        The VCPDEBUG variable acts just like "-d=$VCPDEBUG" was present
        on the command line:

           VCPDEBUG=1

        (see "--debug, -d" for more info). This is useful when VCP is
        embedded in another application, like a makefile or a test
        suite.

SEE ALSO
    VCP::Process, VCP::Newlines, VCP::Source::p4, VCP::Dest::p4,
    VCP::Source::cvs, VCP::Dest::cvs, VCP::Source::revml,
    VCP::Dest::revml, VCP::Newlines. All are also available using "vcp
    help".

AUTHOR
    Barrie Slaymaker <barries@slaysys.com>

COPYRIGHT
    Copyright (c) 2000, 2001, 2002 Perforce Software, Inc. All rights
    reserved.

    See VCP::License ("vcp help license") for the terms of use.
TOPIC
########################################################################
'vcp usage' => <<'TOPIC',
Usage:
       # interactive mode:

       vcp [vcp_opts]

       # scriptable command line mode:

       vcp [vcp_opts] <source> <dest>

       # getting options from a file:

       vcp vcp:config.vcp

       # help output:

       vcp help
       vcp help [topic]
TOPIC
########################################################################
'source' => <<'TOPIC',
NAME
    VCP::Source - A base class for repository sources

SYNOPSIS
DESCRIPTION
OPTIONS
    --bootstrap
          --bootstrap=pattern

        Forces all files matching the given shell regular expression
        (may use wildcards like "*", "?", and "...") to have their first
        revisions transferred as complete copies instead of deltas. This
        is useful when you want to transfer a revision other than the
        first revision as the first revision in the target repository.
        It is also useful when you want to skip some revisions in the
        target repository (although the Map filter has superceded this
        use).

    --continue
        Tells VCP to continue where it left off from last time. This
        will not detect new branches of already transferred revisions
        (this limitation should be lifted, but results in an expensive
        rescan of metadata), but will detect updates to already
        transferred revisions.

    --rev-root
        Tells VCP to extract files relative to a directory in the source
        repository other than the default directory. Ordinarily, VCP
        looks at the source specification and deduces that the lowest
        complete directory name is the "root" directory for all
        revisions, or the "rev_root".

        For instance, given the specification:

            cvs:foo/bar/...

        the rev_root will be "foo/bar" and the files under bar will be
        extracted with a path relative to bar, so "foo/bar/baz/bat" will
        be extracted with the value "baz/bat".

        They will be inserted in the destination repository relative to
        the rev_root for the destination, so if the destination spec is
        like:

            p4://depot/...

        then "baz/bat" will be inserted in the destination as
        "//depot/baz/bat".

        If there is no target rev_root specified, as in the spec:

            p4:

        then the source's rev_root will be assumed, so "baz/bat" in our
        example would be placed in "//foo/bar/baz/bat".

SUBCLASSING
    This class uses the fields pragma, so you'll need to use base and
    possibly fields in any subclasses. See VCP::Plugin for methods often
    needed in subclasses.

  Subclass utility API
    options_spec
        Adds common VCP::Source options to whatever options VCP::Plugin
        parses:

    dest
        Sets/Gets a reference to the VCP::Dest object. The source uses
        this to call handle_header(), handle_rev(), and handle_end()
        methods.

    continue
        Sets/Gets the CONTINUE field (which the user sets via the
        --continue flag)

    real_source
        Returns the reference to be used when sending revisions to the
        destination.

        Each revision has a pointer to the source that sends it so that
        filters and destinations can call get_source_file().

        Most sources return $self; Sources that spool data, such as
        VCP::Source::metadb, need to specify a real source. They do so
        by overloading this method. VCP::Source::revml does not do this,
        as it supplies a get_source_file().

    rev_mode
            my $mode = $self->rev_mode( $filebranch_id, $rev_id );

        Returns FALSE, "base", or "normal" as a function of the
        filebranch and rev_id. Do not queue the revision if this returns
        FALSE (you may also skip any preceding revisions). Queue it only
        as a base revision if it returns "base", and queue it as a full
        revision otherwise.

        Not all base revs will be sent; base revs that have no child
        revs will not be sent.

        Always returns "normal" when not in continue mode.

    queue_rev
        Some revs can't be sent immediately. They get queued. Once
        queued, the revision may not be altered. All revisions must be
        queued before being sent. All revs from the source repository
        should be queued, --continue processing is automatic.
        Placeholders should be inserted for all branches, even empty
        ones.

        This updates last_rev and last_rev_for_filebranch.

        Returns FALSE if the rev cannot be queued, for instance if it's
        already been queued once.

        rev_mode() should be called before creating a rev, or at least
        before queue_rev()ing it in order to see if and in what form the
        rev should be sent.

    queued_rev
            $self->queued_rev( $id );

        Returns a queued rev by id.

        Sources where revs can arrive willy-nilly, like
        VCP::Source::revml, queue up all revs and need to randomly
        access them.

    last_rev_for_filebranch
            $self->last_rev_for_filebranch( $filebranch_id );

        Returns the last revision queued on the indicated filebranch.

    set_last_rev_in_filebranch_previous_id
            $self->set_last_rev_in_filebranch_previous_id( $r );

        If there is a last_rev_for_filebranch for $r->filebranch_id,
        sets its previous_id to point to $r. This is useful for sources
        which scan in most-recent-first order.

    queued_rev_count
        Returns (does not set) the number of revs queued so far.

        Replaces the deprecated function sent_rev_count().

    store_cached_revs
            $self->store_cached_revs;

        For parsers which read history one file at a time and branch in
        rev_id space, like VCP::Source::cvs, it's possible to flush all
        revs to disk after each file is parsed. This method takes the
        last VCP::Rev in each filebranch and stores it to disk, freeing
        memory.

    send_revs
            $self->send_revs;

        Removes and sends all revs accumulated so far. Called
        automatically after scan_metadata().

SUBCLASS OVERLOADS
    These methods should be overridded in any subclasses.

    scan_metadata
        This is called to scan the metadata for the source repository.
        It should call rev_mode() for each revision found (including any
        that need to be concocted to make up for collapsed metadata in
        the source, like VSS or CVS deletes or CVS branch creation) and
        if that returns TRUE, then queue_rev() should be called.

        If rev_mode() returns "base", then the transfer is in --continue
        mode and this rev should be built as or converted to a base
        revision. The easiest way to do this is to build it normally and
        then call $r->base_revify().

        If the metadata source returns metadata from most recent to
        oldest, as do most file history reports, the previous_id() need
        not be set until the next revision in a filebranch is scanned.
        The most recent rev passed to queue_rev() is available by
        calling last_rev(), if the metadata is one branch at a time, and
        the last rev in each filebranch is available by calling
        last_rev_for_filebranch().

        If the metadata is scanned one file or filebranch at a time and
        branched are all created by the time the end of a file's
        metadata arrives, calling store_cached_revs() will flush all
        queued revs from the last_rev() and last_rev_for_filebranch()
        in-memory caches to the disk cache (all other revs are flushed
        as their successors arrive).

        There is no easy way to handle randomly ordered metadata at this
        time, typically a source will accumulate as little as it can in
        memory and queue the rest. See VCP::Source::cvs for an example
        of this.

        Once scan_metadata() is complete, send_revs() will be called
        automatically.

    get_source_file
        REQUIRED OVERLOAD.

        All sources must provide a way for the destination to fetch a
        revision.

    handle_header
        REQUIRED OVERLOAD.

        Subclasses must add all repository-specific info to the $header,
        at least including rep_type and rep_desc.

           $header->{rep_type} => 'p4',
           $self->p4( ['info'], \$header->{rep_desc} ) ;

        The subclass must pass the $header on to the dest:

           $self->dest->handle_header( $header )
              if $self->dest;

        This may be called when dest is null to allow the source to
        initialize itself when it won't be scanning the real source. So
        the if $self->dest is important.

        That's not the case for copy_revs().

    handle_footer
        Not a required overload, as the footer carries no useful
        information at this time. Overriding methods must call this
        method to pass the $footer on:

           $self->SUPER::handle_footer( $footer ) ;

    parse_time
           $time = $self->parse_time( $timestr ) ;

        Parses "[cc]YY/MM/DD[ HH[:MM[:SS]]]".

        Will add ability to use format strings in future. HH, MM, and SS
        are assumed to be 0 if not present.

        Returns a time suitable for feeding to localtime or gmtime.

        Assumes local system time, so no good for parsing times in
        revml, but that's not a common thing to need to do, so it's in
        VCP::Source::revml.pm.

    bootstrap
        Sets (and parses) or gets the bootstrap spec.

        Can be called plain:

           $self->bootstrap( $bootstrap_spec ) ;

        See the command line documentation for the format of
        $bootstrap_spec.

    is_bootstrap_mode
           ... if $self->is_bootstrap_mode( $file ) ;

        Compares the filename passed in against the list of bootstrap
        regular expressions set by "bootstrap".

        The file should be in a format similar to the command line spec
        for whatever repository is passed in, and not relative to
        rev_root, so "//depot/foo/bar" for p4, or "module/foo/bar" for
        cvs.

        This is typically called in the subbase class only after looking
        at the revision number to see if it is a first revision (in
        which case the subclass should automatically put it in bootstrap
        mode).

COPYRIGHT
    Copyright 2000, Perforce Software, Inc. All Rights Reserved.

    This module and the VCP package are licensed according to the terms
    given in the file LICENSE accompanying this distribution, a copy of
    which is included in vcp.

AUTHOR
    Barrie Slaymaker <barries@slaysys.com>
TOPIC
########################################################################
'filter' => <<'TOPIC',
NAME
    VCP::Filter - A base class for filters

SYNOPSIS
       use VCP::Filter;
       @ISA = qw( VCP::Filter );
       ...

DESCRIPTION
    A VPC::Filter is a VCP::Plugin that is placed between the source and
    the destination and allows the stream of revisions to be altered.

    For instance, the Map: option in vcp files is implemented by
    VCP::Filter::Map

    By default a filter is a pass-through.

SUBCLASSING
    This class uses the fields pragma, so you'll need to use base and
    possibly fields in any subclasses.

    parse_rules_list
        Used in VCP::Filter::*map and VCP::Filter::*edit to parse lists
        of rules where every rule is a set of N "words". The value of N
        is computed from the number of labels passed in and the labels
        are used when printing an error message:

            @rules = $self->parse_rules( $options, "Pattern", "Replacement" );

    filter_name
        Returns the StudlyCaps version of the filter name. By default,
        assumes a single work name and uses ucfirst on it. Filters like
        StringEdit should overload this to be more creative and
        typgraphically appealing (heh).

    sort_keys
           my @output_sort_order = $filter->sort_keys( @input_sort_order );

        Accepts a list of sort keys from the upstream filter and returns
        a list of sort keys representing the order that records will be
        emitted in.

        This is a pass-through by default, but VCP::Filter::sort and
        VCP::Filter::changesets return appropriate values.

    config_file_section_as_string
    last_rev_in_filebranch
        (passthru; see VCP::Dest)

    backfill
        (passthru; see VCP::Dest)

    handle_header
        (passthru)

    rev_count
            $self->SUPER::rev_count( @_ );

        passthru, see VCP::Dest.

    handle_rev
            $self->SUPER::handle_rev( @_ );

        passthru, see VCP::Dest.

    skip_rev
            $self->SUPER::skip_rev( @_ );

        passthru, see VCP::Dest

    handle_footer
            $self->SUPER::handle_footer( @_ );

        passthru, see VCP::Dest

COPYRIGHT
    Copyright 2000, Perforce Software, Inc. All Rights Reserved.

    This module and the VCP package are licensed according to the terms
    given in the file LICENSE accompanying this distribution, a copy of
    which is included in vcp.

AUTHOR
    Barrie Slaymaker <barries@slaysys.com>
TOPIC
########################################################################
'defaultfilters' => <<'TOPIC',
NAME
    VCP::DefaultFilters - Class for determining default filters to
    install for a given source and dest.

SYNOPSIS
       require VCP::DefaultFilters;
       my $df = VCP::DefaultFilters->new;
       my @filter_args = $df->create_default_filters( $source, $dest );

DESCRIPTION
    Given references to a vcp source and destination, determines the
    default filters which would be appropriate, builds and returns a
    list of arguments that should look like the portion of @ARGV
    (command line arguments) that specify filters.

COPYRIGHT
    Copyright 2000, Perforce Software, Inc. All Rights Reserved.

    This module and the VCP package are licensed according to the terms
    given in the file LICENSE accompanying this distribution, a copy of
    which is included in vcp.
TOPIC
########################################################################
'dest' => <<'TOPIC',
NAME
    VCP::Dest - A base class for VCP destinations

SYNOPSIS
DESCRIPTION
  SUBCLASS API
    These methods are intended to support subclasses.

    digest
            $self->digest( "/tmp/readers" ) ;

        Returns the Base64 MD5 digest of the named file. Used to compare
        a base rev (which is the revision *before* the first one we want
        to transfer) of a file from the source repo to the existing head
        rev of a dest repo.

        The Base64 version is returned because that's what RevML uses
        and we might want to cross-check with a .revml file when
        debugging.

    compare_base_revs
           $self->compare_base_revs( $rev, $work_path ) ;

        Checks out the indicated revision from the destination
        repository and compares it (using digest()) to the file from the
        source repository (as indicated by $work_path). Dies with an
        error message if the base revisions do not match.

        Calls $self->checkout_file( $rev ), which the subclass must
        implement.

    header
        Gets/sets the $header data structure passed to handle_header().

    rev_map
        Returns a reference to the RevMapDB for this backend and
        repository. Creates an empty one if need be.

    head_revs
        Returns a reference to the HeadRevsDB for this backend and
        repository. Creates an empty one if need be.

    main_branch_id
        Returns a reference to the MainBranchIdDB for this backend and
        repository. Creates an empty one if need be.

    files
        Returns a reference to the FilesDB for this backend and
        repository. Creates an empty one if need be.

  SUBCLASS OVERLOADS
    These methods are overloaded by subclasses.

    backfill
           $dest->backfill( $rev ) ;

        Checks the file indicated by VCP::Rev $rev out of the target
        repository if this destination supports backfilling. Currently,
        only the revml and the reporting & debugging destinations do not
        support backfilling.

        The $rev->workpath must be set to the filename the backfill was
        put in.

        This is used when doing an incremental update, where the first
        revision of a file in the update is encoded as a delta from the
        prior version. A digest of the prior version is sent along
        before the first version delta to verify it's presence in the
        database.

        So, the source calls backfill(), which returns TRUE on success,
        FALSE if the destination doesn't support backfilling, and dies
        if there's an error in procuring the right revision.

        If FALSE is returned, then the revisions will be sent through
        with no working path, but will have a delta record.

        MUST BE OVERRIDDEN.

    sort_filter
            sub sort_filter {
               my $self = shift;
               my @sort_keys = @_;
               return () if @sort_keys && $sort_keys[0] eq "change_id";
               require VCP::Filter::changesets;
               return ( VCP::Filter::changesets->new(), );
            }

        This is passed a sort specification string and returns any
        filters needed to presort data for this destination. It may
        return the empty list (the default), or one or more instantiated
        filters.

    require_change_id_sort
        Destinations that care about the sort order usually want to use
        the changesets filter, so they can overload the sort filter like
        so:

           sub sort_filters { shift->require_change_id_sort( @_ ) }

    handle_footer
           $dest->handle_footer( $footer ) ;

        Does any cleanup necessary. Not required. Don't call this from
        the override.

    handle_header
           $dest->handle_header( $header ) ;

        Stows $header in $self->header. This should only rarely be
        overridden, since the first call to handle_rev() should output
        any header info.

    rev_count
           $dest->rev_count( $number_of_revs_forthcoming );

        Sent by the last aggregating plugin in the filter chain just
        before the first revision is sent to inform us of the number of
        revs to expect.

    skip_rev
        Sent by filters that discard revisions in line.

    handle_rev
           $dest->handle_rev( $rev ) ;

        Outputs the item referred to by VCP::Rev $rev. If this is the
        first call, then $self->none_seen will be TRUE and any preamble
        should be emitted.

        MUST BE OVERRIDDEN. Don't call this from the override.

    last_rev_in_filebranch
           my $rev_id = $dest->last_rev_in_filebranch(
              $source_repo_id,
              $source_filebranch_id
           );

        Returns the last revision for the file and branch indicated by
        $source_filebranch_id. This is used to support --continue.

        Returns undef if not found.

NOTES
    Several fields are jury rigged for "base revisions": these are fake
    revisions used to start off incremental, non-bootstrap transfers
    with the MD5 digest of the version that must be the last version in
    the target repository. Since these are "faked", they don't contain
    comments or timestamps, so the comment and timestamp fields are
    treated as "" and 0 by the sort routines.

COPYRIGHT
    Copyright 2000, Perforce Software, Inc. All Rights Reserved.

    This module and the VCP package are licensed according to the terms
    given in the file LICENSE accompanying this distribution, a copy of
    which is included in vcp.

AUTHOR
    Barrie Slaymaker <barries@slaysys.com>
TOPIC
########################################################################
'filter::logmemsize' => <<'TOPIC',
NAME
    VCP::Filter::logmemsize - developement logging filter

DESCRIPTION
    Watches memory size. Only works on linux for now.

    Not a supported module, API and behavior may change without warning.

AUTHOR
    Barrie Slaymaker <barries@slaysys.com>

COPYRIGHT
    Copyright (c) 2000, 2001, 2002 Perforce Software, Inc. All rights
    reserved.

    See VCP::License ("vcp help license") for the terms of use.
TOPIC
########################################################################
'filter::logmemsize usage' => <<'TOPIC',

TOPIC
