/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmic;

import gnu.classpath.tools.rmic.AbstractMethodGenerator;
import gnu.classpath.tools.rmic.CompilationError;
import gnu.classpath.tools.rmic.Generator;
import gnu.classpath.tools.rmic.HashFinder;
import gnu.classpath.tools.rmic.MethodGenerator;
import gnu.classpath.tools.rmic.RmicBackend;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceGiopRmicCompiler
extends Generator
implements Comparator<AbstractMethodGenerator>,
RmicBackend {
    protected String packag;
    protected String name;
    protected String implName;
    protected String stubName;
    protected Collection<Class<?>> implementedRemotes = new HashSet();
    protected Collection<String> extraImports = new HashSet<String>();
    protected Collection<AbstractMethodGenerator> methods = new HashSet<AbstractMethodGenerator>();
    public Properties vars = new Properties();
    protected boolean poaMode = true;
    protected boolean warnings = true;
    protected boolean noWrite = false;
    protected boolean keep = false;
    protected boolean verbose = false;
    protected boolean force = false;
    protected String outputDirectory;
    ClassLoader classLoader;

    public synchronized void reset() {
        this.stubName = null;
        this.implName = null;
        this.name = null;
        this.packag = null;
        this.implementedRemotes.clear();
        this.extraImports.clear();
        this.methods.clear();
        this.vars.clear();
    }

    public void setClassPath(String classPath) {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        StringTokenizer tok = new StringTokenizer(classPath, File.pathSeparator, true);
        ArrayList<URL> urls = new ArrayList<URL>(tok.countTokens());
        String s = null;
        try {
            while (tok.hasMoreTokens()) {
                s = tok.nextToken();
                if (s.equals(File.pathSeparator)) {
                    urls.add(new File(".").toURL());
                    continue;
                }
                urls.add(new File(s).toURL());
                if (!tok.hasMoreTokens()) continue;
                tok.nextToken();
                if (tok.hasMoreTokens()) continue;
                urls.add(new File(".").toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Malformed path '" + s + "' in classpath '" + classPath + "'");
            System.exit(1);
        }
        URL[] u = new URL[urls.size()];
        int i = 0;
        while (i < u.length) {
            u[i] = (URL)urls.get(i);
            ++i;
        }
        this.classLoader = new URLClassLoader(u, this.classLoader);
    }

    public Class loadClass(String name) {
        ClassLoader loader = this.classLoader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(String.valueOf(name) + " not found on " + loader);
            System.exit(1);
            return null;
        }
    }

    public synchronized void compile(Class<?> remote) {
        this.reset();
        String s = remote.getName();
        int p = s.lastIndexOf(46);
        if (p < 0) {
            this.packag = "";
            this.implName = this.name = s;
        } else {
            this.packag = s.substring(0, p);
            this.implName = this.name = s.substring(p + 1);
        }
        this.stubName = this.name = this.convertStubName(this.name);
        this.vars.put("#name", this.name);
        this.vars.put("#package", this.packag);
        this.vars.put("#implName", this.implName);
        if (this.verbose) {
            System.out.println("Package " + this.packag + ", name " + this.name + " impl " + this.implName);
        }
        Class<?>[] interfaces = remote.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (Remote.class.isAssignableFrom(interfaces[i]) && !interfaces[i].equals(Remote.class)) {
                this.implementedRemotes.add(interfaces[i]);
            }
            ++i;
        }
        this.vars.put("#idList", this.getIdList(this.implementedRemotes));
        for (Class<?> c : this.implementedRemotes) {
            Method[] m = c.getMethods();
            int i2 = 0;
            while (i2 < m.length) {
                Class<?>[] exc = m[i2].getExceptionTypes();
                boolean remEx = false;
                int j = 0;
                while (j < exc.length) {
                    if (exc[j].isAssignableFrom(RemoteException.class)) {
                        remEx = true;
                        break;
                    }
                    ++j;
                }
                if (!remEx && !this.force) {
                    throw new CompilationError(String.valueOf(m[i2].getName()) + ", defined in " + c.getName() + ", does not throw " + RemoteException.class.getName());
                }
                AbstractMethodGenerator mm = this.createMethodGenerator(m[i2]);
                this.methods.add(mm);
                ++i2;
            }
        }
    }

    protected AbstractMethodGenerator createMethodGenerator(Method m) {
        return new MethodGenerator(m, this);
    }

    public synchronized String name(Class nameIt) {
        int p;
        if (nameIt.isArray()) {
            int dimension = 0;
            Class<?> finalComponent = nameIt;
            while (finalComponent.isArray()) {
                finalComponent = finalComponent.getComponentType();
                ++dimension;
            }
            StringBuilder brackets = new StringBuilder();
            int i = 0;
            while (i < dimension) {
                brackets.append("[]");
                ++i;
            }
            return String.valueOf(this.name(finalComponent)) + " " + brackets;
        }
        String n = nameIt.getName();
        if (!(nameIt.isArray() || nameIt.isPrimitive() || n.startsWith("java.lang") || this.packag != null && n.startsWith(this.packag))) {
            this.extraImports.add(n);
        }
        if ((p = n.lastIndexOf(46)) < 0) {
            return n;
        }
        return n.substring(p + 1);
    }

    public String getId(Class<?> c) {
        return "RMI:" + c.getName() + ":0000000000000000";
    }

    public String getIdList(Collection<Class<?>> remotes) {
        StringBuilder b = new StringBuilder();
        TreeSet<String> sortedIds = new TreeSet<String>();
        Iterator<Class<?>> iter = remotes.iterator();
        while (iter.hasNext()) {
            sortedIds.add(this.getId(iter.next()));
        }
        Iterator iterIds = sortedIds.iterator();
        while (iterIds.hasNext()) {
            b.append("      \"" + (String)iterIds.next() + "\"");
            if (!iterIds.hasNext()) continue;
            b.append(", \n");
        }
        return b.toString();
    }

    public String generateStub() {
        String template = this.getResource("Stub.jav");
        StringBuilder b = new StringBuilder();
        for (AbstractMethodGenerator m : this.methods) {
            b.append(m.generateStubMethod());
        }
        this.vars.put("#stub_methods", b.toString());
        this.vars.put("#imports", this.getImportStatements());
        this.vars.put("#interfaces", this.getAllInterfaces());
        String output = this.replaceAll(template, this.vars);
        return output;
    }

    public String getAllInterfaces() {
        StringBuilder b = new StringBuilder();
        Iterator<Class<?>> iter = this.implementedRemotes.iterator();
        while (iter.hasNext()) {
            b.append(this.name(iter.next()));
            if (!iter.hasNext()) continue;
            b.append(", ");
        }
        return b.toString();
    }

    public String generateTie() {
        String template = this.poaMode ? this.getResource("Tie.jav") : this.getResource("ImplTie.jav");
        HashFinder hashFinder = new HashFinder();
        Iterator<AbstractMethodGenerator> iter = this.methods.iterator();
        String[] names = new String[this.methods.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = ((MethodGenerator)iter.next()).getGiopMethodName();
            ++i;
        }
        int hashCharPosition = hashFinder.findHashCharPosition(names);
        iter = this.methods.iterator();
        while (iter.hasNext()) {
            ((MethodGenerator)iter.next()).hashCharPosition = hashCharPosition;
        }
        this.vars.put("#hashCharPos", Integer.toString(hashCharPosition));
        ArrayList<AbstractMethodGenerator> sortedMethods = new ArrayList<AbstractMethodGenerator>(this.methods);
        Collections.sort(sortedMethods, this);
        iter = sortedMethods.iterator();
        StringBuilder b = new StringBuilder();
        MethodGenerator prev = null;
        while (iter.hasNext()) {
            MethodGenerator m = (MethodGenerator)iter.next();
            m.previous = prev;
            m.hashCharPosition = hashCharPosition;
            prev = m;
            b.append(m.generateTieMethod());
        }
        this.vars.put("#tie_methods", b.toString());
        this.vars.put("#imports", this.getImportStatements());
        String output = this.replaceAll(template, this.vars);
        return output;
    }

    @Override
    public int compare(AbstractMethodGenerator ag1, AbstractMethodGenerator ag2) {
        MethodGenerator g1 = (MethodGenerator)ag1;
        MethodGenerator g2 = (MethodGenerator)ag2;
        return g1.getHashChar() - g2.getHashChar();
    }

    protected String getImportStatements() {
        TreeSet<String> imp = new TreeSet<String>();
        for (String ic : this.extraImports) {
            imp.add("import " + ic + ";\n");
        }
        StringBuilder b = new StringBuilder();
        Iterator<String> it = imp.iterator();
        while (it.hasNext()) {
            b.append(it.next());
        }
        return b.toString();
    }

    public void setPoaMode(boolean mode) {
        this.poaMode = mode;
    }

    public void setVerbose(boolean isVerbose) {
        this.verbose = isVerbose;
    }

    public void setWarnings(boolean warn) {
        this.warnings = warn;
    }

    public void setForce(boolean isforce) {
        this.force = isforce;
    }

    public String getPackageName() {
        return this.packag;
    }

    public String getStubName() {
        return this.stubName;
    }

    public String convertStubName(String name) {
        if (name.endsWith("Impl")) {
            return name.substring(0, name.length() - "Impl".length());
        }
        return name;
    }

    protected boolean outputTie(File fw, Class c) {
        try {
            String tie = this.generateTie();
            String tieName = "_" + this.name(c) + "_Tie.java";
            FileOutputStream out = new FileOutputStream(new File(fw, tieName));
            ((OutputStream)out).write(tie.getBytes());
            ((OutputStream)out).close();
        }
        catch (IOException ioex) {
            System.err.println("Output path not accessible");
            ioex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void setup(boolean keep, boolean need11Stubs, boolean need12Stubs, boolean iiop, boolean poa, boolean debug, boolean warnings, boolean noWrite, boolean verbose, boolean force, String classpath, String bootclasspath, String extdirs, String outputDirectory) {
        this.setWarnings(warnings);
        this.setVerbose(verbose);
        this.setForce(force);
        this.setClassPath(classpath);
        this.setPoaMode(poa);
        this.outputDirectory = outputDirectory;
        this.noWrite = noWrite;
        this.keep = keep;
    }

    @Override
    public boolean run(String[] inputFiles) {
        int i = 0;
        while (i < inputFiles.length) {
            this.reset();
            Class c = this.loadClass(inputFiles[i]);
            this.compile(c);
            String packag = this.getPackageName().replace('.', '/');
            File fw = new File(this.outputDirectory, packag);
            String stub = this.generateStub();
            String subName = String.valueOf(this.getStubName()) + "_Stub.java";
            if (!this.noWrite || this.keep) {
                try {
                    fw.mkdirs();
                    FileOutputStream out = new FileOutputStream(new File(fw, subName));
                    ((OutputStream)out).write(stub.getBytes());
                    ((OutputStream)out).close();
                    if (!this.outputTie(fw, c)) {
                        return false;
                    }
                }
                catch (IOException ioex) {
                    System.err.println("Output path not accessible");
                    ioex.printStackTrace();
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

