/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javah;

import gnu.classpath.tools.javah.ClassWrapper;
import gnu.classpath.tools.javah.CniPrintStream;
import gnu.classpath.tools.javah.Main;
import gnu.classpath.tools.javah.Printer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class CniStubPrinter
extends Printer {
    protected CniStubPrinter(Main classpath, File outFile, boolean isDir, boolean force) {
        super(classpath, outFile, isDir, force);
    }

    private void printDecl(CniPrintStream out, String className, MethodNode method) {
        out.printName(className);
        out.print("::");
        out.printName(method.name);
        out.print("(");
        Type[] argTypes = Type.getArgumentTypes(method.desc);
        int j = 0;
        while (j < argTypes.length) {
            if (j > 0) {
                out.print(", ");
            }
            out.print(argTypes[j]);
            ++j;
        }
        out.print(")");
    }

    protected void writePreambleImpl(PrintStream out) {
        out.println("// This file is intended to give you a head start on implementing native");
        out.println("// methods using CNI.");
        out.println("// Be aware: running 'gcjh -stubs' once more for this class may");
        out.println("// overwrite any edits you have made to this file.");
        out.println();
        out.println("#include <gcj/cni.h>");
        out.println("#include <java/lang/UnsupportedOperationException.h>");
    }

    protected PrintStream getPrintStreamImpl(FileOutputStream fos, ClassWrapper klass) {
        return new CniPrintStream(fos);
    }

    public void printClass(File filename, ClassWrapper klass) throws IOException {
        if (!klass.hasNativeMethod()) {
            return;
        }
        String className = klass.name.replaceAll("/", "::");
        CniPrintStream out = (CniPrintStream)this.getPrintStream(filename + ".cc", klass);
        if (out == null) {
            return;
        }
        out.println();
        out.println("#include <" + klass.name + ".h>");
        out.println();
        Iterator i = klass.methods.iterator();
        boolean first = true;
        while (i.hasNext()) {
            MethodNode method = (MethodNode)i.next();
            if (!Modifier.isNative(method.access)) continue;
            if (!first) {
                out.println();
            }
            first = false;
            out.print(Type.getReturnType(method.desc));
            out.println();
            this.printDecl(out, className, method);
            out.println();
            out.println("{");
            out.print("  throw new ::java::lang::UnsupportedOperationException(");
            out.print("JvNewStringLatin1 (\"");
            this.printDecl(out, className, method);
            out.println("\"));");
            out.println("}");
        }
        out.close();
    }
}

