/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropTargetContext
implements Serializable {
    static final long serialVersionUID = -634158968993743371L;
    private DropTarget dropTarget;
    private int targetActions;
    private DropTargetContextPeer dtcp;

    DropTargetContext(DropTarget dropTarget) {
        this.dropTarget = dropTarget;
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public Component getComponent() {
        return this.dropTarget.getComponent();
    }

    public void addNotify(DropTargetContextPeer dtcp) {
        this.dtcp = dtcp;
    }

    public void removeNotify() {
        this.dtcp = null;
    }

    protected void setTargetActions(int actions) {
        this.targetActions = actions;
    }

    protected int getTargetActions() {
        return this.targetActions;
    }

    public void dropComplete(boolean success) {
        if (this.dtcp != null) {
            this.dtcp.dropComplete(success);
        }
    }

    protected void acceptDrag(int dragOperation) {
        if (this.dtcp != null) {
            this.dtcp.acceptDrag(dragOperation);
        }
    }

    protected void rejectDrag() {
        if (this.dtcp != null) {
            this.dtcp.rejectDrag();
        }
    }

    protected void acceptDrop(int dropOperation) {
        if (this.dtcp != null) {
            this.dtcp.acceptDrop(dropOperation);
        }
    }

    protected void rejectDrop() {
        if (this.dtcp != null) {
            this.dtcp.rejectDrop();
        }
    }

    protected DataFlavor[] getCurrentDataFlavors() {
        if (this.dtcp != null) {
            this.dtcp.getTransferDataFlavors();
        }
        return null;
    }

    protected List<DataFlavor> getCurrentDataFlavorsAsList() {
        return Arrays.asList(this.getCurrentDataFlavors());
    }

    protected boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.getCurrentDataFlavorsAsList().contains(flavor);
    }

    protected Transferable getTransferable() throws InvalidDnDOperationException {
        if (this.dtcp != null) {
            return this.dtcp.getTransferable();
        }
        return null;
    }

    protected Transferable createTransferableProxy(Transferable t, boolean local) {
        return new TransferableProxy(t, local);
    }

    protected class TransferableProxy
    implements Transferable {
        protected boolean isLocal;
        protected Transferable transferable;

        TransferableProxy(Transferable t, boolean local) {
            this.transferable = t;
            this.isLocal = local;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.transferable.getTransferDataFlavors();
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.transferable.isDataFlavorSupported(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.transferable.getTransferData(flavor);
        }
    }
}

