/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Random
implements Builder,
Constructed {
    static final int RANDOM_LENGTH = 28;
    private final ByteBuffer buffer;

    public Random(ByteBuffer buffer) {
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public Random copy() {
        ByteBuffer buffer = ByteBuffer.allocate(32);
        buffer.put((ByteBuffer)this.buffer.duplicate().position(0));
        return new Random(buffer);
    }

    public int length() {
        return 32;
    }

    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().position(0).limit(this.length())).slice();
    }

    public int gmtUnixTime() {
        return this.buffer.getInt(0);
    }

    public byte[] randomBytes() {
        byte[] buf = new byte[28];
        this.buffer.position(4);
        this.buffer.get(buf);
        return buf;
    }

    public void setGmtUnixTime(int gmtUnixTime) {
        this.buffer.putInt(0, gmtUnixTime);
    }

    public void setRandomBytes(byte[] randomBytes) {
        this.setRandomBytes(randomBytes, 0);
    }

    public void setRandomBytes(byte[] randomBytes, int offset) {
        if (randomBytes.length - offset < 28) {
            throw new IllegalArgumentException("random value too short");
        }
        this.buffer.position(4);
        this.buffer.put(randomBytes, offset, 28);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  gmt_unix_time: ");
        out.print(this.gmtUnixTime());
        out.println(";");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  random_bytes:  ");
        out.print(Util.toHexString(this.randomBytes(), ':'));
        out.println(";");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} Random;");
        return str.toString();
    }

    public String toString() {
        return this.toString(null);
    }
}

