/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeRGB24
extends BMPDecoder {
    public DecodeRGB24(BMPFileHeader fh, BMPInfoHeader ih) {
        super(fh, ih);
    }

    public BufferedImage decode(ImageInputStream in) throws IOException, BMPException {
        this.skipToImage(in);
        Dimension d = this.infoHeader.getSize();
        int h = (int)d.getHeight();
        int w = (int)d.getWidth();
        BufferedImage image = new BufferedImage(w, h, 1);
        int scansize = (w * 3 & 3) != 0 ? w * 3 + 4 - (w * 3 & 3) : w * 3;
        int[] data = new int[w * h];
        int y = h - 1;
        while (y >= 0) {
            byte[] scanline = new byte[scansize];
            if (in.read(scanline) != scansize) {
                throw new IOException("Couldn't read image data.");
            }
            int x = 0;
            while (x < w) {
                data[x + y * w] = scanline[x * 3] + (scanline[x * 3 + 1] << 8) + (scanline[x * 3 + 2] << 16);
                ++x;
            }
            --y;
        }
        image.setRGB(0, 0, w, h, data, 0, w);
        return image;
    }
}

