# This file was automatically generated by bifcl from /pobj/bro-2.6.1/bro-2.6.1/src/broker/comm.bif (alternative mode).


##! Functions and events regarding Bro's broker communication mechanisms.

export {


module Broker;


## Generated when something changes in the Broker sub-system.
global Broker::status: event(endpoint: EndpointInfo , msg: string );


## Generated when a new peering has been established.
global Broker::peer_added: event(endpoint: EndpointInfo , msg: string );


## Generated when an existing peer has been removed.
global Broker::peer_removed: event(endpoint: EndpointInfo , msg: string );


## Generated when an existing peering has been lost.
global Broker::peer_lost: event(endpoint: EndpointInfo , msg: string );


## Generated when an error occurs in the Broker sub-system.
global Broker::error: event(code: ErrorCode , msg: string );


## Enumerates the possible error types. 
type ErrorCode: enum  {
	UNSPECIFIED = 1,
	PEER_INCOMPATIBLE = 2,
	PEER_INVALID = 3,
	PEER_UNAVAILABLE = 4,
	PEER_TIMEOUT = 5,
	MASTER_EXISTS = 6,
	NO_SUCH_MASTER = 7,
	NO_SUCH_KEY = 8,
	REQUEST_TIMEOUT = 9,
	TYPE_CLASH = 10,
	INVALID_DATA = 11,
	BACKEND_FAILURE = 12,
	STALE_DATA = 13,
	CAF_ERROR = 100,
} ;


## The possible states of a peer endpoint.
type PeerStatus: enum  {
	INITIALIZING,
	CONNECTING,
	CONNECTED,
	PEERED,
	DISCONNECTED,
	RECONNECTING,
} ;


global Broker::__listen: function(a: string , p: port ): port ;


global Broker::__peer: function(a: string , p: port , retry: interval ): bool ;


global Broker::__unpeer: function(a: string , p: port ): bool ;


global Broker::__peers: function(): PeerInfos ;


global Broker::__node_id: function(): string ;

} # end of export section
module GLOBAL;
