/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

final class PropertiesConverter
implements Converter {
    public static final PropertiesConverter INSTANCE = new PropertiesConverter();

    PropertiesConverter() {
    }

    @Override
    public boolean accept(Class<?> cls) {
        return Properties.class.isAssignableFrom(cls);
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value == null) {
            return null;
        }
        Properties prop = (Properties)context.createInternal(c);
        if (value instanceof Map || value instanceof List) {
            PropertiesConverter.flattenProperties(context.getLocalCache().getCachedBuffer(), value, prop);
        } else {
            prop.setProperty(value.toString(), null);
        }
        return prop;
    }

    private static void flattenProperties(StringBuilder key, Object value, Properties props) {
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                int pos = key.length();
                if (pos > 0) {
                    key.append('.');
                }
                key.append(entry.getKey());
                PropertiesConverter.flattenProperties(key, entry.getValue(), props);
                key.setLength(pos);
            }
        } else if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                int pos = key.length();
                if (pos > 0) {
                    key.append('.');
                }
                key.append(i);
                PropertiesConverter.flattenProperties(key, list.get(i), props);
                key.setLength(pos);
            }
        } else {
            props.setProperty(key.toString(), value.toString());
        }
    }
}

