/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import virtuoso.jena.driver.VirtGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtResSetIter
extends NiceIterator<Triple> {
    protected ResultSet v_resultSet;
    protected Triple v_row;
    protected TripleMatch v_in;
    protected boolean v_finished = false;
    protected boolean v_prefetched = false;
    protected VirtGraph v_graph = null;

    public VirtResSetIter() {
        this.v_finished = true;
    }

    public VirtResSetIter(VirtGraph virtGraph, ResultSet resultSet, TripleMatch tripleMatch) {
        this.v_resultSet = resultSet;
        this.v_in = tripleMatch;
        this.v_graph = virtGraph;
    }

    public void reset(ResultSet resultSet, PreparedStatement preparedStatement) {
        this.v_resultSet = resultSet;
        this.v_finished = false;
        this.v_prefetched = false;
        this.v_row = null;
    }

    public boolean hasNext() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        return !this.v_finished;
    }

    public Triple removeNext() {
        Triple triple = this.next();
        this.remove();
        return triple;
    }

    public Triple next() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        this.v_prefetched = false;
        if (this.v_finished) {
            throw new NoSuchElementException();
        }
        return this.getRow();
    }

    public void remove() {
        if (this.v_row != null && this.v_graph != null) {
            this.v_graph.delete(this.v_row);
            this.v_row = null;
        }
    }

    protected void moveForward() {
        try {
            if (!this.v_finished && this.v_resultSet.next()) {
                this.extractRow();
                this.v_prefetched = true;
            } else {
                this.close();
            }
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    protected void extractRow() throws Exception {
        Node node = this.v_in.getMatchSubject() != null ? this.v_in.getMatchSubject() : VirtGraph.Object2Node(this.v_resultSet.getObject("s"));
        Node node2 = this.v_in.getMatchPredicate() != null ? this.v_in.getMatchPredicate() : VirtGraph.Object2Node(this.v_resultSet.getObject("p"));
        Node node3 = this.v_in.getMatchObject() != null ? this.v_in.getMatchObject() : VirtGraph.Object2Node(this.v_resultSet.getObject("o"));
        this.v_row = new Triple(node, node2, node3);
    }

    protected Triple getRow() {
        return this.v_row;
    }

    public void close() {
        if (!this.v_finished && this.v_resultSet != null) {
            try {
                this.v_resultSet.close();
                this.v_resultSet = null;
            }
            catch (SQLException sQLException) {
                throw new JenaException((Throwable)sQLException);
            }
        }
        this.v_finished = true;
    }

    protected void finalize() throws SQLException {
        if (!this.v_finished && this.v_resultSet != null) {
            this.close();
        }
    }
}

