/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.channel;

import com.cloudhopper.smpp.channel.ChannelUtil;
import com.cloudhopper.smpp.channel.LoggingChannelInboundHandlerAdapter;
import com.cloudhopper.smpp.channel.SmppSessionPduDecoder;
import com.cloudhopper.smpp.channel.SmppSessionThreadRenamer;
import com.cloudhopper.smpp.channel.SmppSessionWrapper;
import com.cloudhopper.smpp.impl.DefaultSmppServer;
import com.cloudhopper.smpp.impl.UnboundSmppSession;
import com.cloudhopper.smpp.ssl.SslConfiguration;
import com.cloudhopper.smpp.ssl.SslContextFactory;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class SmppServerConnector
extends LoggingChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(SmppServerConnector.class);
    private ChannelGroup channels;
    private DefaultSmppServer server;

    public SmppServerConnector(ChannelGroup channels, DefaultSmppServer server) {
        super(SmppServerConnector.class);
        this.channels = channels;
        this.server = server;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        logger.trace("channelActive");
        Channel channel = ctx.channel();
        this.channels.add((Object)channel);
        this.server.getCounters().incrementChannelConnectsAndGet();
        String channelName = ChannelUtil.createChannelName(channel);
        String threadName = this.server.getConfiguration().getName() + ".UnboundSession." + channelName;
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.server.getConfiguration().getName());
        logger.info("New channel from [{}]", (Object)channelName);
        Thread.currentThread().setName(currentThreadName);
        if (this.server.getConfiguration().isUseSsl()) {
            SslConfiguration sslConfig = this.server.getConfiguration().getSslConfiguration();
            if (sslConfig == null) {
                throw new IllegalStateException("sslConfiguration must be set");
            }
            SslContextFactory factory = new SslContextFactory(sslConfig);
            SSLEngine sslEngine = factory.newSslEngine();
            sslEngine.setUseClientMode(false);
            channel.pipeline().addLast("smppSessionSSL", (ChannelHandler)new SslHandler(sslEngine));
        }
        channel.pipeline().addLast("smppSessionThreadRenamer", (ChannelHandler)new SmppSessionThreadRenamer(threadName));
        channel.pipeline().addLast("smppSessionPduDecoder", (ChannelHandler)new SmppSessionPduDecoder(this.server.getTranscoder()));
        UnboundSmppSession session = new UnboundSmppSession(channelName, channel, this.server);
        channel.pipeline().addLast("smppSessionWrapper", (ChannelHandler)new SmppSessionWrapper(session));
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.trace("channelInactive");
        logger.info("Disconnected channel from [{}]", (Object)ChannelUtil.createChannelName(ctx.channel()));
        this.channels.remove((Object)ctx.channel());
        this.server.getCounters().incrementChannelDisconnectsAndGet();
        super.channelInactive(ctx);
    }
}

