/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.events;

import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.Map;
import org.traccar.BaseEventHandler;
import org.traccar.Context;
import org.traccar.model.Event;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class AlertEventHandler
extends BaseEventHandler {
    private final boolean ignoreDuplicateAlerts = Context.getConfig().getBoolean("event.ignoreDuplicateAlerts");

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        Object alarm = position.getAttributes().get("alarm");
        if (alarm != null) {
            Position lastPosition;
            boolean ignoreAlert = false;
            if (this.ignoreDuplicateAlerts && (lastPosition = Context.getIdentityManager().getLastPosition(position.getDeviceId())) != null && alarm.equals(lastPosition.getAttributes().get("alarm"))) {
                ignoreAlert = true;
            }
            if (!ignoreAlert) {
                Event event = new Event("alarm", position.getDeviceId(), position.getId());
                event.set("alarm", (String)alarm);
                return Collections.singletonMap(event, position);
            }
        }
        return null;
    }
}

