/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.common.SolrException;

class BooleanStreamIfFunction
extends BooleanValueStream.AbstractBooleanValueStream {
    private final BooleanValue ifExpr;
    private final BooleanValueStream thenExpr;
    private final BooleanValueStream elseExpr;
    public static final String name = "if";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public BooleanStreamIfFunction(BooleanValue ifExpr, BooleanValueStream thenExpr, BooleanValueStream elseExpr) throws SolrException {
        this.ifExpr = ifExpr;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, ifExpr, thenExpr, elseExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
    }

    @Override
    public void streamBooleans(BooleanConsumer cons) {
        boolean ifValue = this.ifExpr.getBoolean();
        if (this.ifExpr.exists()) {
            if (ifValue) {
                this.thenExpr.streamBooleans(cons);
            } else {
                this.elseExpr.streamBooleans(cons);
            }
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

