/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.opennlp.OpenNLPPOSFilter;
import org.apache.lucene.analysis.opennlp.tools.OpenNLPOpsFactory;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class OpenNLPPOSFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String POS_TAGGER_MODEL = "posTaggerModel";
    private final String posTaggerModelFile;

    public OpenNLPPOSFilterFactory(Map<String, String> args) {
        super(args);
        this.posTaggerModelFile = this.require(args, POS_TAGGER_MODEL);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public OpenNLPPOSFilter create(TokenStream in) {
        try {
            return new OpenNLPPOSFilter(in, OpenNLPOpsFactory.getPOSTagger(this.posTaggerModelFile));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void inform(ResourceLoader loader) {
        try {
            OpenNLPOpsFactory.getPOSTaggerModel(this.posTaggerModelFile, loader);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

