/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.PredicateImpl;
import org.apache.calcite.schema.ExtensibleTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.ModifiableViewTable;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

class TableNamespace
extends AbstractNamespace {
    private final SqlValidatorTable table;
    public final ImmutableList<RelDataTypeField> extendedFields;

    private TableNamespace(SqlValidatorImpl validator, SqlValidatorTable table, List<RelDataTypeField> fields) {
        super(validator, null);
        this.table = (SqlValidatorTable)Preconditions.checkNotNull((Object)table);
        this.extendedFields = ImmutableList.copyOf(fields);
    }

    public TableNamespace(SqlValidatorImpl validator, SqlValidatorTable table) {
        this(validator, table, (List<RelDataTypeField>)ImmutableList.of());
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        if (this.extendedFields.isEmpty()) {
            return this.table.getRowType();
        }
        RelDataTypeFactory.FieldInfoBuilder builder = this.validator.getTypeFactory().builder();
        builder.addAll(this.table.getRowType().getFieldList());
        builder.addAll((Iterable<? extends Map.Entry<String, RelDataType>>)this.extendedFields);
        return builder.build();
    }

    @Override
    public SqlNode getNode() {
        return null;
    }

    @Override
    public SqlValidatorTable getTable() {
        return this.table;
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        SqlValidatorTable table = this.getTable();
        return table.getMonotonicity(columnName);
    }

    public TableNamespace extend(SqlNodeList extendList) {
        List<SqlNode> identifierList = Util.quotientList(extendList.getList(), 2, 0);
        SqlValidatorUtil.checkIdentifierListForDuplicates(identifierList, this.validator.getValidationErrorFunction());
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.extendedFields);
        builder.addAll(SqlValidatorUtil.getExtendedColumns(this.validator.getTypeFactory(), this.getTable(), extendList));
        ImmutableList extendedFields = builder.build();
        Table schemaTable = this.table.unwrap(Table.class);
        if (schemaTable != null && this.table instanceof RelOptTable && (schemaTable instanceof ExtensibleTable || schemaTable instanceof ModifiableViewTable)) {
            this.checkExtendedColumnTypes(extendList);
            RelOptTable relOptTable = ((RelOptTable)((Object)this.table)).extend((List<RelDataTypeField>)extendedFields);
            SqlValidatorTable validatorTable = relOptTable.unwrap(SqlValidatorTable.class);
            return new TableNamespace(this.validator, validatorTable, (List<RelDataTypeField>)ImmutableList.of());
        }
        return new TableNamespace(this.validator, this.table, (List<RelDataTypeField>)extendedFields);
    }

    private RelDataType getBaseRowType() {
        Table schemaTable = this.table.unwrap(Table.class);
        if (schemaTable instanceof ModifiableViewTable) {
            Table underlying = ((ModifiableViewTable)schemaTable).unwrap(Table.class);
            assert (underlying != null);
            return underlying.getRowType(this.validator.typeFactory);
        }
        return schemaTable.getRowType(this.validator.typeFactory);
    }

    private void checkExtendedColumnTypes(SqlNodeList extendList) {
        List<RelDataTypeField> extendedFields = SqlValidatorUtil.getExtendedColumns(this.validator.getTypeFactory(), this.table, extendList);
        List<RelDataTypeField> baseFields = this.getBaseRowType().getFieldList();
        Map<String, Integer> nameToIndex = SqlValidatorUtil.mapNameToIndex(baseFields);
        for (final RelDataTypeField extendedField : extendedFields) {
            String extFieldName = extendedField.getName();
            if (!nameToIndex.containsKey(extFieldName)) continue;
            Integer baseIndex = nameToIndex.get(extFieldName);
            RelDataType baseType = baseFields.get(baseIndex).getType();
            RelDataType extType = extendedField.getType();
            if (extType.equals(baseType)) continue;
            PredicateImpl<SqlNode> nameMatches = new PredicateImpl<SqlNode>(){

                @Override
                public boolean test(SqlNode sqlNode) {
                    if (sqlNode instanceof SqlIdentifier) {
                        SqlIdentifier identifier = (SqlIdentifier)sqlNode;
                        return Util.last(identifier.names).equals(extendedField.getName());
                    }
                    return false;
                }
            };
            SqlNode extColNode = (SqlNode)Iterables.find(extendList.getList(), (Predicate)nameMatches);
            throw this.validator.getValidationErrorFunction().apply(extColNode, Static.RESOURCE.typeNotAssignable(baseFields.get(baseIndex).getName(), baseType.getFullTypeString(), extendedField.getName(), extType.getFullTypeString()));
        }
    }
}

