/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.java.Array;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.jdbc.JavaRecordType;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.runtime.Unit;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.sql.type.JavaToSqlTypeConversionRules;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class JavaTypeFactoryImpl
extends SqlTypeFactoryImpl
implements JavaTypeFactory {
    private final Map<List<Pair<Type, Boolean>>, SyntheticRecordType> syntheticTypes = new HashMap<List<Pair<Type, Boolean>>, SyntheticRecordType>();

    public JavaTypeFactoryImpl() {
        this(RelDataTypeSystem.DEFAULT);
    }

    public JavaTypeFactoryImpl(RelDataTypeSystem typeSystem) {
        super(typeSystem);
    }

    @Override
    public RelDataType createStructType(Class type) {
        ArrayList<RelDataTypeField> list = new ArrayList<RelDataTypeField>();
        for (Field field : type.getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            Type fieldType = this.fieldType(field);
            list.add(new RelDataTypeFieldImpl(field.getName(), list.size(), this.createType(fieldType)));
        }
        return this.canonize(new JavaRecordType(list, type));
    }

    private Type fieldType(Field field) {
        Class<?> klass = field.getType();
        Array array = field.getAnnotation(Array.class);
        if (array != null) {
            return new Types.ArrayType((Type)array.component(), array.componentIsNullable(), array.maximumCardinality());
        }
        org.apache.calcite.adapter.java.Map map = field.getAnnotation(org.apache.calcite.adapter.java.Map.class);
        if (map != null) {
            return new Types.MapType((Type)map.key(), map.keyIsNullable(), (Type)map.value(), map.valueIsNullable());
        }
        return klass;
    }

    @Override
    public RelDataType createType(Type type) {
        if (type instanceof RelDataType) {
            return (RelDataType)((Object)type);
        }
        if (type instanceof SyntheticRecordType) {
            SyntheticRecordType syntheticRecordType = (SyntheticRecordType)((Object)type);
            return syntheticRecordType.relType;
        }
        if (type instanceof Types.ArrayType) {
            Types.ArrayType arrayType = (Types.ArrayType)type;
            RelDataType componentRelType = this.createType(arrayType.getComponentType());
            return this.createArrayType(this.createTypeWithNullability(componentRelType, arrayType.componentIsNullable()), arrayType.maximumCardinality());
        }
        if (type instanceof Types.MapType) {
            Types.MapType mapType = (Types.MapType)type;
            RelDataType keyRelType = this.createType(mapType.getKeyType());
            RelDataType valueRelType = this.createType(mapType.getValueType());
            return this.createMapType(this.createTypeWithNullability(keyRelType, mapType.keyIsNullable()), this.createTypeWithNullability(valueRelType, mapType.valueIsNullable()));
        }
        if (!(type instanceof Class)) {
            throw new UnsupportedOperationException("TODO: implement " + type);
        }
        Class clazz = (Class)type;
        switch (Primitive.flavor((Type)clazz)) {
            case PRIMITIVE: {
                return this.createJavaType(clazz);
            }
            case BOX: {
                return this.createJavaType(Primitive.ofBox((Type)clazz).boxClass);
            }
        }
        if (JavaToSqlTypeConversionRules.instance().lookup(clazz) != null) {
            return this.createJavaType(clazz);
        }
        if (clazz.isArray()) {
            return this.createMultisetType(this.createType(clazz.getComponentType()), -1L);
        }
        if (List.class.isAssignableFrom(clazz)) {
            return this.createArrayType(this.createTypeWithNullability(this.createSqlType(SqlTypeName.ANY), true), -1L);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.createMapType(this.createTypeWithNullability(this.createSqlType(SqlTypeName.ANY), true), this.createTypeWithNullability(this.createSqlType(SqlTypeName.ANY), true));
        }
        return this.createStructType(clazz);
    }

    @Override
    public Type getJavaClass(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            RelDataTypeFactoryImpl.JavaType javaType = (RelDataTypeFactoryImpl.JavaType)type;
            return javaType.getJavaClass();
        }
        if (type.isStruct() && type.getFieldCount() == 1) {
            return this.getJavaClass(type.getFieldList().get(0).getType());
        }
        if (type instanceof BasicSqlType || type instanceof IntervalSqlType) {
            switch (type.getSqlTypeName()) {
                case VARCHAR: 
                case CHAR: {
                    return String.class;
                }
                case DATE: 
                case TIME: 
                case INTEGER: 
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    return type.isNullable() ? Integer.class : Integer.TYPE;
                }
                case TIMESTAMP: 
                case BIGINT: 
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    return type.isNullable() ? Long.class : Long.TYPE;
                }
                case SMALLINT: {
                    return type.isNullable() ? Short.class : Short.TYPE;
                }
                case TINYINT: {
                    return type.isNullable() ? Byte.class : Byte.TYPE;
                }
                case DECIMAL: {
                    return BigDecimal.class;
                }
                case BOOLEAN: {
                    return type.isNullable() ? Boolean.class : Boolean.TYPE;
                }
                case DOUBLE: 
                case FLOAT: {
                    return type.isNullable() ? Double.class : Double.TYPE;
                }
                case REAL: {
                    return type.isNullable() ? Float.class : Float.TYPE;
                }
                case BINARY: 
                case VARBINARY: {
                    return ByteString.class;
                }
                case ANY: {
                    return Object.class;
                }
            }
        }
        switch (type.getSqlTypeName()) {
            case ROW: {
                assert (type instanceof RelRecordType);
                if (type instanceof JavaRecordType) {
                    return ((JavaRecordType)type).clazz;
                }
                return this.createSyntheticType((RelRecordType)type);
            }
            case MAP: {
                return Map.class;
            }
            case ARRAY: 
            case MULTISET: {
                return List.class;
            }
        }
        return null;
    }

    @Override
    public RelDataType toSql(RelDataType type) {
        return JavaTypeFactoryImpl.toSql(this, type);
    }

    public static RelDataType toSql(final RelDataTypeFactory typeFactory, RelDataType type) {
        if (type instanceof RelRecordType) {
            return typeFactory.createStructType(Lists.transform(type.getFieldList(), (Function)new Function<RelDataTypeField, RelDataType>(){

                public RelDataType apply(RelDataTypeField a0) {
                    return JavaTypeFactoryImpl.toSql(typeFactory, a0.getType());
                }
            }), type.getFieldNames());
        }
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(type.getSqlTypeName()), type.isNullable());
        }
        return type;
    }

    @Override
    public Type createSyntheticType(List<Type> types) {
        if (types.isEmpty()) {
            return Unit.class;
        }
        String name = "Record" + types.size() + "_" + this.syntheticTypes.size();
        SyntheticRecordType syntheticType = new SyntheticRecordType(null, name);
        for (Ord ord : Ord.zip(types)) {
            syntheticType.fields.add(new RecordFieldImpl(syntheticType, "f" + ord.i, (Type)ord.e, !Primitive.is((Type)((Type)ord.e)), 1));
        }
        return this.register(syntheticType);
    }

    private SyntheticRecordType register(final SyntheticRecordType syntheticType) {
        AbstractList<Pair<Type, Boolean>> key = new AbstractList<Pair<Type, Boolean>>(){

            @Override
            public Pair<Type, Boolean> get(int index) {
                Types.RecordField field = syntheticType.getRecordFields().get(index);
                return Pair.of(field.getType(), field.nullable());
            }

            @Override
            public int size() {
                return syntheticType.getRecordFields().size();
            }
        };
        SyntheticRecordType syntheticType2 = this.syntheticTypes.get(key);
        if (syntheticType2 == null) {
            this.syntheticTypes.put((List<Pair<Type, Boolean>>)key, syntheticType);
            return syntheticType;
        }
        return syntheticType2;
    }

    private Type createSyntheticType(RelRecordType type) {
        String name = "Record" + type.getFieldCount() + "_" + this.syntheticTypes.size();
        SyntheticRecordType syntheticType = new SyntheticRecordType(type, name);
        for (RelDataTypeField recordField : type.getFieldList()) {
            Type javaClass = this.getJavaClass(recordField.getType());
            syntheticType.fields.add(new RecordFieldImpl(syntheticType, recordField.getName(), javaClass, recordField.getType().isNullable() && !Primitive.is((Type)javaClass), 1));
        }
        return this.register(syntheticType);
    }

    private static class RecordFieldImpl
    implements Types.RecordField {
        private final SyntheticRecordType syntheticType;
        private final String name;
        private final Type type;
        private final boolean nullable;
        private final int modifiers;

        public RecordFieldImpl(SyntheticRecordType syntheticType, String name, Type type, boolean nullable, int modifiers) {
            this.syntheticType = (SyntheticRecordType)Preconditions.checkNotNull((Object)syntheticType);
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.type = (Type)Preconditions.checkNotNull((Object)type);
            this.nullable = nullable;
            this.modifiers = modifiers;
            assert (!nullable || !Primitive.is((Type)type)) : "type [" + type + "] can never be null";
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public boolean nullable() {
            return this.nullable;
        }

        public Object get(Object o) {
            throw new UnsupportedOperationException();
        }

        public Type getDeclaringClass() {
            return this.syntheticType;
        }
    }

    public static class SyntheticRecordType
    implements Types.RecordType {
        final List<Types.RecordField> fields = new ArrayList<Types.RecordField>();
        final RelDataType relType;
        private final String name;

        private SyntheticRecordType(RelDataType relType, String name) {
            this.relType = relType;
            this.name = name;
            assert (relType == null || Util.isDistinct(relType.getFieldNames())) : "field names not distinct: " + relType;
        }

        public String getName() {
            return this.name;
        }

        public List<Types.RecordField> getRecordFields() {
            return this.fields;
        }

        public String toString() {
            return this.name;
        }
    }
}

