/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkShardTerms;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.component.RealTimeGetComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.SolrIndexSplitter;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.update.VersionBucket;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.update.processor.AtomicUpdateDocumentMerger;
import org.apache.solr.update.processor.DistributedUpdateProcessorFactory;
import org.apache.solr.update.processor.LogUpdateProcessorFactory;
import org.apache.solr.update.processor.RunUpdateProcessor;
import org.apache.solr.update.processor.TolerantUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.TestInjection;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedUpdateProcessor
extends UpdateRequestProcessor {
    static final String PARAM_WHITELIST_CTX_KEY = DistributedUpdateProcessor.class + "PARAM_WHITELIST_CTX_KEY";
    public static final String DISTRIB_FROM_SHARD = "distrib.from.shard";
    public static final String DISTRIB_FROM_COLLECTION = "distrib.from.collection";
    public static final String DISTRIB_FROM_PARENT = "distrib.from.parent";
    public static final String DISTRIB_FROM = "distrib.from";
    public static final String DISTRIB_INPLACE_PREVVERSION = "distrib.inplace.prevversion";
    private static final String TEST_DISTRIB_SKIP_SERVERS = "test.distrib.skip.servers";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final int MAX_RETRIES_ON_FORWARD_DEAULT = Integer.getInteger("solr.retries.on.forward", 25);
    static final int MAX_RETRIES_TO_FOLLOWERS_DEFAULT = Integer.getInteger("solr.retries.to.followers", 3);
    public static final String COMMIT_END_POINT = "commit_end_point";
    public static final String LOG_REPLAY = "log_replay";
    private boolean finished = false;
    private final SolrQueryRequest req;
    private final SolrQueryResponse rsp;
    private final UpdateRequestProcessor next;
    private final AtomicUpdateDocumentMerger docMerger;
    private final UpdateLog ulog;
    private final VersionInfo vinfo;
    private final boolean versionsStored;
    private boolean returnVersions;
    private NamedList<Object> addsResponse = null;
    private NamedList<Object> deleteResponse = null;
    private NamedList<Object> deleteByQueryResponse = null;
    private CharsRefBuilder scratch;
    private final SchemaField idField;
    private SolrCmdDistributor cmdDistrib;
    private final boolean zkEnabled;
    private final CloudDescriptor cloudDesc;
    private final String collection;
    private final ZkController zkController;
    private boolean isLeader = true;
    private boolean forwardToLeader = false;
    private boolean isSubShardLeader = false;
    private List<SolrCmdDistributor.Node> nodes;
    private Set<String> skippedCoreNodeNames;
    private boolean isIndexChanged = false;
    private final int maxRetriesOnForward = MAX_RETRIES_ON_FORWARD_DEAULT;
    private final int maxRetriesToFollowers = MAX_RETRIES_TO_FOLLOWERS_DEFAULT;
    private UpdateCommand updateCommand;
    private RollupRequestReplicationTracker rollupReplicationTracker = null;
    private LeaderRequestReplicationTracker leaderReplicationTracker = null;
    private final boolean cloneRequiredOnLeader;
    private final Replica.Type replicaType;

    public DistributedUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        this(req, rsp, new AtomicUpdateDocumentMerger(req), next);
    }

    public DistributedUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, AtomicUpdateDocumentMerger docMerger, UpdateRequestProcessor next) {
        super(next);
        this.rsp = rsp;
        this.next = next;
        this.docMerger = docMerger;
        this.idField = req.getSchema().getUniqueKeyField();
        this.ulog = req.getCore().getUpdateHandler().getUpdateLog();
        this.vinfo = this.ulog == null ? null : this.ulog.getVersionInfo();
        this.versionsStored = this.vinfo != null && this.vinfo.getVersionField() != null;
        this.returnVersions = req.getParams().getBool("versions", false);
        this.req = req;
        DistributedUpdateProcessorFactory.addParamToDistributedRequestWhitelist(this.req, "update.chain", TEST_DISTRIB_SKIP_SERVERS, "_version_", "expungeDeletes", "optimize", "maxSegments");
        CoreContainer cc = req.getCore().getCoreContainer();
        this.zkEnabled = cc.isZooKeeperAware();
        this.zkController = cc.getZkController();
        if (this.zkEnabled) {
            this.cmdDistrib = new SolrCmdDistributor(cc.getUpdateShardHandler());
        }
        this.cloudDesc = req.getCore().getCoreDescriptor().getCloudDescriptor();
        if (this.cloudDesc != null) {
            this.collection = this.cloudDesc.getCollectionName();
            this.replicaType = this.cloudDesc.getReplicaType();
        } else {
            this.collection = null;
            this.replicaType = Replica.Type.NRT;
        }
        boolean shouldClone = false;
        UpdateRequestProcessor nextInChain = next;
        while (nextInChain != null) {
            Class<?> klass = nextInChain.getClass();
            if (klass != LogUpdateProcessorFactory.LogUpdateProcessor.class && klass != RunUpdateProcessor.class && klass != TolerantUpdateProcessor.class) {
                shouldClone = true;
                break;
            }
            nextInChain = nextInChain.next;
        }
        this.cloneRequiredOnLeader = shouldClone;
    }

    private List<SolrCmdDistributor.Node> setupRequest(String id, SolrInputDocument doc) {
        return this.setupRequest(id, doc, null);
    }

    private List<SolrCmdDistributor.Node> setupRequest(String id, SolrInputDocument doc, String route) {
        String shardId;
        if (!this.zkEnabled) {
            return null;
        }
        assert (TestInjection.injectUpdateRandomPause());
        if ((this.updateCommand.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0) {
            this.isLeader = false;
            this.forwardToLeader = false;
            return null;
        }
        ClusterState cstate = this.zkController.getClusterState();
        DocCollection coll = cstate.getCollection(this.collection);
        Slice slice = coll.getRouter().getTargetSlice(id, doc, route, this.req.getParams(), coll);
        if (slice == null && (slice = coll.getSlice(shardId = this.cloudDesc.getShardId())) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard " + shardId + " in " + coll);
        }
        DistribPhase phase = DistribPhase.parseParam(this.req.getParams().get("update.distrib"));
        if (DistribPhase.FROMLEADER == phase && !this.couldIbeSubShardLeader(coll) && !this.cloudDesc.isLeader()) {
            assert (TestInjection.injectFailReplicaRequests());
            this.isLeader = false;
            this.forwardToLeader = false;
            return null;
        }
        String shardId2 = slice.getName();
        try {
            Replica leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, shardId2);
            this.isLeader = leaderReplica.getName().equals(this.cloudDesc.getCoreNodeName());
            if (!this.isLeader) {
                this.isSubShardLeader = this.amISubShardLeader(coll, slice, id, doc);
                if (this.isSubShardLeader) {
                    shardId2 = this.cloudDesc.getShardId();
                    leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, shardId2);
                }
            }
            this.doDefensiveChecks(phase);
            String fromCollection = this.updateCommand.getReq().getParams().get(DISTRIB_FROM_COLLECTION);
            if (DistribPhase.FROMLEADER == phase && !this.isSubShardLeader && fromCollection == null) {
                this.forwardToLeader = false;
                return null;
            }
            if (this.isLeader || this.isSubShardLeader) {
                this.forwardToLeader = false;
                ClusterState clusterState = this.zkController.getZkStateReader().getClusterState();
                String leaderCoreNodeName = leaderReplica.getName();
                List replicas = clusterState.getCollection(this.collection).getSlice(shardId2).getReplicas(EnumSet.of(Replica.Type.NRT, Replica.Type.TLOG));
                replicas.removeIf(replica -> replica.getName().equals(leaderCoreNodeName));
                if (replicas.isEmpty()) {
                    return null;
                }
                String[] skipList = this.req.getParams().getParams(TEST_DISTRIB_SKIP_SERVERS);
                HashSet<String> skipListSet = null;
                if (skipList != null) {
                    skipListSet = new HashSet<String>(skipList.length);
                    skipListSet.addAll(Arrays.asList(skipList));
                    log.info("test.distrib.skip.servers was found and contains:" + skipListSet);
                }
                ArrayList<SolrCmdDistributor.Node> nodes = new ArrayList<SolrCmdDistributor.Node>(replicas.size());
                this.skippedCoreNodeNames = new HashSet<String>();
                ZkShardTerms zkShardTerms = this.zkController.getShardTerms(this.collection, shardId2);
                for (Replica replica2 : replicas) {
                    String coreNodeName = replica2.getName();
                    if (skipList != null && skipListSet.contains(replica2.getCoreUrl())) {
                        log.info("check url:" + replica2.getCoreUrl() + " against:" + skipListSet + " result:true");
                        continue;
                    }
                    if (zkShardTerms.registered(coreNodeName) && zkShardTerms.skipSendingUpdatesTo(coreNodeName)) {
                        log.debug("skip url:{} cause its term is less than leader", (Object)replica2.getCoreUrl());
                        this.skippedCoreNodeNames.add(replica2.getName());
                        continue;
                    }
                    if (!clusterState.getLiveNodes().contains(replica2.getNodeName()) || replica2.getState() == Replica.State.DOWN) {
                        this.skippedCoreNodeNames.add(replica2.getName());
                        continue;
                    }
                    nodes.add(new SolrCmdDistributor.StdNode(new ZkCoreNodeProps((ZkNodeProps)replica2), this.collection, shardId2, this.maxRetriesToFollowers));
                }
                return nodes;
            }
            this.forwardToLeader = true;
            return Collections.singletonList(new SolrCmdDistributor.ForwardNode(new ZkCoreNodeProps((ZkNodeProps)leaderReplica), this.zkController.getZkStateReader(), this.collection, shardId2, this.maxRetriesOnForward));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
    }

    private boolean couldIbeSubShardLeader(DocCollection coll) {
        String myShardId = this.cloudDesc.getShardId();
        Slice mySlice = coll.getSlice(myShardId);
        Slice.State state = mySlice.getState();
        return state == Slice.State.CONSTRUCTION || state == Slice.State.RECOVERY;
    }

    private boolean amISubShardLeader(DocCollection coll, Slice parentSlice, String id, SolrInputDocument doc) throws InterruptedException {
        Replica myLeader;
        boolean amILeader;
        String myShardId = this.cloudDesc.getShardId();
        Slice mySlice = coll.getSlice(myShardId);
        Slice.State state = mySlice.getState();
        if ((state == Slice.State.CONSTRUCTION || state == Slice.State.RECOVERY) && (amILeader = (myLeader = this.zkController.getZkStateReader().getLeaderRetry(this.collection, myShardId)).getName().equals(this.cloudDesc.getCoreNodeName()))) {
            DocRouter.Range myRange = mySlice.getRange();
            if (myRange == null) {
                myRange = new DocRouter.Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            if (parentSlice != null) {
                boolean isSubset = parentSlice.getRange() != null && myRange.isSubsetOf(parentSlice.getRange());
                return isSubset && coll.getRouter().isTargetSlice(id, doc, this.req.getParams(), myShardId, coll);
            }
            return true;
        }
        return false;
    }

    private List<SolrCmdDistributor.Node> getReplicaNodesForLeader(String shardId, Replica leaderReplica) {
        ClusterState clusterState = this.zkController.getZkStateReader().getClusterState();
        String leaderCoreNodeName = leaderReplica.getName();
        List replicas = clusterState.getCollection(this.collection).getSlice(shardId).getReplicas(EnumSet.of(Replica.Type.NRT, Replica.Type.TLOG));
        replicas.removeIf(replica -> replica.getName().equals(leaderCoreNodeName));
        if (replicas.isEmpty()) {
            return null;
        }
        String[] skipList = this.req.getParams().getParams(TEST_DISTRIB_SKIP_SERVERS);
        HashSet<String> skipListSet = null;
        if (skipList != null) {
            skipListSet = new HashSet<String>(skipList.length);
            skipListSet.addAll(Arrays.asList(skipList));
            log.info("test.distrib.skip.servers was found and contains:" + skipListSet);
        }
        ArrayList<SolrCmdDistributor.Node> nodes = new ArrayList<SolrCmdDistributor.Node>(replicas.size());
        this.skippedCoreNodeNames = new HashSet<String>();
        ZkShardTerms zkShardTerms = this.zkController.getShardTerms(this.collection, shardId);
        for (Replica replica2 : replicas) {
            String coreNodeName = replica2.getName();
            if (skipList != null && skipListSet.contains(replica2.getCoreUrl())) {
                log.info("check url:" + replica2.getCoreUrl() + " against:" + skipListSet + " result:true");
                continue;
            }
            if (zkShardTerms.registered(coreNodeName) && zkShardTerms.skipSendingUpdatesTo(coreNodeName)) {
                log.debug("skip url:{} cause its term is less than leader", (Object)replica2.getCoreUrl());
                this.skippedCoreNodeNames.add(replica2.getName());
                continue;
            }
            if (!clusterState.getLiveNodes().contains(replica2.getNodeName()) || replica2.getState() == Replica.State.DOWN) {
                this.skippedCoreNodeNames.add(replica2.getName());
                continue;
            }
            nodes.add(new SolrCmdDistributor.StdNode(new ZkCoreNodeProps((ZkNodeProps)replica2), this.collection, shardId));
        }
        return nodes;
    }

    private List<SolrCmdDistributor.Node> getSubShardLeaders(DocCollection coll, String shardId, String docId, SolrInputDocument doc) {
        Collection allSlices = coll.getSlices();
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        for (Slice aslice : allSlices) {
            Replica sliceLeader;
            boolean isSubset;
            Slice.State state = aslice.getState();
            if (state != Slice.State.CONSTRUCTION && state != Slice.State.RECOVERY) continue;
            DocRouter.Range myRange = coll.getSlice(shardId).getRange();
            if (myRange == null) {
                myRange = new DocRouter.Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            if (!(isSubset = aslice.getRange() != null && aslice.getRange().isSubsetOf(myRange)) || docId != null && !coll.getRouter().isTargetSlice(docId, doc, this.req.getParams(), aslice.getName(), coll) || (sliceLeader = aslice.getLeader()) == null || !this.zkController.getClusterState().liveNodesContain(sliceLeader.getNodeName())) continue;
            if (nodes == null) {
                nodes = new ArrayList<SolrCmdDistributor.StdNode>();
            }
            ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)sliceLeader);
            nodes.add(new SolrCmdDistributor.StdNode(nodeProps, coll.getName(), aslice.getName()));
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SolrCmdDistributor.Node> getNodesByRoutingRules(ClusterState cstate, DocCollection coll, String id, SolrInputDocument doc) {
        RoutingRule rule;
        DocRouter router = coll.getRouter();
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        if (!(router instanceof CompositeIdRouter)) return nodes;
        CompositeIdRouter compositeIdRouter = (CompositeIdRouter)router;
        String myShardId = this.cloudDesc.getShardId();
        Slice slice = coll.getSlice(myShardId);
        Map routingRules = slice.getRoutingRules();
        if (routingRules == null) return nodes;
        if (id == null) {
            for (Map.Entry entry : routingRules.entrySet()) {
                String targetCollectionName = ((RoutingRule)entry.getValue()).getTargetCollectionName();
                DocCollection docCollection = cstate.getCollectionOrNull(targetCollectionName);
                if (docCollection == null || docCollection.getActiveSlicesArr().length <= 0) continue;
                Slice[] activeSlices = docCollection.getActiveSlicesArr();
                Slice any = activeSlices[0];
                if (nodes == null) {
                    nodes = new ArrayList<SolrCmdDistributor.StdNode>();
                }
                nodes.add(new SolrCmdDistributor.StdNode(new ZkCoreNodeProps((ZkNodeProps)any.getLeader())));
            }
            return nodes;
        }
        String routeKey = SolrIndexSplitter.getRouteKey(id);
        if (routeKey == null || (rule = (RoutingRule)routingRules.get(routeKey + "!")) == null) return nodes;
        if (!rule.isExpired()) {
            List ranges = rule.getRouteRanges();
            if (ranges == null || ranges.isEmpty()) return nodes;
            int hash = compositeIdRouter.sliceHash(id, doc, null, coll);
            for (DocRouter.Range range : ranges) {
                if (!range.includes(hash)) continue;
                DocCollection targetColl = cstate.getCollection(rule.getTargetCollectionName());
                Collection activeSlices = targetColl.getRouter().getSearchSlicesSingle(id, null, targetColl);
                if (activeSlices == null || activeSlices.isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No active slices serving " + id + " found for target collection: " + rule.getTargetCollectionName());
                }
                Replica targetLeader = targetColl.getLeader(((Slice)activeSlices.iterator().next()).getName());
                nodes = new ArrayList(1);
                nodes.add(new SolrCmdDistributor.StdNode(new ZkCoreNodeProps((ZkNodeProps)targetLeader)));
                return nodes;
            }
            return nodes;
        }
        ReentrantLock ruleExpiryLock = this.req.getCore().getRuleExpiryLock();
        if (ruleExpiryLock.isLocked()) return nodes;
        try {
            if (!ruleExpiryLock.tryLock(10L, TimeUnit.MILLISECONDS)) return nodes;
            log.info("Going to expire routing rule");
            try {
                Map map = Utils.makeMap((Object[])new Object[]{"operation", OverseerAction.REMOVEROUTINGRULE.toLower(), "collection", this.collection, "shard", myShardId, "routeKey", routeKey + "!"});
                SolrZkClient zkClient = this.zkController.getZkClient();
                this.zkController.getOverseer().offerStateUpdate(Utils.toJSON((Object)map));
                return nodes;
            }
            catch (KeeperException e) {
                log.warn("Exception while removing routing rule for route key: " + routeKey, (Throwable)e);
                return nodes;
            }
            catch (Exception e) {
                log.error("Exception while removing routing rule for route key: " + routeKey, (Throwable)e);
                return nodes;
            }
            finally {
                ruleExpiryLock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return nodes;
    }

    private void doDefensiveChecks(DistribPhase phase) {
        boolean isReplayOrPeersync;
        boolean bl = isReplayOrPeersync = (this.updateCommand.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        if (isReplayOrPeersync) {
            return;
        }
        String from = this.req.getParams().get(DISTRIB_FROM);
        ClusterState clusterState = this.zkController.getClusterState();
        DocCollection docCollection = clusterState.getCollection(this.collection);
        Slice mySlice = docCollection.getSlice(this.cloudDesc.getShardId());
        boolean localIsLeader = this.cloudDesc.isLeader();
        if (DistribPhase.FROMLEADER == phase && localIsLeader && from != null) {
            String fromShard = this.req.getParams().get(DISTRIB_FROM_PARENT);
            if (fromShard != null) {
                if (mySlice.getState() == Slice.State.ACTIVE) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request says it is coming from parent shard leader but we are in active state");
                }
                Slice fromSlice = docCollection.getSlice(fromShard);
                DocRouter.Range parentRange = fromSlice.getRange();
                if (parentRange == null) {
                    parentRange = new DocRouter.Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
                }
                if (mySlice.getRange() != null && !mySlice.getRange().isSubsetOf(parentRange)) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request says it is coming from parent shard leader but parent hash range is not superset of my range");
                }
            } else {
                String fromCollection = this.req.getParams().get(DISTRIB_FROM_COLLECTION);
                if (fromCollection == null) {
                    log.error("Request says it is coming from leader, but we are the leader: " + this.req.getParamString());
                    SolrException solrExc = new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request says it is coming from leader, but we are the leader");
                    solrExc.setMetadata("cause", "LeaderChanged");
                    throw solrExc;
                }
            }
        }
        int count = 0;
        while ((this.isLeader && !localIsLeader || this.isSubShardLeader && !localIsLeader) && count < 5) {
            ++count;
            localIsLeader = this.cloudDesc.isLeader();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.isLeader && !localIsLeader || this.isSubShardLeader && !localIsLeader) {
            log.error("ClusterState says we are the leader, but locally we don't think so");
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "ClusterState says we are the leader (" + this.zkController.getBaseUrl() + "/" + this.req.getCore().getName() + "), but locally we don't think so. Request came from " + from);
        }
    }

    private List<SolrCmdDistributor.Node> setupRequestForDBQ() {
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        String shardId = this.cloudDesc.getShardId();
        try {
            Replica leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, shardId);
            this.isLeader = leaderReplica.getName().equals(this.cloudDesc.getCoreNodeName());
            this.forwardToLeader = false;
            List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, shardId, leaderReplica.getName(), null, Replica.State.DOWN, EnumSet.of(Replica.Type.NRT, Replica.Type.TLOG));
            if (replicaProps != null) {
                nodes = new ArrayList<SolrCmdDistributor.StdNode>(replicaProps.size());
                for (ZkCoreNodeProps props : replicaProps) {
                    nodes.add(new SolrCmdDistributor.StdNode(props, this.collection, shardId));
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        return nodes;
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        assert (TestInjection.injectFailUpdateRequests());
        this.updateCommand = cmd;
        if (this.zkEnabled) {
            this.zkCheck();
            this.nodes = this.setupRequest(cmd.getHashableId(), cmd.getSolrInputDocument());
        } else {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        }
        this.checkReplicationTracker(cmd);
        if (!cmd.isInPlaceUpdate()) {
            cmd.prevVersion = cmd.getReq().getParams().getLong(DISTRIB_INPLACE_PREVVERSION, -1L);
        }
        boolean dropCmd = false;
        if (!this.forwardToLeader) {
            dropCmd = this.versionAdd(cmd);
        }
        if (dropCmd) {
            return;
        }
        if (this.zkEnabled && this.isLeader && !this.isSubShardLeader) {
            List<SolrCmdDistributor.Node> nodesByRoutingRules;
            DocCollection coll = this.zkController.getClusterState().getCollection(this.collection);
            List<SolrCmdDistributor.Node> subShardLeaders = this.getSubShardLeaders(coll, this.cloudDesc.getShardId(), cmd.getHashableId(), cmd.getSolrInputDocument());
            if (subShardLeaders != null && !subShardLeaders.isEmpty()) {
                ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
                params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                params.set(DISTRIB_FROM_PARENT, new String[]{this.cloudDesc.getShardId()});
                this.cmdDistrib.distribAdd(cmd, subShardLeaders, params, true);
            }
            if ((nodesByRoutingRules = this.getNodesByRoutingRules(this.zkController.getClusterState(), coll, cmd.getHashableId(), cmd.getSolrInputDocument())) != null && !nodesByRoutingRules.isEmpty()) {
                ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
                params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                params.set(DISTRIB_FROM_COLLECTION, new String[]{this.collection});
                params.set(DISTRIB_FROM_SHARD, new String[]{this.cloudDesc.getShardId()});
                this.cmdDistrib.distribAdd(cmd, nodesByRoutingRules, params, true);
            }
        }
        if (this.nodes != null) {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("update.distrib", new String[]{this.isLeader || this.isSubShardLeader ? DistribPhase.FROMLEADER.toString() : DistribPhase.TOLEADER.toString()});
            params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            if (this.req.getParams().get("min_rf") != null) {
                params.set("min_rf", new String[]{this.req.getParams().get("min_rf")});
            }
            if (cmd.isInPlaceUpdate()) {
                params.set(DISTRIB_INPLACE_PREVVERSION, new String[]{String.valueOf(cmd.prevVersion)});
                this.cmdDistrib.distribAdd(cmd, this.nodes, params, true, this.rollupReplicationTracker, this.leaderReplicationTracker);
            } else {
                this.cmdDistrib.distribAdd(cmd, this.nodes, params, false, this.rollupReplicationTracker, this.leaderReplicationTracker);
            }
        }
        if (this.returnVersions && this.rsp != null && this.idField != null) {
            if (this.addsResponse == null) {
                this.addsResponse = new NamedList(1);
                this.rsp.add("adds", this.addsResponse);
            }
            if (this.scratch == null) {
                this.scratch = new CharsRefBuilder();
            }
            this.idField.getType().indexedToReadable(cmd.getIndexedId(), this.scratch);
            this.addsResponse.add(this.scratch.toString(), (Object)cmd.getVersion());
        }
    }

    private void checkReplicationTracker(UpdateCommand cmd) {
        if (!this.zkEnabled) {
            this.rollupReplicationTracker = null;
            this.leaderReplicationTracker = null;
            return;
        }
        SolrParams rp = cmd.getReq().getParams();
        String distribUpdate = rp.get("update.distrib");
        if ((distribUpdate == null || DistribPhase.NONE.toString().equals(distribUpdate)) && this.rollupReplicationTracker == null) {
            this.rollupReplicationTracker = new RollupRequestReplicationTracker();
        }
        if (this.isLeader && this.leaderReplicationTracker == null) {
            this.leaderReplicationTracker = new LeaderRequestReplicationTracker(this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId());
        }
    }

    @Override
    protected void doClose() {
        if (this.cmdDistrib != null) {
            this.cmdDistrib.close();
        }
    }

    private void doFinish() {
        boolean shouldUpdateTerms;
        boolean bl = shouldUpdateTerms = this.isLeader && this.isIndexChanged;
        if (shouldUpdateTerms) {
            ZkShardTerms zkShardTerms = this.zkController.getShardTerms(this.cloudDesc.getCollectionName(), this.cloudDesc.getShardId());
            if (this.skippedCoreNodeNames != null) {
                zkShardTerms.ensureTermsIsHigher(this.cloudDesc.getCoreNodeName(), this.skippedCoreNodeNames);
            }
            this.zkController.getShardTerms(this.collection, this.cloudDesc.getShardId()).ensureHighestTermsAreNotZero();
        }
        this.cmdDistrib.finish();
        List<SolrCmdDistributor.Error> errors = this.cmdDistrib.getErrors();
        ArrayList<SolrCmdDistributor.Error> errorsForClient = new ArrayList<SolrCmdDistributor.Error>(errors.size());
        HashSet<String> replicasShouldBeInLowerTerms = new HashSet<String>();
        for (SolrCmdDistributor.Error error : errors) {
            String cause;
            DistribPhase phase;
            if (error.req.node instanceof SolrCmdDistributor.ForwardNode) {
                errorsForClient.add(error);
                continue;
            }
            if (log.isWarnEnabled()) {
                log.warn("Error sending update to " + error.req.node.getBaseUrl(), (Throwable)error.e);
            }
            if ((phase = DistribPhase.parseParam(error.req.uReq.getParams().get("update.distrib"))) != DistribPhase.FROMLEADER || error.req.uReq.getParams().get(COMMIT_END_POINT) != null) continue;
            String replicaUrl = error.req.node.getUrl();
            String string = cause = error.e instanceof SolrException ? ((SolrException)((Object)error.e)).getMetadata("cause") : null;
            if ("LeaderChanged".equals(cause)) {
                log.error("On " + this.cloudDesc.getCoreNodeName() + ", replica " + replicaUrl + " now thinks it is the leader! Failing the request to let the client retry! " + error.e);
                errorsForClient.add(error);
                continue;
            }
            String collection = null;
            String shardId = null;
            if (!(error.req.node instanceof SolrCmdDistributor.StdNode)) continue;
            SolrCmdDistributor.StdNode stdNode = (SolrCmdDistributor.StdNode)error.req.node;
            collection = stdNode.getCollection();
            shardId = stdNode.getShardId();
            String leaderCoreNodeName = null;
            Exception getLeaderExc = null;
            Replica leaderProps = null;
            try {
                leaderProps = this.zkController.getZkStateReader().getLeader(collection, shardId);
                if (leaderProps != null) {
                    leaderCoreNodeName = leaderProps.getName();
                }
            }
            catch (Exception exc) {
                getLeaderExc = exc;
            }
            if (leaderCoreNodeName == null) {
                log.warn("Failed to determine if {} is still the leader for collection={} shardId={} before putting {} into leader-initiated recovery", new Object[]{this.cloudDesc.getCoreNodeName(), collection, shardId, replicaUrl, getLeaderExc});
            }
            List myReplicas = this.zkController.getZkStateReader().getReplicaProps(collection, this.cloudDesc.getShardId(), this.cloudDesc.getCoreNodeName());
            boolean foundErrorNodeInReplicaList = false;
            if (myReplicas != null) {
                for (ZkCoreNodeProps replicaProp : myReplicas) {
                    if (!((Replica)replicaProp.getNodeProps()).getName().equals(((Replica)stdNode.getNodeProps().getNodeProps()).getName())) continue;
                    foundErrorNodeInReplicaList = true;
                    break;
                }
            }
            if (leaderCoreNodeName != null && this.cloudDesc.getCoreNodeName().equals(leaderCoreNodeName) && foundErrorNodeInReplicaList && !stdNode.getNodeProps().getCoreUrl().equals(leaderProps.getCoreUrl())) {
                try {
                    String coreNodeName = ((Replica)stdNode.getNodeProps().getNodeProps()).getName();
                    Throwable rootCause = SolrException.getRootCause((Throwable)error.e);
                    log.error("Setting up to try to start recovery on replica {} with url {} by increasing leader term", new Object[]{coreNodeName, replicaUrl, rootCause});
                    replicasShouldBeInLowerTerms.add(coreNodeName);
                }
                catch (Exception exc) {
                    Throwable setLirZnodeFailedCause = SolrException.getRootCause((Throwable)exc);
                    log.error("Leader failed to set replica " + error.req.node.getUrl() + " state to DOWN due to: " + setLirZnodeFailedCause, setLirZnodeFailedCause);
                }
                continue;
            }
            if (!foundErrorNodeInReplicaList) {
                log.warn("Core " + this.cloudDesc.getCoreNodeName() + " belonging to " + collection + " " + this.cloudDesc.getShardId() + ", does not have error'd node " + stdNode.getNodeProps().getCoreUrl() + " as a replica. No request recovery command will be sent!");
                if (shardId.equals(this.cloudDesc.getShardId())) continue;
                errorsForClient.add(error);
                continue;
            }
            log.warn("Core " + this.cloudDesc.getCoreNodeName() + " is no longer the leader for " + collection + " " + shardId + " or we tried to put ourself into LIR, no request recovery command will be sent!");
        }
        if (!replicasShouldBeInLowerTerms.isEmpty()) {
            this.zkController.getShardTerms(this.cloudDesc.getCollectionName(), this.cloudDesc.getShardId()).ensureTermsIsHigher(this.cloudDesc.getCoreNodeName(), replicasShouldBeInLowerTerms);
        }
        this.handleReplicationFactor();
        if (0 < errorsForClient.size()) {
            throw new DistributedUpdatesAsyncException(errorsForClient);
        }
    }

    private void handleReplicationFactor() {
        if (this.leaderReplicationTracker != null || this.rollupReplicationTracker != null) {
            int achievedRf = Integer.MAX_VALUE;
            if (this.leaderReplicationTracker != null) {
                achievedRf = this.leaderReplicationTracker.getAchievedRf();
                if (this.rollupReplicationTracker != null) {
                    this.rollupReplicationTracker.testAndSetAchievedRf(achievedRf);
                }
            }
            if (this.rollupReplicationTracker != null) {
                achievedRf = this.rollupReplicationTracker.getAchievedRf();
            }
            if (this.req.getParams().get("min_rf") != null) {
                this.rsp.getResponseHeader().add("min_rf", (Object)Integer.parseInt(this.req.getParams().get("min_rf")));
            }
            this.rsp.getResponseHeader().add("rf", (Object)achievedRf);
            this.rollupReplicationTracker = null;
            this.leaderReplicationTracker = null;
        }
    }

    private void doLocalAdd(AddUpdateCommand cmd) throws IOException {
        super.processAdd(cmd);
        this.isIndexChanged = true;
    }

    private void doLocalDelete(DeleteUpdateCommand cmd) throws IOException {
        super.processDelete(cmd);
        this.isIndexChanged = true;
    }

    public static int bucketHash(BytesRef idBytes) {
        assert (idBytes != null);
        return Hash.murmurhash3_x86_32((byte[])idBytes.bytes, (int)idBytes.offset, (int)idBytes.length, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean versionAdd(AddUpdateCommand cmd) throws IOException {
        BytesRef idBytes = cmd.getIndexedId();
        if (idBytes == null) {
            super.processAdd(cmd);
            return false;
        }
        if (this.vinfo == null) {
            if (AtomicUpdateDocumentMerger.isAtomicUpdate(cmd)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Atomic document updates are not supported unless <updateLog/> is configured");
            }
            super.processAdd(cmd);
            return false;
        }
        int bucketHash = DistributedUpdateProcessor.bucketHash(idBytes);
        long versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            String versionOnUpdateS;
            Object o;
            SolrInputField versionField = cmd.getSolrInputDocument().getField("_version_");
            versionOnUpdate = versionField != null ? ((o = versionField.getValue()) instanceof Number ? ((Number)o).longValue() : Long.parseLong(o.toString())) : ((versionOnUpdateS = this.req.getParams().get("_version_")) == null ? 0L : Long.parseLong(versionOnUpdateS));
        }
        boolean isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        boolean leaderLogic = this.isLeader && !isReplayOrPeersync;
        boolean forwardedFromCollection = cmd.getReq().getParams().get(DISTRIB_FROM_COLLECTION) != null;
        VersionBucket bucket = this.vinfo.bucket(bucketHash);
        long dependentVersionFound = -1L;
        if (!leaderLogic && cmd.isInPlaceUpdate() && (dependentVersionFound = this.waitForDependentUpdates(cmd, versionOnUpdate, isReplayOrPeersync, bucket)) == -1L) {
            return true;
        }
        this.vinfo.lockForUpdate();
        if (bucket.tryLock()) {
            try {
                bucket.signalAll();
                if (this.versionsStored) {
                    long bucketVersion = bucket.highest;
                    if (leaderLogic) {
                        if (forwardedFromCollection && this.ulog.getState() == UpdateLog.State.ACTIVE) {
                            log.info("Removing version field from doc: " + cmd.getPrintableId());
                            cmd.solrDoc.remove((Object)"_version_");
                            versionOnUpdate = 0L;
                        }
                        boolean updated = this.getUpdatedDocument(cmd, versionOnUpdate);
                        if (forwardedFromCollection && this.ulog.getState() != UpdateLog.State.ACTIVE && !isReplayOrPeersync) {
                            log.info("Leader logic applied but update log is buffering: " + cmd.getPrintableId());
                            cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                            this.ulog.add(cmd);
                            boolean bl = true;
                            return bl;
                        }
                        if (versionOnUpdate != 0L) {
                            long foundVersion;
                            Long lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                            long l = foundVersion = lastVersion == null ? -1L : lastVersion;
                            if (!(versionOnUpdate == foundVersion || versionOnUpdate < 0L && foundVersion < 0L || versionOnUpdate == 1L && foundVersion > 0L)) {
                                throw new SolrException(SolrException.ErrorCode.CONFLICT, "version conflict for " + cmd.getPrintableId() + " expected=" + versionOnUpdate + " actual=" + foundVersion);
                            }
                        }
                        long version = this.vinfo.getNewClock();
                        cmd.setVersion(version);
                        cmd.getSolrInputDocument().setField("_version_", (Object)version);
                        bucket.updateHighest(version);
                    } else {
                        cmd.setVersion(versionOnUpdate);
                        if (this.shouldBufferUpdate(cmd, isReplayOrPeersync, this.ulog.getState())) {
                            cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                            this.ulog.add(cmd);
                            boolean updated = true;
                            return updated;
                        }
                        if (cmd.isInPlaceUpdate()) {
                            long prev = cmd.prevVersion;
                            Long lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                            if (lastVersion == null || Math.abs(lastVersion) < prev) {
                                UpdateCommand fetchedFromLeader = this.fetchFullUpdateFromLeader(cmd, versionOnUpdate);
                                if (fetchedFromLeader instanceof DeleteUpdateCommand) {
                                    log.info("In-place update of {} failed to find valid lastVersion to apply to, and the document was deleted at the leader subsequently.", (Object)idBytes.utf8ToString());
                                    this.versionDelete((DeleteUpdateCommand)fetchedFromLeader);
                                    boolean bl = true;
                                    return bl;
                                }
                                assert (fetchedFromLeader instanceof AddUpdateCommand);
                                log.info("In-place update of {} failed to find valid lastVersion to apply to, forced to fetch full doc from leader: {}", (Object)idBytes.utf8ToString(), (Object)fetchedFromLeader);
                                cmd.solrDoc = ((AddUpdateCommand)fetchedFromLeader).solrDoc;
                                cmd.prevVersion = -1L;
                                cmd.setVersion((Long)cmd.solrDoc.getFieldValue("_version_"));
                                assert (!cmd.isInPlaceUpdate());
                            } else {
                                if (lastVersion != null && Math.abs(lastVersion) > prev) {
                                    log.info("Update was applied on version: " + prev + ", but last version I have is: " + lastVersion + ". Dropping current update.");
                                    boolean bl = true;
                                    return bl;
                                }
                                if (bucketVersion != 0L && bucketVersion < versionOnUpdate) {
                                    bucket.updateHighest(versionOnUpdate);
                                }
                            }
                        } else if (bucketVersion != 0L && bucketVersion < versionOnUpdate) {
                            bucket.updateHighest(versionOnUpdate);
                        } else {
                            Long lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                            if (lastVersion != null && Math.abs(lastVersion) >= versionOnUpdate) {
                                log.debug("Dropping add update due to version {}", (Object)idBytes.utf8ToString());
                                boolean bl = true;
                                return bl;
                            }
                        }
                        if (!this.isSubShardLeader && this.replicaType == Replica.Type.TLOG && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                            cmd.setFlags(cmd.getFlags() | UpdateCommand.IGNORE_INDEXWRITER);
                        }
                    }
                }
                boolean willDistrib = this.isLeader && this.nodes != null && this.nodes.size() > 0;
                SolrInputDocument clonedDoc = null;
                if (willDistrib && this.cloneRequiredOnLeader) {
                    clonedDoc = cmd.solrDoc.deepCopy();
                }
                this.doLocalAdd(cmd);
                if (willDistrib && this.cloneRequiredOnLeader) {
                    cmd.solrDoc = clonedDoc;
                }
            }
            finally {
                bucket.unlock();
                this.vinfo.unlockForUpdate();
            }
            return false;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to get version bucket lock in " + bucket.getLockTimeoutMs() + " ms");
    }

    @VisibleForTesting
    boolean shouldBufferUpdate(AddUpdateCommand cmd, boolean isReplayOrPeersync, UpdateLog.State state) {
        if (state == UpdateLog.State.APPLYING_BUFFERED && !isReplayOrPeersync && !cmd.isInPlaceUpdate()) {
            return false;
        }
        return state != UpdateLog.State.ACTIVE && !isReplayOrPeersync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long waitForDependentUpdates(AddUpdateCommand cmd, long versionOnUpdate, boolean isReplayOrPeersync, VersionBucket bucket) throws IOException {
        long lastFoundVersion = 0L;
        TimeOut waitTimeout = new TimeOut(5L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        this.vinfo.lockForUpdate();
        if (bucket.tryLock()) {
            try {
                Long lookedUpVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                long l = lastFoundVersion = lookedUpVersion == null ? 0L : lookedUpVersion;
                if (Math.abs(lastFoundVersion) < cmd.prevVersion) {
                    log.debug("Re-ordered inplace update. version={}, prevVersion={}, lastVersion={}, replayOrPeerSync={}, id={}", new Object[]{cmd.getVersion() == 0L ? versionOnUpdate : cmd.getVersion(), cmd.prevVersion, lastFoundVersion, isReplayOrPeersync, cmd.getPrintableId()});
                }
                while (Math.abs(lastFoundVersion) < cmd.prevVersion && !waitTimeout.hasTimedOut()) {
                    bucket.awaitNanos(waitTimeout.timeLeft(TimeUnit.NANOSECONDS));
                    lookedUpVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                    lastFoundVersion = lookedUpVersion == null ? 0L : lookedUpVersion;
                }
            }
            finally {
                bucket.unlock();
                this.vinfo.unlockForUpdate();
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to get version bucket lock in " + bucket.getLockTimeoutMs() + " ms");
        }
        if (Math.abs(lastFoundVersion) > cmd.prevVersion) {
            if (log.isDebugEnabled()) {
                log.debug("Update was applied on version: {}, but last version I have is: {}. Current update should be dropped. id={}", new Object[]{cmd.prevVersion, lastFoundVersion, cmd.getPrintableId()});
            }
            return -1L;
        }
        if (Math.abs(lastFoundVersion) == cmd.prevVersion) {
            assert (0L < lastFoundVersion) : "prevVersion " + cmd.prevVersion + " found but is a delete!";
            if (log.isDebugEnabled()) {
                log.debug("Dependent update found. id={}", (Object)cmd.getPrintableId());
            }
            return lastFoundVersion;
        }
        log.info("Missing update, on which current in-place update depends on, hasn't arrived. id={}, looking for version={}, last found version={}", new Object[]{cmd.getPrintableId(), cmd.prevVersion, lastFoundVersion});
        UpdateCommand missingUpdate = this.fetchFullUpdateFromLeader(cmd, versionOnUpdate);
        if (missingUpdate instanceof DeleteUpdateCommand) {
            log.info("Tried to fetch document {} from the leader, but the leader says document has been deleted. Deleting the document here and skipping this update: Last found version: {}, was looking for: {}", new Object[]{cmd.getPrintableId(), lastFoundVersion, cmd.prevVersion});
            this.versionDelete((DeleteUpdateCommand)missingUpdate);
            return -1L;
        }
        assert (missingUpdate instanceof AddUpdateCommand);
        log.debug("Fetched the document: {}", (Object)((AddUpdateCommand)missingUpdate).getSolrInputDocument());
        this.versionAdd((AddUpdateCommand)missingUpdate);
        log.info("Added the fetched document, id=" + ((AddUpdateCommand)missingUpdate).getPrintableId() + ", version=" + missingUpdate.getVersion());
        return missingUpdate.getVersion();
    }

    private UpdateCommand fetchFullUpdateFromLeader(AddUpdateCommand inplaceAdd, long versionOnUpdate) throws IOException {
        NamedList rsp;
        String id = inplaceAdd.getPrintableId();
        UpdateShardHandler updateShardHandler = inplaceAdd.getReq().getCore().getCoreContainer().getUpdateShardHandler();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("distrib", false);
        params.set("getInputDocument", new String[]{id});
        params.set("onlyIfActive", true);
        GenericSolrRequest ur = new GenericSolrRequest(SolrRequest.METHOD.GET, "/get", (SolrParams)params);
        String leaderUrl = this.req.getParams().get(DISTRIB_FROM);
        if (leaderUrl == null) {
            Replica leader;
            if (this.zkController == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't find document with id=" + id + ", but fetching from leader failed since we're not in cloud mode.");
            }
            try {
                leader = this.zkController.getZkStateReader().getLeaderRetry(this.collection, this.cloudDesc.getShardId());
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception during fetching from leader.", (Throwable)e);
            }
            leaderUrl = leader.getCoreUrl();
        }
        try {
            ur.setBasePath(leaderUrl);
            rsp = updateShardHandler.getUpdateOnlyHttpClient().request((SolrRequest)ur);
        }
        catch (SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error during fetching [" + id + "] from leader (" + leaderUrl + "): ", (Throwable)e);
        }
        Object inputDocObj = rsp.get("inputDocument");
        Long version = (Long)rsp.get("version");
        SolrInputDocument leaderDoc = (SolrInputDocument)inputDocObj;
        if (leaderDoc == null) {
            DeleteUpdateCommand del = new DeleteUpdateCommand(inplaceAdd.getReq());
            del.setIndexedId(inplaceAdd.getIndexedId());
            del.setId(inplaceAdd.getIndexedId().utf8ToString());
            del.setVersion(version == null || version == 0L ? -versionOnUpdate : version);
            return del;
        }
        AddUpdateCommand cmd = new AddUpdateCommand(this.req);
        cmd.solrDoc = leaderDoc;
        cmd.setVersion((Long)leaderDoc.getFieldValue("_version_"));
        return cmd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean getUpdatedDocument(AddUpdateCommand cmd, long versionOnUpdate) throws IOException {
        if (!AtomicUpdateDocumentMerger.isAtomicUpdate(cmd)) {
            return false;
        }
        Set<String> inPlaceUpdatedFields = AtomicUpdateDocumentMerger.computeInPlaceUpdatableFields(cmd);
        if (inPlaceUpdatedFields.size() > 0 && this.docMerger.doInPlaceUpdateMerge(cmd, inPlaceUpdatedFields)) {
            return true;
        }
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        BytesRef id = cmd.getIndexedId();
        SolrInputDocument oldDoc = RealTimeGetComponent.getInputDocument(cmd.getReq().getCore(), id);
        if (oldDoc == null) {
            if (versionOnUpdate > 0L) throw new SolrException(SolrException.ErrorCode.CONFLICT, "Document not found for update.  id=" + cmd.getPrintableId());
            oldDoc = new SolrInputDocument(new String[0]);
        } else {
            oldDoc.remove((Object)"_version_");
        }
        cmd.solrDoc = this.docMerger.merge(sdoc, oldDoc);
        return true;
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        assert (TestInjection.injectFailUpdateRequests());
        this.updateCommand = cmd;
        if (!cmd.isDeleteById()) {
            this.doDeleteByQuery(cmd);
        } else {
            this.doDeleteById(cmd);
        }
    }

    private void doDeleteById(DeleteUpdateCommand cmd) throws IOException {
        if (this.zkEnabled) {
            this.zkCheck();
            this.nodes = this.setupRequest(cmd.getId(), null, cmd.getRoute());
        } else {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        }
        this.checkReplicationTracker(cmd);
        boolean dropCmd = false;
        if (!this.forwardToLeader) {
            dropCmd = this.versionDelete(cmd);
        }
        if (dropCmd) {
            return;
        }
        if (this.zkEnabled && this.isLeader && !this.isSubShardLeader) {
            List<SolrCmdDistributor.Node> nodesByRoutingRules;
            DocCollection coll = this.zkController.getClusterState().getCollection(this.collection);
            List<SolrCmdDistributor.Node> subShardLeaders = this.getSubShardLeaders(coll, this.cloudDesc.getShardId(), cmd.getId(), null);
            if (subShardLeaders != null && !subShardLeaders.isEmpty()) {
                ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
                params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                params.set(DISTRIB_FROM_PARENT, new String[]{this.cloudDesc.getShardId()});
                this.cmdDistrib.distribDelete(cmd, subShardLeaders, params, true, null, null);
            }
            if ((nodesByRoutingRules = this.getNodesByRoutingRules(this.zkController.getClusterState(), coll, cmd.getId(), null)) != null && !nodesByRoutingRules.isEmpty()) {
                ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
                params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                params.set(DISTRIB_FROM_COLLECTION, new String[]{this.collection});
                params.set(DISTRIB_FROM_SHARD, new String[]{this.cloudDesc.getShardId()});
                this.cmdDistrib.distribDelete(cmd, nodesByRoutingRules, params, true, null, null);
            }
        }
        if (this.nodes != null) {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("update.distrib", new String[]{this.isLeader || this.isSubShardLeader ? DistribPhase.FROMLEADER.toString() : DistribPhase.TOLEADER.toString()});
            params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            if (this.req.getParams().get("min_rf") != null) {
                params.add("min_rf", new String[]{this.req.getParams().get("min_rf")});
            }
            this.cmdDistrib.distribDelete(cmd, this.nodes, params, false, this.rollupReplicationTracker, this.leaderReplicationTracker);
        }
        if (this.returnVersions && this.rsp != null && cmd.getIndexedId() != null && this.idField != null) {
            if (this.deleteResponse == null) {
                this.deleteResponse = new NamedList(1);
                this.rsp.add("deletes", this.deleteResponse);
            }
            if (this.scratch == null) {
                this.scratch = new CharsRefBuilder();
            }
            this.idField.getType().indexedToReadable(cmd.getIndexedId(), this.scratch);
            this.deleteResponse.add(this.scratch.toString(), (Object)cmd.getVersion());
        }
    }

    protected ModifiableSolrParams filterParams(SolrParams params) {
        ModifiableSolrParams fparams = new ModifiableSolrParams();
        Set whitelist = (Set)this.req.getContext().get(PARAM_WHITELIST_CTX_KEY);
        assert (null != whitelist) : "whitelist can't be null, constructor adds to it";
        for (String p : whitelist) {
            this.passParam(params, fparams, p);
        }
        return fparams;
    }

    private void passParam(SolrParams params, ModifiableSolrParams fparams, String param) {
        String[] values = params.getParams(param);
        if (values != null) {
            for (String value : values) {
                fparams.add(param, new String[]{value});
            }
        }
    }

    public void doDeleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        DocCollection coll;
        if (!this.zkEnabled) {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        } else {
            this.zkCheck();
        }
        DistribPhase phase = DistribPhase.parseParam(this.req.getParams().get("update.distrib"));
        DocCollection docCollection = coll = this.zkEnabled ? this.zkController.getClusterState().getCollection(this.collection) : null;
        if (this.zkEnabled && DistribPhase.NONE == phase) {
            if (this.rollupReplicationTracker == null) {
                this.rollupReplicationTracker = new RollupRequestReplicationTracker();
            }
            boolean leaderForAnyShard = false;
            ModifiableSolrParams outParams = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            outParams.set("update.distrib", new String[]{DistribPhase.TOLEADER.toString()});
            outParams.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            SolrParams params = this.req.getParams();
            String route = params.get("_route_");
            Collection slices = coll.getRouter().getSearchSlices(route, params, coll);
            ArrayList<SolrCmdDistributor.Node> leaders = new ArrayList<SolrCmdDistributor.Node>(slices.size());
            for (Slice slice : slices) {
                Replica leader;
                String sliceName = slice.getName();
                try {
                    leader = this.zkController.getZkStateReader().getLeaderRetry(this.collection, sliceName);
                }
                catch (InterruptedException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Exception finding leader for shard " + sliceName, (Throwable)e);
                }
                ZkCoreNodeProps coreLeaderProps = new ZkCoreNodeProps((ZkNodeProps)leader);
                String leaderCoreNodeName = leader.getName();
                String coreNodeName = this.cloudDesc.getCoreNodeName();
                this.isLeader = coreNodeName.equals(leaderCoreNodeName);
                if (this.isLeader) {
                    leaderForAnyShard = true;
                    continue;
                }
                leaders.add(new SolrCmdDistributor.ForwardNode(coreLeaderProps, this.zkController.getZkStateReader(), this.collection, sliceName, this.maxRetriesOnForward));
            }
            outParams.remove("commit");
            if (params.get("min_rf") != null) {
                outParams.add("min_rf", new String[]{this.req.getParams().get("min_rf")});
            }
            this.cmdDistrib.distribDelete(cmd, leaders, outParams, false, this.rollupReplicationTracker, null);
            if (!leaderForAnyShard) {
                return;
            }
            phase = DistribPhase.TOLEADER;
        }
        List<SolrCmdDistributor.Node> replicas = null;
        if (this.zkEnabled && DistribPhase.TOLEADER == phase) {
            this.isLeader = true;
            replicas = this.setupRequestForDBQ();
        } else if (DistribPhase.FROMLEADER == phase) {
            this.isLeader = false;
        }
        this.checkReplicationTracker(cmd);
        if (this.vinfo == null) {
            super.processDelete(cmd);
            return;
        }
        boolean isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        boolean leaderLogic = this.isLeader && !isReplayOrPeersync;
        this.versionDeleteByQuery(cmd);
        if (this.zkEnabled) {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("_version_", new String[]{Long.toString(cmd.getVersion())});
            params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
            params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            boolean someReplicas = false;
            boolean subShardLeader = false;
            try {
                subShardLeader = this.amISubShardLeader(coll, null, null, null);
                if (subShardLeader) {
                    String myShardId = this.cloudDesc.getShardId();
                    Replica leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, myShardId);
                    List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, myShardId, leaderReplica.getName(), null, Replica.State.DOWN, EnumSet.of(Replica.Type.NRT, Replica.Type.TLOG));
                    if (replicaProps != null) {
                        ArrayList<SolrCmdDistributor.Node> myReplicas = new ArrayList<SolrCmdDistributor.Node>(replicaProps.size());
                        for (ZkCoreNodeProps replicaProp : replicaProps) {
                            myReplicas.add(new SolrCmdDistributor.StdNode(replicaProp, this.collection, myShardId));
                        }
                        this.cmdDistrib.distribDelete(cmd, myReplicas, params, false, this.rollupReplicationTracker, this.leaderReplicationTracker);
                        someReplicas = true;
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            if (leaderLogic) {
                List<SolrCmdDistributor.Node> nodesByRoutingRules;
                List<SolrCmdDistributor.Node> subShardLeaders = this.getSubShardLeaders(coll, this.cloudDesc.getShardId(), null, null);
                if (subShardLeaders != null) {
                    this.cmdDistrib.distribDelete(cmd, subShardLeaders, params, true, this.rollupReplicationTracker, this.leaderReplicationTracker);
                }
                if ((nodesByRoutingRules = this.getNodesByRoutingRules(this.zkController.getClusterState(), coll, null, null)) != null && !nodesByRoutingRules.isEmpty()) {
                    params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                    params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
                    params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                    params.set(DISTRIB_FROM_COLLECTION, new String[]{this.collection});
                    params.set(DISTRIB_FROM_SHARD, new String[]{this.cloudDesc.getShardId()});
                    this.cmdDistrib.distribDelete(cmd, nodesByRoutingRules, params, true, this.rollupReplicationTracker, this.leaderReplicationTracker);
                }
                if (replicas != null) {
                    this.cmdDistrib.distribDelete(cmd, replicas, params, false, this.rollupReplicationTracker, this.leaderReplicationTracker);
                    someReplicas = true;
                }
            }
            if (someReplicas) {
                this.cmdDistrib.blockAndDoRetries();
            }
        }
        if (this.returnVersions && this.rsp != null) {
            if (this.deleteByQueryResponse == null) {
                this.deleteByQueryResponse = new NamedList(1);
                this.rsp.add("deleteByQuery", this.deleteByQueryResponse);
            }
            this.deleteByQueryResponse.add(cmd.getQuery(), (Object)cmd.getVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void versionDeleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        boolean leaderLogic;
        long versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            String versionOnUpdateS = this.req.getParams().get("_version_");
            versionOnUpdate = versionOnUpdateS == null ? 0L : Long.parseLong(versionOnUpdateS);
        }
        versionOnUpdate = Math.abs(versionOnUpdate);
        boolean isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        boolean bl = leaderLogic = this.isLeader && !isReplayOrPeersync;
        if (!leaderLogic && versionOnUpdate == 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing _version_ on update from leader");
        }
        this.vinfo.blockUpdates();
        try {
            if (this.versionsStored) {
                if (leaderLogic) {
                    long version = this.vinfo.getNewClock();
                    cmd.setVersion(-version);
                    this.doLocalDelete(cmd);
                } else {
                    cmd.setVersion(-versionOnUpdate);
                    if (this.ulog.getState() != UpdateLog.State.ACTIVE && !isReplayOrPeersync) {
                        cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                        this.ulog.deleteByQuery(cmd);
                        return;
                    }
                    if (!this.isSubShardLeader && this.replicaType == Replica.Type.TLOG && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                        cmd.setFlags(cmd.getFlags() | UpdateCommand.IGNORE_INDEXWRITER);
                    }
                    this.doLocalDelete(cmd);
                }
            }
        }
        finally {
            this.vinfo.unblockUpdates();
        }
    }

    boolean isLeader(UpdateCommand cmd) {
        this.updateCommand = cmd;
        if (this.zkEnabled) {
            this.zkCheck();
            if (cmd instanceof AddUpdateCommand) {
                AddUpdateCommand acmd = (AddUpdateCommand)cmd;
                this.nodes = this.setupRequest(acmd.getHashableId(), acmd.getSolrInputDocument());
            } else if (cmd instanceof DeleteUpdateCommand) {
                DeleteUpdateCommand dcmd = (DeleteUpdateCommand)cmd;
                this.nodes = this.setupRequest(dcmd.getId(), null);
            }
        } else {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        }
        return this.isLeader;
    }

    private void zkCheck() {
        if (this.req.getCore().getCoreContainer().isShutDown()) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "CoreContainer is shutting down.");
        }
        if ((this.updateCommand.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0) {
            return;
        }
        if (!this.zkController.getZkClient().getConnectionManager().isLikelyExpired()) {
            return;
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot talk to ZooKeeper - Updates are disabled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean versionDelete(DeleteUpdateCommand cmd) throws IOException {
        boolean forwardedFromCollection;
        BytesRef idBytes = cmd.getIndexedId();
        if (this.vinfo == null || idBytes == null) {
            super.processDelete(cmd);
            return false;
        }
        int bucketHash = DistributedUpdateProcessor.bucketHash(idBytes);
        long versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            String versionOnUpdateS = this.req.getParams().get("_version_");
            versionOnUpdate = versionOnUpdateS == null ? 0L : Long.parseLong(versionOnUpdateS);
        }
        long signedVersionOnUpdate = versionOnUpdate;
        versionOnUpdate = Math.abs(versionOnUpdate);
        boolean isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        boolean leaderLogic = this.isLeader && !isReplayOrPeersync;
        boolean bl = forwardedFromCollection = cmd.getReq().getParams().get(DISTRIB_FROM_COLLECTION) != null;
        if (!leaderLogic && versionOnUpdate == 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing _version_ on update from leader");
        }
        VersionBucket bucket = this.vinfo.bucket(bucketHash);
        this.vinfo.lockForUpdate();
        if (bucket.tryLock()) {
            try {
                if (this.versionsStored) {
                    long bucketVersion = bucket.highest;
                    if (leaderLogic) {
                        if (forwardedFromCollection && this.ulog.getState() == UpdateLog.State.ACTIVE) {
                            log.info("Removing version field from doc: " + cmd.getId());
                            signedVersionOnUpdate = 0L;
                            versionOnUpdate = 0L;
                        }
                        if (forwardedFromCollection && this.ulog.getState() != UpdateLog.State.ACTIVE && !isReplayOrPeersync) {
                            log.info("Leader logic applied but update log is buffering: " + cmd.getId());
                            cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                            this.ulog.delete(cmd);
                            boolean bl2 = true;
                            return bl2;
                        }
                        if (signedVersionOnUpdate != 0L) {
                            long foundVersion;
                            Long lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                            long l = foundVersion = lastVersion == null ? -1L : lastVersion;
                            if (!(signedVersionOnUpdate == foundVersion || signedVersionOnUpdate < 0L && foundVersion < 0L || signedVersionOnUpdate == 1L && foundVersion > 0L)) {
                                throw new SolrException(SolrException.ErrorCode.CONFLICT, "version conflict for " + cmd.getId() + " expected=" + signedVersionOnUpdate + " actual=" + foundVersion);
                            }
                        }
                        long version = this.vinfo.getNewClock();
                        cmd.setVersion(-version);
                        bucket.updateHighest(version);
                    } else {
                        cmd.setVersion(-versionOnUpdate);
                        if (this.ulog.getState() != UpdateLog.State.ACTIVE && !isReplayOrPeersync) {
                            cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                            this.ulog.delete(cmd);
                            boolean version = true;
                            return version;
                        }
                        if (bucketVersion != 0L && bucketVersion < versionOnUpdate) {
                            bucket.updateHighest(versionOnUpdate);
                        } else {
                            Long lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                            if (lastVersion != null && Math.abs(lastVersion) >= versionOnUpdate) {
                                log.debug("Dropping delete update due to version {}", (Object)idBytes.utf8ToString());
                                boolean bl3 = true;
                                return bl3;
                            }
                        }
                        if (!this.isSubShardLeader && this.replicaType == Replica.Type.TLOG && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                            cmd.setFlags(cmd.getFlags() | UpdateCommand.IGNORE_INDEXWRITER);
                        }
                    }
                }
                this.doLocalDelete(cmd);
                boolean bl4 = false;
                return bl4;
            }
            finally {
                bucket.unlock();
                this.vinfo.unlockForUpdate();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to get version bucket lock in " + bucket.getLockTimeoutMs() + " ms");
    }

    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        assert (TestInjection.injectFailUpdateRequests());
        this.updateCommand = cmd;
        List<SolrCmdDistributor.Node> nodes = null;
        Replica leaderReplica = null;
        if (this.zkEnabled) {
            this.zkCheck();
            try {
                leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, this.cloudDesc.getShardId());
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Exception finding leader for shard " + this.cloudDesc.getShardId(), (Throwable)e);
            }
            this.isLeader = leaderReplica.getName().equals(this.cloudDesc.getCoreNodeName());
            nodes = this.getCollectionUrls(this.collection, EnumSet.of(Replica.Type.TLOG, Replica.Type.NRT), true);
            if (nodes == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to distribute commit operation. No replicas available of types " + Replica.Type.TLOG + " or " + Replica.Type.NRT);
            }
            nodes.removeIf(node -> node.getNodeProps().getNodeName().equals(this.zkController.getNodeName()) && node.getNodeProps().getCoreName().equals(this.req.getCore().getName()));
        }
        ExecutorCompletionService completionService = new ExecutorCompletionService(this.req.getCore().getCoreContainer().getUpdateShardHandler().getUpdateExecutor());
        HashSet pending = new HashSet();
        if (!this.zkEnabled || !this.isLeader && this.req.getParams().get(COMMIT_END_POINT, "").equals("replicas")) {
            if (this.replicaType == Replica.Type.TLOG) {
                if (this.isLeader) {
                    long commitVersion = this.vinfo.getNewClock();
                    cmd.setVersion(commitVersion);
                    this.doLocalCommit(cmd);
                } else assert (TestInjection.waitForInSyncWithLeader(this.req.getCore(), this.zkController, this.collection, this.cloudDesc.getShardId())) : "Core " + this.req.getCore() + " not in sync with leader";
            } else if (this.replicaType == Replica.Type.PULL) {
                log.warn("Commit not supported on replicas of type " + Replica.Type.PULL);
            } else {
                if (this.vinfo != null) {
                    long commitVersion = this.vinfo.getNewClock();
                    cmd.setVersion(commitVersion);
                }
                this.doLocalCommit(cmd);
            }
        } else {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            List<SolrCmdDistributor.Node> useNodes = null;
            if (this.req.getParams().get(COMMIT_END_POINT) == null) {
                useNodes = nodes;
                params.set("update.distrib", new String[]{DistribPhase.TOLEADER.toString()});
                params.set(COMMIT_END_POINT, new String[]{"leaders"});
                if (useNodes != null) {
                    params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                    this.cmdDistrib.distribCommit(cmd, useNodes, params);
                    this.cmdDistrib.blockAndDoRetries();
                }
            }
            if (this.isLeader) {
                params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
                params.set(COMMIT_END_POINT, new String[]{"replicas"});
                useNodes = this.getReplicaNodesForLeader(this.cloudDesc.getShardId(), leaderReplica);
                if (useNodes != null) {
                    params.set(DISTRIB_FROM, new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                    this.cmdDistrib.distribCommit(cmd, useNodes, params);
                }
                if (this.vinfo != null) {
                    long commitVersion = this.vinfo.getNewClock();
                    cmd.setVersion(commitVersion);
                }
                this.doLocalCommit(cmd);
                if (useNodes != null) {
                    this.cmdDistrib.blockAndDoRetries();
                }
            }
        }
    }

    private void doLocalCommit(CommitUpdateCommand cmd) throws IOException {
        if (this.vinfo != null) {
            this.vinfo.lockForUpdate();
        }
        try {
            if (this.ulog == null || this.ulog.getState() == UpdateLog.State.ACTIVE || (cmd.getFlags() & UpdateCommand.REPLAY) != 0) {
                super.processCommit(cmd);
            } else {
                log.info("Ignoring commit while not ACTIVE - state: " + (Object)((Object)this.ulog.getState()) + " replay: " + ((cmd.getFlags() & UpdateCommand.REPLAY) != 0));
            }
        }
        finally {
            if (this.vinfo != null) {
                this.vinfo.unlockForUpdate();
            }
        }
    }

    @Override
    public void finish() throws IOException {
        assert (!this.finished) : "lifecycle sanity check";
        this.finished = true;
        if (this.zkEnabled) {
            this.doFinish();
        }
        if (this.next != null && this.nodes == null) {
            this.next.finish();
        }
    }

    private List<SolrCmdDistributor.Node> getCollectionUrls(String collection, EnumSet<Replica.Type> types, boolean onlyLeaders) {
        ClusterState clusterState = this.zkController.getClusterState();
        DocCollection docCollection = clusterState.getCollectionOrNull(collection);
        if (collection == null || docCollection.getSlicesMap() == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection in zk: " + clusterState);
        }
        Map slices = docCollection.getSlicesMap();
        ArrayList<SolrCmdDistributor.Node> urls = new ArrayList<SolrCmdDistributor.Node>(slices.size());
        for (Map.Entry sliceEntry : slices.entrySet()) {
            Slice replicas = (Slice)slices.get(sliceEntry.getKey());
            if (onlyLeaders) {
                Replica replica = docCollection.getLeader(replicas.getName());
                if (replica == null) continue;
                ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)replica);
                urls.add(new SolrCmdDistributor.StdNode(nodeProps, collection, replicas.getName()));
                continue;
            }
            Map shardMap = replicas.getReplicasMap();
            for (Map.Entry entry : shardMap.entrySet()) {
                ZkCoreNodeProps nodeProps;
                if (!types.contains(((Replica)entry.getValue()).getType()) || !clusterState.liveNodesContain((nodeProps = new ZkCoreNodeProps((ZkNodeProps)entry.getValue())).getNodeName())) continue;
                urls.add(new SolrCmdDistributor.StdNode(nodeProps, collection, replicas.getName()));
            }
        }
        if (urls.isEmpty()) {
            return null;
        }
        return urls;
    }

    public static boolean getNonZkLeaderAssumption(SolrQueryRequest req) {
        DistribPhase phase = DistribPhase.parseParam(req.getParams().get("update.distrib"));
        return DistribPhase.FROMLEADER != phase;
    }

    public static class LeaderRequestReplicationTracker {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        private int achievedRf = 1;
        private final String myShardId;

        public LeaderRequestReplicationTracker(String shardId) {
            this.myShardId = shardId;
        }

        public int getAchievedRf() {
            return this.achievedRf;
        }

        public void trackRequestResult(SolrCmdDistributor.Node node, boolean success) {
            if (log.isDebugEnabled()) {
                log.debug("trackRequestResult({}): success? {}, shardId={}", new Object[]{node, success, this.myShardId});
            }
            if (success) {
                ++this.achievedRf;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("LeaderRequestReplicationTracker");
            sb.append(", achievedRf=").append(this.getAchievedRf()).append(" for shard ").append(this.myShardId);
            return sb.toString();
        }
    }

    public static class RollupRequestReplicationTracker {
        private int achievedRf = Integer.MAX_VALUE;

        public int getAchievedRf() {
            return this.achievedRf;
        }

        public void testAndSetAchievedRf(int rf) {
            this.achievedRf = Math.min(this.achievedRf, rf);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("RollupRequestReplicationTracker").append(" achievedRf: ").append(this.achievedRf);
            return sb.toString();
        }
    }

    public static final class DistributedUpdatesAsyncException
    extends SolrException {
        public final List<SolrCmdDistributor.Error> errors;

        public DistributedUpdatesAsyncException(List<SolrCmdDistributor.Error> errors) {
            super(DistributedUpdatesAsyncException.buildCode(errors), DistributedUpdatesAsyncException.buildMsg(errors), null);
            this.errors = errors;
            NamedList metadata = new NamedList();
            for (SolrCmdDistributor.Error error : errors) {
                SolrException e;
                NamedList eMeta;
                if (!(error.e instanceof SolrException) || null == (eMeta = (e = (SolrException)((Object)error.e)).getMetadata())) continue;
                metadata.addAll(eMeta);
            }
            if (0 < metadata.size()) {
                this.setMetadata(metadata);
            }
        }

        private static int buildCode(List<SolrCmdDistributor.Error> errors) {
            assert (null != errors);
            assert (0 < errors.size());
            int minCode = Integer.MAX_VALUE;
            int maxCode = Integer.MIN_VALUE;
            for (SolrCmdDistributor.Error error : errors) {
                log.trace("REMOTE ERROR: {}", (Object)error);
                minCode = Math.min(error.statusCode, minCode);
                maxCode = Math.max(error.statusCode, maxCode);
            }
            if (minCode == maxCode) {
                return minCode;
            }
            if (400 <= minCode && maxCode < 500) {
                return SolrException.ErrorCode.BAD_REQUEST.code;
            }
            return SolrException.ErrorCode.SERVER_ERROR.code;
        }

        private static String buildMsg(List<SolrCmdDistributor.Error> errors) {
            assert (null != errors);
            assert (0 < errors.size());
            if (1 == errors.size()) {
                return "Async exception during distributed update: " + errors.get((int)0).e.getMessage();
            }
            StringBuilder buf = new StringBuilder(errors.size() + " Async exceptions during distributed update: ");
            for (SolrCmdDistributor.Error error : errors) {
                buf.append("\n");
                buf.append(error.e.getMessage());
            }
            return buf.toString();
        }
    }

    public static enum DistribPhase {
        NONE,
        TOLEADER,
        FROMLEADER;


        public static DistribPhase parseParam(String param) {
            if (param == null || param.trim().isEmpty()) {
                return NONE;
            }
            try {
                return DistribPhase.valueOf(param);
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal value for update.distrib: " + param, (Throwable)e);
            }
        }
    }
}

