/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.eclipse.jetty.client.api.Request;

public abstract class AuthenticationPlugin
implements Closeable,
SolrInfoBean,
SolrMetricProducer {
    public static final String AUTHENTICATION_PLUGIN_PROP = "authenticationPlugin";
    private Set<String> metricNames = ConcurrentHashMap.newKeySet();
    private MetricRegistry registry;
    protected String registryName;
    protected SolrMetricManager metricManager;
    protected Meter numErrors = new Meter();
    protected Counter requests = new Counter();
    protected Timer requestTimes = new Timer();
    protected Counter totalTime = new Counter();
    protected Counter numAuthenticated = new Counter();
    protected Counter numPassThrough = new Counter();
    protected Counter numWrongCredentials = new Counter();
    protected Counter numMissingCredentials = new Counter();

    public abstract void init(Map<String, Object> var1);

    public abstract boolean doAuthenticate(ServletRequest var1, ServletResponse var2, FilterChain var3) throws Exception;

    public final boolean authenticate(ServletRequest request, ServletResponse response, FilterChain filterChain) throws Exception {
        Timer.Context timer = this.requestTimes.time();
        this.requests.inc();
        try {
            boolean bl = this.doAuthenticate(request, response, filterChain);
            return bl;
        }
        catch (Exception e) {
            this.numErrors.mark();
            throw e;
        }
        finally {
            long elapsed = timer.stop();
            this.totalTime.inc(elapsed);
        }
    }

    protected boolean interceptInternodeRequest(HttpRequest httpRequest, HttpContext httpContext) {
        return this instanceof HttpClientBuilderPlugin;
    }

    protected boolean interceptInternodeRequest(Request request) {
        return this instanceof HttpClientBuilderPlugin;
    }

    public void closeRequest() {
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registryName, String tag, String scope) {
        this.metricManager = manager;
        this.registryName = registryName;
        this.registry = manager.registry(registryName);
        this.numErrors = manager.meter(this, registryName, "errors", this.getCategory().toString(), scope);
        this.requests = manager.counter(this, registryName, "requests", this.getCategory().toString(), scope);
        this.numAuthenticated = manager.counter(this, registryName, "authenticated", this.getCategory().toString(), scope);
        this.numPassThrough = manager.counter(this, registryName, "passThrough", this.getCategory().toString(), scope);
        this.numWrongCredentials = manager.counter(this, registryName, "failWrongCredentials", this.getCategory().toString(), scope);
        this.numMissingCredentials = manager.counter(this, registryName, "failMissingCredentials", this.getCategory().toString(), scope);
        this.requestTimes = manager.timer(this, registryName, "requestTimes", this.getCategory().toString(), scope);
        this.totalTime = manager.counter(this, registryName, "totalTime", this.getCategory().toString(), scope);
        this.metricNames.addAll(Arrays.asList("errors", "requests", "authenticated", "passThrough", "failWrongCredentials", "failMissingCredentials", "requestTimes", "totalTime"));
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public String getDescription() {
        return "Authentication Plugin " + this.getClass().getName();
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.SECURITY;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.registry;
    }
}

