/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.api.collections.TimeRoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.DateMathParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintainRoutedAliasCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String IF_MOST_RECENT_COLL_NAME = "ifMostRecentCollName";
    private final OverseerCollectionMessageHandler ocmh;

    public MaintainRoutedAliasCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    public static NamedList remoteInvoke(CollectionsHandler collHandler, String aliasName, String mostRecentCollName) throws Exception {
        String operation = CollectionParams.CollectionAction.MAINTAINROUTEDALIAS.toLower();
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("operation", operation);
        msg.put("name", aliasName);
        msg.put(IF_MOST_RECENT_COLL_NAME, mostRecentCollName);
        SolrResponse rsp = collHandler.sendToOCPQueue(new ZkNodeProps(msg));
        if (rsp.getException() != null) {
            throw rsp.getException();
        }
        return rsp.getResponse();
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        NamedList createResults;
        String aliasName = message.getStr("name");
        String ifMostRecentCollName = message.getStr(IF_MOST_RECENT_COLL_NAME);
        ZkStateReader.AliasesManager aliasesManager = this.ocmh.zkStateReader.aliasesManager;
        Aliases aliases = aliasesManager.getAliases();
        Map aliasMetadata = aliases.getCollectionAliasProperties(aliasName);
        if (aliasMetadata == null) {
            throw this.newAliasMustExistException(aliasName);
        }
        TimeRoutedAlias timeRoutedAlias = new TimeRoutedAlias(aliasName, aliasMetadata);
        List<Map.Entry<Instant, String>> parsedCollections = timeRoutedAlias.parseCollections(aliases, () -> this.newAliasMustExistException(aliasName));
        Map.Entry<Instant, String> mostRecentEntry = parsedCollections.get(0);
        Instant mostRecentCollTimestamp = mostRecentEntry.getKey();
        String mostRecentCollName = mostRecentEntry.getValue();
        if (ifMostRecentCollName != null) {
            if (!mostRecentCollName.equals(ifMostRecentCollName)) {
                String msg = "ifMostRecentCollName expected " + ifMostRecentCollName + " but it's " + mostRecentCollName;
                if (parsedCollections.stream().map(Map.Entry::getValue).noneMatch(ifMostRecentCollName::equals)) {
                    msg = msg + ". Furthermore this collection isn't in the list of collections referenced by the alias.";
                }
                log.info(msg);
                results.add("message", (Object)msg);
                return;
            }
        } else if (mostRecentCollTimestamp.isAfter(Instant.now())) {
            String msg = "Most recent collection is in the future, so we won't create another.";
            log.info("Most recent collection is in the future, so we won't create another.");
            results.add("message", (Object)"Most recent collection is in the future, so we won't create another.");
            return;
        }
        Instant nextCollTimestamp = timeRoutedAlias.computeNextCollTimestamp(mostRecentCollTimestamp);
        String createCollName = TimeRoutedAlias.formatCollectionNameFromInstant(aliasName, nextCollTimestamp);
        NamedList deleteResults = this.deleteOldestCollectionsAndUpdateAlias(timeRoutedAlias, aliasesManager, nextCollTimestamp);
        if (deleteResults != null) {
            results.add("delete", (Object)deleteResults);
        }
        if ((createResults = MaintainRoutedAliasCmd.createCollectionAndWait(clusterState, aliasName, aliasMetadata, createCollName, this.ocmh)) != null) {
            results.add("create", (Object)createResults);
        }
        aliasesManager.applyModificationAndExportToZk(curAliases -> {
            List curTargetCollections = (List)curAliases.getCollectionAliasListMap().get(aliasName);
            if (curTargetCollections.contains(createCollName)) {
                return curAliases;
            }
            ArrayList<String> newTargetCollections = new ArrayList<String>(curTargetCollections.size() + 1);
            newTargetCollections.add(createCollName);
            newTargetCollections.addAll(curTargetCollections);
            return curAliases.cloneWithCollectionAlias(aliasName, StrUtils.join(newTargetCollections, (char)','));
        });
    }

    NamedList deleteOldestCollectionsAndUpdateAlias(TimeRoutedAlias timeRoutedAlias, ZkStateReader.AliasesManager aliasesManager, Instant now) throws Exception {
        Instant delBefore;
        String autoDeleteAgeMathStr = timeRoutedAlias.getAutoDeleteAgeMath();
        if (autoDeleteAgeMathStr == null) {
            return null;
        }
        try {
            delBefore = new DateMathParser(Date.from(now), timeRoutedAlias.getTimeZone()).parseMath(autoDeleteAgeMathStr).toInstant();
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        String aliasName = timeRoutedAlias.getAliasName();
        LinkedHashSet collectionsToDelete = new LinkedHashSet();
        aliasesManager.applyModificationAndExportToZk(curAliases -> {
            List<Map.Entry<Instant, String>> parsedCollections = timeRoutedAlias.parseCollections((Aliases)curAliases, () -> this.newAliasMustExistException(aliasName));
            int numToKeep = 0;
            for (Map.Entry<Instant, String> parsedCollection : parsedCollections) {
                ++numToKeep;
                Instant colInstant = parsedCollection.getKey();
                if (!colInstant.isBefore(delBefore) && !colInstant.equals(delBefore)) continue;
                break;
            }
            if (numToKeep == parsedCollections.size()) {
                log.debug("No old time routed collections to delete.");
                return curAliases;
            }
            List targetList = (List)curAliases.getCollectionAliasListMap().get(aliasName);
            for (int i = targetList.size() - 1; i >= numToKeep; --i) {
                collectionsToDelete.add(targetList.get(i));
            }
            List collectionsToKeep = targetList.subList(0, numToKeep);
            String collectionsToKeepStr = StrUtils.join(collectionsToKeep, (char)',');
            return curAliases.cloneWithCollectionAlias(aliasName, collectionsToKeepStr);
        });
        if (collectionsToDelete.isEmpty()) {
            return null;
        }
        log.info("Removing old time routed collections: {}", collectionsToDelete);
        CollectionsHandler collHandler = this.ocmh.overseer.getCoreContainer().getCollectionsHandler();
        NamedList results = new NamedList();
        for (String collection : collectionsToDelete) {
            SolrParams reqParams = CollectionAdminRequest.deleteCollection((String)collection).getParams();
            SolrQueryResponse rsp = new SolrQueryResponse();
            collHandler.handleRequestBody(new LocalSolrQueryRequest(null, reqParams), rsp);
            results.add(collection, (Object)rsp.getValues());
        }
        return results;
    }

    static NamedList createCollectionAndWait(ClusterState clusterState, String aliasName, Map<String, String> aliasMetadata, String createCollName, OverseerCollectionMessageHandler ocmh) throws Exception {
        NamedList results;
        block4: {
            ModifiableSolrParams createReqParams = new ModifiableSolrParams();
            for (Map.Entry<String, String> e : aliasMetadata.entrySet()) {
                if (!e.getKey().startsWith("create-collection.")) continue;
                createReqParams.set(e.getKey().substring("create-collection.".length()), new String[]{e.getValue()});
            }
            if (createReqParams.get("collection.configName") == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "We require an explicit collection.configName");
            }
            createReqParams.set("name", new String[]{createCollName});
            createReqParams.set("property.routedAliasName", new String[]{aliasName});
            Map<String, Object> createMsgMap = CollectionsHandler.CollectionOperation.CREATE_OP.execute(new LocalSolrQueryRequest(null, (SolrParams)createReqParams), null, ocmh.overseer.getCoreContainer().getCollectionsHandler());
            createMsgMap.put("operation", "create");
            results = new NamedList();
            try {
                ocmh.commandMap.get(CollectionParams.CollectionAction.CREATE).call(clusterState, new ZkNodeProps(createMsgMap), results);
            }
            catch (SolrException e) {
                if (e.getMessage().contains("collection already exists")) break block4;
                throw e;
            }
        }
        CollectionsHandler.waitForActiveCollection(createCollName, ocmh.overseer.getCoreContainer(), new OverseerSolrResponse(results));
        return results;
    }

    private SolrException newAliasMustExistException(String aliasName) {
        return new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Alias " + aliasName + " does not exist.");
    }
}

