/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mp4.boxes;

import com.drew.lang.SequentialReader;
import com.drew.metadata.mp4.boxes.Box;
import com.drew.metadata.mp4.boxes.SampleEntry;
import com.drew.metadata.mp4.media.Mp4VideoDirectory;
import java.io.IOException;

public class VisualSampleEntry
extends SampleEntry {
    int version;
    int revisionLevel;
    String vendor;
    int temporalQuality;
    int spatialQuality;
    int width;
    int height;
    long horizresolution;
    long vertresolution;
    int frameCount;
    String compressorname;
    int depth;

    public VisualSampleEntry(SequentialReader reader, Box box) throws IOException {
        super(reader, box);
        this.version = reader.getInt16();
        this.revisionLevel = reader.getInt16();
        this.vendor = reader.getString(4);
        this.temporalQuality = reader.getInt32();
        this.spatialQuality = reader.getInt32();
        this.width = reader.getUInt16();
        this.height = reader.getUInt16();
        this.horizresolution = reader.getUInt32();
        this.vertresolution = reader.getUInt32();
        reader.skip(4L);
        this.frameCount = reader.getUInt16();
        this.compressorname = reader.getString(32);
        this.depth = reader.getUInt16();
        reader.skip(2L);
    }

    public void addMetadata(Mp4VideoDirectory directory) {
        directory.setInt(104, this.width);
        directory.setInt(105, this.height);
        directory.setString(110, this.compressorname.trim());
        directory.setInt(109, this.depth);
        double horizontalInteger = (this.horizresolution & 0xFFFFFFFFFFFF0000L) >> 16;
        double horizontalFraction = (double)(this.horizresolution & 0xFFFFL) / Math.pow(2.0, 4.0);
        directory.setDouble(106, horizontalInteger + horizontalFraction);
        double verticalInteger = (this.vertresolution & 0xFFFFFFFFFFFF0000L) >> 16;
        double verticalFraction = (double)(this.vertresolution & 0xFFFFL) / Math.pow(2.0, 4.0);
        directory.setDouble(107, verticalInteger + verticalFraction);
    }
}

