/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.DeleteShardCmd;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateShardCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public CreateShardCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        String collectionName = message.getStr("collection");
        String sliceName = message.getStr("shard");
        boolean waitForFinalState = message.getBool("waitForFinalState", false);
        log.info("Create shard invoked: {}", (Object)message);
        if (collectionName == null || sliceName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'collection' and 'shard' are required parameters");
        }
        DocCollection collection = clusterState.getCollection(collectionName);
        int numNrtReplicas = message.getInt("nrtReplicas", message.getInt("replicationFactor", collection.getInt("nrtReplicas", collection.getInt("replicationFactor", Integer.valueOf(1)))));
        int numPullReplicas = message.getInt("pullReplicas", collection.getInt("pullReplicas", Integer.valueOf(0)));
        int numTlogReplicas = message.getInt("tlogReplicas", collection.getInt("tlogReplicas", Integer.valueOf(0)));
        if (numNrtReplicas + numTlogReplicas <= 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "nrtReplicas + tlogReplicas must be greater than 0");
        }
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)message));
        this.ocmh.waitForNewShard(collectionName, sliceName);
        String async = message.getStr("async");
        ZkNodeProps addReplicasProps = new ZkNodeProps(new String[]{"collection", collectionName, "shard", sliceName, "nrtReplicas", String.valueOf(numNrtReplicas), "tlogReplicas", String.valueOf(numTlogReplicas), "pullReplicas", String.valueOf(numPullReplicas), "createNodeSet", message.getStr("createNodeSet"), "waitForFinalState", Boolean.toString(waitForFinalState)});
        HashMap<String, Object> propertyParams = new HashMap<String, Object>();
        this.ocmh.addPropertyParams(message, propertyParams);
        addReplicasProps = addReplicasProps.plus(propertyParams);
        if (async != null) {
            addReplicasProps.getProperties().put("async", async);
        }
        NamedList addResult = new NamedList();
        try {
            this.ocmh.addReplica(zkStateReader.getClusterState(), addReplicasProps, addResult, () -> {
                Object addResultFailure = addResult.get("failure");
                if (addResultFailure != null) {
                    SimpleOrderedMap failure = (SimpleOrderedMap)results.get("failure");
                    if (failure == null) {
                        failure = new SimpleOrderedMap();
                        results.add("failure", (Object)failure);
                    }
                    failure.addAll((NamedList)addResultFailure);
                } else {
                    SimpleOrderedMap success = (SimpleOrderedMap)results.get("success");
                    if (success == null) {
                        success = new SimpleOrderedMap();
                        results.add("success", (Object)success);
                    }
                    success.addAll((NamedList)addResult.get("success"));
                }
            });
        }
        catch (Assign.AssignmentException e) {
            ZkNodeProps deleteShard = new ZkNodeProps(new String[]{"collection", collectionName, "shard", sliceName, "async", async});
            new DeleteShardCmd(this.ocmh).call(clusterState, deleteShard, results);
            throw e;
        }
        log.info("Finished create command on all shards for collection: " + collectionName);
    }
}

