/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.refactoring.introduce.IntroduceHandler;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.EnumSet;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIntroduceDialog
extends DialogWrapper {
    private JPanel myContentPane;
    private JLabel myNameLabel;
    private ComboBox myNameComboBox;
    private JCheckBox myReplaceAll;
    private JRadioButton mySamePlace;
    private JRadioButton myConstructor;
    private JRadioButton mySetUp;
    private JPanel myPlaceSelector;
    private final Project myProject;
    private final int myOccurrencesCount;
    private final IntroduceValidator myValidator;
    private final PyExpression myExpression;
    private final String myHelpId;

    public PyIntroduceDialog(@NotNull Project project, @NotNull String caption, @NotNull IntroduceValidator validator, String helpId, IntroduceOperation operation) {
        if (project == null) {
            PyIntroduceDialog.$$$reportNull$$$0(0);
        }
        if (caption == null) {
            PyIntroduceDialog.$$$reportNull$$$0(1);
        }
        if (validator == null) {
            PyIntroduceDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.$$$setupUI$$$();
        this.myOccurrencesCount = operation.getOccurrences().size();
        this.myValidator = validator;
        this.myProject = project;
        this.myExpression = operation.getInitializer();
        this.myHelpId = helpId;
        this.setUpNameComboBox(operation.getSuggestedNames());
        this.setTitle(caption);
        this.init();
        this.setupDialog(operation.getAvailableInitPlaces());
        this.updateControls();
    }

    protected String getHelpId() {
        return this.myHelpId;
    }

    private void setUpNameComboBox(Collection<String> possibleNames) {
        StringComboboxEditor comboEditor = new StringComboboxEditor(this.myProject, (FileType)PythonFileType.INSTANCE, this.myNameComboBox);
        this.myNameComboBox.setEditor((ComboBoxEditor)comboEditor);
        this.myNameComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)comboEditor));
        this.myNameComboBox.setEditable(true);
        this.myNameComboBox.setMaximumRowCount(8);
        this.myNameComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PyIntroduceDialog.this.updateControls();
            }
        });
        ((EditorTextField)this.myNameComboBox.getEditor().getEditorComponent()).addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                PyIntroduceDialog.this.updateControls();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/refactoring/introduce/PyIntroduceDialog$2", "documentChanged"));
            }
        });
        this.myContentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)PyIntroduceDialog.this.myNameComboBox, true));
            }
        }, KeyStroke.getKeyStroke(78, 8), 2);
        for (String possibleName : possibleNames) {
            this.myNameComboBox.addItem((Object)possibleName);
        }
    }

    private void setupDialog(EnumSet<IntroduceHandler.InitPlace> availableInitPlaces) {
        this.myReplaceAll.setMnemonic(65);
        this.myNameLabel.setLabelFor((Component)this.myNameComboBox);
        this.myPlaceSelector.setVisible(availableInitPlaces.size() > 1);
        this.myConstructor.setVisible(availableInitPlaces.contains((Object)IntroduceHandler.InitPlace.CONSTRUCTOR));
        this.mySetUp.setVisible(availableInitPlaces.contains((Object)IntroduceHandler.InitPlace.SET_UP));
        this.mySamePlace.setSelected(true);
        if (this.myOccurrencesCount > 1) {
            this.myReplaceAll.setSelected(false);
            this.myReplaceAll.setEnabled(true);
            this.myReplaceAll.setText(this.myReplaceAll.getText() + " (" + this.myOccurrencesCount + " occurrences)");
        } else {
            this.myReplaceAll.setSelected(false);
            this.myReplaceAll.setEnabled(false);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameComboBox;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    @Nullable
    public String getName() {
        Object item = this.myNameComboBox.getEditor().getItem();
        if (item instanceof String && ((String)item).length() > 0) {
            return ((String)item).trim();
        }
        return null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public PyExpression getExpression() {
        return this.myExpression;
    }

    public boolean doReplaceAllOccurrences() {
        return this.myReplaceAll.isSelected();
    }

    private void updateControls() {
        boolean nameValid = this.myValidator.isNameValid(this.getName(), this.getProject());
        this.setOKActionEnabled(nameValid);
        this.setErrorText(!nameValid ? PyBundle.message("refactoring.introduce.name.error", new Object[0]) : null, (JComponent)this.myNameComboBox);
    }

    public IntroduceHandler.InitPlace getInitPlace() {
        if (this.myConstructor.isSelected()) {
            return IntroduceHandler.InitPlace.CONSTRUCTOR;
        }
        if (this.mySetUp.isSelected()) {
            return IntroduceHandler.InitPlace.SET_UP;
        }
        return IntroduceHandler.InitPlace.SAME_METHOD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "caption";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "validator";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/refactoring/introduce/PyIntroduceDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        JCheckBox jCheckBox;
        ComboBox comboBox;
        JLabel jLabel;
        JPanel jPanel2;
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myNameLabel = jLabel = new JLabel();
        jLabel.setText("<HTML><u>N</u>ame:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameComboBox = comboBox = new ComboBox();
        comboBox.setEditable(true);
        comboBox.setLightWeightPopupEnabled(true);
        jPanel3.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myReplaceAll = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/RefactoringBundle").getString("replace.all.occurences.checkbox"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPlaceSelector = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/RefactoringBundle").getString("initialize.in.border.title"), (int)0, (int)0, null, null));
        this.mySamePlace = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("current.method.radio"));
        jPanel.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myConstructor = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("class.constructors.radio"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySetUp = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/RefactoringBundle").getString("setup.method.radio"));
        jPanel.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

