/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParamHelper {
    private ParamHelper() {
    }

    public static void walkDownParamArray(PyParameter[] params, ParamWalker walker) {
        ParamHelper.walkDownParameters(ContainerUtil.map((Object[])params, PyCallableParameterImpl::psi), walker);
    }

    public static void walkDownParameters(@NotNull List<? extends PyCallableParameter> parameters2, @NotNull ParamWalker walker) {
        if (parameters2 == null) {
            ParamHelper.$$$reportNull$$$0(0);
        }
        if (walker == null) {
            ParamHelper.$$$reportNull$$$0(1);
        }
        int i = 0;
        for (PyCallableParameter pyCallableParameter : parameters2) {
            boolean last;
            PyParameter psi = pyCallableParameter.getParameter();
            boolean first = i == 0;
            boolean bl = last = i == parameters2.size() - 1;
            if (psi instanceof PyTupleParameter) {
                PyTupleParameter tupleParameter = (PyTupleParameter)psi;
                walker.enterTupleParameter(tupleParameter, first, last);
                ParamHelper.walkDownParamArray(tupleParameter.getContents(), walker);
                walker.leaveTupleParameter(tupleParameter, first, last);
            } else if (psi instanceof PyNamedParameter) {
                walker.visitNamedParameter((PyNamedParameter)psi, first, last);
            } else if (psi instanceof PySingleStarParameter) {
                walker.visitSingleStarParameter((PySingleStarParameter)psi, first, last);
            } else {
                walker.visitNonPsiParameter(pyCallableParameter, first, last);
            }
            ++i;
        }
    }

    @NotNull
    public static String getPresentableText(@NotNull PyParameter[] parameters2, boolean includeDefaultValue, @Nullable TypeEvalContext context) {
        if (parameters2 == null) {
            ParamHelper.$$$reportNull$$$0(2);
        }
        String string = ParamHelper.getPresentableText(ContainerUtil.map((Object[])parameters2, PyCallableParameterImpl::psi), includeDefaultValue, context);
        if (string == null) {
            ParamHelper.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getPresentableText(@NotNull List<? extends PyCallableParameter> parameters2, final boolean includeDefaultValue, final @Nullable TypeEvalContext context) {
        if (parameters2 == null) {
            ParamHelper.$$$reportNull$$$0(4);
        }
        final StringBuilder result = new StringBuilder();
        result.append("(");
        ParamHelper.walkDownParameters(parameters2, new ParamWalker(){

            @Override
            public void enterTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                result.append("(");
            }

            @Override
            public void leaveTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                result.append(")");
                if (!last) {
                    result.append(", ");
                }
            }

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                this.visitNonPsiParameter(PyCallableParameterImpl.psi(param), first, last);
            }

            @Override
            public void visitSingleStarParameter(PySingleStarParameter param, boolean first, boolean last) {
                result.append('*');
                if (!last) {
                    result.append(", ");
                }
            }

            @Override
            public void visitNonPsiParameter(@NotNull PyCallableParameter parameter, boolean first, boolean last) {
                if (parameter == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.append(parameter.getPresentableText(includeDefaultValue, context));
                if (!last) {
                    result.append(", ");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/python/psi/impl/ParamHelper$1", "visitNonPsiParameter"));
            }
        });
        result.append(")");
        String string = result.toString();
        if (string == null) {
            ParamHelper.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static String getDefaultValueText(@Nullable PyExpression defaultValue) {
        Pair<String, String> quotes;
        if (defaultValue instanceof PyStringLiteralExpression && (quotes = PyStringLiteralUtil.getQuotes(defaultValue.getText())) != null) {
            return (String)quotes.getFirst() + ((PyStringLiteralExpression)defaultValue).getStringValue() + (String)quotes.getSecond();
        }
        return defaultValue == null ? null : defaultValue.getText();
    }

    public static List<PyNamedParameter> collectNamedParameters(PyParameterList plist) {
        final ArrayList<PyNamedParameter> result = new ArrayList<PyNamedParameter>(10);
        ParamHelper.walkDownParamArray(plist.getParameters(), new ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                result.add(param);
            }
        });
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "walker";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/ParamHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/ParamHelper";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "walkDownParameters";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class ParamVisitor
    implements ParamWalker {
        @Override
        public void enterTupleParameter(PyTupleParameter param, boolean first, boolean last) {
        }

        @Override
        public void leaveTupleParameter(PyTupleParameter param, boolean first, boolean last) {
        }

        @Override
        public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
        }

        @Override
        public void visitSingleStarParameter(PySingleStarParameter param, boolean first, boolean last) {
        }

        @Override
        public void visitNonPsiParameter(@NotNull PyCallableParameter parameter, boolean first, boolean last) {
            if (parameter == null) {
                ParamVisitor.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/python/psi/impl/ParamHelper$ParamVisitor", "visitNonPsiParameter"));
        }
    }

    public static interface ParamWalker {
        public void enterTupleParameter(PyTupleParameter var1, boolean var2, boolean var3);

        public void leaveTupleParameter(PyTupleParameter var1, boolean var2, boolean var3);

        public void visitNamedParameter(PyNamedParameter var1, boolean var2, boolean var3);

        public void visitSingleStarParameter(PySingleStarParameter var1, boolean var2, boolean var3);

        public void visitNonPsiParameter(@NotNull PyCallableParameter var1, boolean var2, boolean var3);
    }
}

