/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageManagerUI {
    @NotNull
    private static final Logger LOG = Logger.getInstance(PyPackageManagerUI.class);
    @Nullable
    private final Listener myListener;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Sdk mySdk;

    public PyPackageManagerUI(@NotNull Project project, @NotNull Sdk sdk, @Nullable Listener listener2) {
        if (project == null) {
            PyPackageManagerUI.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            PyPackageManagerUI.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.mySdk = sdk;
        this.myListener = listener2;
    }

    public void installManagement() {
        ProgressManager.getInstance().run((Task)new InstallManagementTask(this.myProject, this.mySdk, this.myListener));
    }

    public void install(@Nullable List<PyRequirement> requirements, @NotNull List<String> extraArgs) {
        if (extraArgs == null) {
            PyPackageManagerUI.$$$reportNull$$$0(2);
        }
        ProgressManager.getInstance().run((Task)new InstallTask(this.myProject, this.mySdk, requirements, extraArgs, this.myListener));
    }

    public void uninstall(@NotNull List<PyPackage> packages) {
        if (packages == null) {
            PyPackageManagerUI.$$$reportNull$$$0(3);
        }
        if (this.checkDependents(packages)) {
            return;
        }
        ProgressManager.getInstance().run((Task)new UninstallTask(this.myProject, this.mySdk, this.myListener, packages));
    }

    private boolean checkDependents(@NotNull List<PyPackage> packages) {
        if (packages == null) {
            PyPackageManagerUI.$$$reportNull$$$0(4);
        }
        try {
            Map<String, Set<PyPackage>> dependentPackages = PyPackageManagerUI.collectDependents(packages, this.mySdk);
            int[] warning = new int[]{0};
            if (!dependentPackages.isEmpty()) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    if (dependentPackages.size() == 1) {
                        String message = "You are attempting to uninstall ";
                        ArrayList<String> dep = new ArrayList<String>();
                        int size = 1;
                        for (Map.Entry entry : dependentPackages.entrySet()) {
                            Set value = (Set)entry.getValue();
                            size = value.size();
                            dep.add((String)entry.getKey() + " package which is required for " + StringUtil.join((Iterable)value, (String)", "));
                        }
                        message = message + StringUtil.join(dep, (String)"\n");
                        message = message + (size == 1 ? " package" : " packages");
                        message = message + "\n\nDo you want to proceed?";
                        warning[0] = Messages.showYesNoDialog((String)message, (String)"Warning", (Icon)AllIcons.General.BalloonWarning);
                    } else {
                        String message = "You are attempting to uninstall packages which are required for another packages.\n\n";
                        ArrayList<String> dep = new ArrayList<String>();
                        for (Map.Entry entry : dependentPackages.entrySet()) {
                            dep.add((String)entry.getKey() + " -> " + StringUtil.join((Iterable)((Iterable)entry.getValue()), (String)", "));
                        }
                        message = message + StringUtil.join(dep, (String)"\n");
                        message = message + "\n\nDo you want to proceed?";
                        warning[0] = Messages.showYesNoDialog((String)message, (String)"Warning", (Icon)AllIcons.General.BalloonWarning);
                    }
                }, ModalityState.current());
            }
            if (warning[0] != 0) {
                return true;
            }
        }
        catch (ExecutionException e) {
            LOG.info("Error loading packages dependents: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static Map<String, Set<PyPackage>> collectDependents(@NotNull List<PyPackage> packages, Sdk sdk) throws ExecutionException {
        if (packages == null) {
            PyPackageManagerUI.$$$reportNull$$$0(5);
        }
        HashMap<String, Set<PyPackage>> dependentPackages = new HashMap<String, Set<PyPackage>>();
        for (PyPackage pkg : packages) {
            Set<PyPackage> dependents = PyPackageManager.getInstance(sdk).getDependents(pkg);
            if (dependents.isEmpty()) continue;
            for (PyPackage dependent : dependents) {
                if (packages.contains((Object)dependent)) continue;
                dependentPackages.put(pkg.getName(), dependents);
            }
        }
        return dependentPackages;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgs";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "uninstall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDependents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDependents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class UninstallTask
    extends PackagingTask {
        @NotNull
        private final List<PyPackage> myPackages;

        UninstallTask(@Nullable Project project, @NotNull Sdk sdk, @Nullable Listener listener2, @NotNull List<PyPackage> packages) {
            if (sdk == null) {
                UninstallTask.$$$reportNull$$$0(0);
            }
            if (packages == null) {
                UninstallTask.$$$reportNull$$$0(1);
            }
            super(project, sdk, "Uninstalling packages", listener2);
            this.myPackages = packages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected List<ExecutionException> runTask(@NotNull ProgressIndicator indicator) {
            List<ExecutionException> list;
            if (indicator == null) {
                UninstallTask.$$$reportNull$$$0(2);
            }
            PyPackageManager manager = PyPackageManagers.getInstance().forSdk(this.mySdk);
            indicator.setIndeterminate(true);
            try {
                manager.uninstall(this.myPackages);
                List<ExecutionException> list2 = Collections.emptyList();
                list = list2;
            }
            catch (ExecutionException e) {
                List<ExecutionException> list3 = Collections.singletonList(e);
                List<ExecutionException> list4 = list3;
                if (list4 == null) {
                    UninstallTask.$$$reportNull$$$0(4);
                }
                return list4;
            }
            finally {
                manager.refresh();
            }
            if (list == null) {
                UninstallTask.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        protected String getSuccessTitle() {
            if ("Packages uninstalled successfully" == null) {
                UninstallTask.$$$reportNull$$$0(5);
            }
            return "Packages uninstalled successfully";
        }

        @Override
        @NotNull
        protected String getSuccessDescription() {
            String packagesString = StringUtil.join(this.myPackages, pkg -> "'" + pkg.getName() + "'", (String)", ");
            String string = "Uninstalled packages: " + packagesString;
            if (string == null) {
                UninstallTask.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getFailureTitle() {
            if ("Uninstall packages failed" == null) {
                UninstallTask.$$$reportNull$$$0(7);
            }
            return "Uninstall packages failed";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packages";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessTitle";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessDescription";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFailureTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runTask";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InstallManagementTask
    extends InstallTask {
        InstallManagementTask(@Nullable Project project, @NotNull Sdk sdk, @Nullable Listener listener2) {
            if (sdk == null) {
                InstallManagementTask.$$$reportNull$$$0(0);
            }
            super(project, sdk, Collections.emptyList(), Collections.emptyList(), listener2);
        }

        @Override
        @NotNull
        protected List<ExecutionException> runTask(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                InstallManagementTask.$$$reportNull$$$0(1);
            }
            ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>();
            PyPackageManager manager = PyPackageManagers.getInstance().forSdk(this.mySdk);
            indicator.setText("Installing packaging tools...");
            indicator.setIndeterminate(true);
            try {
                manager.installManagement();
            }
            catch (ExecutionException e) {
                exceptions.add(e);
            }
            manager.refresh();
            ArrayList<ExecutionException> arrayList = exceptions;
            if (arrayList == null) {
                InstallManagementTask.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected String getSuccessDescription() {
            if ("Installed Python packaging tools" == null) {
                InstallManagementTask.$$$reportNull$$$0(3);
            }
            return "Installed Python packaging tools";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerUI$InstallManagementTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$InstallManagementTask";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runTask";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "runTask";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InstallTask
    extends PackagingTask {
        @Nullable
        private final List<PyRequirement> myRequirements;
        @NotNull
        private final List<String> myExtraArgs;

        InstallTask(@Nullable Project project, @NotNull Sdk sdk, @Nullable List<PyRequirement> requirements, @NotNull List<String> extraArgs, @Nullable Listener listener2) {
            if (sdk == null) {
                InstallTask.$$$reportNull$$$0(0);
            }
            if (extraArgs == null) {
                InstallTask.$$$reportNull$$$0(1);
            }
            super(project, sdk, "Installing packages", listener2);
            this.myRequirements = requirements;
            this.myExtraArgs = extraArgs;
        }

        @Override
        @NotNull
        protected List<ExecutionException> runTask(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                InstallTask.$$$reportNull$$$0(2);
            }
            ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>();
            PyPackageManager manager = PyPackageManagers.getInstance().forSdk(this.mySdk);
            if (this.myRequirements == null) {
                indicator.setText("Installing packages...");
                indicator.setIndeterminate(true);
                try {
                    manager.install(null, this.myExtraArgs);
                }
                catch (RunCanceledByUserException e) {
                    exceptions.add((ExecutionException)((Object)e));
                }
                catch (ExecutionException e) {
                    exceptions.add(e);
                }
            } else {
                int size = this.myRequirements.size();
                for (int i = 0; i < size; ++i) {
                    PyRequirement requirement = this.myRequirements.get(i);
                    indicator.setText(String.format("Installing package '%s'...", requirement.getPresentableText()));
                    if (i == 0) {
                        indicator.setIndeterminate(true);
                    } else {
                        indicator.setIndeterminate(false);
                        indicator.setFraction((double)i / (double)size);
                    }
                    try {
                        manager.install(Collections.singletonList(requirement), this.myExtraArgs);
                        continue;
                    }
                    catch (RunCanceledByUserException e) {
                        exceptions.add((ExecutionException)((Object)e));
                        break;
                    }
                    catch (ExecutionException e) {
                        exceptions.add(e);
                    }
                }
            }
            manager.refresh();
            ArrayList<ExecutionException> arrayList = exceptions;
            if (arrayList == null) {
                InstallTask.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected String getSuccessTitle() {
            if ("Packages installed successfully" == null) {
                InstallTask.$$$reportNull$$$0(4);
            }
            return "Packages installed successfully";
        }

        @Override
        @NotNull
        protected String getSuccessDescription() {
            String string = this.myRequirements != null ? "Installed packages: " + PyPackageUtil.requirementsToString(this.myRequirements) : "Installed all requirements";
            if (string == null) {
                InstallTask.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getFailureTitle() {
            if ("Install packages failed" == null) {
                InstallTask.$$$reportNull$$$0(6);
            }
            return "Install packages failed";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extraArgs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runTask";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessTitle";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessDescription";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFailureTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runTask";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class PackagingTask
    extends Task.Backgroundable {
        private static final String PACKAGING_GROUP_ID = "Packaging";
        @NotNull
        protected final Sdk mySdk;
        @Nullable
        protected final Listener myListener;

        PackagingTask(@Nullable Project project, @NotNull Sdk sdk, @NotNull String title, @Nullable Listener listener2) {
            if (sdk == null) {
                PackagingTask.$$$reportNull$$$0(0);
            }
            if (title == null) {
                PackagingTask.$$$reportNull$$$0(1);
            }
            super(project, title);
            this.mySdk = sdk;
            this.myListener = listener2;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                PackagingTask.$$$reportNull$$$0(2);
            }
            this.taskStarted(indicator);
            this.taskFinished(this.runTask(indicator));
        }

        @NotNull
        protected abstract List<ExecutionException> runTask(@NotNull ProgressIndicator var1);

        @NotNull
        protected abstract String getSuccessTitle();

        @NotNull
        protected abstract String getSuccessDescription();

        @NotNull
        protected abstract String getFailureTitle();

        protected void taskStarted(@NotNull ProgressIndicator indicator) {
            PackagingNotification[] notifications;
            if (indicator == null) {
                PackagingTask.$$$reportNull$$$0(3);
            }
            for (PackagingNotification notification2 : notifications = (PackagingNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(PackagingNotification.class, this.getProject())) {
                notification2.expire();
            }
            indicator.setText(this.getTitle() + "...");
            if (this.myListener != null) {
                ApplicationManager.getApplication().invokeLater(() -> this.myListener.started());
            }
        }

        protected void taskFinished(@NotNull List<ExecutionException> exceptions) {
            if (exceptions == null) {
                PackagingTask.$$$reportNull$$$0(4);
            }
            Ref notificationRef = new Ref(null);
            if (exceptions.isEmpty()) {
                notificationRef.set((Object)new PackagingNotification(PACKAGING_GROUP_ID, this.getSuccessTitle(), this.getSuccessDescription(), NotificationType.INFORMATION, null));
            } else {
                final PackageManagementService.ErrorDescription description = PyPackageManagementService.toErrorDescription(exceptions, this.mySdk);
                if (description != null) {
                    String firstLine = this.getTitle() + ": error occurred.";
                    NotificationListener listener2 = new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                            if (notification2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (event == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            assert (myProject != null);
                            String title = StringUtil.capitalizeWords((String)this.getFailureTitle(), (boolean)true);
                            PackagesNotificationPanel.showError((String)title, (PackageManagementService.ErrorDescription)description);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "notification";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                            }
                            objectArray[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask$1";
                            objectArray[2] = "hyperlinkUpdate";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    notificationRef.set((Object)new PackagingNotification(PACKAGING_GROUP_ID, this.getFailureTitle(), firstLine + " <a href=\"xxx\">Details...</a>", NotificationType.ERROR, listener2));
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                Notification notification2;
                if (exceptions == null) {
                    PackagingTask.$$$reportNull$$$0(5);
                }
                if (this.myListener != null) {
                    this.myListener.finished(exceptions);
                }
                if ((notification2 = (Notification)notificationRef.get()) != null) {
                    notification2.notify(this.myProject);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptions";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "taskStarted";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "taskFinished";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$taskFinished$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class PackagingNotification
        extends Notification {
            PackagingNotification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content2, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
                if (groupDisplayId == null) {
                    PackagingNotification.$$$reportNull$$$0(0);
                }
                if (title == null) {
                    PackagingNotification.$$$reportNull$$$0(1);
                }
                if (content2 == null) {
                    PackagingNotification.$$$reportNull$$$0(2);
                }
                if (type == null) {
                    PackagingNotification.$$$reportNull$$$0(3);
                }
                super(groupDisplayId, title, content2, type, listener2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "groupDisplayId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "title";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "content";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask$PackagingNotification";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static interface Listener {
        public void started();

        public void finished(List<ExecutionException> var1);
    }
}

