/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.quickfix.RemoveUnnecessaryBackslashQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTupleExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatementEffectFunctionCallQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.statement.effect", new Object[0]);
        if (string == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement expression;
        if (project == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(2);
        }
        if ((expression = descriptor2.getPsiElement()) != null && expression.isWritable() && expression instanceof PyReferenceExpression) {
            String expressionText = expression.getText();
            if ("print".equals(expressionText)) {
                StatementEffectFunctionCallQuickFix.replacePrint(expression);
            } else if ("exec".equals(expressionText)) {
                StatementEffectFunctionCallQuickFix.replaceExec(expression);
            } else {
                expression.replace((PsiElement)PyElementGenerator.getInstance(project).createCallExpression(LanguageLevel.forElement(expression), expressionText));
            }
        }
    }

    private static void replaceExec(@NotNull PsiElement expression) {
        if (expression == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(3);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(expression.getProject());
        String expressionText = expression.getText();
        StringBuilder stringBuilder = new StringBuilder(expressionText + " (");
        PsiElement next = StatementEffectFunctionCallQuickFix.getNextElement(expression);
        if (next == null) {
            stringBuilder.append(")");
            expression.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.forElement(expression), PyElement.class, stringBuilder.toString()));
            return;
        }
        String commentText = StatementEffectFunctionCallQuickFix.getComment(next);
        if (next instanceof PyExpressionStatement) {
            PyExpression expr = ((PyExpressionStatement)next).getExpression();
            if (expr instanceof PyBinaryExpression) {
                PsiElement operator = ((PyBinaryExpression)expr).getPsiOperator();
                if (operator instanceof LeafPsiElement && ((LeafPsiElement)operator).getElementType() == PyTokenTypes.IN_KEYWORD) {
                    StatementEffectFunctionCallQuickFix.addInArguments(stringBuilder, (PyBinaryExpression)expr);
                } else {
                    stringBuilder.append(next.getText());
                }
            } else if (expr instanceof PyTupleExpression) {
                PyExpression[] elements = ((PyTupleExpression)expr).getElements();
                if (elements.length > 1) {
                    if (elements[0] instanceof PyBinaryExpression) {
                        StatementEffectFunctionCallQuickFix.addInArguments(stringBuilder, (PyBinaryExpression)elements[0]);
                    }
                    stringBuilder.append(", ");
                    stringBuilder.append(elements[1].getText());
                }
            } else {
                stringBuilder.append(((PyExpressionStatement)next).getExpression().getText());
            }
        } else {
            stringBuilder.append(next.getText());
        }
        next.delete();
        stringBuilder.append(")");
        if (commentText != null) {
            stringBuilder.append(commentText);
        }
        expression.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.forElement(expression), PyStatement.class, stringBuilder.toString()));
    }

    private static String getComment(@Nullable PsiElement next) {
        PsiElement lastChild;
        String commentText = null;
        if (next != null && (lastChild = next.getLastChild()) instanceof PsiComment) {
            commentText = lastChild.getText();
        }
        return commentText;
    }

    private static void addInArguments(@NotNull StringBuilder stringBuilder, @NotNull PyBinaryExpression binaryExpression) {
        if (stringBuilder == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(4);
        }
        if (binaryExpression == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(5);
        }
        stringBuilder.append(binaryExpression.getLeftExpression().getText());
        stringBuilder.append(", ");
        PyExpression rightExpression = binaryExpression.getRightExpression();
        if (rightExpression != null) {
            stringBuilder.append(rightExpression.getText());
        }
    }

    private static void replacePrint(@NotNull PsiElement expression) {
        if (expression == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(6);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(expression.getProject());
        String expressionText = expression.getText();
        StringBuilder stringBuilder = new StringBuilder(expressionText + " (");
        PsiElement next = StatementEffectFunctionCallQuickFix.getNextElement(expression);
        String commentText = StatementEffectFunctionCallQuickFix.getComment(next);
        if (next != null) {
            String text2 = next instanceof PyExpressionStatement ? ((PyExpressionStatement)next).getExpression().getText() : next.getText();
            stringBuilder.append(text2);
            if (text2.endsWith(",")) {
                stringBuilder.append(" end=' '");
            }
            next.delete();
        }
        stringBuilder.append(")");
        if (commentText != null) {
            stringBuilder.append(commentText);
        }
        expression.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.forElement(expression), PyStatement.class, stringBuilder.toString()));
    }

    private static PsiElement getNextElement(@NotNull PsiElement expression) {
        if (expression == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(7);
        }
        PsiElement whiteSpace = expression.getContainingFile().findElementAt(expression.getTextOffset() + expression.getTextLength());
        PsiElement next = null;
        if (whiteSpace instanceof PsiWhiteSpace) {
            String whiteSpaceText = whiteSpace.getText();
            if (!whiteSpaceText.contains("\n")) {
                next = whiteSpace.getNextSibling();
                while (next instanceof PsiWhiteSpace && whiteSpaceText.contains("\\")) {
                    next = next.getNextSibling();
                }
            }
        } else {
            next = whiteSpace;
        }
        RemoveUnnecessaryBackslashQuickFix.removeBackSlash(next);
        if (whiteSpace != null) {
            whiteSpace.delete();
        }
        return next;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/StatementEffectFunctionCallQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/StatementEffectFunctionCallQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceExec";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addInArguments";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replacePrint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNextElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

