/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyAddPropertyForFieldQuickFix
implements LocalQuickFix {
    private String myName = PyBundle.message("QFIX.add.property", new Object[0]);

    public PyAddPropertyForFieldQuickFix(String name) {
        this.myName = name;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myName;
        if (string == null) {
            PyAddPropertyForFieldQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        if (project == null) {
            PyAddPropertyForFieldQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            PyAddPropertyForFieldQuickFix.$$$reportNull$$$0(2);
        }
        if ((element = descriptor2.getPsiElement()) instanceof PyReferenceExpression) {
            PyTargetExpression target;
            PyClass containingClass;
            PsiReference reference = element.getReference();
            if (reference == null) {
                return;
            }
            PsiElement resolved = reference.resolve();
            if (resolved instanceof PyTargetExpression && (containingClass = (target = (PyTargetExpression)resolved).getContainingClass()) != null) {
                PyExpression qualifier;
                String name = target.getName();
                if (name == null) {
                    return;
                }
                String propertyName = StringUtil.trimStart((String)name, (String)"_");
                Map<String, Property> properties = containingClass.getProperties();
                PyElementGenerator generator = PyElementGenerator.getInstance(project);
                if (!properties.containsKey(propertyName)) {
                    PyFunction property = generator.createProperty(LanguageLevel.forElement((PsiElement)containingClass), propertyName, name, AccessDirection.READ);
                    PyUtil.addElementToStatementList(property, containingClass.getStatementList(), false);
                }
                if ((qualifier = ((PyReferenceExpression)element).getQualifier()) != null) {
                    String newElementText = qualifier.getText() + "." + propertyName;
                    PyExpression newElement = generator.createExpressionFromText(LanguageLevel.forElement((PsiElement)containingClass), newElementText);
                    element.replace((PsiElement)newElement);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyAddPropertyForFieldQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyAddPropertyForFieldQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

