/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.editorActions.CodeBlockProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import org.jetbrains.annotations.Nullable;

public class PyCodeBlockProvider
implements CodeBlockProvider {
    @Nullable
    public TextRange getCodeBlockRange(Editor editor, PsiFile psiFile) {
        int caretOffset = editor.getCaretModel().getOffset();
        PsiElement element = psiFile.findElementAt(caretOffset);
        if (element == null) {
            return null;
        }
        while (caretOffset > 0 && element instanceof PsiWhiteSpace) {
            element = psiFile.findElementAt(--caretOffset);
        }
        PyStatement statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyStatement.class);
        if (statement != null) {
            PyStatementList statementList = (PyStatementList)PsiTreeUtil.findChildOfType((PsiElement)statement, PyStatementList.class);
            if (statementList == null && (statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)statement, PyStatementList.class)) != null) {
                statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)statementList, PyStatement.class);
            }
            if (statement != null) {
                PyStatement statementAbove;
                int statementEnd;
                int statementStart = statement.getTextRange().getStartOffset();
                for (statementEnd = statement.getTextRange().getEndOffset(); statementEnd > statementStart && psiFile.findElementAt(statementEnd) instanceof PsiWhiteSpace; --statementEnd) {
                }
                if ((caretOffset == statementStart || caretOffset == statementEnd) && (statementAbove = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PyStatement.class)) != null) {
                    if (caretOffset == statementStart) {
                        return new TextRange(statementAbove.getTextRange().getStartOffset(), statementEnd);
                    }
                    return new TextRange(statementStart, statementAbove.getTextRange().getEndOffset());
                }
                return statement.getTextRange();
            }
        }
        return null;
    }
}

