/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.run;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.PythonSdkType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.run.IpnbRunConfiguration;

public class IpnbCommandLineState
extends PythonCommandLineState {
    private final IpnbRunConfiguration myConfiguration;

    public IpnbCommandLineState(IpnbRunConfiguration configuration, ExecutionEnvironment environment) {
        super((AbstractPythonRunConfiguration)configuration, environment);
        this.myConfiguration = configuration;
    }

    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        String workingDirectory;
        String additionalOptions;
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup exeOptions = parametersList.getParamsGroup("Exe Options");
        assert (exeOptions != null);
        exeOptions.addParametersString(this.myConfiguration.getInterpreterOptions());
        ParamsGroup parameters = parametersList.getParamsGroup("Script");
        assert (parameters != null);
        String home = this.myConfiguration.getSdkHome();
        if (home == null) {
            return;
        }
        String ipython = IpnbCommandLineState.findJupyterRunner(home);
        if (ipython == null) {
            ipython = PythonHelper.LOAD_ENTRY_POINT.asParamString();
            parameters.addParameter(ipython);
            parameters.addParameter("notebook");
        } else {
            parameters.addParameter(ipython);
        }
        parameters.addParameter("--no-browser");
        if (this.myConfiguration.getHost() != null) {
            parameters.addParameter("--ip");
            parameters.addParameter(this.myConfiguration.getHost());
        }
        if (this.myConfiguration.getPort() != null) {
            parameters.addParameter("--port");
            parameters.addParameter(this.myConfiguration.getPort());
        }
        if (this.myConfiguration.getPort() != null) {
            parameters.addParameter("--port-retries=0");
        }
        if (!StringUtil.isEmptyOrSpaces((String)(additionalOptions = this.myConfiguration.getAdditionalOptions()))) {
            parameters.addParameters(StringUtil.split((String)additionalOptions, (String)" "));
        }
        commandLine.setWorkDirectory(!StringUtil.isEmptyOrSpaces((String)(workingDirectory = this.myConfiguration.getWorkingDirectory())) ? workingDirectory : this.myConfiguration.getProject().getBasePath());
    }

    public void customizeEnvironmentVars(Map<String, String> envs, boolean passParentEnvs) {
        String ipython;
        super.customizeEnvironmentVars(envs, passParentEnvs);
        String home = this.myConfiguration.getSdkHome();
        if (home != null && (ipython = IpnbCommandLineState.findJupyterRunner(home)) == null) {
            envs.put("PYCHARM_EP_DIST", "ipython");
            envs.put("PYCHARM_EP_NAME", "ipython");
        }
    }

    @Nullable
    public static Pair<String, String> getHostPortFromUrl(@NotNull String url) {
        if (url == null) {
            IpnbCommandLineState.$$$reportNull$$$0(0);
        }
        try {
            URI uri = new URI(url);
            int port = uri.getPort();
            return Pair.create((Object)uri.getHost(), (Object)(port == -1 ? null : String.valueOf(port)));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Nullable
    private static String findJupyterRunner(@NotNull String homePath) {
        if (homePath == null) {
            IpnbCommandLineState.$$$reportNull$$$0(1);
        }
        for (String name : Lists.newArrayList((Object[])new String[]{"jupyter-notebook", "jupyter"})) {
            String runnerPath = PythonSdkType.getExecutablePath((String)homePath, (String)name);
            if (runnerPath == null) continue;
            return runnerPath;
        }
        return null;
    }

    @NotNull
    protected ProcessHandler startProcess(PythonCommandLineState.PythonProcessStarter processStarter, CommandLinePatcher ... patchers) throws ExecutionException {
        ProcessHandler processHandler = super.startProcess(processStarter, patchers);
        this.addTokenListener(processHandler);
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            IpnbCommandLineState.$$$reportNull$$$0(2);
        }
        return processHandler2;
    }

    public void addTokenListener(ProcessHandler processHandler) {
        final Ref serverStarted = new Ref((Object)false);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((text = event.getText()).toLowerCase().contains("active kernels")) {
                    serverStarted.set((Object)true);
                }
                String token = "?token=";
                if (text.toLowerCase().contains("?token=") && StringUtil.isEmpty((String)IpnbCommandLineState.this.myConfiguration.getToken())) {
                    IpnbCommandLineState.this.myConfiguration.setToken(text.substring(text.indexOf("?token=") + "?token=".length()).trim());
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                IpnbCommandLineState.this.myConfiguration.setToken(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ipnb/run/IpnbCommandLineState$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/run/IpnbCommandLineState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/run/IpnbCommandLineState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHostPortFromUrl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findJupyterRunner";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

