/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inplace;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.inplace.ApplyChangeSignatureAction;
import com.intellij.refactoring.changeSignature.inplace.InplaceChangeSignature;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetectors;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ChangeSignaturePassFactory
implements TextEditorHighlightingPassFactory {
    public ChangeSignaturePassFactory(TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, true, -1);
    }

    @Override
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        LanguageChangeSignatureDetector detector;
        if (file2 == null) {
            ChangeSignaturePassFactory.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ChangeSignaturePassFactory.$$$reportNull$$$0(1);
        }
        if ((detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(file2.getLanguage())) == null) {
            return null;
        }
        return new ChangeSignaturePass(file2.getProject(), file2, editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/changeSignature/inplace/ChangeSignaturePassFactory";
        objectArray[2] = "createHighlightingPass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ChangeSignaturePass
    extends TextEditorHighlightingPass {
        @NonNls
        private static final String SIGNATURE_SHOULD_BE_POSSIBLY_CHANGED = "Signature change was detected";
        private final Project myProject;
        private final PsiFile myFile;
        private final Editor myEditor;

        ChangeSignaturePass(Project project, PsiFile file2, Editor editor) {
            super(project, editor.getDocument(), true);
            this.myProject = project;
            this.myFile = file2;
            this.myEditor = editor;
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                ChangeSignaturePass.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void doApplyInformationToEditor() {
            HighlightInfo info = null;
            InplaceChangeSignature currentRefactoring = InplaceChangeSignature.getCurrentRefactoring(this.myEditor);
            if (currentRefactoring != null) {
                ChangeInfo changeInfo = currentRefactoring.getStableChange();
                PsiElement element = changeInfo.getMethod();
                int offset = this.myEditor.getCaretModel().getOffset();
                if (element == null || !element.isValid()) {
                    return;
                }
                TextRange elementTextRange = element.getTextRange();
                if (elementTextRange == null || !elementTextRange.contains(offset)) {
                    return;
                }
                LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(changeInfo.getLanguage());
                TextRange range2 = detector.getHighlightingRange(changeInfo);
                TextAttributes attributes = new TextAttributes(null, null, this.myEditor.getColorsScheme().getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getEffectColor(), null, 0);
                HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(HighlightInfoType.INFORMATION).range(range2);
                builder2.textAttributes(attributes);
                builder2.descriptionAndTooltip(SIGNATURE_SHOULD_BE_POSSIBLY_CHANGED);
                info = builder2.createUnconditionally();
                QuickFixAction.registerQuickFixAction(info, (IntentionAction)new ApplyChangeSignatureAction(currentRefactoring.getInitialName()));
            }
            List<Object> infos = info != null ? Collections.singletonList(info) : Collections.emptyList();
            UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.myFile.getTextLength(), infos, this.getColorsScheme(), this.getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/refactoring/changeSignature/inplace/ChangeSignaturePassFactory$ChangeSignaturePass", "doCollectInformation"));
        }
    }
}

