/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.vcs.ex.BlocksRefresher;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.RangeChangeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u0017J&\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aJ.\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0010J\u001c\u0010%\u001a\u00020\u00122\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010'\u001a\u00020\u0010R0\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/openapi/vcs/ex/LineTracker;", "", "handler", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "originalChanges", "", "Lcom/intellij/diff/util/Range;", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;Ljava/util/List;)V", "<set-?>", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "blocks", "getBlocks", "()Ljava/util/List;", "setBlocks", "(Ljava/util/List;)V", "isDirty", "", "destroy", "", "partiallyApplyBlocks", "side", "Lcom/intellij/diff/util/Side;", "condition", "Lkotlin/Function1;", "rangeChanged", "startLine", "", "beforeLength", "afterLength", "refreshDirty", "text1", "", "text2", "lineOffsets1", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "lineOffsets2", "fastRefresh", "setRanges", "ranges", "dirty", "intellij.platform.diff.impl"})
final class LineTracker {
    @NotNull
    private List<DocumentTracker.Block> blocks;
    private boolean isDirty;
    private final DocumentTracker.Handler handler;

    @NotNull
    public final List<DocumentTracker.Block> getBlocks() {
        return this.blocks;
    }

    private final void setBlocks(List<DocumentTracker.Block> list2) {
        this.blocks = list2;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRanges(@NotNull List<? extends Range> ranges, boolean dirty) {
        Collection<DocumentTracker.Block> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(ranges, (String)"ranges");
        Iterable iterable = ranges;
        LineTracker lineTracker = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Range range2 = (Range)item$iv$iv;
            collection = destination$iv$iv;
            DocumentTracker.Block block = new DocumentTracker.Block((Range)it, dirty, false);
            collection.add(block);
        }
        collection = (List)destination$iv$iv;
        lineTracker.blocks = collection;
        this.isDirty = dirty;
        this.handler.afterBulkRangeChange();
    }

    public final void destroy() {
        this.blocks = CollectionsKt.emptyList();
    }

    public final void refreshDirty(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, boolean fastRefresh) {
        Intrinsics.checkParameterIsNotNull((Object)text1, (String)"text1");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text2");
        Intrinsics.checkParameterIsNotNull((Object)lineOffsets1, (String)"lineOffsets1");
        Intrinsics.checkParameterIsNotNull((Object)lineOffsets2, (String)"lineOffsets2");
        if (!this.isDirty) {
            return;
        }
        BlocksRefresher.Result result2 = new BlocksRefresher(this.handler, text1, text2, lineOffsets1, lineOffsets2).refresh(this.blocks, fastRefresh);
        this.blocks = result2.getNewBlocks();
        this.isDirty = false;
        this.handler.afterBulkRangeChange();
    }

    /*
     * WARNING - void declaration
     */
    public final void rangeChanged(@NotNull Side side, int startLine, int beforeLength, int afterLength) {
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        RangeChangeHandler.Result data = new RangeChangeHandler().run(this.blocks, side, startLine, beforeLength, afterLength);
        this.handler.onRangesChanged(data.getAffectedBlocks(), data.getNewAffectedBlock());
        int n = 0;
        int n2 = ((Collection)data.getAfterBlocks()).size();
        while (n < n2) {
            void i;
            this.handler.onRangeShifted(data.getAfterBlocks().get((int)i), data.getNewAfterBlocks().get((int)i));
            ++i;
        }
        this.blocks = data.getNewBlocks();
        this.isDirty = true;
        this.handler.afterRangeChange();
    }

    @NotNull
    public final List<DocumentTracker.Block> partiallyApplyBlocks(@NotNull Side side, @NotNull Function1<? super DocumentTracker.Block, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        List newBlocks = new ArrayList();
        List appliedBlocks = new ArrayList();
        int shift = 0;
        for (DocumentTracker.Block block : this.blocks) {
            if (((Boolean)condition.invoke((Object)block)).booleanValue()) {
                appliedBlocks.add(block);
                shift += DocumentTrackerKt.access$getRangeDelta(block.getRange(), side);
                continue;
            }
            DocumentTracker.Block newBlock = DocumentTrackerKt.access$shift(block, side, shift);
            this.handler.onRangeShifted(block, newBlock);
            newBlocks.add(newBlock);
        }
        this.blocks = newBlocks;
        this.handler.afterBulkRangeChange();
        return appliedBlocks;
    }

    /*
     * WARNING - void declaration
     */
    public LineTracker(@NotNull DocumentTracker.Handler handler2, @NotNull List<? extends Range> originalChanges) {
        Collection<DocumentTracker.Block> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)handler2, (String)"handler");
        Intrinsics.checkParameterIsNotNull(originalChanges, (String)"originalChanges");
        this.handler = handler2;
        Iterable iterable = originalChanges;
        LineTracker lineTracker = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Range range2 = (Range)item$iv$iv;
            collection = destination$iv$iv;
            DocumentTracker.Block block = new DocumentTracker.Block((Range)it, false, false);
            collection.add(block);
        }
        collection = (List)destination$iv$iv;
        lineTracker.blocks = collection;
    }
}

