/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.UnresolvedMergeCheckProvider;
import com.intellij.util.PairConsumer;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnresolvedMergeCheckFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(final @NotNull CheckinProjectPanel panel2, final @NotNull CommitContext commitContext) {
        if (panel2 == null) {
            UnresolvedMergeCheckFactory.$$$reportNull$$$0(0);
        }
        if (commitContext == null) {
            UnresolvedMergeCheckFactory.$$$reportNull$$$0(1);
        }
        CheckinHandler checkinHandler = new CheckinHandler(){

            public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
                for (UnresolvedMergeCheckProvider extension : (UnresolvedMergeCheckProvider[])UnresolvedMergeCheckProvider.EP_NAME.getExtensions()) {
                    CheckinHandler.ReturnResult result2 = extension.checkUnresolvedConflicts(panel2, commitContext, executor);
                    if (result2 == null) continue;
                    return result2;
                }
                return UnresolvedMergeCheckFactory.performDefaultCheck(panel2);
            }
        };
        if (checkinHandler == null) {
            UnresolvedMergeCheckFactory.$$$reportNull$$$0(2);
        }
        return checkinHandler;
    }

    @NotNull
    private static CheckinHandler.ReturnResult performDefaultCheck(@NotNull CheckinProjectPanel panel2) {
        int answer;
        if (panel2 == null) {
            UnresolvedMergeCheckFactory.$$$reportNull$$$0(3);
        }
        if (UnresolvedMergeCheckFactory.containsUnresolvedConflicts(panel2) && (answer = Messages.showYesNoDialog((Component)panel2.getComponent(), (String)"Are you sure you want to commit changes with unresolved conflicts?", (String)"Unresolved Conflicts", (Icon)Messages.getWarningIcon())) != 0) {
            CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.CANCEL;
            if (returnResult == null) {
                UnresolvedMergeCheckFactory.$$$reportNull$$$0(4);
            }
            return returnResult;
        }
        CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.COMMIT;
        if (returnResult == null) {
            UnresolvedMergeCheckFactory.$$$reportNull$$$0(5);
        }
        return returnResult;
    }

    private static boolean containsUnresolvedConflicts(@NotNull CheckinProjectPanel panel2) {
        if (panel2 == null) {
            UnresolvedMergeCheckFactory.$$$reportNull$$$0(6);
        }
        for (Change change : panel2.getSelectedChanges()) {
            FileStatus status = change.getFileStatus();
            if (!status.equals(FileStatus.MERGE) && !status.equals(FileStatus.MERGED_WITH_BOTH_CONFLICTS) && !status.equals(FileStatus.MERGED_WITH_CONFLICTS) && !status.equals(FileStatus.MERGED_WITH_PROPERTY_CONFLICTS)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/checkin/UnresolvedMergeCheckFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/checkin/UnresolvedMergeCheckFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "performDefaultCheck";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performDefaultCheck";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsUnresolvedConflicts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

