/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThreeState;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.DonePromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;

public class InternalPromiseUtil {
    public static final RuntimeException OBSOLETE_ERROR = new MessageError("Obsolete", false);
    public static final NotNullLazyValue<Promise<Object>> CANCELLED_PROMISE = new NotNullLazyValue<Promise<Object>>(){

        @NotNull
        protected Promise<Object> compute() {
            DonePromise<Object> donePromise = new DonePromise<Object>(PromiseValue.createRejected(OBSOLETE_ERROR));
            if (donePromise == null) {
                1.$$$reportNull$$$0(0);
            }
            return donePromise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/InternalPromiseUtil$1", "compute"));
        }
    };
    public static final NotNullLazyValue<Promise<Object>> FULFILLED_PROMISE = new NotNullLazyValue<Promise<Object>>(){

        @NotNull
        protected Promise<Object> compute() {
            DonePromise<Object> donePromise = new DonePromise<Object>(PromiseValue.createFulfilled(null));
            if (donePromise == null) {
                2.$$$reportNull$$$0(0);
            }
            return donePromise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/InternalPromiseUtil$2", "compute"));
        }
    };

    public static boolean isHandlerObsolete(@NotNull Object handler) {
        if (handler == null) {
            InternalPromiseUtil.$$$reportNull$$$0(0);
        }
        return handler instanceof Obsolescent && ((Obsolescent)handler).isObsolete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/concurrency/InternalPromiseUtil", "isHandlerObsolete"));
    }

    public static abstract class BasePromise<T>
    implements Promise<T>,
    Future<T>,
    PromiseImpl<T>,
    CancellablePromise<T> {
        @Nullable
        protected abstract PromiseValue<T> getValue();

        @Override
        public final boolean isDone() {
            return this.getValue() != null;
        }

        @Override
        @NotNull
        public final Promise.State getState() {
            PromiseValue<T> value = this.getValue();
            Promise.State state = value == null ? Promise.State.PENDING : value.getState();
            if (state == null) {
                BasePromise.$$$reportNull$$$0(0);
            }
            return state;
        }

        @Override
        public final boolean isCancelled() {
            PromiseValue<T> value = this.getValue();
            return value != null && value.isCancelled();
        }

        @Override
        public final T get() throws ExecutionException {
            try {
                return this.blockingGet(-1);
            }
            catch (TimeoutException e) {
                throw new ExecutionException(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T get(long timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, TimeoutException {
            void unit;
            if (timeUnit == null) {
                BasePromise.$$$reportNull$$$0(1);
            }
            return this.blockingGet((int)timeout, (TimeUnit)unit);
        }

        @Override
        public final boolean cancel(boolean mayInterruptIfRunning) {
            if (this.getState() == Promise.State.PENDING) {
                this.cancel();
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/concurrency/InternalPromiseUtil$BasePromise";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/concurrency/InternalPromiseUtil$BasePromise";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PromiseValue<T> {
        public final T result;
        public final Throwable error;

        public static <T> PromiseValue<T> createFulfilled(@Nullable T result2) {
            return new PromiseValue<T>(result2, null);
        }

        public static <T> PromiseValue<T> createRejected(@Nullable Throwable error) {
            return new PromiseValue<Object>(null, error);
        }

        private PromiseValue(@Nullable T result2, @Nullable Throwable error) {
            this.result = result2;
            this.error = error;
        }

        @NotNull
        public Promise.State getState() {
            Promise.State state = this.error == null ? Promise.State.SUCCEEDED : Promise.State.REJECTED;
            if (state == null) {
                PromiseValue.$$$reportNull$$$0(0);
            }
            return state;
        }

        public boolean isCancelled() {
            return this.error == OBSOLETE_ERROR;
        }

        @Nullable
        public T getResultOrThrowError() throws ExecutionException, TimeoutException {
            if (this.error == null) {
                return this.result;
            }
            if (this.error == OBSOLETE_ERROR) {
                return null;
            }
            ExceptionUtil.rethrowUnchecked((Throwable)this.error);
            if (this.error instanceof ExecutionException) {
                throw (ExecutionException)this.error;
            }
            if (this.error instanceof TimeoutException) {
                throw (TimeoutException)this.error;
            }
            throw new ExecutionException(this.error);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PromiseValue value = (PromiseValue)o;
            if (this.result != null ? !this.result.equals(value.result) : value.result != null) {
                return false;
            }
            return !(this.error != null ? !this.error.equals(value.error) : value.error != null);
        }

        public int hashCode() {
            int result1 = this.result != null ? this.result.hashCode() : 0;
            result1 = 31 * result1 + (this.error != null ? this.error.hashCode() : 0);
            return result1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/InternalPromiseUtil$PromiseValue", "getState"));
        }
    }

    public static class MessageError
    extends RuntimeException {
        public final ThreeState log;

        public MessageError(@NotNull String message, boolean isLog) {
            if (message == null) {
                MessageError.$$$reportNull$$$0(0);
            }
            super(message);
            this.log = ThreeState.fromBoolean((boolean)isLog);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/concurrency/InternalPromiseUtil$MessageError", "<init>"));
        }
    }

    public static interface CompletablePromise<T>
    extends Promise<T> {
        public void setResult(@Nullable T var1);

        public boolean setError(@NotNull Throwable var1);
    }

    public static interface PromiseImpl<T> {
        public void _setValue(@NotNull PromiseValue<T> var1);
    }
}

