/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.RealLookupElementPresentation;
import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.EmptyResourceBundle;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertiesPsiCompletionUtil;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesCompletionContributor
extends CompletionContributor {
    public static final LookupElementRenderer<LookupElement> LOOKUP_ELEMENT_RENDERER = new LookupElementRenderer<LookupElement>(){

        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
            IProperty defaultProperty;
            PropertiesFile defaultPropertiesFile;
            boolean hasBundle;
            IProperty property = (IProperty)element.getObject();
            presentation.setIcon(PlatformIcons.PROPERTY_ICON);
            String key = StringUtil.notNullize((String)property.getUnescapedKey());
            presentation.setItemText(key);
            PropertiesFile propertiesFile = property.getPropertiesFile();
            ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
            String value = property.getValue();
            boolean bl = hasBundle = resourceBundle != EmptyResourceBundle.getInstance();
            if (hasBundle && (defaultPropertiesFile = resourceBundle.getDefaultPropertiesFile()).getContainingFile() != propertiesFile.getContainingFile() && (defaultProperty = defaultPropertiesFile.findPropertyByKey(key)) != null) {
                value = defaultProperty.getValue();
            }
            if (hasBundle) {
                presentation.setTypeText(resourceBundle.getBaseName(), AllIcons.FileTypes.Properties);
            }
            if (presentation instanceof RealLookupElementPresentation && value != null) {
                value = "=" + value;
                int limit = 1000;
                if (value.length() > limit || !((RealLookupElementPresentation)presentation).hasEnoughSpaceFor(value, false)) {
                    if (value.length() > limit) {
                        value = value.substring(0, limit);
                    }
                    while (value.length() > 0 && !((RealLookupElementPresentation)presentation).hasEnoughSpaceFor(value + "...", false)) {
                        value = value.substring(0, value.length() - 1);
                    }
                    value = value + "...";
                }
            }
            TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_VALUE);
            presentation.setTailText(value, attrs.getForegroundColor());
        }
    };

    public PropertiesCompletionContributor() {
        this.extend(null, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                PropertiesCompletionContributor.doAdd(parameters, result);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/properties/references/PropertiesCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void doAdd(CompletionParameters parameters, CompletionResultSet result) {
        TextRange range;
        PsiElement element;
        int startOffset;
        int offsetInElement;
        PsiElement position = parameters.getPosition();
        Object[] references = (PsiReference[])ArrayUtil.mergeArrays((Object[])position.getReferences(), (Object[])position.getParent().getReferences());
        PropertyReference propertyReference = (PropertyReference)ContainerUtil.findInstance((Object[])references, PropertyReference.class);
        if (propertyReference != null && !PropertiesCompletionContributor.hasMoreImportantReference((PsiReference[])references, propertyReference) && (offsetInElement = (startOffset = parameters.getOffset()) - (element = propertyReference.getElement()).getTextRange().getStartOffset()) >= (range = propertyReference.getRangeInElement()).getStartOffset()) {
            String prefix = element.getText().substring(range.getStartOffset(), offsetInElement);
            LookupElement[] variants = PropertiesCompletionContributor.getVariants(propertyReference);
            result.withPrefixMatcher(prefix).addAllElements(Arrays.asList(variants));
        }
    }

    public static boolean hasMoreImportantReference(@NotNull PsiReference[] references, @NotNull PropertyReference propertyReference) {
        if (references == null) {
            PropertiesCompletionContributor.$$$reportNull$$$0(0);
        }
        if (propertyReference == null) {
            PropertiesCompletionContributor.$$$reportNull$$$0(1);
        }
        return propertyReference.isSoft() && ContainerUtil.or((Object[])references, reference -> !reference.isSoft());
    }

    @NotNull
    public static LookupElement[] getVariants(PropertyReferenceBase propertyReference) {
        Set<Object> variants = PropertiesPsiCompletionUtil.getPropertiesKeys(propertyReference);
        LookupElement[] lookupElementArray = PropertiesCompletionContributor.getVariants(variants);
        if (lookupElementArray == null) {
            PropertiesCompletionContributor.$$$reportNull$$$0(2);
        }
        return lookupElementArray;
    }

    public static LookupElement[] getVariants(Set<Object> variants) {
        return (LookupElement[])variants.stream().map(o -> o instanceof String ? LookupElementBuilder.create((String)((String)o)).withIcon(PlatformIcons.PROPERTY_ICON) : PropertiesCompletionContributor.createVariant((IProperty)o)).filter(Objects::nonNull).toArray(LookupElement[]::new);
    }

    @Nullable
    public static LookupElement createVariant(IProperty property) {
        String key = property.getKey();
        return key == null ? null : LookupElementBuilder.create((Object)property, (String)key).withRenderer(LOOKUP_ELEMENT_RENDERER);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            PropertiesCompletionContributor.$$$reportNull$$$0(3);
        }
        if (context.getFile() instanceof PropertiesFile) {
            context.setDummyIdentifier(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/references/PropertiesCompletionContributor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/references/PropertiesCompletionContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasMoreImportantReference";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

