/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.List;
import java.util.Set;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.common.DefaultTimephasedWorkContainer;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.RtfHelper;
import net.sf.mpxj.common.SplitTaskFactory;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.MPPTimephasedBaselineCostNormaliser;
import net.sf.mpxj.mpp.MPPTimephasedBaselineWorkNormaliser;
import net.sf.mpxj.mpp.MPPTimephasedWorkNormaliser;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MppBitFlag;
import net.sf.mpxj.mpp.TimephasedDataFactory;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;

public class ResourceAssignmentFactory {
    private static final Integer MPP9_CREATION_DATA = 138;
    private static final MppBitFlag[] ASSIGNMENT_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(AssignmentField.FLAG1, 28, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG2, 28, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG3, 28, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG4, 28, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG5, 28, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG6, 28, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG7, 28, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG8, 28, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG9, 28, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG10, 28, 65536, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG11, 28, 131072, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG12, 28, 262144, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG13, 28, 524288, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG14, 28, 0x100000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG15, 28, 0x200000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG16, 28, 0x400000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG17, 28, 0x800000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG18, 28, 0x1000000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG19, 28, 0x2000000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG20, 28, 0x4000000, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] MPP14_ASSIGNMENT_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(AssignmentField.FLAG10, 28, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG1, 28, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG2, 28, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG3, 28, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG4, 28, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG5, 28, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG6, 28, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG7, 28, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG8, 28, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG9, 28, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG11, 28, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG12, 28, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG13, 28, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG14, 28, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG15, 28, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG16, 28, 65536, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG17, 28, 131072, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG18, 28, 262144, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG19, 28, 524288, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG20, 28, 0x100000, Boolean.FALSE, Boolean.TRUE)};
    private static final Duration DEFAULT_NORMALIZER_WORK_PER_DAY = Duration.getInstance(480, TimeUnit.MINUTES);

    public void process(ProjectFile projectFile, FieldMap fieldMap, FieldMap fieldMap2, boolean bl, boolean bl2, VarMeta varMeta, Var2Data var2Data, FixedMeta fixedMeta, FixedData fixedData, FixedData fixedData2, int n) {
        Set<Integer> set = varMeta.getUniqueIdentifierSet();
        TimephasedDataFactory timephasedDataFactory = new TimephasedDataFactory();
        SplitTaskFactory splitTaskFactory = new SplitTaskFactory();
        MPPTimephasedWorkNormaliser mPPTimephasedWorkNormaliser = new MPPTimephasedWorkNormaliser();
        MPPTimephasedBaselineWorkNormaliser mPPTimephasedBaselineWorkNormaliser = new MPPTimephasedBaselineWorkNormaliser();
        MPPTimephasedBaselineCostNormaliser mPPTimephasedBaselineCostNormaliser = new MPPTimephasedBaselineCostNormaliser();
        ProjectCalendar projectCalendar = projectFile.getBaselineCalendar();
        MppBitFlag[] mppBitFlagArray = NumberHelper.getInt(projectFile.getProjectProperties().getMppFileType()) == 14 ? MPP14_ASSIGNMENT_META_DATA_BIT_FLAGS : ASSIGNMENT_META_DATA_BIT_FLAGS;
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2;
            Integer n3;
            int n4;
            byte[] byArray;
            byte[] byArray2 = fixedMeta.getByteArrayValue(i);
            if (byArray2[0] != 0 || (byArray = fixedData.getByteArrayValue(fixedData.getIndexFromOffset(n4 = MPPUtility.getInt(byArray2, 4)))) == null) continue;
            if (byArray.length < fieldMap.getMaxFixedDataSize(0)) {
                byte[] byArray3 = new byte[fieldMap.getMaxFixedDataSize(0)];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                byArray = byArray3;
            }
            if (!set.contains(n3 = Integer.valueOf(n2 = MPPUtility.getInt(byArray, fieldMap.getFixedDataOffset(AssignmentField.UNIQUE_ID))))) continue;
            byte[] byArray4 = null;
            if (fixedData2 != null) {
                byArray4 = fixedData2.getByteArrayValue(i);
            }
            ResourceAssignment resourceAssignment = new ResourceAssignment(projectFile, null);
            resourceAssignment.disableEvents();
            fieldMap.populateContainer(AssignmentField.class, resourceAssignment, n3, new byte[][]{byArray, byArray4}, var2Data);
            if (fieldMap2 != null) {
                fieldMap2.populateContainer(AssignmentField.class, resourceAssignment, n3, null, var2Data);
            }
            resourceAssignment.enableEvents();
            Object object2 = mppBitFlagArray;
            int n5 = ((MppBitFlag[])object2).length;
            for (int j = 0; j < n5; ++j) {
                object = object2[j];
                ((MppBitFlag)object).setValue(resourceAssignment, byArray2);
            }
            resourceAssignment.setConfirmed((byArray2[8] & 0x80) != 0);
            resourceAssignment.setResponsePending((byArray2[9] & 1) != 0);
            resourceAssignment.setTeamStatusPending((byArray2[10] & 2) != 0);
            this.processHyperlinkData(resourceAssignment, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.HYPERLINK_DATA)));
            if (NumberHelper.getInt(projectFile.getProjectProperties().getMppFileType()) == 9 && resourceAssignment.getCreateDate() == null && (object2 = (Object)var2Data.getByteArray(n3, MPP9_CREATION_DATA)) != null && ((MppBitFlag[])object2).length >= 28) {
                resourceAssignment.setCreateDate(MPPUtility.getTimestamp((byte[])object2, 24));
            }
            object2 = resourceAssignment.getNotes();
            if (!bl2) {
                object2 = RtfHelper.strip((String)object2);
            }
            resourceAssignment.setNotes((String)object2);
            Task task = projectFile.getTaskByUniqueID(resourceAssignment.getTaskUniqueID());
            if (task == null) continue;
            task.addResourceAssignment(resourceAssignment);
            Resource resource = projectFile.getResourceByUniqueID(resourceAssignment.getResourceUniqueID());
            object = null;
            if (resource != null) {
                object = resource.getResourceCalendar();
            }
            if (object == null || task.getIgnoreResourceCalendar()) {
                object = task.getEffectiveCalendar();
            }
            resourceAssignment.setTimephasedBaselineWork(0, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(1, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE1_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(2, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE2_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(3, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE3_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(4, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE4_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(5, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE5_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(6, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE6_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(7, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE7_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(8, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE8_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(9, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE9_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(10, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE10_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineCost(0, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(1, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE1_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(2, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE2_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(3, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE3_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(4, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE4_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(5, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE5_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(6, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE6_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(7, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE7_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(8, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE8_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(9, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE9_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(10, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE10_COST)), !bl));
            byte[] byArray5 = var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_ACTUAL_WORK));
            byte[] byArray6 = var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_WORK));
            byte[] byArray7 = var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_ACTUAL_OVERTIME_WORK));
            List<TimephasedWork> list = timephasedDataFactory.getCompleteWork((ProjectCalendar)object, resourceAssignment, byArray5);
            List<TimephasedWork> list2 = timephasedDataFactory.getPlannedWork((ProjectCalendar)object, resourceAssignment.getStart(), resourceAssignment.getUnits().doubleValue(), byArray6, list);
            List<TimephasedWork> list3 = timephasedDataFactory.getCompleteWork((ProjectCalendar)object, resourceAssignment, byArray7);
            resourceAssignment.setActualStart(list.isEmpty() ? null : resourceAssignment.getStart());
            resourceAssignment.setActualFinish(resourceAssignment.getRemainingWork().getDuration() == 0.0 && resource != null ? resourceAssignment.getFinish() : null);
            if (task.getSplits() != null && task.getSplits().isEmpty()) {
                splitTaskFactory.processSplitData(task, list, list2);
            }
            this.createTimephasedData(projectFile, resourceAssignment, list2, list);
            resourceAssignment.setTimephasedWork(new DefaultTimephasedWorkContainer((ProjectCalendar)object, mPPTimephasedWorkNormaliser, list2, !bl));
            resourceAssignment.setTimephasedActualWork(new DefaultTimephasedWorkContainer((ProjectCalendar)object, mPPTimephasedWorkNormaliser, list, !bl));
            resourceAssignment.setTimephasedActualOvertimeWork(new DefaultTimephasedWorkContainer((ProjectCalendar)object, mPPTimephasedWorkNormaliser, list3, !bl));
            if (byArray6 != null) {
                if (timephasedDataFactory.getWorkModified(list2)) {
                    resourceAssignment.setWorkContour(WorkContour.CONTOURED);
                } else if (byArray6.length >= 30) {
                    resourceAssignment.setWorkContour(WorkContour.getInstance(MPPUtility.getShort(byArray6, 28)));
                } else {
                    resourceAssignment.setWorkContour(WorkContour.FLAT);
                }
            }
            projectFile.getEventManager().fireAssignmentReadEvent(resourceAssignment);
        }
    }

    private void processHyperlinkData(ResourceAssignment resourceAssignment, byte[] byArray) {
        if (byArray != null) {
            int n = 12;
            String string = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string.length() + 1) * 2;
            String string2 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string2.length() + 1) * 2;
            String string3 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string3.length() + 1) * 2;
            String string4 = MPPUtility.getUnicodeString(byArray, n += 12);
            resourceAssignment.setHyperlink(string);
            resourceAssignment.setHyperlinkAddress(string2);
            resourceAssignment.setHyperlinkSubAddress(string3);
            resourceAssignment.setHyperlinkScreenTip(string4);
        }
    }

    private void createTimephasedData(ProjectFile projectFile, ResourceAssignment resourceAssignment, List<TimephasedWork> list, List<TimephasedWork> list2) {
        if (list.isEmpty() && list2.isEmpty()) {
            Duration duration;
            Duration duration2 = resourceAssignment.getWork().convertUnits(TimeUnit.MINUTES, projectFile.getProjectProperties());
            if (resourceAssignment.getResource() == null || resourceAssignment.getResource().getType() == ResourceType.WORK) {
                duration = duration2.getDuration() == 0.0 ? duration2 : DEFAULT_NORMALIZER_WORK_PER_DAY;
                int n = NumberHelper.getInt(resourceAssignment.getUnits());
                if (n != 100) {
                    duration = Duration.getInstance(duration.getDuration() * (double)n / 100.0, duration.getUnits());
                }
            } else if (resourceAssignment.getVariableRateUnits() == null) {
                Duration duration3 = resourceAssignment.getCalendar().getWork(resourceAssignment.getStart(), resourceAssignment.getFinish(), TimeUnit.DAYS);
                double d = NumberHelper.getDouble(resourceAssignment.getUnits());
                double d2 = d * 60.0 / (duration3.getDuration() * 100.0);
                duration = Duration.getInstance(d2, TimeUnit.MINUTES);
            } else {
                double d = NumberHelper.getDouble(resourceAssignment.getUnits());
                duration = DEFAULT_NORMALIZER_WORK_PER_DAY;
                Duration duration4 = duration.convertUnits(TimeUnit.HOURS, projectFile.getProjectProperties());
                double d3 = d * duration4.getDuration() / 100.0;
                double d4 = d3 * 60.0;
                duration = Duration.getInstance(d4, TimeUnit.MINUTES);
            }
            Duration duration5 = resourceAssignment.getOvertimeWork();
            if (duration5 != null && duration5.getDuration() != 0.0) {
                Duration duration6 = duration5.convertUnits(TimeUnit.MINUTES, projectFile.getProjectProperties());
                duration2 = Duration.getInstance(duration2.getDuration() - duration6.getDuration(), TimeUnit.MINUTES);
            }
            TimephasedWork timephasedWork = new TimephasedWork();
            timephasedWork.setStart(resourceAssignment.getStart());
            timephasedWork.setAmountPerDay(duration);
            timephasedWork.setModified(false);
            timephasedWork.setFinish(resourceAssignment.getFinish());
            timephasedWork.setTotalAmount(duration2);
            list.add(timephasedWork);
        }
    }
}

