/**
 * The CSSStyleSheet interface is a concrete interface used to represent a CSS style sheet i.e., a style sheet whose content type is "text/css".
 */
var CSSStyleSheet = {
}
/**
 * Used to delete a rule from the style sheet.
 * @syntax cSSStyleSheet.deleteRule(index)
 * @param {Number} index The index within the style sheet's rule list of the rule to remove.
 * @returns {undefined} 
 */
CSSStyleSheet.prototype.deleteRule = function(index) {};

/**
 * If this style sheet comes from an @import rule, the ownerRule attribute will contain the CSSImportRule. In that case, the ownerNode attribute in the StyleSheet interface will be null. If the style sheet comes from an element or a processing instruction, the ownerRule attribute will be null and the ownerNode attribute will contain the Node.
 * @syntax cSSStyleSheet.ownerRule
 * @returns {CSSRule} 
 */
CSSStyleSheet.prototype.ownerRule = new CSSRule();

/**
 * The list of all CSS rules contained within the style sheet. This includes both rule sets and at-rules.
 * @syntax cSSStyleSheet.cssRules
 * @returns {CSSRuleList} 
 */
CSSStyleSheet.prototype.cssRules = new CSSRuleList();

/**
 * Used to insert a new rule into the style sheet. The new rule now becomes part of the cascade.
 * @syntax cSSStyleSheet.insertRule(rule, index)
 * @param {String} rule The parsable text representing the rule. For rule sets this contains both the selector and the style declaration. For at-rules, this specifies both the at-identifier and the rule content.
 * @param {Number} index The index within the style sheet's rule list of the rule before which to insert the specified rule. If the specified index is equal to the length of the style sheet's rule collection, the rule will be added to the end of the style sheet.
 * @returns {Number} The index within the style sheet's rule collection of the newly inserted rule.
 */
CSSStyleSheet.prototype.insertRule = function(rule,  index) {};

/**
 * Represents the CSSStyleSheet prototype object.
 * @syntax CSSStyleSheet.prototype
 * @static
 */
CSSStyleSheet.prototype;

