/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt.ui.options;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javascript.grunt.options.GruntOptions;
import org.netbeans.modules.javascript.grunt.options.GruntOptionsValidator;
import org.netbeans.modules.javascript.grunt.ui.options.GruntOptionsPanel;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class GruntOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    public static final String OPTIONS_CATEGORY = "Html5";
    public static final String OPTIONS_SUBCATEGORY = "Grunt";
    public static final String OPTIONS_PATH = "Html5/Grunt";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private GruntOptionsPanel gruntOptionsPanel;
    private volatile boolean changed = false;
    private boolean firstOpening = true;

    public void update() {
        assert (EventQueue.isDispatchThread());
        if (this.firstOpening || !this.isChanged()) {
            this.firstOpening = false;
            this.getPanel().setGrunt(this.getGruntOptions().getGrunt());
        }
        this.changed = false;
    }

    public void applyChanges() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GruntOptionsPanelController.this.getGruntOptions().setGrunt(GruntOptionsPanelController.this.getPanel().getGrunt());
                GruntOptionsPanelController.this.changed = false;
            }
        });
    }

    public void cancel() {
        if (this.isChanged()) {
            this.getPanel().setGrunt(this.getGruntOptions().getGrunt());
        }
    }

    public boolean isValid() {
        assert (EventQueue.isDispatchThread());
        GruntOptionsPanel panel = this.getPanel();
        ValidationResult result = new GruntOptionsValidator().validateGrunt(panel.getGrunt()).getResult();
        if (result.hasErrors()) {
            panel.setError(result.getFirstErrorMessage());
            return false;
        }
        if (result.hasWarnings()) {
            panel.setWarning(result.getFirstWarningMessage());
            return true;
        }
        panel.setError(" ");
        return true;
    }

    public boolean isChanged() {
        String saved = this.getGruntOptions().getGrunt();
        String current = this.getPanel().getGrunt().trim();
        return saved == null ? !current.isEmpty() : !saved.equals(current);
    }

    public JComponent getComponent(Lookup masterLookup) {
        assert (EventQueue.isDispatchThread());
        return this.getPanel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.javascript.grunt.ui.options.GruntOptionsPanelController");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private GruntOptionsPanel getPanel() {
        assert (EventQueue.isDispatchThread());
        if (this.gruntOptionsPanel == null) {
            this.gruntOptionsPanel = new GruntOptionsPanel();
            this.gruntOptionsPanel.addChangeListener(this);
        }
        return this.gruntOptionsPanel;
    }

    private GruntOptions getGruntOptions() {
        return GruntOptions.getInstance();
    }
}

