/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.editor.lib.ElementsIteratorHandle;
import org.netbeans.modules.html.editor.lib.ElementsParserCache;
import org.netbeans.modules.html.editor.lib.EmptyResult;
import org.netbeans.modules.html.editor.lib.HtmlSourceVersionQuery;
import org.netbeans.modules.html.editor.lib.XmlSyntaxTreeBuilder;
import org.netbeans.modules.html.editor.lib.api.DefaultParseResult;
import org.netbeans.modules.html.editor.lib.api.HtmlParseResult;
import org.netbeans.modules.html.editor.lib.api.HtmlParser;
import org.netbeans.modules.html.editor.lib.api.HtmlParserFactory;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.MaskedAreas;
import org.netbeans.modules.html.editor.lib.api.ParseException;
import org.netbeans.modules.html.editor.lib.api.ParseResult;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzer;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzerElements;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.AttributeFilter;
import org.netbeans.modules.html.editor.lib.api.elements.Declaration;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementFilter;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.Named;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.foreign.UndeclaredContentResolver;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class SyntaxAnalyzerResult {
    public static final String FILTERED_CODE_NAMESPACE = "filtered_code";
    private static final Logger LOG = Logger.getLogger(SyntaxAnalyzerResult.class.getSimpleName());
    private AtomicReference<Declaration> declaration;
    private HtmlVersion detectedHtmlVersion;
    private HtmlParseResult htmlParseResult;
    private Map<String, ParseResult> embeddedCodeParseResults;
    private Map<String, Collection<String>> namespaces;
    private ParseResult undeclaredEmbeddedCodeParseResult;
    private Set<String> allPrefixes;
    private UndeclaredContentResolver resolver;
    private HtmlSource source;
    private ElementsParserCache elementsParserCache;
    private MaskedAreas maskedAreas;
    private static final UndeclaredContentResolver EMPTY_RESOLVER = new EmptyUndeclaredContentResolver();

    SyntaxAnalyzerResult(HtmlSource source) {
        this(source, EMPTY_RESOLVER);
    }

    SyntaxAnalyzerResult(HtmlSource source, UndeclaredContentResolver resolver) {
        this.source = source;
        this.resolver = resolver;
    }

    public HtmlSource getSource() {
        return this.source;
    }

    public Iterator<Element> getElementsIterator() {
        return this.getElementsParserCache().createElementsIterator();
    }

    private synchronized ElementsParserCache getElementsParserCache() {
        if (this.elementsParserCache == null) {
            CharSequence sourceCode = this.source.getSourceCode();
            Snapshot snapshot = this.source.getSnapshot();
            TokenHierarchy hi = snapshot != null ? snapshot.getTokenHierarchy() : TokenHierarchy.create((CharSequence)sourceCode, (Language)HTMLTokenId.language());
            TokenSequence tokenSequence = hi.tokenSequence(HTMLTokenId.language());
            this.elementsParserCache = new ElementsParserCache(this.source.getSourceCode(), (TokenSequence<HTMLTokenId>)tokenSequence);
        }
        return this.elementsParserCache;
    }

    @Deprecated
    public SyntaxAnalyzerElements getElements() {
        return SyntaxAnalyzer.create(this.source).elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HtmlVersion getHtmlVersion() {
        HtmlVersion detected;
        long start;
        block3: {
            HtmlVersion htmlVersion;
            start = System.currentTimeMillis();
            try {
                detected = this.getDetectedHtmlVersion();
                HtmlVersion found = HtmlSourceVersionQuery.getSourceCodeVersion(this, detected);
                if (found == null) break block3;
                htmlVersion = found;
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                this.log(String.format("getHtmlVersion() took %s ms.", end - start));
                throw throwable;
            }
            long end = System.currentTimeMillis();
            this.log(String.format("getHtmlVersion() took %s ms.", end - start));
            return htmlVersion;
        }
        HtmlVersion htmlVersion = detected != null ? detected : (this.mayBeXhtml() ? HtmlVersion.getDefaultXhtmlVersion() : HtmlVersion.getDefaultVersion());
        long end = System.currentTimeMillis();
        this.log(String.format("getHtmlVersion() took %s ms.", end - start));
        return htmlVersion;
    }

    public HtmlModel getHtmlModel() {
        return HtmlModelFactory.getModel(this.getHtmlVersion());
    }

    public synchronized HtmlVersion getDetectedHtmlVersion() {
        if (this.detectedHtmlVersion == null) {
            this.detectedHtmlVersion = this.detectHtmlVersion();
        }
        return this.detectedHtmlVersion;
    }

    public boolean mayBeXhtml() {
        FileObject fo = this.getSource().getSourceFileObject();
        String mimeType = fo != null ? fo.getMIMEType() : null;
        return this.getHtmlTagDefaultNamespace() != null || "text/xhtml".equals(mimeType);
    }

    private HtmlVersion detectHtmlVersion() {
        Declaration doctypeDeclaration = this.getDoctypeDeclaration();
        if (doctypeDeclaration == null) {
            return null;
        }
        String publicId = this.getPublicID();
        String namespace = this.getHtmlTagDefaultNamespace();
        return HtmlVersion.find(publicId, namespace);
    }

    public Collection<ParseResult> getAllParseResults() throws ParseException {
        ArrayList<ParseResult> all = new ArrayList<ParseResult>();
        all.add(this.parseHtml());
        for (String ns : this.getAllDeclaredNamespaces().keySet()) {
            all.add(this.parseEmbeddedCode(ns));
        }
        all.add(this.parseUndeclaredEmbeddedCode());
        return all;
    }

    public synchronized HtmlParseResult parseHtml() throws ParseException {
        if (this.htmlParseResult == null) {
            this.htmlParseResult = this.doParseHtml();
        }
        return this.htmlParseResult;
    }

    private HtmlParser findParser() {
        HtmlVersion version = this.getHtmlVersion();
        HtmlParser parser = HtmlParserFactory.findParser(version);
        if (parser == null) {
            throw new IllegalStateException("Cannot find an HtmlParser implementation for " + this.getHtmlVersion().name());
        }
        return parser;
    }

    @NonNull
    private Collection<String> getNamespacePrefixes() {
        HtmlVersion version = this.getHtmlVersion();
        return version.getDefaultNamespace() != null ? this.getAllDeclaredNamespaces().get(version.getDefaultNamespace()) : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HtmlParseResult doParseHtml() throws ParseException {
        HtmlParseResult htmlParseResult;
        this.log("doParseHtml()...");
        long start = System.currentTimeMillis();
        long justParsingStart = 0L;
        try {
            final Collection<String> prefixes = this.getNamespacePrefixes();
            HtmlParser parser = this.findParser();
            Iterator<Element> original = this.getElementsIterator();
            final FilteredIterator filteredIterator = new FilteredIterator(original, new ElementFilter(){

                @Override
                public boolean accepts(Element node) {
                    switch (node.type()) {
                        case OPEN_TAG: 
                        case CLOSE_TAG: {
                            Named named = (Named)node;
                            if (SyntaxAnalyzerResult.this.resolver.isCustomTag(named, SyntaxAnalyzerResult.this.source)) {
                                return false;
                            }
                            CharSequence prefix = named.namespacePrefix();
                            if (prefix == null) {
                                return true;
                            }
                            return prefixes != null && prefixes.contains(prefix.toString());
                        }
                        default: {
                            return true;
                        }
                    }
                }
            });
            HtmlSource newSource = new HtmlSource(this.source.getSourceCode(), this.source.getSnapshot(), this.source.getSourceFileObject());
            InstanceContent content = new InstanceContent();
            content.add((Object)this.getMaskedAreas(this.source, FilteredContent.CUSTOM_TAGS, FilteredContent.DECLARED_FOREIGN_XHTML_CONTENT));
            content.add((Object)new ElementsIteratorHandle(){

                @Override
                public Iterator<Element> getIterator() {
                    return filteredIterator;
                }
            });
            AbstractLookup lookup = new AbstractLookup((AbstractLookup.Content)content);
            justParsingStart = System.currentTimeMillis();
            this.log("really parsing...");
            htmlParseResult = parser.parse(newSource, this.getHtmlVersion(), (Lookup)lookup);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.log(String.format("doParseHtml() took %s ms (clear parsing time %s)", end - start, end - justParsingStart));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.log(String.format("doParseHtml() took %s ms (clear parsing time %s)", end - start, end - justParsingStart));
        return htmlParseResult;
    }

    private synchronized ParseResult doParseFilteredCode() throws ParseException {
        Iterator<Element> original = this.getElementsIterator();
        FilteredIterator filteredIterator = new FilteredIterator(original, new ElementFilter(){

            @Override
            public boolean accepts(Element node) {
                switch (node.type()) {
                    case OPEN_TAG: 
                    case CLOSE_TAG: {
                        Named named = (Named)node;
                        return SyntaxAnalyzerResult.this.resolver.isCustomTag(named, SyntaxAnalyzerResult.this.source);
                    }
                }
                return false;
            }
        });
        Node root = XmlSyntaxTreeBuilder.makeUncheckedTree(this.source, FILTERED_CODE_NAMESPACE, SyntaxAnalyzerResult.createLookupFor(filteredIterator));
        return new DefaultParseResult(this.source, root, Collections.emptyList());
    }

    public synchronized ParseResult parseEmbeddedCode(String namespace) throws ParseException {
        ParseResult result;
        if (this.embeddedCodeParseResults == null) {
            this.embeddedCodeParseResults = new HashMap<String, ParseResult>();
        }
        if ((result = this.embeddedCodeParseResults.get(namespace)) == null) {
            result = FILTERED_CODE_NAMESPACE.equals(namespace) ? this.doParseFilteredCode() : this.doParseEmbeddedCode(namespace);
            this.embeddedCodeParseResults.put(namespace, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult doParseEmbeddedCode(String namespace) throws ParseException {
        Collection<String> prefixes;
        long justParsingStart;
        long start;
        block3: {
            EmptyResult emptyResult;
            start = System.currentTimeMillis();
            justParsingStart = 0L;
            try {
                prefixes = this.getAllDeclaredNamespaces().get(namespace);
                if (prefixes != null && !prefixes.isEmpty()) break block3;
                emptyResult = new EmptyResult(this.getSource());
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                this.log(String.format("doParseEmbeddedCode() took %s ms (clear parsing time %s)", end - start, end - justParsingStart));
                throw throwable;
            }
            long end = System.currentTimeMillis();
            this.log(String.format("doParseEmbeddedCode() took %s ms (clear parsing time %s)", end - start, end - justParsingStart));
            return emptyResult;
        }
        Iterator<Element> original = this.getElementsIterator();
        FilteredIterator filteredIterator = new FilteredIterator(original, new ElementFilter(){

            @Override
            public boolean accepts(Element node) {
                switch (node.type()) {
                    case OPEN_TAG: 
                    case CLOSE_TAG: {
                        Named named = (Named)node;
                        CharSequence prefix = named.namespacePrefix();
                        return prefix != null && prefixes.contains(prefix.toString());
                    }
                    default: {
                        return true;
                    }
                }
            }
        });
        justParsingStart = System.currentTimeMillis();
        Node root = XmlSyntaxTreeBuilder.makeUncheckedTree(this.source, namespace, SyntaxAnalyzerResult.createLookupFor(filteredIterator));
        DefaultParseResult defaultParseResult = new DefaultParseResult(this.source, root, Collections.emptyList());
        long end = System.currentTimeMillis();
        this.log(String.format("doParseEmbeddedCode() took %s ms (clear parsing time %s)", end - start, end - justParsingStart));
        return defaultParseResult;
    }

    private static Lookup createLookupFor(final Iterator<Element> elementsIterator) {
        InstanceContent ic = new InstanceContent();
        ic.add((Object)new ElementsIteratorHandle(){

            @Override
            public Iterator<Element> getIterator() {
                return elementsIterator;
            }
        });
        return new AbstractLookup((AbstractLookup.Content)ic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParseResult parsePlain() {
        DefaultParseResult defaultParseResult;
        long start = System.currentTimeMillis();
        try {
            Node root = XmlSyntaxTreeBuilder.makeUncheckedTree(this.source, null, SyntaxAnalyzerResult.createLookupFor(this.getElementsIterator()));
            defaultParseResult = new DefaultParseResult(this.source, root, Collections.emptyList());
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.log(String.format("parsePlain() took %s ms", end - start));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.log(String.format("parsePlain() took %s ms", end - start));
        return defaultParseResult;
    }

    public ParseResult parseUndeclaredEmbeddedCode() throws ParseException {
        if (this.undeclaredEmbeddedCodeParseResult == null) {
            this.undeclaredEmbeddedCodeParseResult = this.doParseUndeclaredEmbeddedCode();
        }
        return this.undeclaredEmbeddedCodeParseResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult doParseUndeclaredEmbeddedCode() throws ParseException {
        DefaultParseResult defaultParseResult;
        long start = System.currentTimeMillis();
        try {
            final Set<String> prefixes = this.getAllDeclaredPrefixes();
            Iterator<Element> original = this.getElementsIterator();
            FilteredIterator filteredIterator = new FilteredIterator(original, new ElementFilter(){

                @Override
                public boolean accepts(Element node) {
                    switch (node.type()) {
                        case OPEN_TAG: {
                            OpenTag openTag = (OpenTag)node;
                            for (Attribute attribute : openTag.attributes(new AttributeFilter(){

                                @Override
                                public boolean accepts(Attribute attribute) {
                                    return attribute.namespacePrefix() != null && !"xmlns".equals(attribute.namespacePrefix());
                                }
                            })) {
                                if (prefixes.contains(attribute.namespacePrefix().toString())) continue;
                                return true;
                            }
                            CharSequence otPrefix = openTag.namespacePrefix();
                            if (otPrefix == null || prefixes.contains(otPrefix.toString())) break;
                            return true;
                        }
                        case CLOSE_TAG: {
                            Named named = (Named)node;
                            CharSequence prefix = named.namespacePrefix();
                            if (prefix == null || prefixes.contains(prefix.toString())) break;
                            return true;
                        }
                        default: {
                            return true;
                        }
                    }
                    return false;
                }
            });
            Node root = XmlSyntaxTreeBuilder.makeUncheckedTree(this.source, null, SyntaxAnalyzerResult.createLookupFor(filteredIterator));
            defaultParseResult = new DefaultParseResult(this.source, root, Collections.emptyList());
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.log(String.format("doParseUndeclaredEmbeddedCode() took %s ms", end - start));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.log(String.format("doParseUndeclaredEmbeddedCode() took %s ms", end - start));
        return defaultParseResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MaskedAreas getMaskedAreas(HtmlSource source, FilteredContent ... filteredContent) {
        MaskedAreas maskedAreas;
        this.log("findMaskedAreas...");
        ElementContentFilter filter = new ElementContentFilter(source, filteredContent);
        long start = System.currentTimeMillis();
        try {
            ArrayList<MaskedArea> ignoredAreas = new ArrayList<MaskedArea>();
            Iterator<Element> itr = this.getElementsIterator();
            while (itr.hasNext()) {
                Element e = itr.next();
                ignoredAreas.addAll(filter.getMasks(e));
            }
            int[] positions = new int[ignoredAreas.size()];
            int[] lens = new int[ignoredAreas.size()];
            for (int i = 0; i < positions.length; ++i) {
                MaskedArea ia = (MaskedArea)ignoredAreas.get(i);
                positions[i] = ia.from;
                lens[i] = ia.to - ia.from;
            }
            maskedAreas = new MaskedAreas(positions, lens);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.log(String.format("findMaskedAreas() took %s ms.", end - start));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.log(String.format("findMaskedAreas() took %s ms.", end - start));
        return maskedAreas;
    }

    public String getPublicID() {
        Declaration decl = this.getDoctypeDeclaration();
        if (decl == null) {
            return null;
        }
        CharSequence pid = this.getDoctypeDeclaration().publicId();
        return pid == null ? null : pid.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Declaration getDoctypeDeclaration() {
        Declaration declaration;
        long start = System.currentTimeMillis();
        try {
            if (this.declaration == null) {
                Declaration declarationElement = null;
                int limitCountdown = 20;
                Iterator<Element> elementsIterator = this.getElementsIterator();
                while (elementsIterator.hasNext() && limitCountdown-- != 0) {
                    Element e = elementsIterator.next();
                    if (e.type() != ElementType.DECLARATION) continue;
                    Declaration decl = (Declaration)e;
                    if (!SyntaxAnalyzerResult.isValidDoctype(decl)) break;
                    declarationElement = (Declaration)e;
                    break;
                }
                this.declaration = new AtomicReference<Object>(declarationElement);
            }
            declaration = this.declaration.get();
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.log(String.format("getDoctypeDeclaration() took %s ms.", end - start));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.log(String.format("getDoctypeDeclaration() took %s ms.", end - start));
        return declaration;
    }

    private static boolean isValidDoctype(Declaration decl) {
        return "doctype".equalsIgnoreCase(decl.declarationName().toString()) && decl.rootElementName() != null;
    }

    @Deprecated
    public Map<String, String> getDeclaredNamespaces() {
        HashMap<String, Collection<String>> all = new HashMap<String, Collection<String>>(this.getAllDeclaredNamespaces());
        HashMap<String, String> firstPrefixOnly = new HashMap<String, String>();
        for (String namespace : all.keySet()) {
            Collection prefixes = (Collection)all.get(namespace);
            if (prefixes == null || prefixes.size() <= 0) continue;
            firstPrefixOnly.put(namespace, (String)prefixes.iterator().next());
        }
        return firstPrefixOnly;
    }

    public synchronized Set<String> getAllDeclaredPrefixes() {
        if (this.allPrefixes == null) {
            this.allPrefixes = this.findAllDeclaredPrefixes();
        }
        return this.allPrefixes;
    }

    private Set<String> findAllDeclaredPrefixes() {
        HashSet<String> all = new HashSet<String>();
        for (Collection<String> prefixes : this.getAllDeclaredNamespaces().values()) {
            all.addAll(prefixes);
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHtmlTagDefaultNamespace() {
        block4: {
            this.log("getHtmlTagDefaultNamespace()...");
            start = System.currentTimeMillis();
            try {
                limitCountdown = 100;
                elementsIterator = this.getElementsIterator();
                while (elementsIterator.hasNext() && limitCountdown-- != 0) {
                    se = elementsIterator.next();
                    if (se.type() != ElementType.OPEN_TAG || (xmlns = (tag = (OpenTag)se).getAttribute("xmlns")) == null || (value = xmlns.unquotedValue()) == null) continue;
                    var9_9 = value.toString();
                    break block4;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var12_11) {
                end = System.currentTimeMillis();
                this.log(String.format("getHtmlTagDefaultNamespace() took %s ms.", new Object[]{end - start}));
                throw var12_11;
            }
        }
        end = System.currentTimeMillis();
        this.log(String.format("getHtmlTagDefaultNamespace() took %s ms.", new Object[]{end - start}));
        return var9_9;
lbl-1000:
        // 1 sources

        {
            var5_4 = null;
        }
        end = System.currentTimeMillis();
        this.log(String.format("getHtmlTagDefaultNamespace() took %s ms.", new Object[]{end - start}));
        return var5_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, Collection<String>> getAllDeclaredNamespaces() {
        Map<String, Collection<String>> map;
        this.log("getAllDeclaredNamespaces...");
        long start = System.currentTimeMillis();
        try {
            if (this.namespaces == null) {
                this.namespaces = new HashMap<String, Collection<String>>();
                if (this.resolver != null) {
                    this.namespaces.putAll(this.resolver.getUndeclaredNamespaces(this.getSource()));
                }
                Iterator<Element> iterator = this.getElementsIterator();
                while (iterator.hasNext()) {
                    Element se = iterator.next();
                    if (se.type() != ElementType.OPEN_TAG) continue;
                    OpenTag tag = (OpenTag)se;
                    for (Attribute attr : tag.attributes()) {
                        String nsPrefix;
                        String attrName = attr.name().toString();
                        if (!attrName.startsWith("xmlns")) continue;
                        int colonIndex = attrName.indexOf(58);
                        String string = nsPrefix = colonIndex == -1 ? null : attrName.substring(colonIndex + 1);
                        CharSequence value = attr.unquotedValue();
                        if (value == null) continue;
                        String key = value.toString();
                        Collection<String> prefixes = this.namespaces.get(key);
                        if (prefixes == null) {
                            prefixes = new LinkedList<String>();
                            prefixes.add(nsPrefix);
                            this.namespaces.put(key, prefixes);
                            continue;
                        }
                        if (prefixes.contains(key)) continue;
                        prefixes.add(nsPrefix);
                    }
                }
            }
            map = this.namespaces;
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.log(String.format("getAllDeclaredNamespaces() took %s ms.", end - start));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.log(String.format("getAllDeclaredNamespaces() took %s ms.", end - start));
        return map;
    }

    private void log(String message) {
        LOG.log(Level.FINE, "HtmlSource(" + this.source.hashCode() + "):" + message);
    }

    private static final class EmptyUndeclaredContentResolver
    implements UndeclaredContentResolver {
        private EmptyUndeclaredContentResolver() {
        }

        @Override
        public Map<String, List<String>> getUndeclaredNamespaces(HtmlSource source) {
            return Collections.emptyMap();
        }

        @Override
        public boolean isCustomTag(Named element, HtmlSource source) {
            return false;
        }

        @Override
        public boolean isCustomAttribute(Attribute attribute, HtmlSource source) {
            return false;
        }
    }

    private static class MaskedArea {
        int from;
        int to;

        public MaskedArea(int from, int to) {
            this.from = from;
            this.to = to;
        }
    }

    private static class FilteredIterator
    implements Iterator<Element> {
        private Iterator<Element> source;
        private ElementFilter filter;
        private Element next;

        public FilteredIterator(Iterator<Element> source, ElementFilter filter) {
            this.source = source;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.source.hasNext();
            if (!hasNext) {
                return false;
            }
            while (this.source.hasNext()) {
                this.next = this.source.next();
                if (!this.filter.accepts(this.next)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Element next() {
            return this.next;
        }

        @Override
        public void remove() {
        }
    }

    private class ElementContentFilter {
        private final Collection<String> prefixes;
        private final Set<FilteredContent> conf;
        private final HtmlSource source;

        public ElementContentFilter(HtmlSource source, FilteredContent ... conf) {
            this.source = source;
            this.prefixes = SyntaxAnalyzerResult.this.getNamespacePrefixes();
            this.conf = EnumSet.of(conf[0], conf);
        }

        @NonNull
        public Collection<MaskedArea> getMasks(Element element) {
            switch (element.type()) {
                case OPEN_TAG: {
                    OpenTag openTag = (OpenTag)element;
                    if (this.shouldBeFiltered(openTag)) {
                        return Collections.singleton(new MaskedArea(element.from(), element.to()));
                    }
                    ArrayList<MaskedArea> masks = null;
                    for (Attribute attr : openTag.attributes()) {
                        String name = attr.unqualifiedName().toString();
                        if (!LexerUtils.startsWith((CharSequence)name, (CharSequence)"xmlns:", (boolean)true, (boolean)false) && !SyntaxAnalyzerResult.this.resolver.isCustomAttribute(attr, this.source)) continue;
                        if (masks == null) {
                            masks = new ArrayList<MaskedArea>();
                        }
                        masks.add(new MaskedArea(attr.from(), attr.to()));
                    }
                    return masks == null ? Collections.emptySet() : masks;
                }
                case CLOSE_TAG: {
                    if (!this.shouldBeFiltered((Named)element)) break;
                    return Collections.singleton(new MaskedArea(element.from(), element.to()));
                }
            }
            return Collections.emptySet();
        }

        private boolean shouldBeFiltered(Named named) {
            if (this.conf.contains((Object)FilteredContent.CUSTOM_TAGS) && SyntaxAnalyzerResult.this.resolver.isCustomTag(named, this.source)) {
                return true;
            }
            CharSequence nsPrefix = named.namespacePrefix();
            if (nsPrefix == null) {
                return false;
            }
            return this.conf.contains((Object)FilteredContent.DECLARED_FOREIGN_XHTML_CONTENT) && (this.prefixes == null || !this.prefixes.contains(nsPrefix.toString()));
        }
    }

    public static enum FilteredContent {
        CUSTOM_TAGS,
        DECLARED_FOREIGN_XHTML_CONTENT;

    }
}

