/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.LocaleVariants;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.NetigsoModule;
import org.netbeans.ProxyClassLoader;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;

public final class Util {
    public static final Logger err = Logger.getLogger("org.netbeans.core.modules");
    private static final Map<String, Object[]> codeNameParseCache = new HashMap<String, Object[]>(200);

    private Util() {
    }

    public static synchronized String[] getLocalizingSuffixesFast() {
        return LocaleVariants.getLocalizingSuffixesFast();
    }

    static File makeTempJar(File moduleFile) throws IOException {
        String prefix = moduleFile.getName();
        if (prefix.endsWith(".jar") || prefix.endsWith(".JAR")) {
            prefix = prefix.substring(0, prefix.length() - 4);
        }
        if (prefix.length() < 3) {
            prefix = prefix + '.';
        }
        if (prefix.length() < 3) {
            prefix = prefix + '.';
        }
        if (prefix.length() < 3) {
            prefix = prefix + '.';
        }
        String suffix = "-test.jar";
        File physicalModuleFile = File.createTempFile(prefix, suffix);
        physicalModuleFile.deleteOnExit();
        try (InputStream is = Files.newInputStream(moduleFile.toPath(), new OpenOption[0]);
             OutputStream os = Files.newOutputStream(physicalModuleFile.toPath(), new OpenOption[0]);){
            int i;
            byte[] buf = new byte[4096];
            while ((i = is.read(buf)) != -1) {
                os.write(buf, 0, i);
            }
        }
        catch (InvalidPathException ex) {
            throw new IOException(ex);
        }
        err.fine("Made " + physicalModuleFile);
        return physicalModuleFile;
    }

    static boolean checkJavaDependency(Dependency dep) throws IllegalArgumentException {
        if (dep.getType() == 3) {
            if (dep.getName().equals("Java")) {
                if (dep.getComparison() == 1) {
                    return new SpecificationVersion(dep.getVersion()).compareTo((Object)Dependency.JAVA_SPEC) <= 0;
                }
                return dep.getVersion().equals(Dependency.JAVA_IMPL);
            }
            if (dep.getComparison() == 1) {
                return new SpecificationVersion(dep.getVersion()).compareTo((Object)Dependency.VM_SPEC) <= 0;
            }
            return dep.getVersion().equals(Dependency.VM_IMPL);
        }
        throw new IllegalArgumentException();
    }

    public static boolean checkPackageDependency(Dependency dep, ClassLoader cl) throws IllegalArgumentException {
        String sampleName;
        String packageName;
        if (dep.getType() != 2) {
            throw new IllegalArgumentException("Not a package dependency");
        }
        if (!(cl instanceof ProxyClassLoader) && cl != Util.class.getClassLoader()) {
            throw new IllegalArgumentException("Not a package-accessible classloader: " + cl);
        }
        String name = dep.getName();
        String version = dep.getVersion();
        int comparison = dep.getComparison();
        int idx = name.indexOf(91);
        if (idx == -1) {
            packageName = name;
            sampleName = null;
        } else if (idx == 0) {
            packageName = null;
            sampleName = name.substring(1, name.length() - 1);
        } else {
            packageName = name.substring(0, idx);
            sampleName = name.substring(idx + 1, name.length() - 1);
            if (sampleName.indexOf(46) == -1) {
                sampleName = packageName + '.' + sampleName;
            }
        }
        if (sampleName != null) {
            try {
                cl.loadClass(sampleName);
            }
            catch (ClassNotFoundException cnfe) {
                if (packageName == null) {
                    err.log(Level.FINE, null, cnfe);
                    err.fine("Probed class could not be found");
                    return false;
                }
            }
            catch (RuntimeException e) {
                err.log(Level.WARNING, null, e);
                err.fine("Assuming package " + packageName + " is corrupt");
                return false;
            }
            catch (LinkageError le) {
                err.log(Level.WARNING, null, le);
                err.fine("Assuming package " + packageName + " is corrupt");
                return false;
            }
        }
        if (packageName != null) {
            Package pkg = cl instanceof ProxyClassLoader ? ((ProxyClassLoader)cl).getPackage(packageName) : Package.getPackage(packageName);
            if (pkg == null) {
                err.fine("No package with the name " + packageName + " found");
                return false;
            }
            if (comparison == 3) {
                return true;
            }
            if (comparison == 1) {
                if (pkg.getSpecificationVersion() == null) {
                    err.fine("Package " + packageName + " did not give a specification version");
                    return false;
                }
                try {
                    SpecificationVersion versionSpec = new SpecificationVersion(version);
                    SpecificationVersion pkgSpec = new SpecificationVersion(pkg.getSpecificationVersion().trim());
                    if (versionSpec.compareTo((Object)pkgSpec) <= 0) {
                        return true;
                    }
                    err.fine("Loaded package " + packageName + " was only of version " + pkgSpec + " but " + versionSpec + " was requested");
                    return false;
                }
                catch (NumberFormatException nfe) {
                    err.log(Level.WARNING, null, nfe);
                    err.fine("Will not honor a dependency on non-numeric package spec version");
                    return false;
                }
            }
            if (pkg.getImplementationVersion() == null) {
                err.fine("Package " + packageName + " had no implementation version");
                return false;
            }
            if (!pkg.getImplementationVersion().trim().equals(version)) {
                err.fine("Package " + packageName + " had the wrong impl version: " + pkg.getImplementationVersion());
                return false;
            }
            return true;
        }
        return true;
    }

    public static Map<Module, List<Module>> moduleDependencies(Collection<Module> modules, Map<String, Module> modulesByName, Map<String, Set<Module>> _providersOf) {
        return Util.moduleDependencies(modules, modulesByName, _providersOf, Collections.emptyMap());
    }

    static Map<Module, List<Module>> moduleDependencies(Collection<Module> modules, Map<String, Module> modulesByName, Map<String, Set<Module>> _providersOf, Map<String, Collection<Module>> fragments) {
        Set<Object> modulesSet = modules instanceof Set ? (Set<Object>)modules : new HashSet<Module>(modules);
        HashMap<String, LinkedList<Module>> providersOf = new HashMap<String, LinkedList<Module>>(_providersOf.size() * 2 + 1);
        for (Map.Entry<String, Set<Module>> entry : _providersOf.entrySet()) {
            Set<Module> providers = entry.getValue();
            if (providers == null) continue;
            LinkedList<Module> availableProviders = new LinkedList<Module>(providers);
            availableProviders.retainAll(modulesSet);
            if (availableProviders.isEmpty()) continue;
            providersOf.put(entry.getKey(), availableProviders);
        }
        HashMap<Module, List<Module>> m = new HashMap<Module, List<Module>>();
        for (Module m1 : modules) {
            List<Module> l = null;
            for (Dependency dep : m1.getDependenciesArray()) {
                String cnb;
                Module m2;
                if (dep.getType() == 5) {
                    List providers = (List)providersOf.get(dep.getName());
                    if (providers == null) continue;
                    l = Util.fillMapSlot(m, m1);
                    l.addAll(providers);
                    continue;
                }
                if (dep.getType() != 1 || (m2 = modulesByName.get(cnb = (String)Util.parseCodeName(dep.getName())[0])) == null || !modulesSet.contains((Object)m2)) continue;
                l = Util.fillMapSlot(m, m1);
                l.add(m2);
            }
            Collection<Module> frags = fragments.get(m1.getCodeNameBase());
            if (frags != null && !frags.isEmpty()) {
                frags = new HashSet<Module>(frags);
                frags.retainAll(modules);
                for (Module f : frags) {
                    List<Module> fragmentDep = Util.fillMapSlot(m, f);
                    fragmentDep.add(m1);
                    for (Dependency dep : f.getDependenciesArray()) {
                        String cnb;
                        Module m2;
                        if (dep.getType() == 5) {
                            List providers = (List)providersOf.get(dep.getName());
                            if (providers == null) continue;
                            l = Util.fillMapSlot(m, m1);
                            l.addAll(providers);
                            continue;
                        }
                        if (dep.getType() != 1 || (m2 = modulesByName.get(cnb = (String)Util.parseCodeName(dep.getName())[0])) == null || !modulesSet.contains((Object)m2)) continue;
                        l = Util.fillMapSlot(m, m1);
                        l.add(m2);
                    }
                }
                if (l != null) {
                    l.remove((Object)m1);
                }
            }
            if (l == null) continue;
            m.put(m1, l);
        }
        return m;
    }

    private static List<Module> fillMapSlot(Map<Module, List<Module>> map, Module module) {
        List<Module> l = map.get((Object)module);
        if (l == null) {
            l = new LinkedList<Module>();
            map.put(module, l);
        }
        return l;
    }

    static Set<Module> moduleInterdependencies(Module m, boolean reverse, boolean transitive, boolean considerNeeds, Set<Module> modules, Map<String, Module> modulesByName, Map<String, Set<Module>> providersOf) {
        if (reverse) {
            HashSet<Module> s = new HashSet<Module>();
            for (Module m2 : modules) {
                if (m2 == m || !Util.moduleInterdependencies(m2, false, transitive, considerNeeds, modules, modulesByName, providersOf).contains((Object)m)) continue;
                s.add(m2);
            }
            return s;
        }
        HashSet<Module> s = new HashSet<Module>();
        for (Dependency dep : m.getDependenciesArray()) {
            String cnb;
            Module m2;
            boolean needsProvider;
            boolean bl = needsProvider = dep.getType() == 5 || considerNeeds && dep.getType() == 6;
            if (m instanceof NetigsoModule && dep.getType() == 7) {
                needsProvider = true;
            }
            if (needsProvider) {
                Set<Module> providers = providersOf.get(dep.getName());
                if (providers == null) continue;
                s.addAll(providers);
                continue;
            }
            if (dep.getType() != 1 || (m2 = modulesByName.get(cnb = (String)Util.parseCodeName(dep.getName())[0])) == null) continue;
            s.add(m2);
        }
        s.remove((Object)m);
        if (transitive) {
            HashSet<Module> toAdd;
            do {
                toAdd = new HashSet<Module>();
                for (Module m2 : s) {
                    Set<Module> s2 = Util.moduleInterdependencies(m2, false, false, considerNeeds, modules, modulesByName, providersOf);
                    s2.remove((Object)m);
                    s2.removeAll(s);
                    toAdd.addAll(s2);
                }
                s.addAll(toAdd);
            } while (!toAdd.isEmpty());
        }
        return s;
    }

    static FilenameFilter jarFilter() {
        return new JarFilter();
    }

    public static String createPackageName(String name) throws IllegalArgumentException {
        String clExt = ".class";
        if (!name.endsWith(clExt)) {
            clExt = ".ser";
        }
        if (name.endsWith(clExt)) {
            String bareName = name.substring(0, name.length() - clExt.length());
            if (bareName.length() == 0) {
                throw new IllegalArgumentException("Bad class file name: " + name);
            }
            if (bareName.charAt(0) == '/') {
                throw new IllegalArgumentException("Bad class file name: " + name);
            }
            if (bareName.charAt(bareName.length() - 1) == '/') {
                throw new IllegalArgumentException("Bad class file name: " + name);
            }
            if (bareName.indexOf(46) != -1) {
                throw new IllegalArgumentException("Bad class file name: " + name);
            }
            return bareName.replace('/', '.');
        }
        throw new IllegalArgumentException("Bad class file name: " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] parseCodeName(String cn) throws NumberFormatException {
        Map<String, Object[]> map = codeNameParseCache;
        synchronized (map) {
            Object[] r = codeNameParseCache.get(cn);
            if (r == null) {
                r = new Object[3];
                int i = cn.lastIndexOf(47);
                if (i == -1) {
                    r[0] = cn;
                } else {
                    r[0] = cn.substring(0, i).intern();
                    String end = cn.substring(i + 1);
                    int j = end.indexOf(45);
                    if (j == -1) {
                        r[1] = Integer.valueOf(end);
                    } else {
                        r[1] = Integer.valueOf(end.substring(0, j));
                        r[2] = Integer.valueOf(end.substring(j + 1));
                    }
                }
                codeNameParseCache.put(cn.intern(), r);
            }
            return r;
        }
    }

    public static SpecificationVersion getModuleDep(Set<Dependency> dependencies, String cnb) {
        for (Dependency d : dependencies) {
            if (d.getType() != 1 || d.getComparison() != 1) continue;
            try {
                Object[] p = Util.parseCodeName(d.getName());
                if (!p[0].equals(cnb)) continue;
                int rel = (Integer)p[1];
                if (rel == -1) {
                    rel = 0;
                }
                return new SpecificationVersion("" + rel + "." + d.getVersion());
            }
            catch (NumberFormatException nfe) {
                err.log(Level.WARNING, null, nfe);
                return null;
            }
        }
        return null;
    }

    public static void transitiveClosureModuleDependencies(ModuleManager mgr, Set<Module> modules) {
        HashSet<Module> nue = null;
        while (nue == null || !nue.isEmpty()) {
            nue = new HashSet<Module>();
            for (Module m : modules) {
                for (Dependency dep : m.getDependenciesArray()) {
                    Module other;
                    if (dep.getType() != 1 || (other = mgr.get((String)Util.parseCodeName(dep.getName())[0])) == null || modules.contains((Object)other)) continue;
                    nue.add(other);
                }
            }
            modules.addAll(nue);
        }
    }

    static final class ModuleLookup
    extends Lookup {
        private final Set<Module> modules = new HashSet<Module>(100);
        private final Set<ModuleResult> results = new WeakSet(10);

        ModuleLookup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Module m) {
            Set<Module> set = this.modules;
            synchronized (set) {
                this.modules.add(m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Module m) {
            Set<Module> set = this.modules;
            synchronized (set) {
                this.modules.remove((Object)m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed() {
            Set<ModuleResult> set = this.results;
            synchronized (set) {
                Iterator<ModuleResult> it = this.results.iterator();
                while (it.hasNext()) {
                    it.next().changed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T lookup(Class<T> clazz) {
            if (!(clazz != Module.class && clazz != ModuleInfo.class && clazz != Object.class && clazz != null || this.modules.isEmpty())) {
                Set<Module> set = this.modules;
                synchronized (set) {
                    return clazz.cast((Object)this.modules.iterator().next());
                }
            }
            return null;
        }

        public <T> Lookup.Result<T> lookup(Lookup.Template<T> t) {
            Class clazz = t.getType();
            if (clazz == Module.class || clazz == ModuleInfo.class || clazz == Object.class || clazz == null) {
                return new ModuleResult(t);
            }
            return Lookup.EMPTY.lookup(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Set<Module> set = this.modules;
            synchronized (set) {
                return "ModuleLookup" + this.modules;
            }
        }

        private static final class ModuleItem
        extends Lookup.Item<Module> {
            public static final String PREFIX = "Module[";
            private final Module item;

            public ModuleItem(Module item) {
                this.item = item;
            }

            public Module getInstance() {
                return this.item;
            }

            public Class<? extends Module> getType() {
                return Module.class;
            }

            public String getId() {
                return PREFIX + this.item.getCodeNameBase();
            }

            public String getDisplayName() {
                return this.item.getDisplayName();
            }
        }

        private final class ModuleResult
        extends Lookup.Result<Module> {
            private final Lookup.Template<? super Module> t;
            private final Set<LookupListener> listeners = new HashSet<LookupListener>(10);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ModuleResult(Lookup.Template<? super Module> t) {
                this.t = t;
                Set set = ModuleLookup.this.results;
                synchronized (set) {
                    ModuleLookup.this.results.add(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addLookupListener(LookupListener l) {
                Set<LookupListener> set = this.listeners;
                synchronized (set) {
                    this.listeners.add(l);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeLookupListener(LookupListener l) {
                Set<LookupListener> set = this.listeners;
                synchronized (set) {
                    this.listeners.remove(l);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changed() {
                LookupListener[] _listeners;
                Set<LookupListener> set = this.listeners;
                synchronized (set) {
                    if (this.listeners.isEmpty()) {
                        return;
                    }
                    _listeners = this.listeners.toArray(new LookupListener[this.listeners.size()]);
                }
                LookupEvent ev = new LookupEvent((Lookup.Result)this);
                for (int i = 0; i < _listeners.length; ++i) {
                    _listeners[i].resultChanged(ev);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Collection<Module> allInstances() {
                Set set = ModuleLookup.this.modules;
                synchronized (set) {
                    String id = this.t.getId();
                    Object inst = this.t.getInstance();
                    if (id != null) {
                        for (Module m : ModuleLookup.this.modules) {
                            if (!id.equals("Module[" + m.getCodeNameBase()) || inst != null && inst != m) continue;
                            return Collections.singleton(m);
                        }
                        return Collections.emptySet();
                    }
                    if (inst != null) {
                        return ModuleLookup.this.modules.contains(inst) ? Collections.singleton(Module.class.cast(inst)) : Collections.emptySet();
                    }
                    return new HashSet<Module>(ModuleLookup.this.modules);
                }
            }

            public Set<Class<? extends Module>> allClasses() {
                return Collections.singleton(Module.class);
            }

            public Collection<? extends Lookup.Item<Module>> allItems() {
                Collection<Module> insts = this.allInstances();
                ArrayList<ModuleItem> list = new ArrayList<ModuleItem>(Math.max(1, insts.size()));
                for (Module m : insts) {
                    list.add(new ModuleItem(m));
                }
                return list;
            }

            public String toString() {
                return "ModuleResult:" + this.t;
            }
        }
    }

    private static final class JarFilter
    implements FilenameFilter {
        JarFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            String n = name.toLowerCase(Locale.US);
            return n.endsWith(".jar");
        }
    }

    public static interface ModuleProvider {
        public Module getModule();
    }
}

