/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.spi;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.spi.BrandingSupport;
import org.netbeans.modules.apisupport.project.spi.Bundle;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public abstract class BrandingModel {
    private BrandingSupport branding;
    private boolean brandingEnabled;
    private String name;
    private String title;
    @NullAllowed
    private BrandingSupport.BrandedFile icon48 = null;
    private BrandingSupport.BrandedFile icon16 = null;
    private BrandingSupport.BrandedFile icon32 = null;
    private BrandingSupport.BundleKey productInformation = null;
    private BrandingSupport.BundleKey mainWindowTitle = null;
    private BrandingSupport.BundleKey splashWindowTitle = null;
    private BrandingSupport.BundleKey mainWindowTitleNoProject = null;
    private BrandingSupport.BundleKey currentVersion = null;
    private BrandingSupport.BrandedFile splash = null;
    private BrandingSupport.BundleKey splashWidth = null;
    private BrandingSupport.BundleKey splashHeight = null;
    private BrandingSupport.BundleKey splashShowProgressBar = null;
    private BrandingSupport.BundleKey splashRunningTextBounds = null;
    private BrandingSupport.BundleKey splashProgressBarBounds = null;
    private BrandingSupport.BundleKey splashRunningTextFontSize = null;
    private BrandingSupport.BundleKey splashRunningTextColor = null;
    private BrandingSupport.BundleKey splashProgressBarColor = null;
    private BrandingSupport.BundleKey splashProgressBarEdgeColor = null;
    private BrandingSupport.BundleKey splashProgressBarCornerColor = null;
    private final Set<BrandingSupport.BundleKey> splashKeys = new HashSet<BrandingSupport.BundleKey>();
    private BrandingSupport.BundleKey wsEnableDragAndDrop = null;
    private BrandingSupport.BundleKey wsEnableFloating = null;
    private BrandingSupport.BundleKey wsEnableSliding = null;
    private BrandingSupport.BundleKey wsEnableClosingViews = null;
    private BrandingSupport.BundleKey wsEnableClosingEditors = null;
    private BrandingSupport.BundleKey wsEnableResizing = null;
    private BrandingSupport.BundleKey wsEnableMinimumSize = null;
    private BrandingSupport.BundleKey wsEnableMaximization = null;
    private BrandingSupport.BundleKey wsEnableAutoSlideInMinimizedMode = null;
    private BrandingSupport.BundleKey wsEnableEditorModeUndocking = null;
    private BrandingSupport.BundleKey wsEnableModeClosing = null;
    private BrandingSupport.BundleKey wsEnableEditorModeDnD = null;
    private BrandingSupport.BundleKey wsEnableModeSliding = null;
    private BrandingSupport.BundleKey wsEnableViewModeDnD = null;
    private BrandingSupport.BundleKey wsEnableViewModeUndocking = null;
    private final Set<BrandingSupport.BundleKey> winsysKeys = new HashSet<BrandingSupport.BundleKey>();
    private final Set<BrandingSupport.BundleKey> generalResourceBundleKeys = new HashSet<BrandingSupport.BundleKey>();
    private final Set<BrandingSupport.BundleKey> internationalizedResourceBundleKeys = new HashSet<BrandingSupport.BundleKey>();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    protected Locale locale;

    protected BrandingModel() {
    }

    public final boolean isBrandingEnabled() {
        return this.brandingEnabled;
    }

    public void setBrandingEnabled(boolean brandingEnabled) {
        if (this.brandingEnabled != brandingEnabled) {
            this.brandingEnabled = brandingEnabled;
            this.changeSupport.fireChange();
        }
    }

    public final String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.isBrandingEnabled()) {
            this.name = name;
        }
    }

    public final String getTitle() {
        return this.title;
    }

    public final void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void setTitle(String title) {
        if (this.isBrandingEnabled()) {
            this.title = title;
            if (this.productInformation != null) {
                this.productInformation.setValue(title);
            }
            if (this.mainWindowTitle != null) {
                this.mainWindowTitle.setValue(title + " {0}");
            }
            if (this.splashWindowTitle != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(Bundle.LBL_splash_window_title_prefix());
                sb.append(" ").append(title);
                this.splashWindowTitle.setValue(sb.toString());
            }
            if (this.mainWindowTitleNoProject != null) {
                this.mainWindowTitleNoProject.setValue(title + " {0}");
            }
            if (this.currentVersion != null) {
                this.currentVersion.setValue(title + " {0}");
            }
        }
    }

    public final URL getIconSource(int size) {
        switch (size) {
            case 16: {
                return this.icon16 != null ? this.icon16.getBrandingSource() : null;
            }
            case 32: {
                return this.icon32 != null ? this.icon32.getBrandingSource() : null;
            }
            case 48: {
                return this.icon48 != null ? this.icon48.getBrandingSource() : null;
            }
        }
        throw new IllegalArgumentException("Invalid icon size: " + size);
    }

    public void setIconSource(int size, URL url) {
        if (this.isBrandingEnabled()) {
            BrandingSupport.BrandedFile icon = null;
            switch (size) {
                case 16: {
                    icon = this.icon16;
                    break;
                }
                case 32: {
                    icon = this.icon32;
                    break;
                }
                case 48: {
                    icon = this.icon48;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid icon size: " + size);
                }
            }
            if (icon != null && url != null) {
                icon.setBrandingSource(url);
            }
        }
    }

    @CheckForNull
    protected final String getIconLocation() {
        if (this.icon48 == null) {
            return null;
        }
        File prj = this.getProjectDirectoryFile();
        String relativePath = PropertyUtils.relativizeFile((File)prj, (File)this.icon48.getFileLocation());
        return relativePath;
    }

    public abstract Project getProject();

    public final Set<File> getBrandableJars() {
        return this.getBranding().getBrandableJars();
    }

    protected abstract File getProjectDirectoryFile();

    public void store() throws IOException {
        if (this.brandingEnabled) {
            this.getBranding().brandBundleKey(this.productInformation);
            this.getBranding().brandBundleKey(this.mainWindowTitle);
            this.getBranding().brandBundleKey(this.splashWindowTitle);
            this.getBranding().brandBundleKey(this.mainWindowTitleNoProject);
            this.getBranding().brandBundleKey(this.currentVersion);
            if (this.icon48 != null) {
                this.getBranding().brandFile(this.icon48, BrandingModel.getScaleAndStoreIconTask(this.icon48, 48, 48));
            }
            if (this.icon16 != null) {
                this.getBranding().brandFile(this.icon16, BrandingModel.getScaleAndStoreIconTask(this.icon16, 16, 16));
            }
            if (this.icon32 != null) {
                this.getBranding().brandFile(this.icon32, BrandingModel.getScaleAndStoreIconTask(this.icon32, 32, 32));
            }
            this.getBranding().brandBundleKeys(this.splashKeys);
            if (this.splash != null) {
                this.getBranding().brandFile(this.splash);
            }
            this.getBranding().brandBundleKeys(this.winsysKeys);
            this.getBranding().brandBundleKeys(this.generalResourceBundleKeys);
            this.getBranding().brandBundleKeys(this.internationalizedResourceBundleKeys);
            FileObject root = FileUtil.toFileObject((File)this.getBranding().getBrandingRoot());
            if (null != root) {
                root.refresh();
            }
        }
    }

    private static Runnable getScaleAndStoreIconTask(final BrandingSupport.BrandedFile icon, final int width, final int height) throws IOException {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedImage bi = new BufferedImage(width, height, 2);
                Graphics2D g2 = bi.createGraphics();
                ImageIcon image = new ImageIcon(icon.getBrandingSource());
                g2.drawImage(image.getImage(), 0, 0, width, height, null);
                g2.dispose();
                try {
                    FileObject fo;
                    File iconLocation = icon.getFileLocation();
                    if (!iconLocation.exists()) {
                        iconLocation.createNewFile();
                    }
                    OutputStream os = (fo = FileUtil.toFileObject((File)iconLocation)) == null ? new FileOutputStream(iconLocation) : fo.getOutputStream();
                    try {
                        ImageIO.write((RenderedImage)bi, "png", os);
                    }
                    finally {
                        os.close();
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        };
    }

    public void refreshLocalizedBundles(Locale locale) {
        this.locale = locale;
        try {
            this.branding.refreshLocalizedBundles(locale);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private BrandingSupport getBranding() {
        if (this.branding == null) {
            try {
                this.branding = this.createBranding();
                this.branding.init();
            }
            catch (IOException x) {
                Logger.getLogger(BrandingModel.class.getName()).log(Level.INFO, null, x);
                this.branding = new BrandingSupport(this.getProject(), "nowhere"){

                    @Override
                    protected BrandingSupport.BrandableModule findBrandableModule(String moduleCodeNameBase) {
                        return null;
                    }

                    @Override
                    public Set<File> getBrandableJars() {
                        return Collections.emptySet();
                    }

                    @Override
                    protected Set<BrandingSupport.BrandableModule> loadModules() throws IOException {
                        return null;
                    }

                    @Override
                    protected Map<String, String> localizingBundle(BrandingSupport.BrandableModule moduleEntry) {
                        return Collections.emptyMap();
                    }
                };
            }
        }
        return this.branding;
    }

    protected abstract BrandingSupport createBranding() throws IOException;

    public void init() {
        this.initBundleKeys();
        this.initName(false);
        this.initTitle(false);
        this.brandingEnabledRefresh();
    }

    public final void brandingEnabledRefresh() {
        this.brandingEnabled = this.isBrandingEnabledRefresh();
    }

    protected abstract boolean isBrandingEnabledRefresh();

    protected String getSimpleName() {
        if (this.mainWindowTitle == null) {
            return this.getProjectDirectoryFile().getName();
        }
        String res = this.mainWindowTitle.getValue();
        if (res.endsWith(" {0}")) {
            res = res.substring(0, res.lastIndexOf(" {0}"));
        }
        return res;
    }

    public final void initName(boolean reread) {
        if (this.name == null || reread) {
            this.name = this.loadName();
        }
        if (this.name == null) {
            this.name = this.getSimpleName().toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "_");
            if (!this.name.matches("[a-z][a-z0-9]*(_[a-z][a-z0-9]*)*")) {
                this.name = "app";
            }
        }
        assert (this.name != null);
    }

    protected abstract String loadName();

    public final void initTitle(boolean reread) {
        if (this.title == null || reread) {
            String initTitle = this.loadTitle();
            if (initTitle == null && Character.isLowerCase((initTitle = this.getSimpleName()).charAt(0))) {
                initTitle = String.valueOf(Character.toLowerCase(initTitle.charAt(0))) + initTitle.substring(1);
            }
            assert (initTitle != null);
            this.title = initTitle;
        }
    }

    protected abstract String loadTitle();

    private void initBundleKeys() {
        this.productInformation = this.getBranding().getBundleKey("org.netbeans.core", "org/netbeans/core/ui/Bundle.properties", "LBL_ProductInformation");
        this.mainWindowTitle = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/view/ui/Bundle.properties", "CTL_MainWindow_Title");
        this.splashWindowTitle = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "LBL_splash_window_title");
        this.mainWindowTitleNoProject = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/view/ui/Bundle.properties", "CTL_MainWindow_Title_No_Project");
        this.currentVersion = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "currentVersion");
        this.icon48 = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/frame48.gif");
        this.icon16 = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/frame.gif");
        this.icon32 = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/frame32.gif");
        this.splash = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/splash.gif");
        this.splashWidth = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SPLASH_WIDTH");
        this.splashHeight = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SPLASH_HEIGHT");
        this.splashShowProgressBar = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashShowProgressBar");
        this.splashRunningTextFontSize = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextFontSize");
        this.splashProgressBarBounds = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarBounds");
        this.splashRunningTextBounds = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextBounds");
        this.splashRunningTextColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextColor");
        this.splashProgressBarColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarColor");
        this.splashProgressBarEdgeColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarEdgeColor");
        this.splashProgressBarCornerColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarCornerColor");
        this.splashKeys.clear();
        if (this.splashWidth != null) {
            this.splashKeys.add(this.splashWidth);
        }
        if (this.splashHeight != null) {
            this.splashKeys.add(this.splashHeight);
        }
        if (this.splashShowProgressBar != null) {
            this.splashKeys.add(this.splashShowProgressBar);
        }
        if (this.splashRunningTextBounds != null) {
            this.splashKeys.add(this.splashRunningTextBounds);
        }
        if (this.splashProgressBarBounds != null) {
            this.splashKeys.add(this.splashProgressBarBounds);
        }
        if (this.splashRunningTextFontSize != null) {
            this.splashKeys.add(this.splashRunningTextFontSize);
        }
        if (this.splashRunningTextColor != null) {
            this.splashKeys.add(this.splashRunningTextColor);
        }
        if (this.splashProgressBarColor != null) {
            this.splashKeys.add(this.splashProgressBarColor);
        }
        if (this.splashProgressBarEdgeColor != null) {
            this.splashKeys.add(this.splashProgressBarEdgeColor);
        }
        if (this.splashProgressBarCornerColor != null) {
            this.splashKeys.add(this.splashProgressBarCornerColor);
        }
        this.splashKeys.remove(null);
        this.wsEnableClosingEditors = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "Editor.TopComponent.Closing.Enabled");
        this.wsEnableClosingViews = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "View.TopComponent.Closing.Enabled");
        this.wsEnableDragAndDrop = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.DragAndDrop.Enabled");
        this.wsEnableFloating = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.Undocking.Enabled");
        this.wsEnableMinimumSize = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "Splitter.Respect.MinimumSize.Enabled");
        this.wsEnableResizing = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.Resizing.Enabled");
        this.wsEnableSliding = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.Sliding.Enabled");
        this.wsEnableMaximization = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.Maximization.Enabled");
        this.wsEnableAutoSlideInMinimizedMode = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.Auto.Slide.In.Minimized.Mode.Enabled");
        this.wsEnableEditorModeUndocking = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "Mode.Editor.Undocking.Enabled");
        this.wsEnableModeClosing = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "Mode.Closing.Enabled");
        this.wsEnableEditorModeDnD = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "Mode.Editor.DragAndDrop.Enabled");
        this.wsEnableModeSliding = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "Mode.Sliding.Enabled");
        this.wsEnableViewModeDnD = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "Mode.View.DragAndDrop.Enabled");
        this.wsEnableViewModeUndocking = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "Mode.View.Undocking.Enabled");
        this.winsysKeys.clear();
        if (this.wsEnableClosingEditors != null) {
            this.winsysKeys.add(this.wsEnableClosingEditors);
        }
        if (this.wsEnableClosingViews != null) {
            this.winsysKeys.add(this.wsEnableClosingViews);
        }
        if (this.wsEnableDragAndDrop != null) {
            this.winsysKeys.add(this.wsEnableDragAndDrop);
        }
        if (this.wsEnableFloating != null) {
            this.winsysKeys.add(this.wsEnableFloating);
        }
        if (this.wsEnableMaximization != null) {
            this.winsysKeys.add(this.wsEnableMaximization);
        }
        if (this.wsEnableMinimumSize != null) {
            this.winsysKeys.add(this.wsEnableMinimumSize);
        }
        if (this.wsEnableResizing != null) {
            this.winsysKeys.add(this.wsEnableResizing);
        }
        if (this.wsEnableSliding != null) {
            this.winsysKeys.add(this.wsEnableSliding);
        }
        if (this.wsEnableAutoSlideInMinimizedMode != null) {
            this.winsysKeys.add(this.wsEnableAutoSlideInMinimizedMode);
        }
        if (this.wsEnableEditorModeUndocking != null) {
            this.winsysKeys.add(this.wsEnableEditorModeUndocking);
        }
        if (this.wsEnableModeClosing != null) {
            this.winsysKeys.add(this.wsEnableModeClosing);
        }
        if (this.wsEnableEditorModeDnD != null) {
            this.winsysKeys.add(this.wsEnableEditorModeDnD);
        }
        if (this.wsEnableModeSliding != null) {
            this.winsysKeys.add(this.wsEnableModeSliding);
        }
        if (this.wsEnableViewModeDnD != null) {
            this.winsysKeys.add(this.wsEnableViewModeDnD);
        }
        if (this.wsEnableViewModeUndocking != null) {
            this.winsysKeys.add(this.wsEnableViewModeUndocking);
        }
        this.winsysKeys.remove(null);
        this.generalResourceBundleKeys.clear();
        this.internationalizedResourceBundleKeys.clear();
    }

    private String backslashesToSlashes(String text) {
        return text.replace('\\', '/');
    }

    private BrandingSupport.BundleKey findInModifiedGeneralBundleKeys(String codenamebase, String bundlepath, String key) {
        for (BrandingSupport.BundleKey bundleKey : this.generalResourceBundleKeys) {
            if (!key.equals(bundleKey.getKey()) || !this.backslashesToSlashes(bundleKey.getBundleFilePath()).endsWith(bundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return bundleKey;
        }
        return null;
    }

    private BrandingSupport.BundleKey findInModifiedInternationalizedBundleKeys(String codenamebase, String bundlepath, String key) {
        for (BrandingSupport.BundleKey bundleKey : this.internationalizedResourceBundleKeys) {
            String localizedBundlepath = bundlepath;
            if (!localizedBundlepath.endsWith("_" + this.locale.toString() + ".properties")) {
                localizedBundlepath = bundlepath.replaceAll(".properties", "_" + this.locale.toString() + ".properties");
            }
            if (!key.equals(bundleKey.getKey()) || !this.backslashesToSlashes(bundleKey.getBundleFilePath()).endsWith(localizedBundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return bundleKey;
        }
        return null;
    }

    public final void addModifiedGeneralBundleKey(BrandingSupport.BundleKey key) {
        this.generalResourceBundleKeys.add(key);
    }

    public final void addModifiedInternationalizedBundleKey(BrandingSupport.BundleKey key) {
        File bundleFile;
        Set<BrandingSupport.BundleKey> brandedBundleKeys = this.branding.getBrandedBundleKeys();
        String localizedBundlepath = key.getBundleFilePath();
        if (!localizedBundlepath.endsWith("_" + this.locale.toString() + ".properties")) {
            localizedBundlepath = localizedBundlepath.replaceAll(".properties", "_" + this.locale.toString() + ".properties");
        }
        if (!(bundleFile = new File(localizedBundlepath)).exists()) {
            for (BrandingSupport.BundleKey keyIter : brandedBundleKeys) {
                if (!keyIter.getBundleFilePath().equals(key.getBundleFilePath()) || key.getKey().equals(keyIter.getKey())) continue;
                this.internationalizedResourceBundleKeys.add(this.branding.createModifiedBundleKey(keyIter.getModuleEntry(), bundleFile, keyIter.getKey(), keyIter.getValue()));
            }
        }
        this.internationalizedResourceBundleKeys.add(this.branding.createModifiedBundleKey(key.getModuleEntry(), bundleFile, key.getKey(), key.getValue()));
    }

    public final BrandingSupport.BundleKey getGeneralBundleKeyForModification(String codenamebase, String bundlepath, String key) {
        BrandingSupport.BundleKey bKey = this.findInModifiedGeneralBundleKeys(codenamebase, bundlepath, key);
        return null != bKey ? bKey : this.getBranding().getBundleKey(codenamebase, bundlepath, key);
    }

    public final String getKeyValue(String bundlepath, String codenamebase, String key) {
        BrandingSupport.BundleKey bKey = this.findInModifiedGeneralBundleKeys(codenamebase, bundlepath, key);
        return null != bKey ? bKey.getValue() : this.getBranding().getBundleKey(codenamebase, bundlepath, key).getValue();
    }

    public final BrandingSupport.BundleKey getGeneralLocalizedBundleKeyForModification(String codenamebase, String bundlepath, String key) {
        BrandingSupport.BundleKey bKey = this.findInModifiedInternationalizedBundleKeys(codenamebase, bundlepath, key);
        return null != bKey ? bKey : this.getBranding().getLocalizedBundleKey(codenamebase, bundlepath, key);
    }

    public final String getLocalizedKeyValue(String bundlepath, String codenamebase, String key) {
        BrandingSupport.BundleKey bKey = this.findInModifiedInternationalizedBundleKeys(codenamebase, bundlepath, key);
        return null != bKey ? bKey.getValue() : this.getBranding().getLocalizedBundleKey(codenamebase, bundlepath, key).getValue();
    }

    public final boolean isKeyBranded(String bundlepath, String codenamebase, String key) {
        if (this.inModifiedKeys(bundlepath, codenamebase, key)) {
            return true;
        }
        Set<BrandingSupport.BundleKey> bundleKeys = this.getBranding().getBrandedBundleKeys();
        for (BrandingSupport.BundleKey bundleKey : bundleKeys) {
            if (!key.equals(bundleKey.getKey()) || !this.backslashesToSlashes(bundleKey.getBundleFilePath()).endsWith(bundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    public final boolean isKeyLocallyBranded(String bundlepath, String codenamebase, String key) {
        if (this.inModifiedLocalizedKeys(bundlepath, codenamebase, key)) {
            return true;
        }
        Set<BrandingSupport.BundleKey> bundleKeys = this.getBranding().getLocalizedBrandedBundleKeys();
        for (BrandingSupport.BundleKey bundleKey : bundleKeys) {
            String bundleFilePath = bundleKey.getBundleFilePath();
            String localizedBundlepath = bundlepath;
            if (bundleFilePath.endsWith("_" + this.locale.toString() + ".properties")) {
                localizedBundlepath = bundlepath.replaceAll(".properties", "_" + this.locale.toString() + ".properties");
            }
            if (!key.equals(bundleKey.getKey()) || !this.backslashesToSlashes(bundleFilePath).endsWith(localizedBundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    private boolean inModifiedKeys(String bundlepath, String codenamebase, String key) {
        for (BrandingSupport.BundleKey bundleKey : this.generalResourceBundleKeys) {
            if (!key.equals(bundleKey.getKey()) || !this.backslashesToSlashes(bundleKey.getBundleFilePath()).endsWith(bundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    private boolean inModifiedLocalizedKeys(String bundlepath, String codenamebase, String key) {
        for (BrandingSupport.BundleKey bundleKey : this.internationalizedResourceBundleKeys) {
            String localizedBundlepath = bundlepath;
            if (!localizedBundlepath.endsWith("_" + this.locale.toString() + ".properties")) {
                localizedBundlepath = bundlepath.replaceAll(".properties", "_" + this.locale.toString() + ".properties");
            }
            if (!key.equals(bundleKey.getKey()) || !this.backslashesToSlashes(bundleKey.getBundleFilePath()).endsWith(localizedBundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    public final boolean isBundleBranded(String bundlepath, String codenamebase) {
        if (this.inModifiedKeysBundle(bundlepath, codenamebase)) {
            return true;
        }
        Set<BrandingSupport.BundleKey> bundleKeys = this.getBranding().getBrandedBundleKeys();
        for (BrandingSupport.BundleKey bundleKey : bundleKeys) {
            if (!this.backslashesToSlashes(bundleKey.getBundleFilePath()).endsWith(bundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    public final boolean isBundleLocallyBranded(String bundlepath, String codenamebase) {
        if (this.inModifiedLocalizedKeysBundle(bundlepath, codenamebase)) {
            return true;
        }
        Set<BrandingSupport.BundleKey> bundleKeys = this.getBranding().getLocalizedBrandedBundleKeys();
        for (BrandingSupport.BundleKey bundleKey : bundleKeys) {
            String bundleFilePath = bundleKey.getBundleFilePath();
            String localizedBundlepath = bundlepath;
            if (bundleFilePath.endsWith("_" + this.locale.toString() + ".properties")) {
                localizedBundlepath = bundlepath.replaceAll(".properties", "_" + this.locale.toString() + ".properties");
            }
            if (!this.backslashesToSlashes(bundleFilePath).endsWith(localizedBundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    private boolean inModifiedKeysBundle(String bundlepath, String codenamebase) {
        for (BrandingSupport.BundleKey bundleKey : this.generalResourceBundleKeys) {
            if (!this.backslashesToSlashes(bundleKey.getBundleFilePath()).endsWith(bundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    private boolean inModifiedLocalizedKeysBundle(String bundlepath, String codenamebase) {
        for (BrandingSupport.BundleKey bundleKey : this.internationalizedResourceBundleKeys) {
            String localizedBundlepath = bundlepath;
            if (!localizedBundlepath.endsWith("_" + this.locale.toString() + ".properties")) {
                localizedBundlepath = bundlepath.replaceAll(".properties", "_" + this.locale.toString() + ".properties");
            }
            if (!this.backslashesToSlashes(bundleKey.getBundleFilePath()).endsWith(localizedBundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getSplashWidth() {
        return this.splashWidth;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getSplashHeight() {
        return this.splashHeight;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getSplashShowProgressBar() {
        return this.splashShowProgressBar;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getSplashRunningTextBounds() {
        return this.splashRunningTextBounds;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getSplashProgressBarBounds() {
        return this.splashProgressBarBounds;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getSplashRunningTextFontSize() {
        return this.splashRunningTextFontSize;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getSplashRunningTextColor() {
        return this.splashRunningTextColor;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getSplashProgressBarColor() {
        return this.splashProgressBarColor;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getSplashProgressBarEdgeColor() {
        return this.splashProgressBarEdgeColor;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getSplashProgressBarCornerColor() {
        return this.splashProgressBarCornerColor;
    }

    @CheckForNull
    public final BrandingSupport.BrandedFile getSplash() {
        return this.splash;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableClosingEditors() {
        return this.wsEnableClosingEditors;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableClosingViews() {
        return this.wsEnableClosingViews;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableDragAndDrop() {
        return this.wsEnableDragAndDrop;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableFloating() {
        return this.wsEnableFloating;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableMaximization() {
        return this.wsEnableMaximization;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableMinimumSize() {
        return this.wsEnableMinimumSize;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableResizing() {
        return this.wsEnableResizing;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableSliding() {
        return this.wsEnableSliding;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableAutoSlideInMinimizedMode() {
        return this.wsEnableAutoSlideInMinimizedMode;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableEditorModeDnD() {
        return this.wsEnableEditorModeDnD;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableEditorModeUndocking() {
        return this.wsEnableEditorModeUndocking;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableModeClosing() {
        return this.wsEnableModeClosing;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableModeSliding() {
        return this.wsEnableModeSliding;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableViewModeDnD() {
        return this.wsEnableViewModeDnD;
    }

    @CheckForNull
    public final BrandingSupport.BundleKey getWsEnableViewModeUndocking() {
        return this.wsEnableViewModeUndocking;
    }

    public void doSave() {
        try {
            this.store();
        }
        catch (IOException ioE) {
            Exceptions.printStackTrace((Throwable)ioE);
        }
    }

    public void reloadProperties() {
    }

    public abstract void updateProjectInternationalizationLocales();

    public Locale getLocale() {
        return this.locale;
    }
}

