/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public final class CBJarResource {
    protected Hashtable contents = new Hashtable();
    protected Hashtable entries = new Hashtable();
    protected String zipFileName;
    protected ZipFile zipFile;
    private static Logger log = Logger.getLogger(CBJarResource.class.getName());

    public String getZipFileName() {
        return this.zipFileName;
    }

    public long getLastModified() {
        File zip = new File(this.zipFileName);
        if (zip == null) {
            return 0L;
        }
        return zip.lastModified();
    }

    public CBJarResource(String zipFileName) {
        this.zipFileName = zipFileName;
        this.init();
        log.fine("INITIALIZED JAR " + zipFileName);
    }

    public String toString() {
        return "CBJarResource (" + this.zipFileName + ")";
    }

    public boolean hasResource(String name) {
        return this.entries.containsKey(name);
    }

    public byte[] getResource(String name) throws ZipException {
        return this.getRawResource(name);
    }

    protected byte[] getRawResource(String name) throws ZipException {
        try {
            ZipEntry entry = (ZipEntry)this.entries.get(name);
            InputStream in = this.zipFile.getInputStream(entry);
            if (entry == null) {
                throw new ZipException("Unable to find: " + name + " in zip file " + this.zipFileName);
            }
            return this.readZipEntryData(in, entry);
        }
        catch (IOException e) {
            throw new ZipException("Error reading zip file: " + e);
        }
    }

    public Image getImage(String imageName, Toolkit imageCreator) throws ZipException {
        if (!this.hasResource(imageName)) {
            throw new ZipException("resource: " + imageName + " not found in zip file: " + this.zipFileName);
        }
        Image ret = imageCreator.createImage(this.getRawResource(imageName));
        return ret;
    }

    public InputStream getInputStream(String resourceName) throws ZipException {
        try {
            ZipEntry entry = (ZipEntry)this.entries.get(resourceName);
            InputStream in = this.zipFile.getInputStream(entry);
            return in;
        }
        catch (IOException e) {
            throw new ZipException("Error getting input stream: " + e.toString());
        }
    }

    protected void init() {
        try {
            this.zipFile = new ZipFile(this.zipFileName);
            Enumeration<? extends ZipEntry> e = this.zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String name = ze.getName();
                log.fine("added zip entry: " + name);
                this.entries.put(name, ze);
                if (!name.endsWith("Editor") && !name.endsWith("editor")) continue;
                log.fine("double loading " + name.toLowerCase());
                this.entries.put(name.toLowerCase(), ze);
            }
        }
        catch (NullPointerException e) {
            log.warning("unable to init zip file " + this.zipFileName + " - no entries?");
        }
        catch (FileNotFoundException e) {
            log.log(Level.WARNING, "can't find zip file", e);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "error reading zip file", e);
        }
    }

    protected byte[] readZipEntryData(InputStream is, ZipEntry ze) throws IOException {
        int size = (int)ze.getSize();
        if (size == -1) {
            log.warning("bizarre size error in zip entry reading = corrupt zip file?");
            return null;
        }
        byte[] b = new byte[size];
        int rb = 0;
        int chunk = 0;
        while (size - rb > 0 && (chunk = is.read(b, rb, size - rb)) != -1) {
            rb += chunk;
        }
        return b;
    }

    protected String dumpZipEntry(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("dir:  ");
        } else {
            sb.append("file: ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("deflated ");
        }
        sb.append(ze.getName());
        sb.append("\t\t");
        sb.append("" + ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        CBJarResource jr;
        byte[] buff;
        if (args.length != 2) {
            System.out.println("usage: java CBJarResources <jar file name> <resource name>");
            System.exit(1);
        }
        if ((buff = (jr = new CBJarResource(args[0])).getResource(args[1])) == null) {
            System.out.println("Could not find " + args[1] + ".");
        } else {
            System.out.println("Found " + args[1] + " (length=" + buff.length + ").");
        }
    }

    protected void finalize() {
        try {
            this.zipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getPrefixedResources(String prefix) {
        prefix = prefix.toLowerCase();
        Vector<String> results = new Vector<String>();
        Enumeration keys = this.entries.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            if (!name.toLowerCase().startsWith(prefix)) continue;
            results.add(name);
        }
        if (results.size() == 0) {
            return new String[0];
        }
        return results.toArray(new String[results.size()]);
    }
}

