/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.net.URI;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.jd.gui.api.feature.ContentSearchable;
import org.jd.gui.api.feature.LineNumberNavigable;
import org.jd.gui.api.feature.PreferencesChangeListener;
import org.jd.gui.api.feature.UriOpenable;
import org.jd.gui.view.component.ErrorStrip;

public class AbstractTextPage
extends JPanel
implements LineNumberNavigable,
ContentSearchable,
UriOpenable,
PreferencesChangeListener,
GroovyObject {
    protected static final String FONT_SIZE_KEY = "ViewerPreferences.fontSize";
    protected static final ImageIcon COLLAPSED_ICON;
    protected static final ImageIcon EXPANDED_ICON;
    protected static final Color DOUBLE_CLICK_HIGHLIGHT_COLOR;
    protected static final Color SEARCH_HIGHLIGHT_COLOR;
    protected static final Color SELECT_HIGHLIGHT_COLOR;
    protected static final RSyntaxTextAreaEditorKit.DecreaseFontSizeAction DECREASE_FONT_SIZE_ACTION;
    protected static final RSyntaxTextAreaEditorKit.IncreaseFontSizeAction INCREASE_FONT_SIZE_ACTION;
    protected RSyntaxTextArea textArea;
    protected RTextScrollPane scrollPane;
    protected Map<String, String> preferences;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public AbstractTextPage() {
        super(new BorderLayout());
        RTextScrollPane rTextScrollPane;
        RSyntaxTextArea rSyntaxTextArea;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.textArea = rSyntaxTextArea = this.newRSyntaxTextArea();
        this.textArea.setSyntaxEditingStyle(this.getSyntaxStyle());
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setAntiAliasingEnabled(true);
        int n = 0;
        this.textArea.setCaretPosition(n);
        boolean bl = false;
        this.textArea.setEditable(bl);
        Object var5_5 = null;
        this.textArea.setDropTarget((DropTarget)ScriptBytecodeAdapter.castToType(var5_5, DropTarget.class));
        Object var6_6 = null;
        this.textArea.setPopupMenu((JPopupMenu)ScriptBytecodeAdapter.castToType(var6_6, JPopupMenu.class));
        this.textArea.addMouseListener((MouseListener)((Object)new GroovyObject(this){
            public /* synthetic */ AbstractTextPage this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                AbstractTextPage abstractTextPage;
                this.this$0 = abstractTextPage = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Color color = DOUBLE_CLICK_HIGHLIGHT_COLOR;
                    ((RSyntaxTextArea)this.getProperty("textArea")).setMarkAllHighlightColor(color);
                    SearchEngine.markAll((RTextArea)ScriptBytecodeAdapter.castToType(this.getProperty("textArea"), RTextArea.class), this.this$0.newSearchContext(((RSyntaxTextArea)this.getProperty("textArea")).getSelectedText(), true, true, true, false));
                }
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$5(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, AbstractTextPage.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$5(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty(object, null, AbstractTextPage.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$5(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, AbstractTextPage.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty(this, string);
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty(this, string, object);
            }
        }));
        KeyStroke ctrlA = KeyStroke.getKeyStroke(KeyEvent.VK_A, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        KeyStroke ctrlC = KeyStroke.getKeyStroke(KeyEvent.VK_C, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        KeyStroke ctrlV = KeyStroke.getKeyStroke(KeyEvent.VK_V, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        InputMap inputMap = this.textArea.getInputMap();
        inputMap.put(ctrlA, "none");
        inputMap.put(ctrlC, "none");
        inputMap.put(ctrlV, "none");
        Theme theme = Theme.load(this.getClass().getClassLoader().getResourceAsStream("rsyntaxtextarea/themes/eclipse.xml"));
        theme.apply(this.textArea);
        this.scrollPane = rTextScrollPane = new RTextScrollPane(this.textArea);
        boolean bl2 = true;
        this.scrollPane.setFoldIndicatorEnabled(bl2);
        Font font = this.textArea.getFont();
        this.scrollPane.setFont(font);
        Reference<MouseWheelListener[]> mouseWheelListeners = new Reference<MouseWheelListener[]>(this.scrollPane.getMouseWheelListeners());
        MouseWheelListener listener2 = null;
        MouseWheelListener[] mouseWheelListenerArray = mouseWheelListeners.get();
        if (mouseWheelListenerArray != null) {
            for (MouseWheelListener listener2 : mouseWheelListenerArray) {
                this.scrollPane.removeMouseWheelListener(listener2);
            }
        }
        this.scrollPane.addMouseWheelListener(new MouseWheelListener(this, mouseWheelListeners){
            public /* synthetic */ Reference mouseWheelListeners;
            public /* synthetic */ AbstractTextPage this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                AbstractTextPage abstractTextPage;
                this.this$0 = abstractTextPage = p0;
                this.mouseWheelListeners = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if ((e.getModifiers() & (Event.META_MASK | Event.CTRL_MASK)) != 0) {
                    int n;
                    int x = e.getX() + ((RTextScrollPane)this.getProperty("scrollPane")).getX() - ((RSyntaxTextArea)this.getProperty("textArea")).getX();
                    int y = e.getY() + ((RTextScrollPane)this.getProperty("scrollPane")).getY() - ((RSyntaxTextArea)this.getProperty("textArea")).getY();
                    int offset = ((RSyntaxTextArea)this.getProperty("textArea")).viewToModel(new Point(x, y));
                    if (e.getWheelRotation() > 0) {
                        INCREASE_FONT_SIZE_ACTION.actionPerformedImpl(null, (RTextArea)ScriptBytecodeAdapter.castToType(this.getProperty("textArea"), RTextArea.class));
                    } else {
                        DECREASE_FONT_SIZE_ACTION.actionPerformedImpl(null, (RTextArea)ScriptBytecodeAdapter.castToType(this.getProperty("textArea"), RTextArea.class));
                    }
                    if (DefaultTypeTransformation.booleanUnbox(this.getProperty("preferences"))) {
                        ((Map)this.getProperty("preferences")).put(FONT_SIZE_KEY, String.valueOf(((RSyntaxTextArea)this.getProperty("textArea")).getFont().getSize()));
                    }
                    Rectangle newRectangle = ((RSyntaxTextArea)this.getProperty("textArea")).modelToView(offset);
                    int newY = newRectangle.y + (newRectangle.height >> 1);
                    Point viewPosition = ((RTextScrollPane)this.getProperty("scrollPane")).getViewport().getViewPosition();
                    viewPosition.y = n = Math.max(viewPosition.y + newY - y, 0);
                    Point point = viewPosition;
                    ((RTextScrollPane)this.getProperty("scrollPane")).getViewport().setViewPosition(point);
                } else {
                    MouseWheelListener listener2 = null;
                    Object t = this.mouseWheelListeners.get();
                    MouseWheelListener[] mouseWheelListenerArray = (MouseWheelListener[])ScriptBytecodeAdapter.castToType(t, MouseWheelListener[].class);
                    if (t != null) {
                        for (MouseWheelListener listener2 : mouseWheelListenerArray) {
                            listener2.mouseWheelMoved(e);
                        }
                    }
                }
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$5(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(2.class, AbstractTextPage.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$5(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty(object, null, AbstractTextPage.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$5(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(2.class, AbstractTextPage.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 2.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty(this, string);
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty(this, string, object);
            }
        });
        Gutter gutter = this.scrollPane.getGutter();
        gutter.setFoldIcons(COLLAPSED_ICON, EXPANDED_ICON);
        Color color = gutter.getBorderColor();
        gutter.setFoldIndicatorForeground(color);
        this.add((Component)this.scrollPane, BorderLayout.CENTER);
        this.add((Component)new ErrorStrip(this.textArea), BorderLayout.LINE_END);
    }

    protected RSyntaxTextArea newRSyntaxTextArea() {
        return new RSyntaxTextArea();
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String text) {
        String string = text;
        this.textArea.setText(string);
        int n = 0;
        this.textArea.setCaretPosition(n);
    }

    public String getSyntaxStyle() {
        return SyntaxConstants.SYNTAX_STYLE_NONE;
    }

    public void setCaretPositionAndCenter(DocumentRange range) {
        block7: {
            Reference<Integer> start = new Reference<Integer>(range.getStartOffset());
            Reference<Integer> end = new Reference<Integer>(range.getEndOffset());
            boolean foldsExpanded = false;
            FoldManager fm = this.textArea.getFoldManager();
            if (fm.isCodeFoldingSupportedAndEnabled()) {
                boolean bl;
                foldsExpanded = bl = fm.ensureOffsetNotInClosedFold(start.get());
                Boolean bl2 = DefaultGroovyMethods.or(foldsExpanded, fm.ensureOffsetNotInClosedFold(end.get()));
                foldsExpanded = DefaultTypeTransformation.booleanUnbox(bl2);
            }
            if (!foldsExpanded) {
                try {
                    Reference<Rectangle> r = new Reference<Rectangle>(this.textArea.modelToView(start.get()));
                    if (DefaultTypeTransformation.booleanUnbox(r.get())) {
                        this.setCaretPositionAndCenter(start.get(), end.get(), r.get());
                        break block7;
                    }
                    SwingUtilities.invokeLater(new Runnable(this, r, start, end){
                        public /* synthetic */ Reference end;
                        public /* synthetic */ Reference start;
                        public /* synthetic */ Reference r;
                        public /* synthetic */ AbstractTextPage this$0;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private transient /* synthetic */ MetaClass metaClass;
                        {
                            MetaClass metaClass;
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            AbstractTextPage abstractTextPage;
                            this.this$0 = abstractTextPage = p0;
                            this.end = reference3 = p3;
                            this.start = reference2 = p2;
                            this.r = reference = p1;
                            this.metaClass = metaClass = this.$getStaticMetaClass();
                        }

                        @Override
                        public void run() {
                            Rectangle rectangle = ((RSyntaxTextArea)this.getProperty("textArea")).modelToView(DefaultTypeTransformation.intUnbox(this.start.get()));
                            this.r.set(rectangle);
                            if (DefaultTypeTransformation.booleanUnbox(this.r.get())) {
                                this.this$0.setCaretPositionAndCenter(DefaultTypeTransformation.intUnbox(this.start.get()), DefaultTypeTransformation.intUnbox(this.end.get()), (Rectangle)ScriptBytecodeAdapter.castToType(this.r.get(), Rectangle.class));
                            }
                        }

                        public /* synthetic */ Object methodMissing(String name, Object args) {
                            return this.this$0.this$dist$invoke$5(name, args);
                        }

                        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                            return ScriptBytecodeAdapter.invokeMethodN(3.class, AbstractTextPage.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
                        }

                        public /* synthetic */ void propertyMissing(String name, Object val) {
                            this.this$0.this$dist$set$5(name, val);
                        }

                        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                            Object object = val;
                            ScriptBytecodeAdapter.setProperty(object, null, AbstractTextPage.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                        }

                        public /* synthetic */ Object propertyMissing(String name) {
                            return this.this$0.this$dist$get$5(name);
                        }

                        public static /* synthetic */ Object $static_propertyMissing(String name) {
                            return ScriptBytecodeAdapter.getProperty(3.class, AbstractTextPage.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (this.getClass() != 3.class) {
                                return ScriptBytecodeAdapter.initMetaClass(this);
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        @Override
                        @Generated
                        @Internal
                        public /* synthetic */ MetaClass getMetaClass() {
                            MetaClass metaClass = this.metaClass;
                            if (metaClass != null) {
                                return metaClass;
                            }
                            this.metaClass = this.$getStaticMetaClass();
                            return this.metaClass;
                        }

                        @Override
                        @Generated
                        @Internal
                        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                            this.metaClass = metaClass;
                        }

                        @Override
                        @Generated
                        @Internal
                        public /* synthetic */ Object invokeMethod(String string, Object object) {
                            return this.getMetaClass().invokeMethod((Object)this, string, object);
                        }

                        @Override
                        @Generated
                        @Internal
                        public /* synthetic */ Object getProperty(String string) {
                            return this.getMetaClass().getProperty(this, string);
                        }

                        @Override
                        @Generated
                        @Internal
                        public /* synthetic */ void setProperty(String string, Object object) {
                            this.getMetaClass().setProperty(this, string, object);
                        }
                    });
                }
                catch (BadLocationException ignore) {
                }
            }
        }
    }

    protected void setCaretPositionAndCenter(int start, int end, Rectangle r) {
        int n;
        int n2;
        if (end != start) {
            Rectangle rectangle;
            r = rectangle = r.union(this.textArea.modelToView(end));
        }
        Rectangle visible = this.textArea.getVisibleRect();
        visible.y = n2 = DefaultTypeTransformation.intUnbox(ScriptBytecodeAdapter.asType(NumberNumberMinus.minus(r.y, NumberNumberDiv.div(visible.height - r.height, 2)), Integer.TYPE));
        Rectangle bounds = this.textArea.getBounds();
        Insets i = this.textArea.getInsets();
        bounds.y = n = i.top;
        bounds.height = bounds.height - (i.top + i.bottom);
        if (visible.y < bounds.y) {
            int n3;
            visible.y = n3 = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            int n4;
            visible.y = n4 = bounds.y + bounds.height - visible.height;
        }
        this.textArea.scrollRectToVisible(visible);
        int n5 = start;
        this.textArea.setCaretPosition(n5);
    }

    @Override
    public int getMaximumLineNumber() {
        return this.textArea.getLineOfOffset(this.textArea.getDocument().getLength()) + 1;
    }

    @Override
    public void goToLineNumber(int lineNumber) {
        int n = this.textArea.getLineStartOffset(lineNumber - 1);
        this.textArea.setCaretPosition(n);
    }

    @Override
    public boolean checkLineNumber(int lineNumber) {
        return true;
    }

    @Override
    public boolean highlightText(String text, boolean caseSensitive) {
        if (text.length() > 1) {
            Color color = SEARCH_HIGHLIGHT_COLOR;
            this.textArea.setMarkAllHighlightColor(color);
            int n = this.textArea.getSelectionStart();
            this.textArea.setCaretPosition(n);
            SearchContext context = this.newSearchContext(text, caseSensitive, false, true, false);
            SearchResult result = SearchEngine.find(this.textArea, context);
            if (!result.wasFound()) {
                SearchResult searchResult;
                int n2 = 0;
                this.textArea.setCaretPosition(n2);
                result = searchResult = SearchEngine.find(this.textArea, context);
            }
            return result.wasFound();
        }
        return true;
    }

    @Override
    public void findNext(String text, boolean caseSensitive) {
        if (text.length() > 1) {
            Color color = SEARCH_HIGHLIGHT_COLOR;
            this.textArea.setMarkAllHighlightColor(color);
            SearchContext context = this.newSearchContext(text, caseSensitive, false, true, false);
            SearchResult result = SearchEngine.find(this.textArea, context);
            if (!result.wasFound()) {
                int n = 0;
                this.textArea.setCaretPosition(n);
                SearchEngine.find(this.textArea, context);
            }
        }
    }

    @Override
    public void findPrevious(String text, boolean caseSensitive) {
        if (text.length() > 1) {
            Color color = SEARCH_HIGHLIGHT_COLOR;
            this.textArea.setMarkAllHighlightColor(color);
            SearchContext context = this.newSearchContext(text, caseSensitive, false, false, false);
            SearchResult result = SearchEngine.find(this.textArea, context);
            if (!result.wasFound()) {
                int n = this.textArea.getDocument().getLength();
                this.textArea.setCaretPosition(n);
                SearchEngine.find(this.textArea, context);
            }
        }
    }

    protected SearchContext newSearchContext(String searchFor, boolean matchCase, boolean wholeWord, boolean searchForward, boolean regexp) {
        SearchContext context = new SearchContext(searchFor, matchCase);
        boolean bl = true;
        context.setMarkAll(bl);
        boolean bl2 = wholeWord;
        context.setWholeWord(bl2);
        boolean bl3 = searchForward;
        context.setSearchForward(bl3);
        boolean bl4 = regexp;
        context.setRegularExpression(bl4);
        return context;
    }

    @Override
    public boolean openUri(URI uri) {
        String query = uri.getQuery();
        if (DefaultTypeTransformation.booleanUnbox(query)) {
            Map<String, String> parameters = this.parseQuery(query);
            if (parameters.containsKey("lineNumber")) {
                String lineNumber = ShortTypeHandling.castToString(parameters.get("lineNumber"));
                if (StringGroovyMethods.isNumber((CharSequence)lineNumber)) {
                    this.goToLineNumber(StringGroovyMethods.toInteger((CharSequence)lineNumber));
                    return true;
                }
            } else if (parameters.containsKey("position")) {
                String position = ShortTypeHandling.castToString(parameters.get("position"));
                if (StringGroovyMethods.isNumber((CharSequence)position)) {
                    int pos = StringGroovyMethods.toInteger((CharSequence)position);
                    if (this.textArea.getDocument().getLength() > pos) {
                        this.setCaretPositionAndCenter(new DocumentRange(pos, pos));
                        return true;
                    }
                }
            } else if (parameters.containsKey("highlightFlags")) {
                String highlightFlags = ShortTypeHandling.castToString(parameters.get("highlightFlags"));
                if (ScriptBytecodeAdapter.compareNotEqual(highlightFlags.indexOf("s"), -1) && parameters.containsKey("highlightPattern")) {
                    Color color = SELECT_HIGHLIGHT_COLOR;
                    this.textArea.setMarkAllHighlightColor(color);
                    int n = 0;
                    this.textArea.setCaretPosition(n);
                    String searchFor = AbstractTextPage.createRegExp(ShortTypeHandling.castToString(parameters.get("highlightPattern")));
                    SearchContext context = this.newSearchContext(searchFor, true, false, true, true);
                    SearchResult result = SearchEngine.find(this.textArea, context);
                    if (DefaultTypeTransformation.booleanUnbox(result.getMatchRange())) {
                        int n2 = result.getMatchRange().getStartOffset();
                        this.textArea.setCaretPosition(n2);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected Map<String, String> parseQuery(String query) {
        LinkedHashMap parameters = (LinkedHashMap)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.createMap(new Object[0]), LinkedHashMap.class);
        String param2 = null;
        String[] stringArray = query.split("&");
        if (stringArray != null) {
            for (String param2 : stringArray) {
                int index = param2.indexOf("=");
                if (ScriptBytecodeAdapter.compareEqual(index, -1)) {
                    parameters.put(URLDecoder.decode(param2, "UTF-8"), "");
                    continue;
                }
                String key = param2.substring(0, index);
                String value = param2.substring(index + 1);
                parameters.put(URLDecoder.decode(key, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
            }
        }
        return parameters;
    }

    public static String createRegExp(String pattern) {
        int patternLength = pattern.length();
        StringBuffer sbPattern = new StringBuffer(patternLength * 2);
        int i = 0;
        while (i < patternLength) {
            char c = pattern.charAt(i);
            if (c == '*') {
                sbPattern.append(".*");
            } else if (c == '?') {
                sbPattern.append(".");
            } else if (c == '.') {
                sbPattern.append("\\.");
            } else {
                sbPattern.append(c);
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return sbPattern.toString();
    }

    @Override
    public void preferencesChanged(Map<String, String> preferences) {
        String fontSize = ShortTypeHandling.castToString(preferences.get(FONT_SIZE_KEY));
        if (DefaultTypeTransformation.booleanUnbox(fontSize)) {
            try {
                Font font = this.textArea.getFont().deriveFont(Float.parseFloat(fontSize));
                this.textArea.setFont(font);
            }
            catch (Exception ignore) {
            }
        }
        Map<String, String> map = preferences;
        this.preferences = map;
    }

    public /* synthetic */ Object this$dist$invoke$5(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractTextPage.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$5(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, AbstractTextPage.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$5(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AbstractTextPage.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractTextPage.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty(this, string);
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty(this, string, object);
    }

    static {
        RSyntaxTextAreaEditorKit.IncreaseFontSizeAction increaseFontSizeAction;
        RSyntaxTextAreaEditorKit.DecreaseFontSizeAction decreaseFontSizeAction;
        Color color;
        Color color2;
        Color color3;
        ImageIcon imageIcon;
        ImageIcon imageIcon2;
        COLLAPSED_ICON = imageIcon2 = new ImageIcon(AbstractTextPage.class.getClassLoader().getResource("org/jd/gui/images/plus.png"));
        EXPANDED_ICON = imageIcon = new ImageIcon(AbstractTextPage.class.getClassLoader().getResource("org/jd/gui/images/minus.png"));
        DOUBLE_CLICK_HIGHLIGHT_COLOR = color3 = new Color(0x66FF66);
        SEARCH_HIGHLIGHT_COLOR = color2 = new Color(0xFFFF66);
        SELECT_HIGHLIGHT_COLOR = color = new Color(16029712);
        DECREASE_FONT_SIZE_ACTION = decreaseFontSizeAction = new RSyntaxTextAreaEditorKit.DecreaseFontSizeAction();
        INCREASE_FONT_SIZE_ACTION = increaseFontSizeAction = new RSyntaxTextAreaEditorKit.IncreaseFontSizeAction();
    }
}

