/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.util;

import jd.core.model.instruction.bytecode.ByteCodeConstants;

public class ByteCodeUtil {
    public static int NextTableSwitchOffset(byte[] code, int index) {
        int i = index + 4 & 0xFFFC;
        int low = (code[i += 4] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
        int high = (code[i += 4] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
        i += 4;
        return (i += 4 * (high - low + 1)) - 1;
    }

    public static int NextLookupSwitchOffset(byte[] code, int index) {
        int i = index + 4 & 0xFFFC;
        int npairs = (code[i += 4] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
        i += 4;
        return (i += 8 * npairs) - 1;
    }

    public static int NextWideOffset(byte[] code, int index) {
        int opcode = code[index + 1] & 0xFF;
        return index + (opcode == 132 ? 5 : 3);
    }

    public static int NextInstructionOffset(byte[] code, int index) {
        int opcode = code[index] & 0xFF;
        switch (opcode) {
            case 170: {
                return ByteCodeUtil.NextTableSwitchOffset(code, index);
            }
            case 171: {
                return ByteCodeUtil.NextLookupSwitchOffset(code, index);
            }
            case 196: {
                return ByteCodeUtil.NextWideOffset(code, index);
            }
        }
        return index + 1 + ByteCodeConstants.NO_OF_OPERANDS[opcode];
    }

    public static boolean JumpTo(byte[] code, int offset, int targetOffset) {
        if (offset != -1) {
            int codeLength = code.length;
            int i = 0;
            while (i < 10) {
                if (offset == targetOffset) {
                    return true;
                }
                if (offset >= codeLength) break;
                int opcode = code[offset] & 0xFF;
                if (opcode == 167) {
                    offset += (short)((code[offset + 1] & 0xFF) << 8 | code[offset + 2] & 0xFF);
                } else {
                    if (opcode != 200) break;
                    offset += (code[offset + 1] & 0xFF) << 24 | (code[offset + 2] & 0xFF) << 16 | (code[offset + 3] & 0xFF) << 8 | code[offset + 4] & 0xFF;
                }
                ++i;
            }
        }
        return false;
    }
}

