/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.List;
import java.util.Stack;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.ByteCodeConstants;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayStoreInstructionFactory
extends InstructionFactory {
    private String signature;

    public ArrayStoreInstructionFactory(String signature) {
        this.signature = signature;
    }

    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Stack<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        Instruction valueref = stack.pop();
        Instruction index = stack.pop();
        Instruction arrayref = stack.pop();
        ArrayStoreInstruction instruction = new ArrayStoreInstruction(272, offset, lineNumber, arrayref, index, this.signature, valueref);
        list.add(instruction);
        listForAnalyze.add(instruction);
        return ByteCodeConstants.NO_OF_OPERANDS[opcode];
    }
}

