/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile;

import jd.core.model.reference.ReferenceMap;
import jd.core.util.CharArrayUtil;
import jd.core.util.SignatureFormatException;

public class SignatureAnalyzer {
    public static void AnalyzeClassSignature(ReferenceMap referenceMap, String signature) {
        try {
            char[] caSignature = signature.toCharArray();
            int length = caSignature.length;
            int index = 0;
            index = SignatureAnalyzer.AnalyzeGenerics(referenceMap, caSignature, length, index);
            index = SignatureAnalyzer.AnalyzeSignature(referenceMap, caSignature, length, index);
            while (index < signature.length()) {
                index = SignatureAnalyzer.AnalyzeSignature(referenceMap, caSignature, length, index);
            }
        }
        catch (RuntimeException e) {
            System.err.println("SignatureAnalyzer.AnalyzeClassSignature: Infinite loop, signature=" + signature);
            throw e;
        }
    }

    public static void AnalyzeMethodSignature(ReferenceMap referenceMap, String signature) {
        try {
            char[] caSignature = signature.toCharArray();
            int length = caSignature.length;
            int index = 0;
            index = SignatureAnalyzer.AnalyzeGenerics(referenceMap, caSignature, length, index);
            if (caSignature[index] != '(') {
                throw new SignatureFormatException(signature);
            }
            ++index;
            while (caSignature[index] != ')') {
                index = SignatureAnalyzer.AnalyzeSignature(referenceMap, caSignature, length, index);
            }
            SignatureAnalyzer.AnalyzeSignature(referenceMap, caSignature, length, ++index);
        }
        catch (RuntimeException e) {
            System.err.println("SignatureAnalyzer.AnalyzeMethodSignature: Infinite loop, signature=" + signature);
            throw e;
        }
    }

    public static void AnalyzeSimpleSignature(ReferenceMap referenceMap, String signature) {
        try {
            char[] caSignature = signature.toCharArray();
            SignatureAnalyzer.AnalyzeSignature(referenceMap, caSignature, caSignature.length, 0);
        }
        catch (RuntimeException e) {
            System.err.println("SignatureAnalyzer.AnalyzeSimpleSignature: Infinite loop, signature=" + signature);
            throw e;
        }
    }

    private static int AnalyzeGenerics(ReferenceMap referenceMap, char[] caSignature, int length, int index) {
        if (caSignature[index] == '<') {
            ++index;
            while (index < length) {
                if (caSignature[index = CharArrayUtil.IndexOf(caSignature, ':', index) + 1] == ':') {
                    ++index;
                }
                if (caSignature[index = SignatureAnalyzer.AnalyzeSignature(referenceMap, caSignature, length, index)] == '>') break;
            }
            ++index;
        }
        return index;
    }

    private static int AnalyzeSignature(ReferenceMap referenceMap, char[] caSignature, int length, int index) {
        block14: {
            int debugCounter = 0;
            do {
                if (caSignature[index] == '[') {
                    while (++index < length) {
                        if (caSignature[index] == 'L' && index + 1 < length && caSignature[index + 1] == '[') {
                            ++index;
                            --length;
                            continue;
                        }
                        if (caSignature[index] != '[') break;
                    }
                }
                switch (caSignature[index]) {
                    case '.': 
                    case 'L': {
                        boolean classFlag = caSignature[index] == 'L';
                        int beginIndex = ++index;
                        int c = 46;
                        while (index < length) {
                            c = caSignature[index];
                            if (c == 59 || c == 60) break;
                            ++index;
                        }
                        if (classFlag) {
                            referenceMap.add(CharArrayUtil.Substring(caSignature, beginIndex, index));
                        }
                        if (c == 60) {
                            ++index;
                            while (caSignature[index] != '>') {
                                index = SignatureAnalyzer.AnalyzeSignature(referenceMap, caSignature, length, index);
                            }
                            ++index;
                        }
                        if (caSignature[index] != ';') break;
                        ++index;
                        break;
                    }
                    case '+': 
                    case '-': {
                        index = SignatureAnalyzer.AnalyzeSignature(referenceMap, caSignature, length, index + 1);
                        break;
                    }
                    case 'T': {
                        index = CharArrayUtil.IndexOf(caSignature, ';', index + 1) + 1;
                        break;
                    }
                    case '*': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'V': 
                    case 'Z': {
                        ++index;
                    }
                }
                if (index >= length || caSignature[index] != '.') break block14;
            } while (++debugCounter <= 3000);
            throw new RuntimeException("Infinite loop");
        }
        return index;
    }
}

