/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.api.JadxArgs;
import jadx.core.deobf.Deobfuscator;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.files.FileUtils;
import jadx.core.utils.files.InputFile;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class RenameVisitor
extends AbstractVisitor {
    private Deobfuscator deobfuscator;

    @Override
    public void init(RootNode root) {
        List<DexNode> dexNodes = root.getDexNodes();
        if (dexNodes.isEmpty()) {
            return;
        }
        InputFile firstInputFile = dexNodes.get(0).getDexFile().getInputFile();
        String firstInputFileName = firstInputFile.getFile().getAbsolutePath();
        String inputPath = FilenameUtils.getFullPathNoEndSeparator((String)firstInputFileName);
        String inputName = FilenameUtils.getBaseName((String)firstInputFileName);
        File deobfMapFile = new File(inputPath, inputName + ".jobf");
        JadxArgs args = root.getArgs();
        this.deobfuscator = new Deobfuscator(args, dexNodes, deobfMapFile);
        boolean deobfuscationOn = args.isDeobfuscationOn();
        if (deobfuscationOn) {
            this.deobfuscator.execute();
        }
        boolean isCaseSensitive = FileUtils.isCaseSensitiveFS(new File(inputPath));
        this.checkClasses(root, isCaseSensitive);
    }

    private void checkClasses(RootNode root, boolean caseSensitive) {
        HashSet<String> clsNames = new HashSet<String>();
        for (ClassNode cls : root.getClasses(true)) {
            ClassInfo classInfo;
            String clsFileName;
            this.checkClassName(cls);
            this.checkFields(cls);
            this.checkMethods(cls);
            if (caseSensitive || clsNames.add((clsFileName = (classInfo = cls.getClassInfo()).getAlias().getFullPath()).toLowerCase())) continue;
            String newShortName = this.deobfuscator.getClsAlias(cls);
            String newFullName = classInfo.makeFullClsName(newShortName, true);
            classInfo.rename(cls.root(), newFullName);
            clsNames.add(classInfo.getAlias().getFullPath().toLowerCase());
        }
    }

    private void checkClassName(ClassNode cls) {
        ClassInfo classInfo = cls.getClassInfo();
        ClassInfo alias = classInfo.getAlias();
        String clsName = alias.getShortName();
        String newShortName = null;
        char firstChar = clsName.charAt(0);
        if (Character.isDigit(firstChar)) {
            newShortName = "AnonymousClass" + clsName;
        } else if (firstChar == '$') {
            newShortName = "C" + clsName;
        }
        if (newShortName != null) {
            classInfo.rename(cls.root(), alias.makeFullClsName(newShortName, true));
        }
        if (alias.getPackage().isEmpty()) {
            String fullName = alias.makeFullClsName(alias.getShortName(), true);
            String newFullName = "defpackage." + fullName;
            classInfo.rename(cls.root(), newFullName);
        }
    }

    private void checkFields(ClassNode cls) {
        HashSet<String> names = new HashSet<String>();
        for (FieldNode field : cls.getFields()) {
            FieldInfo fieldInfo = field.getFieldInfo();
            String fieldName = fieldInfo.getAlias();
            if (names.add(fieldName) && NameMapper.isValidIdentifier(fieldName)) continue;
            this.deobfuscator.forceRenameField(field);
        }
    }

    private void checkMethods(ClassNode cls) {
        HashSet<String> names = new HashSet<String>();
        for (MethodNode mth : cls.getMethods()) {
            String signature;
            AccessInfo accessFlags = mth.getAccessFlags();
            if (accessFlags.isConstructor() || accessFlags.isBridge() || accessFlags.isSynthetic() || mth.contains(AFlag.DONT_GENERATE) || names.add(signature = mth.getMethodInfo().makeSignature(false)) && NameMapper.isValidIdentifier(mth.getAlias())) continue;
            this.deobfuscator.forceRenameMethod(mth);
        }
    }
}

