(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/text/csv#+line-endings+
    (cons std/misc/string#+cr+
          (cons std/misc/string#+lf+ (cons std/misc/string#+crlf+ '()))))
  (define std/text/csv#+strict-line-endings+
    (cons std/misc/string#+crlf+ (cons std/misc/string#+lf+ '())))
  (define std/text/csv#csv-separator (make-parameter '#\,))
  (define std/text/csv#csv-quote (make-parameter '#\"))
  (define std/text/csv#csv-unquoted-quotequote? (make-parameter '#f))
  (define std/text/csv#csv-loose-quote? (make-parameter '#f))
  (define std/text/csv#csv-skip-whitespace? (make-parameter '#t))
  (define std/text/csv#csv-allow-binary? (make-parameter '#t))
  (define std/text/csv#csv-eol (make-parameter std/misc/string#+crlf+))
  (define std/text/csv#csv-line-endings
    (make-parameter std/text/csv#+line-endings+))
  (define std/text/csv#call-with-creativyst-csv-syntax
    (lambda (_thunk113008_)
      (call-with-parameters
       (lambda () (_thunk113008_))
       std/text/csv#csv-separator
       '#\,
       std/text/csv#csv-quote
       '#\"
       std/text/csv#csv-unquoted-quotequote?
       '#f
       std/text/csv#csv-loose-quote?
       '#f
       std/text/csv#csv-allow-binary?
       '#t
       std/text/csv#csv-eol
       std/misc/string#+crlf+
       std/text/csv#csv-line-endings
       std/text/csv#+line-endings+
       std/text/csv#csv-skip-whitespace?
       '#t)))
  (define std/text/csv#call-with-rfc4180-csv-syntax
    (lambda (_thunk113005_)
      (call-with-parameters
       (lambda () (_thunk113005_))
       std/text/csv#csv-separator
       '#\,
       std/text/csv#csv-quote
       '#\"
       std/text/csv#csv-unquoted-quotequote?
       '#f
       std/text/csv#csv-loose-quote?
       '#f
       std/text/csv#csv-allow-binary?
       '#t
       std/text/csv#csv-eol
       std/misc/string#+lf+
       std/text/csv#csv-line-endings
       std/text/csv#+strict-line-endings+
       std/text/csv#csv-skip-whitespace?
       '#f)))
  (define std/text/csv#call-with-strict-rfc4180-csv-syntax
    (lambda (_thunk113001_)
      (std/text/csv#call-with-rfc4180-csv-syntax
       (lambda ()
         (call-with-parameters
          (lambda () (_thunk113001_))
          std/text/csv#csv-line-endings
          std/text/csv#+strict-line-endings+
          std/text/csv#csv-allow-binary?
          '#f)))))
  (define std/text/csv#valid-eol?
    (lambda (_x112999_) (member _x112999_ std/text/csv#+line-endings+)))
  (define std/text/csv#validate-csv-parameters
    (lambda ()
      (if (char? (std/text/csv#csv-separator))
          '#!void
          (error '"Assertion failed" '(char? (csv-separator))))
      (if (char? (std/text/csv#csv-quote))
          '#!void
          (error '"Assertion failed" '(char? (csv-quote))))
      (if (not (equal? (std/text/csv#csv-separator) (std/text/csv#csv-quote)))
          '#!void
          (error '"Assertion failed"
                 '(not (equal? (csv-separator) (csv-quote)))))
      (if (boolean? (std/text/csv#csv-unquoted-quotequote?))
          '#!void
          (error '"Assertion failed" '(boolean? (csv-unquoted-quotequote?))))
      (if (boolean? (std/text/csv#csv-loose-quote?))
          '#!void
          (error '"Assertion failed" '(boolean? (csv-loose-quote?))))
      (if (boolean? (std/text/csv#csv-skip-whitespace?))
          '#!void
          (error '"Assertion failed" '(boolean? (csv-skip-whitespace?))))
      (if (std/text/csv#valid-eol? (std/text/csv#csv-eol))
          '#!void
          (error '"Assertion failed" '(valid-eol? (csv-eol))))
      (if (not (member (string-ref (std/text/csv#csv-eol) '0)
                       (cons (std/text/csv#csv-separator)
                             (cons (std/text/csv#csv-quote) '()))))
          '#!void
          (error '"Assertion failed"
                 '(not (member (string-ref (csv-eol) 0)
                               [(csv-separator) (csv-quote)]))))
      (if (and (list? (std/text/csv#csv-line-endings))
               (std/srfi/1#every
                std/text/csv#valid-eol?
                (std/text/csv#csv-line-endings)))
          '#!void
          (error '"Assertion failed"
                 '(and (list? (csv-line-endings))
                       (every valid-eol? (csv-line-endings)))))))
  (define std/text/csv#csv-eol-matrix (make-parameter '#(#t #t #t)))
  (define std/text/csv#csv-eol-matrix<-line-endings
    (lambda (_line-endings112992_)
      (letrec ((_?112994_
                (lambda (_x112996_)
                  (if (member _x112996_ _line-endings112992_) '#t '#f))))
        (vector (_?112994_ std/misc/string#+cr+)
                (_?112994_ std/misc/string#+lf+)
                (_?112994_ std/misc/string#+crlf+)))))
  (define std/text/csv#char-csv-space?
    (lambda (_c112987_)
      (if (or (eqv? _c112987_ '#\space) (eqv? _c112987_ '#\tab))
          (not (eqv? _c112987_ (std/text/csv#csv-separator)))
          '#f)))
  (define std/text/csv#char-ascii-text?
    (lambda (_c112977_)
      (let* ((_i112979_ (char->integer _c112977_))
             (_$e112981_ (<= '32 _i112979_ '126)))
        (if _$e112981_
            _$e112981_
            (let ((_$e112984_ (= _i112979_ '10)))
              (if _$e112984_ _$e112984_ (= _i112979_ '13)))))))
  (define std/text/csv#accept
    (lambda (_pred112974_ _port112975_)
      (if (_pred112974_ (peek-char _port112975_))
          (read-char _port112975_)
          '#f)))
  (define std/text/csv#accept-char
    (lambda (_c112967_ _port112968_)
      (std/text/csv#accept
       (lambda (_g112969112971_) (eqv? _c112967_ _g112969112971_))
       _port112968_)))
  (define std/text/csv#accept-eof
    (lambda (_port112965_) (std/text/csv#accept eof-object? _port112965_)))
  (define std/text/csv#accept-eol
    (lambda (_port112915_)
      (let* ((_g112916112924_ (std/text/csv#csv-eol-matrix))
             (_E112918112928_
              (lambda () (error '"No clause matching" _g112916112924_)))
             (_K112919112947_
              (lambda (_crlf?112931_ _cr?112932_ _lf?112933_)
                (let ((_$e112935_
                       (if _lf?112933_
                           (if (std/text/csv#accept-char
                                '#\newline
                                _port112915_)
                               '#t
                               '#f)
                           '#f)))
                  (if _$e112935_
                      _$e112935_
                      (if (or _cr?112932_ _crlf?112931_)
                          (if (std/text/csv#accept-char '#\return _port112915_)
                              (let ((_$e112941_
                                     (if _crlf?112931_
                                         (std/text/csv#accept-char
                                          '#\newline
                                          _port112915_)
                                         '#f)))
                                (if _$e112941_
                                    _$e112941_
                                    (let ((_$e112944_ _cr?112932_))
                                      (if _$e112944_
                                          _$e112944_
                                          (std/error#raise-io-error
                                           'accept-eol
                                           '"Carriage-Return without Linefeed!")))))
                              '#f)
                          '#f))))))
        (if (##vector? _g112916112924_)
            (if (##fx= (##vector-length _g112916112924_) '3)
                (let* ((_e112920112950_ (##vector-ref _g112916112924_ '0))
                       (_lf?112953_ _e112920112950_)
                       (_e112921112955_ (##vector-ref _g112916112924_ '1))
                       (_cr?112958_ _e112921112955_)
                       (_e112922112960_ (##vector-ref _g112916112924_ '2))
                       (_crlf?112963_ _e112922112960_))
                  (_K112919112947_ _crlf?112963_ _cr?112958_ _lf?112953_))
                (_E112918112928_))
            (_E112918112928_)))))
  (define std/text/csv#accept-space
    (lambda (_port112913_)
      (std/text/csv#accept std/text/csv#char-csv-space? _port112913_)))
  (define std/text/csv#accept-spaces
    (lambda (_port112904_)
      (std/misc/list#call-with-list-builder
       (lambda (_c112906_ _g113026_)
         (let _loop112908_ ()
           (let ((_x112911_ (std/text/csv#accept-space _port112904_)))
             (if _x112911_
                 (begin (_c112906_ _x112911_) (_loop112908_))
                 '#!void)))))))
  (define std/text/csv#accept-quote
    (lambda (_port112898_)
      (std/text/csv#accept
       (lambda (_g112899112901_)
         (eqv? _g112899112901_ (std/text/csv#csv-quote)))
       _port112898_)))
  (define std/text/csv#accept-separator
    (lambda (_port112892_)
      (std/text/csv#accept
       (lambda (_g112893112895_)
         (eqv? _g112893112895_ (std/text/csv#csv-separator)))
       _port112892_)))
  (define std/text/csv#read-csv-line
    (lambda (_port112843_)
      (letrec* ((_ss112845_ (open-output-string))
                (_fields112846_ '())
                (_had-quotes?112847_ '#f)
                (_do-fields112848_
                 (lambda ()
                   (set! _had-quotes?112847_ '#f)
                   (if (std/text/csv#csv-skip-whitespace?)
                       (std/text/csv#accept-spaces _port112843_)
                       '#!void)
                   (if (and (null? _fields112846_)
                            (or (std/text/csv#accept-eol _port112843_)
                                (std/text/csv#accept-eof _port112843_)))
                       (_done112858_)
                       (_do-field-start112849_))))
                (_do-field-start112849_
                 (lambda ()
                   (if (std/text/csv#accept-separator _port112843_)
                       (begin (_add112855_ '"") (_do-fields112848_))
                       (if (std/text/csv#accept-quote _port112843_)
                           (if (and (std/text/csv#csv-unquoted-quotequote?)
                                    (std/text/csv#accept-quote _port112843_))
                               (begin
                                 (_add-char112856_ (std/text/csv#csv-quote))
                                 (_do-field-unquoted112852_))
                               (_do-field-quoted112850_))
                           (_do-field-unquoted112852_)))))
                (_do-field-quoted112850_
                 (lambda ()
                   (set! _had-quotes?112847_ '#t)
                   (if (std/text/csv#accept-eof _port112843_)
                       (std/error#raise-io-error
                        'read-csv-line
                        '"unexpected eof in quotes")
                       (if (std/text/csv#accept-quote _port112843_)
                           (if (std/text/csv#accept-quote _port112843_)
                               (_quoted-field-char112851_
                                (std/text/csv#csv-quote))
                               (if (std/text/csv#csv-loose-quote?)
                                   (_do-field-unquoted112852_)
                                   (begin
                                     (_add112855_ (_current-string112857_))
                                     (_end-of-field112854_))))
                           (_quoted-field-char112851_
                            (read-char _port112843_))))))
                (_quoted-field-char112851_
                 (lambda (_c112884_)
                   (_add-char112856_ _c112884_)
                   (_do-field-quoted112850_)))
                (_do-field-unquoted112852_
                 (lambda ()
                   (if (std/text/csv#csv-skip-whitespace?)
                       (let ((_spaces112879_
                              (std/text/csv#accept-spaces _port112843_)))
                         (if (std/text/csv#accept-separator _port112843_)
                             (begin
                               (_add112855_ (_current-string112857_))
                               (_do-fields112848_))
                             (if (or (std/text/csv#accept-eol _port112843_)
                                     (std/text/csv#accept-eof _port112843_))
                                 (begin
                                   (_add112855_ (_current-string112857_))
                                   (_done112858_))
                                 (begin
                                   (for-each _add-char112856_ _spaces112879_)
                                   (_do-field-unquoted-no-skip112853_)))))
                       (_do-field-unquoted-no-skip112853_))))
                (_do-field-unquoted-no-skip112853_
                 (lambda ()
                   (if (std/text/csv#accept-separator _port112843_)
                       (begin
                         (_add112855_ (_current-string112857_))
                         (_do-fields112848_))
                       (if (or (std/text/csv#accept-eol _port112843_)
                               (std/text/csv#accept-eof _port112843_))
                           (begin
                             (_add112855_ (_current-string112857_))
                             (_done112858_))
                           (if (std/text/csv#accept-quote _port112843_)
                               (if (and (std/text/csv#csv-unquoted-quotequote?)
                                        (std/text/csv#accept-quote
                                         _port112843_))
                                   (begin
                                     (_add-char112856_
                                      (std/text/csv#csv-quote))
                                     (_do-field-unquoted112852_))
                                   (if (std/text/csv#csv-loose-quote?)
                                       (_do-field-quoted112850_)
                                       (std/error#raise-io-error
                                        'read-csv-line
                                        '"unexpected quote in middle of field")))
                               (begin
                                 (_add-char112856_ (read-char _port112843_))
                                 (_do-field-unquoted112852_)))))))
                (_end-of-field112854_
                 (lambda ()
                   (if (std/text/csv#csv-skip-whitespace?)
                       (std/text/csv#accept-spaces _port112843_)
                       '#!void)
                   (if (or (std/text/csv#accept-eol _port112843_)
                           (std/text/csv#accept-eof _port112843_))
                       (_done112858_)
                       (if (std/text/csv#accept-separator _port112843_)
                           (_do-fields112848_)
                           (std/error#raise-io-error
                            'read-csv-line
                            '"end of field expected")))))
                (_add112855_
                 (lambda (_x112868_)
                   (set! _fields112846_ (cons _x112868_ _fields112846_))))
                (_add-char112856_
                 (lambda (_c112863_)
                   (if (or (std/text/csv#csv-allow-binary?)
                           (std/text/csv#char-ascii-text? _c112863_))
                       '#!void
                       (std/error#raise-io-error
                        'read-csv-line
                        '"binary data not allowed"
                        _c112863_))
                   (write-char _c112863_ _ss112845_)))
                (_current-string112857_
                 (lambda () (get-output-string _ss112845_)))
                (_done112858_
                 (lambda () (std/srfi/1#reverse! _fields112846_))))
        (call-with-parameters
         (lambda () (_do-fields112848_))
         std/text/csv#csv-eol-matrix
         (std/text/csv#csv-eol-matrix<-line-endings
          (std/text/csv#csv-line-endings))))))
  (define std/text/csv#read-csv-lines
    (lambda (_port112835_)
      (std/text/csv#validate-csv-parameters)
      (std/misc/list#call-with-list-builder
       (lambda (_c112837_ _g113027_)
         (let _lp112839_ ()
           (if (std/text/csv#accept-eof _port112835_)
               '#!void
               (begin
                 (_c112837_ (std/text/csv#read-csv-line _port112835_))
                 (_lp112839_))))))))
  (define std/text/csv#read-csv-file
    (lambda (_path112832_ . _settings112833_)
      (call-with-input-file
       (cons 'path: (cons _path112832_ _settings112833_))
       std/text/csv#read-csv-lines)))
  (define std/text/csv#char-needs-quoting?
    (lambda (_x112818_)
      (let ((_$e112820_ (eqv? _x112818_ (std/text/csv#csv-quote))))
        (if _$e112820_
            _$e112820_
            (let ((_$e112823_ (eqv? _x112818_ (std/text/csv#csv-separator))))
              (if _$e112823_
                  _$e112823_
                  (let ((_$e112826_ (eqv? _x112818_ '#\newline)))
                    (if _$e112826_
                        _$e112826_
                        (let ((_$e112829_ (eqv? _x112818_ '#\return)))
                          (if _$e112829_
                              _$e112829_
                              (not (std/text/csv#char-ascii-text?
                                    _x112818_))))))))))))
  (define std/text/csv#string-needs-quoting?
    (lambda (_x112810_)
      (if (not (std/srfi/13#string-null? _x112810_))
          (if (or (std/text/csv#char-csv-space? (string-ref _x112810_ '0))
                  (std/text/csv#char-csv-space?
                   (string-ref _x112810_ (- (string-length _x112810_) '1)))
                  (std/srfi/13#string-any__0
                   std/text/csv#char-needs-quoting?
                   _x112810_))
              '#t
              '#f)
          '#f)))
  (define std/text/csv#write-csv-lines
    (lambda (_lines112803_ _port112804_)
      (for-each
       (lambda (_g112805112807_)
         (std/text/csv#write-csv-line _g112805112807_ _port112804_))
       _lines112803_)))
  (define std/text/csv#write-csv-line
    (lambda (_fields112758_ _port112759_)
      (let _loop112761_ ((_fields112763_ _fields112758_))
        (let* ((_fields112764112773_ _fields112763_)
               (_E112767112777_
                (lambda ()
                  (error '"No clause matching" _fields112764112773_))))
          (let ((_K112769112791_
                 (lambda (_rest112788_ _first112789_)
                   (std/text/csv#write-csv-field _first112789_ _port112759_)
                   (if (null? _rest112788_)
                       '#!void
                       (write-char (std/text/csv#csv-separator) _port112759_))
                   (_loop112761_ _rest112788_)))
                (_K112768112782_
                 (lambda () (display (std/text/csv#csv-eol) _port112759_))))
            (let ((_try-match112766112785_
                   (lambda ()
                     (if (##null? _fields112764112773_)
                         (_K112768112782_)
                         (_E112767112777_)))))
              (if (##pair? _fields112764112773_)
                  (let ((_tl112771112796_ (##cdr _fields112764112773_))
                        (_hd112770112794_ (##car _fields112764112773_)))
                    (let ((_first112799_ _hd112770112794_)
                          (_rest112801_ _tl112771112796_))
                      (_K112769112791_ _rest112801_ _first112799_)))
                  (_try-match112766112785_))))))))
  (define std/text/csv#write-csv-field
    (lambda (_field112705_ _port112706_)
      (let* ((_field112707112719_ _field112705_)
             (_else112712112727_
              (lambda () (error '"invalid CSV field" _field112705_))))
        (let ((_K112717112755_ (lambda () '#!void))
              (_K112716112748_
               (lambda () (display _field112705_ _port112706_)))
              (_K112715112740_
               (lambda ()
                 (std/text/csv#write-csv-string-safely
                  _field112705_
                  _port112706_)))
              (_K112714112732_
               (lambda ()
                 (std/text/csv#write-csv-string-safely
                  (symbol->string _field112705_)
                  _port112706_))))
          (let* ((_try-match112711112735_
                  (lambda ()
                    (if (symbol? _field112707112719_)
                        (_K112714112732_)
                        (_else112712112727_))))
                 (_try-match112710112743_
                  (lambda ()
                    (if (string? _field112707112719_)
                        (_K112715112740_)
                        (_try-match112711112735_))))
                 (_try-match112709112751_
                  (lambda ()
                    (if (number? _field112707112719_)
                        (_K112716112748_)
                        (_try-match112710112743_)))))
            (if (not _field112707112719_)
                '#!void
                (_try-match112709112751_)))))))
  (define std/text/csv#write-csv-string-safely
    (lambda (_string112702_ _port112703_)
      (if (std/text/csv#string-needs-quoting? _string112702_)
          (std/text/csv#write-quoted-string _string112702_ _port112703_)
          (display _string112702_ _port112703_))))
  (define std/text/csv#write-quoted-string
    (lambda (_string112697_ _port112698_)
      (write-char (std/text/csv#csv-quote) _port112698_)
      (std/srfi/13#string-for-each__0
       (lambda (_c112700_)
         (if (char=? _c112700_ (std/text/csv#csv-quote))
             (write-char _c112700_ _port112698_)
             '#!void)
         (write-char _c112700_ _port112698_))
       _string112697_)
      (write-char (std/text/csv#csv-quote) _port112698_))))
