/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected boolean isPalette = false;
    protected Icon paletteCloseIcon;
    protected int paletteTitleHeight;
    JLabel title;

    public MetalInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.selectedTextColor = MetalLookAndFeel.getControlTextColor();
        this.selectedTitleColor = MetalLookAndFeel.getWindowTitleBackground();
        this.notSelectedTextColor = MetalLookAndFeel.getInactiveControlTextColor();
        this.notSelectedTitleColor = MetalLookAndFeel.getWindowTitleInactiveBackground();
        this.paletteTitleHeight = UIManager.getInt("InternalFrame.paletteTitleHeight");
        this.paletteCloseIcon = UIManager.getIcon("InternalFrame.paletteCloseIcon");
        this.minIcon = MetalIconFactory.getInternalFrameAltMaximizeIcon(16);
        this.title = new JLabel(this.frame.getTitle(), MetalIconFactory.getInternalFrameDefaultMenuIcon(), 2);
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.selectedTextColor = null;
        this.selectedTitleColor = null;
        this.notSelectedTextColor = null;
        this.notSelectedTitleColor = null;
        this.paletteCloseIcon = null;
        this.minIcon = null;
        this.title = null;
    }

    protected void createButtons() {
        super.createButtons();
        this.closeButton.setBorderPainted(false);
        this.closeButton.setContentAreaFilled(false);
        this.iconButton.setBorderPainted(false);
        this.iconButton.setContentAreaFilled(false);
        this.maxButton.setBorderPainted(false);
        this.maxButton.setContentAreaFilled(false);
    }

    protected void addSystemMenuItems(JMenu systemMenu) {
    }

    protected void showSystemMenu() {
    }

    protected void addSubComponents() {
        this.add(this.title);
        this.add(this.closeButton);
        this.add(this.iconButton);
        this.add(this.maxButton);
    }

    protected LayoutManager createLayout() {
        return new MetalTitlePaneLayout();
    }

    public void paintPalette(Graphics g) {
        Color savedColor = g.getColor();
        Rectangle b = SwingUtilities.getLocalBounds(this);
        if (UIManager.get("InternalFrame.activeTitleGradient") != null && this.frame.isSelected()) {
            MetalUtils.paintGradient(g, b.x, b.y, b.width, b.height, 1, "InternalFrame.activeTitleGradient");
        }
        MetalUtils.fillMetalPattern(this, g, b.x + 4, b.y + 2, b.width - this.paletteCloseIcon.getIconWidth() - 13, b.height - 5, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getBlack());
        Dimension d = this.getSize();
        g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
        g.drawLine(0, d.height - 1, d.width - 1, d.height - 1);
        g.setColor(savedColor);
    }

    public void paintComponent(Graphics g) {
        Color savedColor = g.getColor();
        if (this.isPalette) {
            this.paintPalette(g);
        } else {
            int startX;
            this.paintTitleBackground(g);
            this.paintChildren(g);
            Dimension d = this.getSize();
            if (this.frame.isSelected()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(0, 0, 0, 0);
            g.drawLine(d.width - 1, 0, d.width - 1, 0);
            g.drawLine(0, d.height - 1, d.width - 1, d.height - 1);
            if (UIManager.get("InternalFrame.activeTitleGradient") != null && this.frame.isSelected()) {
                MetalUtils.paintGradient(g, 0, 0, this.getWidth(), this.getHeight(), 1, "InternalFrame.activeTitleGradient");
            }
            Rectangle b = this.title.getBounds();
            int endX = startX = b.x + b.width + 5;
            if (this.iconButton.isVisible()) {
                endX = Math.max(this.iconButton.getX(), endX);
            } else if (this.maxButton.isVisible()) {
                endX = Math.max(this.maxButton.getX(), endX);
            } else if (this.closeButton.isVisible()) {
                endX = Math.max(this.closeButton.getX(), endX);
            }
            if ((endX -= 7) > startX) {
                MetalUtils.fillMetalPattern(this, g, startX, 3, endX - startX, this.getHeight() - 6, Color.white, Color.gray);
            }
        }
        g.setColor(savedColor);
    }

    public void setPalette(boolean b) {
        this.isPalette = b;
        this.title.setVisible(!this.isPalette);
        this.iconButton.setVisible(!this.isPalette && this.frame.isIconifiable());
        this.maxButton.setVisible(!this.isPalette && this.frame.isMaximizable());
        if (this.isPalette) {
            this.closeButton.setIcon(this.paletteCloseIcon);
        } else {
            this.closeButton.setIcon(this.closeIcon);
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new MetalInternalFrameTitlePanePropertyChangeHandler();
    }

    class MetalInternalFrameTitlePanePropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        public void propertyChange(PropertyChangeEvent e) {
            String propName = e.getPropertyName();
            if (e.getPropertyName().equals("frameIcon")) {
                MetalInternalFrameTitlePane.this.title.setIcon(MetalInternalFrameTitlePane.this.frame.getFrameIcon());
            } else if (propName.equals("JInternalFrame.isPalette")) {
                if (e.getNewValue().equals(Boolean.TRUE)) {
                    MetalInternalFrameTitlePane.this.setPalette(true);
                } else {
                    MetalInternalFrameTitlePane.this.setPalette(false);
                }
            } else {
                super.propertyChange(e);
            }
        }
    }

    private class MetalTitlePaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component c) {
        }

        public void layoutContainer(Container c) {
            int buttonWidth;
            Dimension size = c.getSize();
            Insets insets = c.getInsets();
            int width = size.width - insets.left - insets.right;
            int height = size.height - insets.top - insets.bottom;
            int loc = width - insets.right - 1;
            int top = insets.top + 2;
            int buttonHeight = height - 4;
            if (MetalInternalFrameTitlePane.this.closeButton.isVisible()) {
                buttonWidth = MetalInternalFrameTitlePane.this.closeIcon.getIconWidth();
                MetalInternalFrameTitlePane.this.closeButton.setBounds(loc -= buttonWidth + 2, top, buttonWidth, buttonHeight);
                loc -= 6;
            }
            if (MetalInternalFrameTitlePane.this.maxButton.isVisible()) {
                buttonWidth = MetalInternalFrameTitlePane.this.maxIcon.getIconWidth();
                MetalInternalFrameTitlePane.this.maxButton.setBounds(loc -= buttonWidth + 4, top, buttonWidth, buttonHeight);
            }
            if (MetalInternalFrameTitlePane.this.iconButton.isVisible()) {
                buttonWidth = MetalInternalFrameTitlePane.this.minIcon.getIconWidth();
                MetalInternalFrameTitlePane.this.iconButton.setBounds(loc -= buttonWidth + 4, top, buttonWidth, buttonHeight);
                loc -= 2;
            }
            Dimension titlePreferredSize = MetalInternalFrameTitlePane.this.title.getPreferredSize();
            MetalInternalFrameTitlePane.this.title.setBounds(insets.left + 5, insets.top, Math.min(titlePreferredSize.width, loc - insets.left - 10), height);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public Dimension preferredLayoutSize(Container c) {
            if (MetalInternalFrameTitlePane.this.isPalette) {
                return new Dimension(MetalInternalFrameTitlePane.this.paletteTitleHeight, MetalInternalFrameTitlePane.this.paletteTitleHeight);
            }
            return new Dimension(22, 22);
        }

        public void removeLayoutComponent(Component c) {
        }
    }
}

