/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.lang.CPStringBuilder;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collections {
    private static final int LARGE_LIST_SIZE = 16;
    public static final Set EMPTY_SET = new EmptySet();
    public static final List EMPTY_LIST = new EmptyList();
    public static final Map EMPTY_MAP = new EmptyMap();
    private static final ReverseComparator rcInstance = new ReverseComparator();
    private static Random defaultRandom = null;

    private static boolean isSequential(List<?> l) {
        return !(l instanceof RandomAccess) && l.size() > 16;
    }

    private Collections() {
    }

    public static final <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static final <T> List<T> emptyList() {
        return EMPTY_LIST;
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    static final <T> int compare(T o1, T o2, Comparator<? super T> c) {
        return c == null ? ((Comparable)o1).compareTo(o2) : c.compare(o1, o2);
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> l, T key) {
        return Collections.binarySearch(l, key, null);
    }

    /*
     * Unable to fully structure code
     */
    public static <T> int binarySearch(List<? extends T> l, T key, Comparator<? super T> c) {
        block12: {
            pos = 0;
            low = 0;
            hi = l.size() - 1;
            if (!Collections.isSequential(l)) ** GOTO lbl46
            itr = l.listIterator();
            i = 0;
            o = itr.next();
            forward = true;
            while (low <= hi) {
                pos = low + hi >>> 1;
                if (i < pos) {
                    if (!forward) {
                        itr.next();
                    }
                    while (i != pos) {
                        ++i;
                        o = itr.next();
                    }
                    forward = true;
                } else {
                    if (forward) {
                        itr.previous();
                    }
                    while (i != pos) {
                        --i;
                        o = itr.previous();
                    }
                    forward = false;
                }
                d = Collections.compare(o, key, c);
                if (d == 0) {
                    return pos;
                }
                if (d > 0) {
                    hi = pos - 1;
                    continue;
                }
                low = ++pos;
            }
            break block12;
lbl-1000:
            // 1 sources

            {
                pos = low + hi >>> 1;
                d = Collections.compare(l.get(pos), key, c);
                if (d == 0) {
                    return pos;
                }
                if (d > 0) {
                    hi = pos - 1;
                    continue;
                }
                low = ++pos;
lbl46:
                // 3 sources

                ** while (low <= hi)
            }
        }
        return -pos - 1;
    }

    public static <T> void copy(List<? super T> dest, List<? extends T> source) {
        int pos = source.size();
        if (dest.size() < pos) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        Iterator<T> i1 = source.iterator();
        ListIterator<T> i2 = dest.listIterator();
        while (--pos >= 0) {
            i2.next();
            i2.set(i1.next());
        }
    }

    public static <T> Enumeration<T> enumeration(Collection<T> c) {
        final Iterator<T> i = c.iterator();
        return new Enumeration<T>(){

            @Override
            public final boolean hasMoreElements() {
                return i.hasNext();
            }

            @Override
            public final T nextElement() {
                return i.next();
            }
        };
    }

    public static <T> void fill(List<? super T> l, T val) {
        ListIterator<T> itr = l.listIterator();
        int i = l.size() - 1;
        while (i >= 0) {
            itr.next();
            itr.set(val);
            --i;
        }
    }

    public static int indexOfSubList(List<?> source, List<?> target) {
        int ssize = source.size();
        int i = 0;
        int j = target.size();
        while (j <= ssize) {
            if (source.subList(i, j).equals(target)) {
                return i;
            }
            ++i;
            ++j;
        }
        return -1;
    }

    public static int lastIndexOfSubList(List<?> source, List<?> target) {
        int ssize = source.size();
        int i = ssize - target.size();
        int j = ssize;
        while (i >= 0) {
            if (source.subList(i, j).equals(target)) {
                return i;
            }
            --i;
            --j;
        }
        return -1;
    }

    public static <T> ArrayList<T> list(Enumeration<T> e) {
        ArrayList<T> l = new ArrayList<T>();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        return l;
    }

    public static <T> T max(Collection<? extends T> c) {
        return Collections.max(c, null);
    }

    public static <T> T max(Collection<? extends T> c, Comparator<? super T> order) {
        Iterator<T> itr = c.iterator();
        T max = itr.next();
        int csize = c.size();
        int i = 1;
        while (i < csize) {
            T o = itr.next();
            if (Collections.compare(max, o, order) < 0) {
                max = o;
            }
            ++i;
        }
        return max;
    }

    public static <T> T min(Collection<? extends T> c) {
        return Collections.min(c, null);
    }

    public static <T> T min(Collection<? extends T> c, Comparator<? super T> order) {
        Iterator<T> itr = c.iterator();
        T min = itr.next();
        int csize = c.size();
        int i = 1;
        while (i < csize) {
            T o = itr.next();
            if (Collections.compare(min, o, order) > 0) {
                min = o;
            }
            ++i;
        }
        return min;
    }

    public static <T> List<T> nCopies(int n, T o) {
        return new CopiesList<T>(n, o);
    }

    public static <T> boolean replaceAll(List<T> list2, T oldval, T newval) {
        ListIterator<T> itr = list2.listIterator();
        boolean replace_occured = false;
        int i = list2.size();
        while (--i >= 0) {
            if (!AbstractCollection.equals(oldval, itr.next())) continue;
            itr.set(newval);
            replace_occured = true;
        }
        return replace_occured;
    }

    public static void reverse(List<?> l) {
        ListIterator<?> i1 = l.listIterator();
        int pos1 = 1;
        int pos2 = l.size();
        ListIterator<?> i2 = l.listIterator(pos2);
        while (pos1 < pos2) {
            Object o1 = i1.next();
            Object o2 = i2.previous();
            i1.set(o2);
            i2.set(o1);
            ++pos1;
            --pos2;
        }
    }

    public static <T> Comparator<T> reverseOrder(final Comparator<T> c) {
        if (c == null) {
            return rcInstance;
        }
        return new ReverseComparator<T>(){

            @Override
            public int compare(T a, T b) {
                return -c.compare(a, b);
            }
        };
    }

    public static <T> Comparator<T> reverseOrder() {
        return rcInstance;
    }

    public static void rotate(List<?> list2, int distance) {
        int size = list2.size();
        if (size == 0) {
            return;
        }
        if ((distance %= size) == 0) {
            return;
        }
        if (distance < 0) {
            distance += size;
        }
        if (Collections.isSequential(list2)) {
            Collections.reverse(list2);
            Collections.reverse(list2.subList(0, distance));
            Collections.reverse(list2.subList(distance, size));
        } else {
            int a = size;
            int lcm = distance;
            int b = a % lcm;
            while (b != 0) {
                a = lcm;
                lcm = b;
                b = a % lcm;
            }
            List<?> objList = list2;
            while (--lcm >= 0) {
                Object o = objList.get(lcm);
                int i = lcm + distance;
                while (i != lcm) {
                    o = objList.set(i, o);
                    i = (i + distance) % size;
                }
                objList.set(lcm, o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void shuffle(List<?> l) {
        if (defaultRandom == null) {
            Class<Collections> clazz = Collections.class;
            // MONITORENTER : java.util.Collections.class
            if (defaultRandom == null) {
                defaultRandom = new Random();
            }
            // MONITOREXIT : clazz
        }
        Collections.shuffle(l, defaultRandom);
    }

    public static void shuffle(List<?> l, Random r) {
        int lsize = l.size();
        List<?> list2 = l;
        ListIterator<?> i = list2.listIterator(lsize);
        boolean sequential = Collections.isSequential(l);
        Object[] a = null;
        if (sequential) {
            a = list2.toArray();
        }
        int pos = lsize - 1;
        while (pos > 0) {
            Object o;
            int swap = r.nextInt(pos + 1);
            if (sequential) {
                o = a[swap];
                a[swap] = i.previous();
            } else {
                o = list2.set(swap, i.previous());
            }
            i.set(o);
            --pos;
        }
    }

    public static int frequency(Collection<?> c, Object o) {
        int result = 0;
        for (Object v : c) {
            if (!AbstractCollection.equals(o, v)) continue;
            ++result;
        }
        return result;
    }

    public static <T> boolean addAll(Collection<? super T> c, T ... a) {
        boolean overall = false;
        T[] TArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            boolean result = c.add(element);
            if (result) {
                overall = true;
            }
            ++n2;
        }
        return overall;
    }

    public static boolean disjoint(Collection<?> c1, Collection<?> c2) {
        Collection<?> oc1 = c1;
        Iterator<?> it = oc1.iterator();
        while (it.hasNext()) {
            if (!c2.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> Set<T> singleton(T o) {
        return new SingletonSet<T>(o);
    }

    public static <T> List<T> singletonList(T o) {
        return new SingletonList<T>(o);
    }

    public static <K, V> Map<K, V> singletonMap(K key, V value) {
        return new SingletonMap<K, V>(key, value);
    }

    public static <T extends Comparable<? super T>> void sort(List<T> l) {
        Collections.sort(l, null);
    }

    public static <T> void sort(List<T> l, Comparator<? super T> c) {
        Object[] a = l.toArray();
        Arrays.sort(a, c);
        ListIterator<T> i = l.listIterator();
        int pos = 0;
        int alen = a.length;
        while (pos < alen) {
            i.next();
            i.set(a[pos]);
            ++pos;
        }
    }

    public static void swap(List<?> l, int i, int j) {
        List<?> list2 = l;
        list2.set(i, list2.set(j, list2.get(i)));
    }

    public static <T> Collection<T> synchronizedCollection(Collection<T> c) {
        return new SynchronizedCollection<T>(c);
    }

    public static <T> List<T> synchronizedList(List<T> l) {
        if (l instanceof RandomAccess) {
            return new SynchronizedRandomAccessList<T>(l);
        }
        return new SynchronizedList<T>(l);
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> m) {
        return new SynchronizedMap<K, V>(m);
    }

    public static <T> Set<T> synchronizedSet(Set<T> s) {
        return new SynchronizedSet<T>(s);
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> m) {
        return new SynchronizedSortedMap<K, V>(m);
    }

    public static <T> SortedSet<T> synchronizedSortedSet(SortedSet<T> s) {
        return new SynchronizedSortedSet<T>(s);
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> c) {
        return new UnmodifiableCollection<T>(c);
    }

    public static <T> List<T> unmodifiableList(List<? extends T> l) {
        if (l instanceof RandomAccess) {
            return new UnmodifiableRandomAccessList<T>(l);
        }
        return new UnmodifiableList<T>(l);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> m) {
        return new UnmodifiableMap<K, V>(m);
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> s) {
        return new UnmodifiableSet<T>(s);
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> m) {
        return new UnmodifiableSortedMap<K, V>(m);
    }

    public static <T> SortedSet<T> unmodifiableSortedSet(SortedSet<T> s) {
        return new UnmodifiableSortedSet<T>(s);
    }

    public static <E> Collection<E> checkedCollection(Collection<E> c, Class<E> type) {
        return new CheckedCollection<E>(c, type);
    }

    public static <E> List<E> checkedList(List<E> l, Class<E> type) {
        if (l instanceof RandomAccess) {
            return new CheckedRandomAccessList<E>(l, type);
        }
        return new CheckedList<E>(l, type);
    }

    public static <K, V> Map<K, V> checkedMap(Map<K, V> m, Class<K> keyType, Class<V> valueType) {
        return new CheckedMap<K, V>(m, keyType, valueType);
    }

    public static <E> Set<E> checkedSet(Set<E> s, Class<E> type) {
        return new CheckedSet<E>(s, type);
    }

    public static <K, V> SortedMap<K, V> checkedSortedMap(SortedMap<K, V> m, Class<K> keyType, Class<V> valueType) {
        return new CheckedSortedMap<K, V>(m, keyType, valueType);
    }

    public static <E> SortedSet<E> checkedSortedSet(SortedSet<E> s, Class<E> type) {
        return new CheckedSortedSet<E>(s, type);
    }

    public static <T> Queue<T> asLifoQueue(Deque<T> deque) {
        return new LIFOQueue<T>(deque);
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return new MapSet<E>(map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1578914078182001775L;
        final Collection<E> c;
        final Class<E> type;

        CheckedCollection(Collection<E> c, Class<E> type) {
            this.c = c;
            this.type = type;
            if (c == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public boolean add(E o) {
            if (this.type.isInstance(o)) {
                return this.c.add(o);
            }
            throw new ClassCastException("The element is of the incorrect type.");
        }

        @Override
        public boolean addAll(Collection<? extends E> coll) {
            Collection<E> typedColl = this.c;
            for (E element : typedColl) {
                if (this.type.isInstance(element)) continue;
                throw new ClassCastException("A member of the collection is not of the correct type.");
            }
            return this.c.addAll(typedColl);
        }

        @Override
        public void clear() {
            this.c.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.c.containsAll(coll);
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new CheckedIterator<E>(this.c.iterator(), this.type);
        }

        @Override
        public boolean remove(Object o) {
            return this.c.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            return this.c.removeAll(coll);
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            return this.c.retainAll(coll);
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <S> S[] toArray(S[] a) {
            return this.c.toArray(a);
        }

        public String toString() {
            return this.c.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedIterator<E>
    implements Iterator<E> {
        private final Iterator<E> i;
        final Class<E> type;

        CheckedIterator(Iterator<E> i, Class<E> type) {
            this.i = i;
            this.type = type;
        }

        @Override
        public E next() {
            return this.i.next();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedList<E>
    extends CheckedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 65247728283967356L;
        final List<E> list;

        CheckedList(List<E> l, Class<E> type) {
            super(l, type);
            this.list = l;
        }

        @Override
        public void add(int index, E o) {
            if (!this.type.isInstance(o)) {
                throw new ClassCastException("The object is of the wrong type.");
            }
            this.list.add(index, o);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> coll) {
            Collection<E> typedColl = coll;
            Iterator<E> it = typedColl.iterator();
            while (it.hasNext()) {
                if (this.type.isInstance(it.next())) continue;
                throw new ClassCastException("A member of the collection is not of the correct type.");
            }
            return this.list.addAll(index, coll);
        }

        @Override
        public boolean equals(Object o) {
            return this.list.equals(o);
        }

        @Override
        public E get(int index) {
            return this.list.get(index);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new CheckedListIterator<E>(this.list.listIterator(), this.type);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new CheckedListIterator<E>(this.list.listIterator(index), this.type);
        }

        @Override
        public E remove(int index) {
            return this.list.remove(index);
        }

        @Override
        public E set(int index, E o) {
            return this.list.set(index, o);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return Collections.checkedList(this.list.subList(fromIndex, toIndex), this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CheckedListIterator<E>
    extends CheckedIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> li;

        CheckedListIterator(ListIterator<E> li, Class<E> type) {
            super(li, type);
            this.li = li;
        }

        @Override
        public void add(E o) {
            if (!this.type.isInstance(o)) {
                throw new ClassCastException("The object is of the wrong type.");
            }
            this.li.add(o);
        }

        @Override
        public boolean hasPrevious() {
            return this.li.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.li.nextIndex();
        }

        @Override
        public E previous() {
            return this.li.previous();
        }

        @Override
        public int previousIndex() {
            return this.li.previousIndex();
        }

        @Override
        public void set(E o) {
            if (!this.type.isInstance(o)) {
                throw new ClassCastException("The object is of the wrong type.");
            }
            this.li.set(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 5742860141034234728L;
        private final Map<K, V> m;
        final Class<K> keyType;
        final Class<V> valueType;
        private transient Set<Map.Entry<K, V>> entries;
        private transient Set<K> keys;
        private transient Collection<V> values;

        CheckedMap(Map<K, V> m, Class<K> keyType, Class<V> valueType) {
            this.m = m;
            this.keyType = keyType;
            this.valueType = valueType;
            if (m == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.m.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entries == null) {
                Class<Map.Entry> klass = Map.Entry.class;
                this.entries = new CheckedEntrySet<Map.Entry, K, V>(this.m.entrySet(), klass, this.keyType, this.valueType);
            }
            return this.entries;
        }

        @Override
        public boolean equals(Object o) {
            return this.m.equals(o);
        }

        @Override
        public V get(Object key) {
            return this.m.get(key);
        }

        @Override
        public V put(K key, V value) {
            if (this.keyType.isInstance(key)) {
                if (this.valueType.isInstance(value)) {
                    return this.m.put(key, value);
                }
                throw new ClassCastException("The value is of the wrong type.");
            }
            throw new ClassCastException("The key is of the wrong type.");
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            if (this.keys == null) {
                this.keys = new CheckedSet<K>(this.m.keySet(), this.keyType);
            }
            return this.keys;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Map<K, V> typedMap = map;
            for (Map.Entry<K, V> entry : typedMap.entrySet()) {
                if (!this.keyType.isInstance(entry.getKey())) {
                    throw new ClassCastException("A key is of the wrong type.");
                }
                if (this.valueType.isInstance(entry.getValue())) continue;
                throw new ClassCastException("A value is of the wrong type.");
            }
            this.m.putAll(typedMap);
        }

        @Override
        public V remove(Object o) {
            return this.m.remove(o);
        }

        @Override
        public int size() {
            return this.m.size();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = new CheckedCollection<V>(this.m.values(), this.valueType);
            }
            return this.values;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class CheckedEntrySet<E, SK, SV>
        extends CheckedSet<E> {
            private final Class<SK> keyType;
            private final Class<SV> valueType;

            CheckedEntrySet(Set<E> s, Class<E> type, Class<SK> keyType, Class<SV> valueType) {
                super(s, type);
                this.keyType = keyType;
                this.valueType = valueType;
            }

            @Override
            public Iterator<E> iterator() {
                return new CheckedIterator<E>(this, this.c.iterator(), this.type){
                    final /* synthetic */ CheckedEntrySet this$2;
                    {
                        this.this$2 = checkedEntrySet;
                        super($anonymous0, $anonymous1);
                    }

                    public E next() {
                        Map.Entry e = (Map.Entry)super.next();
                        return (E)new Map.Entry(this, e){
                            final /* synthetic */ 6 this$3;
                            private final /* synthetic */ Map.Entry val$e;
                            {
                                this.this$3 = var1_1;
                                this.val$e = entry;
                            }

                            public boolean equals(Object o) {
                                return this.val$e.equals(o);
                            }

                            public Object getKey() {
                                return this.val$e.getKey();
                            }

                            public Object getValue() {
                                return this.val$e.getValue();
                            }

                            public int hashCode() {
                                return this.val$e.hashCode();
                            }

                            public Object setValue(Object value) {
                                if (CheckedEntrySet.access$0(6.access$0(this.this$3)).isInstance(value)) {
                                    return this.val$e.setValue(value);
                                }
                                throw new ClassCastException("The value is of the wrong type.");
                            }

                            public String toString() {
                                return this.val$e.toString();
                            }
                        };
                    }

                    static /* synthetic */ CheckedEntrySet access$0(6 var0) {
                        return var0.this$2;
                    }
                };
            }

            static /* synthetic */ Class access$0(CheckedEntrySet checkedEntrySet) {
                return checkedEntrySet.valueType;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CheckedRandomAccessList<E>
    extends CheckedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1638200125423088369L;

        CheckedRandomAccessList(List<E> l, Class<E> type) {
            super(l, type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedSet<E>
    extends CheckedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 4694047833775013803L;

        CheckedSet(Set<E> s, Class<E> type) {
            super(s, type);
        }

        @Override
        public boolean equals(Object o) {
            return this.c.equals(o);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedSortedMap<K, V>
    extends CheckedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = 1599671320688067438L;
        private final SortedMap<K, V> sm;

        CheckedSortedMap(SortedMap<K, V> sm, Class<K> keyType, Class<V> valueType) {
            super(sm, keyType, valueType);
            this.sm = sm;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return new CheckedSortedMap<K, V>(this.sm.headMap(toKey), this.keyType, this.valueType);
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return new CheckedSortedMap<K, V>(this.sm.subMap(fromKey, toKey), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return new CheckedSortedMap<K, V>(this.sm.tailMap(fromKey), this.keyType, this.valueType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedSortedSet<E>
    extends CheckedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 1599911165492914959L;
        private SortedSet<E> ss;

        CheckedSortedSet(SortedSet<E> ss, Class<E> type) {
            super(ss, type);
            this.ss = ss;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return new CheckedSortedSet<E>(this.ss.headSet(toElement), this.type);
        }

        @Override
        public E last() {
            return this.ss.last();
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return new CheckedSortedSet<E>(this.ss.subSet(fromElement, toElement), this.type);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return new CheckedSortedSet<E>(this.ss.tailSet(fromElement), this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CopiesList<T>
    extends AbstractList<T>
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 2739099268398711800L;
        private final int n;
        private final T element;

        CopiesList(int n, T o) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.n = n;
            this.element = o;
        }

        @Override
        public int size() {
            return this.n;
        }

        @Override
        public T get(int index) {
            if (index < 0 || index >= this.n) {
                throw new IndexOutOfBoundsException();
            }
            return this.element;
        }

        @Override
        public boolean contains(Object o) {
            return this.n > 0 && CopiesList.equals(o, this.element);
        }

        @Override
        public int indexOf(Object o) {
            return this.n > 0 && CopiesList.equals(o, this.element) ? 0 : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return CopiesList.equals(o, this.element) ? this.n - 1 : -1;
        }

        @Override
        public List<T> subList(int from, int to) {
            if (from < 0 || to > this.n) {
                throw new IndexOutOfBoundsException();
            }
            return new CopiesList<T>(to - from, this.element);
        }

        @Override
        public Object[] toArray() {
            Object[] a = new Object[this.n];
            Arrays.fill(a, this.element);
            return a;
        }

        @Override
        public String toString() {
            CPStringBuilder r = new CPStringBuilder("{");
            int i = this.n - 1;
            while (--i > 0) {
                r.append(this.element).append(", ");
            }
            r.append(this.element).append("}");
            return r.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyList<T>
    extends AbstractList<T>
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 8842843931221139166L;

        EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof List && ((List)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public int indexOf(Object o) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return -1;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <E> E[] toArray(E[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public String toString() {
            return "[]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        EmptyMap() {
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return EMPTY_SET;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).isEmpty();
        }

        @Override
        public V get(Object o) {
            return null;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public Set<K> keySet() {
            return EMPTY_SET;
        }

        @Override
        public V remove(Object o) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Collection<V> values() {
            return EMPTY_SET;
        }

        @Override
        public String toString() {
            return "[]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptySet<T>
    extends AbstractSet<T>
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        EmptySet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<T> iterator() {
            return EMPTY_LIST.iterator();
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Set && ((Set)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <E> E[] toArray(E[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public String toString() {
            return "[]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LIFOQueue<T>
    extends AbstractQueue<T> {
        private Deque<T> deque;

        public LIFOQueue(Deque<T> deque) {
            this.deque = deque;
        }

        @Override
        public boolean add(T e) {
            return this.deque.offerFirst(e);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean result = false;
            Iterator<T> it = c.iterator();
            while (it.hasNext()) {
                result |= this.deque.offerFirst(it.next());
            }
            return result;
        }

        @Override
        public void clear() {
            this.deque.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.deque.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.deque.iterator();
        }

        @Override
        public boolean offer(T e) {
            return this.deque.offerFirst(e);
        }

        @Override
        public T peek() {
            return this.deque.peek();
        }

        @Override
        public T poll() {
            return this.deque.poll();
        }

        @Override
        public int size() {
            return this.deque.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapSet<E>
    extends AbstractSet<E> {
        private Map<E, Boolean> map;

        public MapSet(Map<E, Boolean> map) {
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("The map must be empty.");
            }
            this.map = map;
        }

        @Override
        public boolean add(E e) {
            return this.map.put(e, true) == null;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            boolean result = false;
            Iterator<E> it = c.iterator();
            while (it.hasNext()) {
                result |= this.map.put(it.next(), true) == null;
            }
            return result;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;

        ReverseComparator() {
        }

        @Override
        public int compare(T a, T b) {
            return ((Comparable)b).compareTo(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingletonList<T>
    extends AbstractList<T>
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 3093736618740652951L;
        private final T element;

        SingletonList(T o) {
            this.element = o;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public T get(int index) {
            if (index == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean contains(Object o) {
            return SingletonList.equals(o, this.element);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Iterator<?> i = c.iterator();
            int pos = c.size();
            while (--pos >= 0) {
                if (SingletonList.equals(i.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return 31 + SingletonList.hashCode(this.element);
        }

        @Override
        public int indexOf(Object o) {
            return SingletonList.equals(o, this.element) ? 0 : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return SingletonList.equals(o, this.element) ? 0 : -1;
        }

        @Override
        public List<T> subList(int from, int to) {
            if (from == to && (to == 0 || to == 1)) {
                return Collections.emptyList();
            }
            if (from == 0 && to == 1) {
                return this;
            }
            if (from > to) {
                throw new IllegalArgumentException();
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.element};
        }

        @Override
        public String toString() {
            return "[" + this.element + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingletonMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        private final K k;
        private final V v;
        private transient Set<Map.Entry<K, V>> entries;

        SingletonMap(K key, V value) {
            this.k = key;
            this.v = value;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entries == null) {
                AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry<K, V>(this, this.k, this.v){
                    final /* synthetic */ SingletonMap this$1;
                    {
                        this.this$1 = singletonMap;
                        super($anonymous0, $anonymous1);
                    }

                    public V setValue(V o) {
                        throw new UnsupportedOperationException();
                    }
                };
                this.entries = Collections.singleton(entry);
            }
            return this.entries;
        }

        @Override
        public boolean containsKey(Object key) {
            return SingletonMap.equals(key, this.k);
        }

        @Override
        public boolean containsValue(Object value) {
            return SingletonMap.equals(value, this.v);
        }

        @Override
        public V get(Object key) {
            return SingletonMap.equals(key, this.k) ? (V)this.v : null;
        }

        @Override
        public int hashCode() {
            return SingletonMap.hashCode(this.k) ^ SingletonMap.hashCode(this.v);
        }

        @Override
        public Set<K> keySet() {
            if (this.keys == null) {
                this.keys = Collections.singleton(this.k);
            }
            return this.keys;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        @Override
        public String toString() {
            return "{" + this.k + "=" + this.v + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingletonSet<T>
    extends AbstractSet<T>
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        final T element;

        SingletonSet(T o) {
            this.element = o;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(this){
                private boolean hasNext;
                final /* synthetic */ SingletonSet this$1;
                {
                    this.this$1 = singletonSet;
                    this.hasNext = true;
                }

                public boolean hasNext() {
                    return this.hasNext;
                }

                public T next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return this.this$1.element;
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return SingletonSet.equals(o, this.element);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Iterator<?> i = c.iterator();
            int pos = c.size();
            while (--pos >= 0) {
                if (SingletonSet.equals(i.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return SingletonSet.hashCode(this.element);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.element};
        }

        @Override
        public String toString() {
            return "[" + this.element + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedCollection<T>
    implements Collection<T>,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection<T> c;
        final Object mutex;

        SynchronizedCollection(Collection<T> c) {
            this.c = c;
            this.mutex = this;
            if (c == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedCollection(Object sync, Collection<T> c) {
            this.c = c;
            this.mutex = sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(T o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends T> col) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(col);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c1) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(c1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<T> iterator() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedIterator<T>(this.mutex, this.c.iterator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> col) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(col);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> col) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(col);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <E> E[] toArray(E[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SynchronizedIterator<T>
    implements Iterator<T> {
        final Object mutex;
        private final Iterator<T> i;

        SynchronizedIterator(Object sync, Iterator<T> i) {
            this.i = i;
            this.mutex = sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            Object object = this.mutex;
            synchronized (object) {
                return this.i.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = this.mutex;
            synchronized (object) {
                return this.i.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Object object = this.mutex;
            synchronized (object) {
                this.i.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedList<T>
    extends SynchronizedCollection<T>
    implements List<T> {
        private static final long serialVersionUID = -7754090372962971524L;
        final List<T> list;

        SynchronizedList(List<T> l) {
            super(l);
            this.list = l;
        }

        SynchronizedList(Object sync, List<T> l) {
            super(sync, l);
            this.list = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, T o) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.add(index, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.lastIndexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<T> listIterator() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedListIterator<T>(this.mutex, this.list.listIterator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<T> listIterator(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedListIterator<T>(this.mutex, this.list.listIterator(index));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T remove(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T set(int index, T o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.set(index, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList<T>(this.mutex, this.list.subList(fromIndex, toIndex));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SynchronizedListIterator<T>
    extends SynchronizedIterator<T>
    implements ListIterator<T> {
        private final ListIterator<T> li;

        SynchronizedListIterator(Object sync, ListIterator<T> li) {
            super(sync, li);
            this.li = li;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(T o) {
            Object object = this.mutex;
            synchronized (object) {
                this.li.add(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasPrevious() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.hasPrevious();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int nextIndex() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.nextIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T previous() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.previous();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int previousIndex() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.previousIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(T o) {
            Object object = this.mutex;
            synchronized (object) {
                this.li.set(o);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SynchronizedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map<K, V> m;
        final Object mutex;
        private transient Set<Map.Entry<K, V>> entries;
        private transient Set<K> keys;
        private transient Collection<V> values;

        SynchronizedMap(Map<K, V> m) {
            this.m = m;
            this.mutex = this;
            if (m == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedMap(Object sync, Map<K, V> m) {
            this.m = m;
            this.mutex = sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entries == null) {
                Object object = this.mutex;
                synchronized (object) {
                    this.entries = new SynchronizedSet<Map.Entry<K, V>>(this, this.mutex, this.m.entrySet()){
                        final /* synthetic */ SynchronizedMap this$1;
                        {
                            this.this$1 = synchronizedMap;
                            super($anonymous0, $anonymous1);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Iterator<Map.Entry<K, V>> iterator() {
                            Object object = this.mutex;
                            synchronized (object) {
                                return new SynchronizedIterator<Map.Entry<K, V>>(this, this.mutex, this.c.iterator()){
                                    final /* synthetic */ 3 this$2;
                                    {
                                        this.this$2 = var1_1;
                                        super($anonymous0, $anonymous1);
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public Map.Entry<K, V> next() {
                                        Object object = this.mutex;
                                        synchronized (object) {
                                            /*
                                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                                             */
                                            class SynchronizedMapEntry<K, V>
                                            implements Map.Entry<K, V> {
                                                final Map.Entry<K, V> e;
                                                final /* synthetic */ SynchronizedMap this$1;

                                                SynchronizedMapEntry(SynchronizedMap synchronizedMap, Map.Entry<K, V> o) {
                                                    this.this$1 = synchronizedMap;
                                                    this.e = o;
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public boolean equals(Object o) {
                                                    Object object = this.this$1.mutex;
                                                    synchronized (object) {
                                                        return this.e.equals(o);
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public K getKey() {
                                                    Object object = this.this$1.mutex;
                                                    synchronized (object) {
                                                        return this.e.getKey();
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public V getValue() {
                                                    Object object = this.this$1.mutex;
                                                    synchronized (object) {
                                                        return this.e.getValue();
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public int hashCode() {
                                                    Object object = this.this$1.mutex;
                                                    synchronized (object) {
                                                        return this.e.hashCode();
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public V setValue(V value) {
                                                    Object object = this.this$1.mutex;
                                                    synchronized (object) {
                                                        return this.e.setValue(value);
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public String toString() {
                                                    Object object = this.this$1.mutex;
                                                    synchronized (object) {
                                                        return this.e.toString();
                                                    }
                                                }
                                            }
                                            return new SynchronizedMapEntry<K, V>(3.access$0(this.this$2), (Map.Entry)super.next());
                                        }
                                    }
                                };
                            }
                        }

                        static /* synthetic */ SynchronizedMap access$0(3 var0) {
                            return var0.this$1;
                        }
                    };
                }
            }
            return this.entries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            if (this.keys == null) {
                Object object = this.mutex;
                synchronized (object) {
                    this.keys = new SynchronizedSet<K>(this.mutex, this.m.keySet());
                }
            }
            return this.keys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            if (this.values == null) {
                Object object = this.mutex;
                synchronized (object) {
                    this.values = new SynchronizedCollection<V>(this.mutex, this.m.values());
                }
            }
            return this.values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SynchronizedRandomAccessList<T>
    extends SynchronizedList<T>
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List<T> l) {
            super(l);
        }

        SynchronizedRandomAccessList(Object sync, List<T> l) {
            super(sync, l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.mutex, this.list.subList(fromIndex, toIndex));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedSet<T>
    extends SynchronizedCollection<T>
    implements Set<T> {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set<T> s) {
            super(s);
        }

        SynchronizedSet(Object sync, Set<T> s) {
            super(sync, s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SynchronizedSortedMap<K, V>
    extends SynchronizedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap<K, V> sm;

        SynchronizedSortedMap(SortedMap<K, V> sm) {
            super(sm);
            this.sm = sm;
        }

        SynchronizedSortedMap(Object sync, SortedMap<K, V> sm) {
            super(sync, sm);
            this.sm = sm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> headMap(K toKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.mutex, this.sm.headMap(toKey));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.mutex, this.sm.subMap(fromKey, toKey));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.mutex, this.sm.tailMap(fromKey));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SynchronizedSortedSet<T>
    extends SynchronizedSet<T>
    implements SortedSet<T> {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet<T> ss;

        SynchronizedSortedSet(SortedSet<T> ss) {
            super(ss);
            this.ss = ss;
        }

        SynchronizedSortedSet(Object sync, SortedSet<T> ss) {
            super(sync, ss);
            this.ss = ss;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super T> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<T> headSet(T toElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<T>(this.mutex, this.ss.headSet(toElement));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<T> subSet(T fromElement, T toElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<T>(this.mutex, this.ss.subSet(fromElement, toElement));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<T> tailSet(T fromElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<T>(this.mutex, this.ss.tailSet(fromElement));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableCollection<T>
    implements Collection<T>,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection<? extends T> c;

        UnmodifiableCollection(Collection<? extends T> c) {
            this.c = c;
            if (c == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c1) {
            return this.c.containsAll(c1);
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return new UnmodifiableIterator<T>(this.c.iterator());
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <S> S[] toArray(S[] a) {
            return this.c.toArray(a);
        }

        public String toString() {
            return this.c.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T> i;

        UnmodifiableIterator(Iterator<? extends T> i) {
            this.i = i;
        }

        @Override
        public T next() {
            return this.i.next();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableList<T>
    extends UnmodifiableCollection<T>
    implements List<T> {
        private static final long serialVersionUID = -283967356065247728L;
        final List<T> list;

        UnmodifiableList(List<? extends T> l) {
            super(l);
            this.list = l;
        }

        @Override
        public void add(int index, T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            return this.list.equals(o);
        }

        @Override
        public T get(int index) {
            return this.list.get(index);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return new UnmodifiableListIterator<T>(this.list.listIterator());
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return new UnmodifiableListIterator<T>(this.list.listIterator(index));
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T set(int index, T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return Collections.unmodifiableList(this.list.subList(fromIndex, toIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnmodifiableListIterator<T>
    extends UnmodifiableIterator<T>
    implements ListIterator<T> {
        private final ListIterator<T> li;

        UnmodifiableListIterator(ListIterator<T> li) {
            super(li);
            this.li = li;
        }

        @Override
        public void add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.li.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.li.nextIndex();
        }

        @Override
        public T previous() {
            return this.li.previous();
        }

        @Override
        public int previousIndex() {
            return this.li.previousIndex();
        }

        @Override
        public void set(T o) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map<K, V> m;
        private transient Set<Map.Entry<K, V>> entries;
        private transient Set<K> keys;
        private transient Collection<V> values;

        UnmodifiableMap(Map<? extends K, ? extends V> m) {
            this.m = m;
            if (m == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.m.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entries == null) {
                this.entries = new UnmodifiableEntrySet<K, V>(this.m.entrySet());
            }
            return this.entries;
        }

        @Override
        public boolean equals(Object o) {
            return this.m.equals(o);
        }

        @Override
        public V get(Object key) {
            return this.m.get(key);
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            if (this.keys == null) {
                this.keys = new UnmodifiableSet<K>(this.m.keySet());
            }
            return this.keys;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = new UnmodifiableCollection<V>(this.m.values());
            }
            return this.values;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class UnmodifiableEntrySet<K, V>
        extends UnmodifiableSet<Map.Entry<K, V>>
        implements Serializable {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set<Map.Entry<K, V>> s) {
                super(s);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new UnmodifiableIterator<Map.Entry<K, V>>(this, this.c.iterator()){
                    final /* synthetic */ UnmodifiableEntrySet this$2;
                    {
                        this.this$2 = unmodifiableEntrySet;
                        super($anonymous0);
                    }

                    public Map.Entry<K, V> next() {
                        Map.Entry e = (Map.Entry)super.next();
                        return new UnmodifiableMapEntry<K, V>(e);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] mapEntryResult = super.toArray();
                Object[] result = null;
                if (mapEntryResult != null) {
                    result = new UnmodifiableMapEntry[mapEntryResult.length];
                    int i = 0;
                    while (i < mapEntryResult.length) {
                        result[i] = new UnmodifiableMapEntry((Map.Entry)mapEntryResult[i]);
                        ++i;
                    }
                }
                return result;
            }

            @Override
            public <S> S[] toArray(S[] array) {
                S[] result = super.toArray(array);
                if (result != null) {
                    int i = 0;
                    while (i < result.length) {
                        array[i] = new UnmodifiableMapEntry((Map.Entry)result[i]);
                        ++i;
                    }
                }
                return array;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static final class UnmodifiableMapEntry<K, V>
            implements Map.Entry<K, V> {
                private final Map.Entry<K, V> e;

                private UnmodifiableMapEntry(Map.Entry<K, V> e) {
                    this.e = e;
                }

                @Override
                public boolean equals(Object o) {
                    return this.e.equals(o);
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException();
                }

                public String toString() {
                    return this.e.toString();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnmodifiableRandomAccessList<T>
    extends UnmodifiableList<T>
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List<? extends T> l) {
            super(l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableSet<T>
    extends UnmodifiableCollection<T>
    implements Set<T> {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set<? extends T> s) {
            super(s);
        }

        @Override
        public boolean equals(Object o) {
            return this.c.equals(o);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableSortedMap<K, V>
    extends UnmodifiableMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap<K, V> sm;

        UnmodifiableSortedMap(SortedMap<K, ? extends V> sm) {
            super(sm);
            this.sm = sm;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return new UnmodifiableSortedMap<K, V>(this.sm.headMap(toKey));
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return new UnmodifiableSortedMap<K, V>(this.sm.subMap(fromKey, toKey));
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return new UnmodifiableSortedMap<K, V>(this.sm.tailMap(fromKey));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableSortedSet<T>
    extends UnmodifiableSet<T>
    implements SortedSet<T> {
        private static final long serialVersionUID = -4929149591599911165L;
        private SortedSet<T> ss;

        UnmodifiableSortedSet(SortedSet<T> ss) {
            super(ss);
            this.ss = ss;
        }

        @Override
        public Comparator<? super T> comparator() {
            return this.ss.comparator();
        }

        @Override
        public T first() {
            return this.ss.first();
        }

        @Override
        public SortedSet<T> headSet(T toElement) {
            return new UnmodifiableSortedSet<T>(this.ss.headSet(toElement));
        }

        @Override
        public T last() {
            return this.ss.last();
        }

        @Override
        public SortedSet<T> subSet(T fromElement, T toElement) {
            return new UnmodifiableSortedSet<T>(this.ss.subSet(fromElement, toElement));
        }

        @Override
        public SortedSet<T> tailSet(T fromElement) {
            return new UnmodifiableSortedSet<T>(this.ss.tailSet(fromElement));
        }
    }
}

