/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.logging.log4j.LogManager;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.FingerprintFilter;
import org.elasticsearch.analysis.common.FingerprintAnalyzerProvider;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;

public class FingerprintTokenFilterFactory
extends AbstractTokenFilterFactory {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(FingerprintTokenFilterFactory.class));
    private final char separator;
    private final int maxOutputSize;

    FingerprintTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.separator = FingerprintAnalyzerProvider.parseSeparator(settings);
        this.maxOutputSize = settings.getAsInt(FingerprintAnalyzerProvider.MAX_OUTPUT_SIZE.getPreferredName(), Integer.valueOf(FingerprintAnalyzerProvider.DEFAULT_MAX_OUTPUT_SIZE));
    }

    public TokenStream create(TokenStream tokenStream) {
        TokenStream result = tokenStream;
        result = new FingerprintFilter(result, this.maxOutputSize, this.separator);
        return result;
    }

    public TokenFilterFactory getSynonymFilter() {
        DEPRECATION_LOGGER.deprecatedAndMaybeLog("synonym_tokenfilters", "Token filter [" + this.name() + "] will not be usable to parse synonyms after v7.0", new Object[0]);
        return this;
    }
}

